/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;

public class CVSNewFilesWatcher {
    private final URL _directoryUrl;
    private Collection<Collection<VCSHashURL>> _snapshots;
    private Collection<VCSHashURL> _newWorkspaces;
    private Collection<VCSHashURL> _newProjects;
    private Collection<VCSHashURL> _newRegulars;

    public CVSNewFilesWatcher(URL directoryUrl) {
        Assert.precondition((boolean)URLFileSystem.isDirectory((URL)directoryUrl));
        this._directoryUrl = directoryUrl;
        this._snapshots = new ArrayList<Collection<VCSHashURL>>();
        this._newWorkspaces = new ArrayList<VCSHashURL>();
        this._newProjects = new ArrayList<VCSHashURL>();
        this._newRegulars = new ArrayList<VCSHashURL>();
    }

    public URL getURL() {
        return this._directoryUrl;
    }

    public void takeSnapshotOne() {
        this._snapshots.add(this.createSnapshot(this._directoryUrl));
    }

    public void takeSnapshotTwo() {
        this._snapshots.add(this.createSnapshot(this._directoryUrl));
        if (this._snapshots.size() < 2) {
            throw new IllegalStateException();
        }
        Iterator<Collection<VCSHashURL>> itr = this._snapshots.iterator();
        this._snapshots = null;
        this.handleSnapshots(itr.next(), itr.next());
    }

    public boolean isReady() {
        return this._snapshots == null;
    }

    public boolean hasNewURLs() {
        return this._newWorkspaces.size() > 0 || this._newProjects.size() > 0 || this._newRegulars.size() > 0;
    }

    public boolean hasNewWorkspaceURLs() {
        return this._newWorkspaces.size() > 0;
    }

    public boolean hasNewProjectURLs() {
        return this._newProjects.size() > 0;
    }

    public boolean hasNewRegularURLs() {
        return this._newRegulars.size() > 0;
    }

    public Collection<URL> getNewURLs() {
        ArrayList<URL> all = new ArrayList<URL>();
        all.addAll(VCSHashURL.convertToURLs(this._newWorkspaces));
        all.addAll(VCSHashURL.convertToURLs(this._newProjects));
        all.addAll(VCSHashURL.convertToURLs(this._newRegulars));
        return all;
    }

    public Collection<URL> getNewWorkspaceURLs() {
        return VCSHashURL.convertToURLs(this._newWorkspaces);
    }

    public Collection getNewProjectURLs() {
        return VCSHashURL.convertToURLs(this._newProjects);
    }

    public Collection getNewRegularURLs() {
        return VCSHashURL.convertToURLs(this._newRegulars);
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        toStringBuilder.append("directory=" + URLFileSystem.getPlatformPathName((URL)this._directoryUrl));
        toStringBuilder.append(',');
        toStringBuilder.append("workspace URLs=" + this._newWorkspaces);
        toStringBuilder.append(',');
        toStringBuilder.append("project URLs=" + this._newProjects);
        toStringBuilder.append(',');
        toStringBuilder.append("regular URLs=" + this._newProjects);
        return toStringBuilder.toString();
    }

    protected Collection<VCSHashURL> createSnapshot(URL directoryUrl) {
        return VCSHashURL.convertFromURLs(CVSListFilesUtil.listFiles(directoryUrl, 5));
    }

    protected void handleSnapshots(Collection<VCSHashURL> snapshotOne, Collection<VCSHashURL> snapshotTwo) {
        snapshotTwo.removeAll(snapshotOne);
        this.organizeNewURLs(snapshotTwo);
    }

    protected final void organizeNewURLs(Collection<VCSHashURL> urls) {
        Iterator<VCSHashURL> itr = urls.iterator();
        while (itr.hasNext()) {
            this.organizeNewURL(itr.next());
        }
    }

    protected final void organizeNewURL(VCSHashURL url) {
        String name = URLFileSystem.getFileName((URL)url.getURL());
        if (name.endsWith(".jpr")) {
            this._newProjects.add(url);
            return;
        }
        if (name.endsWith(".jws")) {
            this._newWorkspaces.add(url);
            return;
        }
        this._newRegulars.add(url);
    }
}

