/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdevimpl.vcs.cvs.CVSNewFilesWatcher;
import oracle.jdevimpl.vcs.cvs.control.CVSSimpleChoiceDialog;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.generic.util.NewFilesHandler;
import oracle.jdevimpl.vcs.util.FileHandler;

public final class CVSNewFilesHandler
extends FileHandler {
    private CVSNewFilesHandler() {
    }

    public static final void handleNewFiles(final Context context, final CVSNewFilesWatcher watcher, final URL checkoutDirectoryUrl, final String moduleName) {
        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CVSNewFilesHandler._handleNewFiles(context, watcher, checkoutDirectoryUrl, moduleName);
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                }
            }
        });
    }

    private static final void _handleNewFiles(Context context, CVSNewFilesWatcher watcher, URL checkoutDirectoryUrl, String moduleName) throws Exception {
        Assert.precondition((boolean)watcher.isReady());
        VCSFileEventSender.fireFileStructureChanged((URL[])watcher.getNewRegularURLs().toArray(new URL[0]));
        if (watcher.hasNewWorkspaceURLs()) {
            CVSNewFilesHandler.openWorkspaces((Context)context, watcher.getNewWorkspaceURLs());
            return;
        }
        if (!watcher.hasNewProjectURLs() && !watcher.hasNewRegularURLs()) {
            return;
        }
        Workspace activeWorkspace = CVSNewFilesHandler.determineActiveWorkspace(context);
        CVSNewFilesHandler.handleNewFiles0(context, watcher, checkoutDirectoryUrl, moduleName, activeWorkspace);
    }

    private static final Workspace createNewWorkspace(Context context, URL checkoutDirectoryUrl, String moduleName) throws IllegalAccessException, InstantiationException {
        Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace((Context)context, (URL)CVSNewFilesHandler.createWorkspaceURL(checkoutDirectoryUrl, moduleName));
        Ide.getWorkspaces().setWorkDirectory(checkoutDirectoryUrl);
        return workspace;
    }

    private static final void handleNewFiles0(Context context, CVSNewFilesWatcher watcher, URL checkoutDirectoryUrl, String moduleName, Workspace activeWorkspace) throws Exception {
        CVSSimpleChoiceDialog choiceDialog;
        URL newProjectDirectoryUrl;
        if (watcher.hasNewProjectURLs()) {
            if (activeWorkspace == null) {
                activeWorkspace = CVSNewFilesHandler.createNewWorkspace(context, checkoutDirectoryUrl, moduleName);
            }
            CVSNewFilesHandler.openProjectsInWorkspace(context, activeWorkspace, watcher.getNewProjectURLs());
            return;
        }
        final Collection urls = watcher.getNewRegularURLs();
        ArrayList<String> choices = new ArrayList<String>();
        choices.add(CVSArb.get("NEW_FILES_CHOICE_OPEN_FILES"));
        choices.add(CVSArb.get("NEW_FILES_CHOICE_CREATE_NEW_PROJECT"));
        choices.add(CVSArb.get("NEW_FILES_CHOICE_EDIT_FILES"));
        choices.add(CVSArb.get("NEW_FILES_CHOICE_DO_NOT_OPEN"));
        Project activeProject = CVSNewFilesHandler.determineActiveProject((Context)context);
        if (activeProject != null) {
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)activeProject).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            Assert.check((contentSet != null ? 1 : 0) != 0);
            newProjectDirectoryUrl = watcher.getURL();
            Assert.check((newProjectDirectoryUrl != null ? 1 : 0) != 0);
            if (contentSet.canHaveMember(newProjectDirectoryUrl)) {
                return;
            }
        }
        if (activeWorkspace == null || activeProject == null) {
            choices.remove(CVSArb.get("NEW_FILES_CHOICE_OPEN_FILES"));
        }
        if (!(choiceDialog = new CVSSimpleChoiceDialog(CVSArb.get("NEW_FILES_TITLE"), CVSArb.get("NEW_FILE_PROMPT"), choices.toArray(new String[0]), null)).show()) {
            return;
        }
        if (choices.indexOf(CVSArb.get("NEW_FILES_CHOICE_OPEN_FILES")) == choiceDialog.getChoice()) {
            newProjectDirectoryUrl = watcher.getURL();
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)activeProject).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            contentSet.getURLPath().add(newProjectDirectoryUrl);
            UpdateMessage.fireStructureChanged((Subject)activeProject);
        }
        if (choices.indexOf(CVSArb.get("NEW_FILES_CHOICE_CREATE_NEW_PROJECT")) == choiceDialog.getChoice()) {
            if (activeWorkspace == null) {
                activeWorkspace = CVSNewFilesHandler.createNewWorkspace(context, checkoutDirectoryUrl, moduleName);
            }
            NewFilesHandler.createNewProject((Context)context, (Workspace)activeWorkspace, (String)CVSNewFilesHandler.convertToFileName((String)moduleName), (URL)watcher.getURL());
        }
        if (choices.indexOf(CVSArb.get("NEW_FILES_CHOICE_EDIT_FILES")) == choiceDialog.getChoice()) {
            IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (URL url : urls) {
                        String suffix = URLFileSystem.getSuffix((URL)url);
                        if (suffix.equals(".jpr") || suffix.equals(".jws")) continue;
                        try {
                            EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                        }
                        catch (Exception e) {
                            Assert.printStackTrace((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private static final URL createWorkspaceURL(URL checkoutDirectoryUrl, String moduleName) {
        String workspaceName = CVSNewFilesHandler.convertToFileName((String)moduleName);
        URL workspaceUrl = URLFactory.newURL((URL)checkoutDirectoryUrl, (String)(workspaceName + ".jws"));
        int i = 2;
        while (URLFileSystem.exists((URL)workspaceUrl)) {
            workspaceUrl = URLFactory.newURL((URL)checkoutDirectoryUrl, (String)(workspaceName + Integer.toString(i++) + ".jws"));
        }
        return workspaceUrl;
    }

    private static final void openProjectsInWorkspace(Context context, Workspace workspace, Collection projects) throws IllegalAccessException, InstantiationException {
        for (URL url : projects) {
            if (NodeFactory.find((URL)url) != null) {
                new IllegalStateException("CVS: node exists for project " + url).printStackTrace();
            }
            NodeFactory.uncache((URL)url);
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node == null || !(node instanceof Project) || workspace.containsChild((Element)node) || !CVSNewFilesHandler.migrateSystemFile((Node)node)) continue;
            workspace.add((Element)node, true);
            FileOpenHistory.getInstance().updateProjectHistory(node.getURL());
            CVSNewFilesHandler.selectNavigatorTNode((Context)context, (Element)node);
        }
    }

    private static final Workspace determineActiveWorkspace(Context context) {
        Workspace contextWorkspace = context.getWorkspace();
        if (contextWorkspace == null) {
            contextWorkspace = Ide.getActiveWorkspace();
        }
        Workspaces workspaces = Ide.getWorkspaces();
        Iterator itr = workspaces.getChildren();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof Workspace) || contextWorkspace != null && o != contextWorkspace) continue;
            return (Workspace)o;
        }
        return null;
    }
}

