/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.merge.BaseTextMergeEditor;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSMergeAnnotation;
import oracle.jdevimpl.vcs.cvs.CVSVersionToolsPrefs;
import oracle.jdevimpl.vcs.cvs.client.CVSEntriesFile;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRevisionNumber;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionInfo;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionUtils;

public class CVSMergeEditor
extends BaseTextMergeEditor {
    protected void initializeMergeContextCS(Context context) throws Exception {
        URL url = this.getRealURL();
        String type = this.getSuffixAsType(url);
        InputStream ancestorInputStream = this.openAncestorInputStream(url);
        if (ancestorInputStream == null) {
            MergeContext.setClientSideMerge((Context)context, (boolean)false);
            return;
        }
        String charsetName = StreamDecoder.getDefaultEncoding((URL)url);
        String resourceName = URLFileSystem.getFileName((URL)url);
        InputStreamTextContributor contributor = new InputStreamTextContributor(VCSFileSystemUtils.openConflictsStreamAsContributor((URL)url, (String)charsetName), charsetName, resourceName, resourceName, type);
        contributor.setType(type);
        MergeContext.setFirstContributor((Context)context, (CompareContributor)contributor);
        CVSRevisionInfo info = CVSRevisionUtils.downloadContents(url, CVSRevisionNumber.HEAD.toString(), null, true);
        resourceName = CVSArb.format("MERGE_INTEGRATED_RESOURCE", CVSRevisionNumber.HEAD.toString());
        contributor = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(info.getContents()), charsetName, resourceName, resourceName, type);
        contributor.setType(type);
        MergeContext.setSecondContributor((Context)context, (CompareContributor)contributor);
        contributor = new InputStreamTextContributor(ancestorInputStream, charsetName, "", "", type);
        contributor.setType(type);
        MergeContext.setAncestorContributor((Context)context, (CompareContributor)contributor);
        MergeContext.setMergeEngine((Context)context, (MergeEngine)MergeEngine.getInstance());
    }

    private InputStream openAncestorInputStream(URL url) throws Exception {
        URL parent = URLFileSystem.getParent((URL)url);
        CVSEntry entriesDotOldEntry = CVSEntriesFile.findEntry(new CVSEntriesFile(parent, CVSEntriesFile.ENTRIES_DOT_OLD_RELATIVE_PATH).getEntries(), url);
        if (entriesDotOldEntry != null && !entriesDotOldEntry.hasConflicts()) {
            CVSRevisionInfo info = CVSRevisionUtils.downloadContents(url, entriesDotOldEntry.getRevision(), null, true);
            return new ByteArrayInputStream(info.getContents());
        }
        CVSEntry entriesDotArchiveEntry = CVSEntriesFile.findEntry(new CVSEntriesFile(parent, CVSEntriesFile.ENTRIES_DOT_ARCHIVE_RELATIVE_PATH).getEntries(), url);
        if (entriesDotArchiveEntry == null || entriesDotArchiveEntry.hasConflicts()) {
            return null;
        }
        URL entriesUrl = URLFactory.newFileURL((File)new File(URLFileSystem.getPlatformPathName((URL)parent), CVSEntriesFile.ENTRIES_RELATIVE_PATH));
        URL entriesDotArchiveUrl = URLFactory.newFileURL((File)new File(URLFileSystem.getPlatformPathName((URL)parent), CVSEntriesFile.ENTRIES_DOT_ARCHIVE_RELATIVE_PATH));
        if (URLFileSystem.lastModified((URL)entriesDotArchiveUrl) != URLFileSystem.lastModified((URL)entriesUrl)) {
            return null;
        }
        CVSRevisionInfo info = CVSRevisionUtils.downloadContents(url, entriesDotArchiveEntry.getRevision(), null, true);
        return new ByteArrayInputStream(info.getContents());
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_cvsmergetool_html");
    }

    protected void resolveMergeStatus(URL url) {
        try {
            CVSMergeEditor.clearEntriesResultOfMergeMarker(url);
        }
        catch (IOException ioe) {
            FeedbackManager.reportException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void clearEntriesResultOfMergeMarker(URL url) throws IOException {
        CVSEntriesFile entriesFile = new CVSEntriesFile(URLFileSystem.getParent((URL)url));
        ArrayList<CVSEntry> entries = new ArrayList<CVSEntry>(entriesFile.getEntries());
        CVSEntry entry = CVSEntriesFile.findEntry(entries, url);
        try {
            if (entry == null || !entry.hasConflicts()) {
                return;
            }
            CVSEntry entry0 = CVSEntry.parseEntrySpec(entry.toString().replaceFirst("Result of merge\\+", ""));
            if (entry0 == null) {
                return;
            }
            entries.set(entries.indexOf(entry), entry0);
            entriesFile.writeEntries(entries);
        }
        finally {
            CVSEntriesCache.getInstance().clear();
            CVSClient.getInstance();
            CVSClient.getStatusCache().clear(url);
        }
    }

    protected Class getAnnotationClassSS() {
        return CVSMergeAnnotation.class;
    }

    protected String createFirstContributorLabelSS() {
        HashSet leftAnnotationsSet = new HashSet(this.getDiff3Model().getSourceAnnotations().values());
        Object[] leftAnnotations = leftAnnotationsSet.toArray(new CVSMergeAnnotation[0]);
        Arrays.sort(leftAnnotations);
        if (leftAnnotations.length <= 0) {
            return CVSArb.get("MERGE_LABEL_NO_REVISION");
        }
        if (leftAnnotations.length == 1) {
            return CVSArb.format("MERGE_LABEL_ONE_REVISION", ((CVSMergeAnnotation)leftAnnotations[0]).toString());
        }
        if (leftAnnotations.length >= 2 && leftAnnotations.length <= 3) {
            StringBuilder annotationsListBuffer = new StringBuilder();
            for (int i = 0; i < leftAnnotations.length; ++i) {
                if (i > 0) {
                    annotationsListBuffer.append(',');
                }
                annotationsListBuffer.append(((CVSMergeAnnotation)leftAnnotations[i]).toString());
            }
            return CVSArb.format("MERGE_LABEL_FEW_REVISIONS", annotationsListBuffer.toString());
        }
        return CVSArb.format("MERGE_LABEL_RANGE_OF_REVISIONS", ((CVSMergeAnnotation)leftAnnotations[0]).toString(), ((CVSMergeAnnotation)leftAnnotations[leftAnnotations.length - 1]).toString());
    }

    protected boolean getClientSideMergeSetting() {
        return CVSMergeEditor.getClientSideMergeSettingImpl();
    }

    protected boolean isMergeModelBasedOnFile() {
        return true;
    }

    public static final boolean getClientSideMergeSettingImpl() {
        int mergeEditor = CVSVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getMergeEditor();
        return mergeEditor == 0;
    }
}

