/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import oracle.jdevimpl.vcs.cvs.util.CVSVersionNumber;

public class CVSMergeAnnotation
implements Comparable {
    private final String _id;
    private CVSVersionNumber _versionNumber;

    public CVSMergeAnnotation(String id) {
        this._id = id;
        try {
            this._versionNumber = CVSVersionNumber.createVersionNumber(this._id, ".");
        }
        catch (NumberFormatException nfe) {
            this._versionNumber = null;
        }
    }

    public boolean equals(Object o) {
        return o instanceof CVSMergeAnnotation && this._id.equals(((CVSMergeAnnotation)o)._id);
    }

    public int hashCode() {
        return this._id.intern().hashCode();
    }

    public int compareTo(Object o) {
        CVSMergeAnnotation otherAnnotation = (CVSMergeAnnotation)o;
        if (this._versionNumber == null && otherAnnotation._versionNumber == null) {
            return this._id.compareTo(otherAnnotation._id);
        }
        if (this._versionNumber != null && otherAnnotation._versionNumber == null) {
            return 1;
        }
        if (this._versionNumber == null && otherAnnotation._versionNumber != null) {
            return -1;
        }
        return this._versionNumber.compareTo(otherAnnotation._versionNumber);
    }

    public String toString() {
        return this._id;
    }
}

