/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.jdevimpl.vcs.cvs.client.CVSAccessPServer;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginMethod;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;

public final class CVSLoginCache {
    private static final CVSLoginCache s_inst = new CVSLoginCache();
    private final Map m_cache = new WeakHashMap();

    public static final CVSLoginCache getInstance() {
        return s_inst;
    }

    public boolean isLoggedIn() {
        CVSConnectionListAPI connectionList = CVSConnectionNodes.getConnectionListAPI();
        for (Object connectionName : ((CVSConnectionListData)connectionList).getConnectionNames()) {
            if (!this.isLoggedIn(new CVSRootString(((CVSConnectionListData)connectionList).getConnectionRoot((String)connectionName)))) continue;
            return true;
        }
        return false;
    }

    public final synchronized boolean isLoggedIn(CVSRootString root) {
        Boolean state = (Boolean)this.m_cache.get(root);
        if (state != null) {
            return state;
        }
        state = this.isLoggedInImpl(root) ? Boolean.TRUE : Boolean.FALSE;
        this.m_cache.put(root, state);
        return state;
    }

    public final synchronized void clear() {
        this.m_cache.clear();
    }

    private final boolean isLoggedInImpl(CVSRootString root) {
        return CVSLogin.getMethod(root).isLoggedInImpl(root);
    }

    public static void _test_ClearLoginCache() {
        CVSLoginCache.getInstance().clear();
        Iterator itr = CVSLogin.getMethodIterator();
        while (itr.hasNext()) {
            CVSLoginMethod method = (CVSLoginMethod)itr.next();
            method.isLoggedIn(new CVSRootString(""));
            method.doLogoutAll();
        }
        try {
            CVSAccessPServer.getGenericInstance().deletePassFile();
            CVSAccessPServer.getNTInstance().deletePassFile();
            CVSAccessPServer.getOSXInstance().deletePassFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

