/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.util.Assert;
import oracle.ide.util.Enum;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSDefaultUtils;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public abstract class CVSFileStatus
implements VCSStatus,
ChangeListStatus {
    public static final CVSFileStatus STATUS_LOCALLY_CHANGED = new LazyStatus(true, "LABEL_MODIFIED");
    public static final CVSFileStatus STATUS_REMOVED = new LazyStatus(false, "LABEL_REMOVED");
    public static final CVSFileStatus STATUS_ADDED = new LazyStatus(true, "LABEL_ADDED");
    public static final CVSFileStatus STATUS_UNMODIFIED_READWRITE = new LazyStatus(true, "LABEL_UNMODIFIED_READWRITE");
    public static final CVSFileStatus STATUS_UNMODIFIED_READONLY = new LazyStatus(true, "LABEL_UNMODIFIED_READONLY");
    public static final CVSFileStatus STATUS_CONFLICTS = new LazyStatus(true, "LABEL_CONFLICTS");
    public static final CVSFileStatus STATUS_UNADDED = new LazyStatus(false, "LABEL_UNADDED");
    public static final CVSFileStatus STATUS_SANDBOX = new LazyStatus(true, "LABEL_SANDBOX");
    public static final VCSStatus STATUS_NOT_UNDER_CVS = VCSDefaultUtils.createUnrecognizedStatus();
    public static final VCSStatus STATUS_ADMINISTRATIVE = VCSDefaultUtils.createUnrecognizedStatus();

    private CVSFileStatus() {
    }

    public abstract String getLabel();

    static void setScheme(Scheme scheme) {
        ((LazyStatus)STATUS_SANDBOX).initializeIcon(OracleIcons.getIcon((String)"extras/overlay_sandbox.png"));
        if (scheme == Scheme.TORTOISE) {
            ((LazyStatus)STATUS_LOCALLY_CHANGED).initializeIconKey("TORTOISE_OVERLAY_MODIFIED");
            ((LazyStatus)STATUS_REMOVED).initializeIconKey(LazyStatus.NULL_ICON_KEY);
            ((LazyStatus)STATUS_ADDED).initializeIconKey("TORTOISE_OVERLAY_ADDED");
            ((LazyStatus)STATUS_UNMODIFIED_READWRITE).initializeIconKey("TORTOISE_OVERLAY_UNMODIFIED_READWRITE");
            ((LazyStatus)STATUS_UNMODIFIED_READONLY).initializeIconKey("TORTOISE_OVERLAY_UNMODIFIED_READONLY");
            ((LazyStatus)STATUS_CONFLICTS).initializeIconKey("TORTOISE_OVERLAY_CONFLICTS");
            ((LazyStatus)STATUS_UNADDED).initializeIconKey("TORTOISE_OVERLAY_UNADDED");
            return;
        }
        if (scheme == Scheme.WINDOWS) {
            ((LazyStatus)STATUS_LOCALLY_CHANGED).initializeIconKey("WINDOWS_OVERLAY_MODIFIED");
            ((LazyStatus)STATUS_REMOVED).initializeIconKey("WINDOWS_OVERLAY_REMOVED");
            ((LazyStatus)STATUS_ADDED).initializeIconKey("WINDOWS_OVERLAY_ADDED");
            ((LazyStatus)STATUS_UNMODIFIED_READWRITE).initializeIconKey("WINDOWS_OVERLAY_UNMODIFIED");
            ((LazyStatus)STATUS_UNMODIFIED_READONLY).initializeIconKey("WINDOWS_OVERLAY_UNMODIFIED");
            ((LazyStatus)STATUS_CONFLICTS).initializeIconKey("WINDOWS_OVERLAY_CONFLICTS");
            ((LazyStatus)STATUS_UNADDED).initializeIconKey("WINDOWS_OVERLAY_UNADDED");
            return;
        }
        if (scheme == Scheme.JDEVELOPER) {
            ((LazyStatus)STATUS_LOCALLY_CHANGED).initializeIcon(VCSIconArb.getIcon((String)"extras/overlay_modified.png"));
            ((LazyStatus)STATUS_REMOVED).initializeIcon(VCSIconArb.getIcon((String)"extras/overlay_removed.png"));
            ((LazyStatus)STATUS_ADDED).initializeIcon(VCSIconArb.getIcon((String)"extras/overlay_added.png"));
            ((LazyStatus)STATUS_UNMODIFIED_READWRITE).initializeIcon(OracleIcons.getIcon((String)"extras/overlay_unmodified.png"));
            ((LazyStatus)STATUS_UNMODIFIED_READONLY).initializeIcon(VCSIconArb.getIcon((String)"extras/overlay_checkedin.png"));
            ((LazyStatus)STATUS_CONFLICTS).initializeIcon(VCSIconArb.getIcon((String)"extras/overlay_conflicts.png"));
            ((LazyStatus)STATUS_UNADDED).initializeIcon(VCSIconArb.getIcon((String)"extras/overlay_unversioned.png"));
            return;
        }
        throw new IllegalArgumentException();
    }

    private static class LazyStatus
    extends CVSFileStatus {
        public static final int STATE_UNVERSIONED = 1;
        public static final int STATE_VERSIONED = 2;
        public static final int STATE_OTHER = 3;
        private static final String NULL_ICON_KEY = null;
        private final int _state;
        private final String _labelKey;
        private Icon _icon = null;
        private String _iconKey = null;
        private IconOverlay _overlay;

        public LazyStatus(boolean versioned, String labelKey) {
            this._state = versioned ? 2 : 1;
            this._labelKey = labelKey;
        }

        public void initializeIconKey(String iconKey) {
            this._iconKey = iconKey;
            this._overlay = null;
            this._icon = null;
        }

        public void initializeIcon(Icon icon) {
            this._iconKey = null;
            this._overlay = null;
            this._icon = icon;
        }

        public String getChangeListLabel() {
            return this.getLabel();
        }

        public boolean isChangeListCellHighlighted() {
            return this.equals(STATUS_CONFLICTS);
        }

        @Override
        public String getLabel() {
            return CVSArb.get(this._labelKey);
        }

        public boolean isVersioned() {
            return this._state == 2;
        }

        public boolean isCandidate() {
            return this._state == 1;
        }

        public IconOverlay getOverlay() {
            if (this._iconKey == null && this._icon == null) {
                Assert.printStackTrace((Throwable)new IllegalStateException());
                CVSFileStatus.setScheme(Scheme.JDEVELOPER);
            }
            if (this._overlay != null) {
                return this._overlay;
            }
            if (this._icon != null) {
                this._overlay = new IconOverlay(this._icon, null, this.getLabel());
                return this._overlay;
            }
            this._overlay = new IconOverlay(this._iconKey == NULL_ICON_KEY ? null : ImageIconCache.get((URL)CVSArb.class.getResource(CVSArb.get(this._iconKey))), null, this.getLabel());
            return this._overlay;
        }
    }

    static class Scheme
    extends Enum {
        public static final Scheme JDEVELOPER = new Scheme("JDEVELOPER");
        public static final Scheme TORTOISE = new Scheme("TORTOISE");
        public static final Scheme WINDOWS = new Scheme("WINDOWS");
        private static final Scheme[] PRIVATE_VALUES = new Scheme[]{JDEVELOPER, TORTOISE, WINDOWS};
        private static int _nextOrdinal = 0;

        private Scheme(String name) {
            super(name, _nextOrdinal++);
        }

        public static final Scheme valueOf(String name) {
            return (Scheme)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final Scheme[] values() {
            return (Scheme[])PRIVATE_VALUES.clone();
        }
    }
}

