/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.cvs.client.CVSEntriesFile;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;

public final class CVSEntriesCache {
    private static final CVSEntriesCache _inst = new CVSEntriesCache();
    private final Map<VCSHashURL, Map<EntryKey, CVSEntry>> _cache = new HashMap<VCSHashURL, Map<EntryKey, CVSEntry>>();

    private CVSEntriesCache() {
    }

    public static final CVSEntriesCache getInstance() {
        return _inst;
    }

    public Collection<CVSEntry> getEntries(URL dir) throws IOException {
        return this.getEntriesMap(dir).values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<EntryKey, CVSEntry> getEntriesMap(URL dir) throws IOException {
        Map<VCSHashURL, Map<EntryKey, CVSEntry>> map = this._cache;
        synchronized (map) {
            Map<EntryKey, CVSEntry> cachedEntries = this._cache.get(new VCSHashURL(dir));
            if (cachedEntries != null) {
                return cachedEntries;
            }
        }
        LinkedHashMap<EntryKey, CVSEntry> entries = new LinkedHashMap<EntryKey, CVSEntry>();
        try {
            for (CVSEntry entry : new CVSEntriesFile(dir).getEntries()) {
                entries.put(new EntryKey(entry), entry);
            }
        }
        finally {
            Map<VCSHashURL, Map<EntryKey, CVSEntry>> map2 = this._cache;
            synchronized (map2) {
                this._cache.put(new VCSHashURL(dir), entries);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<VCSHashURL, Map<EntryKey, CVSEntry>> map = this._cache;
        synchronized (map) {
            this._cache.clear();
        }
    }

    @Deprecated
    public static final CVSEntry findEntry(Collection<CVSEntry> list, URL file) {
        return CVSEntriesFile.findEntry(list, file);
    }

    public static final CVSEntry findEntry(Map<EntryKey, CVSEntry> entriesMap, URL file) {
        return entriesMap.get(new EntryKey(URLFileSystem.getFileName((URL)file)));
    }

    public static final class EntryKey {
        private final String _name;

        private EntryKey(String name) {
            this._name = name;
        }

        private EntryKey(CVSEntry entry) {
            String name = entry.getName();
            this._name = name != null && !name.equals("") ? name : entry.toString();
        }

        public final boolean equals(Object o) {
            return o instanceof EntryKey && this._name.equals(((EntryKey)o)._name);
        }

        public final int hashCode() {
            return this._name.hashCode();
        }
    }
}

