/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSCheckOutNodeCmd;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSFileSystemAPI;
import oracle.jdevimpl.vcs.cvs.CVSFileURLFileSystemHelper;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSEditNodeCmd
extends VCSCheckOutNodeCmd {
    public CVSEditNodeCmd() {
        super(0, CVSArb.get("EDIT_NODE_CMD_NAME"));
    }

    protected boolean isOperable(URL url) {
        if (CVSClient.getInstance().isUsingInternalClient() && !CVSInternalClientSupport.isSupportedCommand("edit")) {
            return false;
        }
        if (!CVSUtil.isOpenSessionFile(url)) {
            return false;
        }
        return CVSFileURLFileSystemHelper.checkForCVS();
    }

    protected boolean canCheckOutUI(URL url) {
        return super.canCheckOutUI(url);
    }

    protected boolean undoCheckOut(URL url) throws Exception {
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        if (!status.isVersioned() || URLFileSystem.isDirectory((URL)url)) {
            return false;
        }
        Ide.getStatusBar().setText(CVSArb.format("FILE_SYSTEM_UNEDITING_FILE", URLFileSystem.getPlatformPathName((URL)url)));
        long timestamp = URLFileSystem.lastModified((URL)url);
        CVSFileSystemAPI.executeUneditRegularFile(url);
        if (URLFileSystem.lastModified((URL)url) != timestamp) {
            VCSBufferUtils.reloadBuffer((URL)url);
        }
        this.clearStatusBarText();
        return URLFileSystem.isReadOnly((URL)url);
    }

    private void clearStatusBarText() {
        Ide.getStatusBar().setText("");
    }
}

