/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.properties.PropertiesCommand;
import oracle.jdeveloper.vcs.spi.VCSContextMenuListener;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFolderOperationUtil;
import oracle.jdevimpl.vcs.cvs.CVSLoginCache;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;

public final class CVSContextMenuListener
extends VCSContextMenuListener {
    public CVSContextMenuListener() {
        super("oracle.jdeveloper.cvs");
    }

    protected Component[] getContextMenuItems(Context context) {
        if (context.getElement() != null && context.getElement() instanceof CVSConnectionElement) {
            return null;
        }
        ArrayList<JMenu> menuItems = new ArrayList<JMenu>();
        CVSConnectionListAPI connectionList = CVSConnectionNodes.getConnectionListAPI();
        JMenu contextMenu = null;
        if (((CVSConnectionListData)connectionList).getConnectionCount() > 0) {
            contextMenu = this.createVersioningSubmenu(context);
        }
        if (contextMenu != null) {
            menuItems.add(contextMenu);
        }
        VCSMenuUtils.addCompareSubmenu(menuItems, (Context)context);
        return menuItems.toArray(new Component[0]);
    }

    private VCSStatus getStatus(Locatable locatable) {
        try {
            CVSClient.getInstance();
            return (VCSStatus)CVSClient.getStatusCache().get(locatable.getURL());
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return null;
        }
    }

    private boolean isProjectEmpty(Project project) {
        return false;
    }

    private boolean isWorkspaceEmpty(Workspace workspace) {
        return workspace.getListOfChildren().isEmpty();
    }

    private String getRootForURLs(URL[] urls) {
        try {
            for (int i = 0; i < urls.length; ++i) {
                URL url = URLFileSystem.isDirectoryPath((URL)urls[i]) ? urls[i] : URLFileSystem.getParent((URL)urls[i]);
                CVSRootString root = CVSRootCache.getInstance().getRoot(url);
                if (root == null) continue;
                return root.toString();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    private JMenu createVersioningSubmenu(Context context) {
        JMenu menu = VCSMenuUtils.createVersioningSubmenu();
        float section = 1.0f;
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_LOGIN_CMD_ID, section, context);
        if (!CVSLoginCache.getInstance().isLoggedIn()) {
            return menu;
        }
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_INHERIT_CONNECTION_CMD_ID, section += 1.0f, context);
        int legacyDynamicCommandId = this.getLegacyDynamicCommandID(context);
        if (legacyDynamicCommandId >= 0) {
            this.addDynamicMenuItem(menu, legacyDynamicCommandId, section += 1.0f, context);
        }
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UPDATE_PROJECT_CMD_ID, section += 1.0f, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UPDATE_WORKSPACE_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UPDATE_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_COMMIT_PROJECT_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_COMMIT_WORKSPACE_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_COMMIT_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ADD_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ADD_BINARY_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_REMOVE_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_EDIT_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UNEDIT_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UNDO_CHANGES_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_WATCH_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_CREATE_BRANCH_CMD_ID, section += 1.0f, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_MERGE_BRANCH_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_SWITCH_BRANCH_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ASSIGN_PROJECT_TAG_CMD_ID, section += 1.0f, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ASSIGN_WORKSPACE_TAG_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ASSIGN_TAG_CMD_ID, section, context);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_LOG_CMD_ID, section += 1.0f, context);
        this.addDynamicMenuItem(menu, PropertiesCommand.PROPERTIES_CMD_ID, section += 1.0f, context);
        return menu;
    }

    private void addDynamicMenuItem(JMenu menu, int cmdId, float section, Context context) {
        VCSMenuUtils.addLazyDynamicMenuItem((JMenu)menu, (int)cmdId, (float)section, (Context)context);
    }

    private final int getLegacyDynamicCommandID(Context context) {
        Locatable[] locatables;
        VCSStatus status;
        CVSConnectionListAPI connectionList;
        URL[] urls;
        Workspace workspace = CVSFolderOperationUtil.getContextWorkspace(context);
        Project project = null;
        if (workspace != null) {
            if (this.getStatus((Locatable)workspace) == CVSFileStatus.STATUS_CONFLICTS) {
                return CVSCommandConstants.OPERATION_MERGE_CMD_ID;
            }
            if (this.isWorkspaceEmpty(workspace)) {
                return CVSCommandConstants.OPERATION_CHECKOUT_CMD_ID;
            }
            urls = CVSFolderOperationUtil.getWorkspaceFolderURLs(workspace);
            if (this.getRootForURLs(urls) == null) {
                return CVSCommandConstants.OPERATION_IMPORT_CMD_ID;
            }
        }
        if (workspace == null) {
            project = CVSFolderOperationUtil.getContextProject(context);
        }
        if (project != null) {
            if (this.getStatus((Locatable)project) == CVSFileStatus.STATUS_CONFLICTS) {
                return CVSCommandConstants.OPERATION_MERGE_CMD_ID;
            }
            if (this.isProjectEmpty(project)) {
                return CVSCommandConstants.OPERATION_CHECKOUT_CMD_ID;
            }
            urls = CVSFolderOperationUtil.getProjectFolderURLs(project);
            if (this.getRootForURLs(urls) == null) {
                return CVSCommandConstants.OPERATION_IMPORT_CMD_ID;
            }
        }
        if (((CVSConnectionListData)(connectionList = CVSConnectionNodes.getConnectionListAPI())).getConnectionCount() > 0) {
            if (workspace != null) {
                return CVSCommandConstants.OPERATION_UPDATE_WORKSPACE_CMD_ID;
            }
            if (project != null) {
                return CVSCommandConstants.OPERATION_UPDATE_PROJECT_CMD_ID;
            }
        }
        if ((status = this.getStatus((locatables = VCSContextUtils.getContextLocatables((Context)context, (URLFilter)CVSClient.getInstance().getURLFilter()))[0])) == CVSFileStatus.STATUS_CONFLICTS) {
            return CVSCommandConstants.OPERATION_MERGE_CMD_ID;
        }
        return -1;
    }
}

