/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.replace.ReplaceMenuManager;
import oracle.ide.util.Assert;
import oracle.ide.util.Enum;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.util.Log;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.AsynchronousStatusCache;
import oracle.jdeveloper.vcs.changelist.AsynchronousStatusTask;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListContextMenuListener;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventListener;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.changelist.cmd.OpenCommand;
import oracle.jdeveloper.vcs.changeset.ChangeSetChangeList;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSInvokableState;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSConfigUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSCommandOptionsPrefs;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFileURLFileSystemHelper;
import oracle.jdevimpl.vcs.cvs.CVSIgnorePatternList;
import oracle.jdevimpl.vcs.cvs.CVSLoginCache;
import oracle.jdevimpl.vcs.cvs.CVSRootContext;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.CVSVersionToolsPrefs;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginEvent;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginListener;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.resource.Resource;
import oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.util.ActionUtil;
import oracle.jdevimpl.vcs.util.DelimitedStrings;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import oracle.ocvs.OCVSPrompter;
import oracle.ocvs.OCVSRoot;

public class CVSChangeListWindow
extends ChangeListWindow {
    public static final String OPEN_INCOMING_CMD = OpenIncomingCommand.class.getName();
    public static final int OPEN_INCOMING_CMD_ID = Ide.findOrCreateCmdID((String)OPEN_INCOMING_CMD);
    private static final String FORCE_COMMIT_CMD = "CVSChangeListWindow.ForceCommit";
    public static final int FORCE_COMMIT_CMD_ID = Ide.findOrCreateCmdID((String)"CVSChangeListWindow.ForceCommit");
    private static final String MODE_PERSISTENCE_KEY = "CVS.PendingChangesWindow.Mode";
    private static final String CANDIDATES_VISIBLE_PERSISTENCE_KEY = "CVS.PendingChangesWindow.CandidatesVisible";
    private static final String INCOMING_VISIBLE_PERSISTENCE_KEY = "CVS.PendingChangesWindow.IncomingVisible";
    private static final String WATCHERS_VISIBLE_PERSISTENCE_KEY = "CVS.PendingChangesWindow.WatchersVisible";
    private OptionsStateListener _optionsStateListener;
    private StructureChangeListener _preferencesListener;
    private static VCSThreadPool _threadPool;
    private static ToggleAction _displayConflictsAction;
    private JComponent _gui;
    private CardLayout _guiCardLayout;
    private JComponent _conflictsFilterPanel;
    private static final String GUI_CHANGELISTWINDOW = "changeListWindow";
    private static final String GUI_NO_CONNECTION = "noConnection";
    private static final HelpInfo F1_HELP_INFO;
    private static final Log LOG;
    private static final String SETTINGS_NAMESPACE_URI;
    private static final String SETTINGS_ROOT_TAG = "changelist-settings";
    private static final String FILENAME = "changelist-settings.xml";
    private static final Object _incomingChangesMutexLock;

    public HelpInfo getHelpInfo() {
        return F1_HELP_INFO;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._guiCardLayout = new CardLayout();
            this._gui = new JPanel(this._guiCardLayout);
            this._gui.add(super.getGUI(), GUI_CHANGELISTWINDOW);
            FocusableLabel defaultLabel = new FocusableLabel(CVSArb.get("NO_ACTIVE_CONNECTION"));
            defaultLabel.setOpaque(true);
            defaultLabel.setBackground(UIManager.getColor("window"));
            this._gui.add((Component)defaultLabel, GUI_NO_CONNECTION);
            this.updateGUICardLayout();
        }
        return this._gui;
    }

    private void updateGUICardLayout() {
        if (this._gui == null) {
            return;
        }
        if (CVSLoginCache.getInstance().isLoggedIn()) {
            this._guiCardLayout.show(this._gui, GUI_CHANGELISTWINDOW);
        } else {
            this._guiCardLayout.show(this._gui, GUI_NO_CONNECTION);
        }
    }

    private JComponent getConflictsFilterPanel() {
        if (this._conflictsFilterPanel == null) {
            JLabel removeFilterLabel = new JLabel(CVSArb.get("CONFLICTS_FILTER_LABEL") + " ");
            removeFilterLabel.setIcon(OracleIcons.getIcon((String)"info.png"));
            HyperlinkButton removeFilterButton = new HyperlinkButton(CVSArb.get("CONFLICTS_FILTER_REMOVE_FILTER"));
            removeFilterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CVSChangeListWindow.getChangeListWindow().setDisplayOutgoingConflicts(false);
                }
            });
            this._conflictsFilterPanel = Box.createHorizontalBox();
            this._conflictsFilterPanel.add(this.getToolbar().newSeparator());
            this._conflictsFilterPanel.add(removeFilterLabel);
            this._conflictsFilterPanel.add((Component)removeFilterButton);
            this._conflictsFilterPanel.setVisible(false);
        }
        return this._conflictsFilterPanel;
    }

    public CVSChangeListWindow(String windowID) {
        super(CVSChangeListWindow._createChangeLists(), windowID);
        this.getChangeList().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if ("optionsVisible".equals(pce.getPropertyName())) {
                    Ide.getDTCache().putBoolean("CVS.ChangeListWindow.CommentsVisible", (Boolean)pce.getNewValue());
                }
            }
        });
        IdeAction.findOrCreate((int)OPEN_INCOMING_CMD_ID, (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.cvs"), OPEN_INCOMING_CMD), (String)"");
        CVSLogin.addLoginListener(new CVSLoginListener(){

            @Override
            public void loginPerformed(CVSLoginEvent le) {
                CVSChangeListWindow.this.updateGUICardLayout();
            }

            @Override
            public void logoutPerformed(CVSLoginEvent le) {
                CVSChangeListWindow.this.updateGUICardLayout();
            }
        });
        CVSConnectionNodes.getConnectionListNode().attach(new Observer(){

            public void update(Object observed, UpdateMessage change) {
                if (change.getMessageID() == UpdateMessage.CHILD_ADDED || change.getMessageID() == UpdateMessage.CHILD_REMOVED) {
                    CVSChangeListWindow.this.updateGUICardLayout();
                }
            }
        });
    }

    private static final ChangeList[] _createChangeLists() {
        return new ChangeList[]{new OutgoingChangeList(), new CandidatesChangeList(), new IncomingChangeList(), new WatchersChangeList()};
    }

    public static final CVSChangeListWindow getChangeListWindow() {
        return (CVSChangeListWindow)DockStation.getDockStation().getDockable(new ViewId(CVSClient.CHANGE_LIST_ID));
    }

    public static final synchronized ToggleAction getDisplayConflictsAction() {
        if (_displayConflictsAction != null) {
            return _displayConflictsAction;
        }
        _displayConflictsAction = new ToggleAction(CVSArb.get("DISPLAY_CONFLICTS_NAME"), OracleIcons.getIcon((String)"display_conflicts.png")){
            {
                this.setBooleanValue("Check", true);
            }

            public void actionPerformed(ActionEvent ae) {
                CVSChangeListWindow.getChangeListWindow().setDisplayOutgoingConflicts(this.getState());
            }

            public void itemStateChanged(ItemEvent ie) {
            }
        };
        return _displayConflictsAction;
    }

    public void activateOutgoingChanges() {
        if (this.getModeId() != Mode.OUTGOING) {
            this.setModeId((Object)Mode.OUTGOING);
        }
    }

    public void displayOutgoingConflicts() {
        this.setDisplayOutgoingConflicts(true);
        this.setDisplayConflictsPanel(true);
    }

    private void setDisplayOutgoingConflicts(boolean displayOutgoingConflicts) {
        CVSFileStatus[] cVSFileStatusArray;
        if (!displayOutgoingConflicts) {
            this.setDisplayConflictsPanel(false);
        }
        CVSChangeListWindow.getDisplayConflictsAction().setState(displayOutgoingConflicts);
        ChangeList changeList = this.getOutgoingChangeList();
        if (CVSChangeListWindow.getDisplayConflictsAction().getState()) {
            CVSFileStatus[] cVSFileStatusArray2 = new CVSFileStatus[1];
            cVSFileStatusArray = cVSFileStatusArray2;
            cVSFileStatusArray2[0] = CVSFileStatus.STATUS_CONFLICTS;
        } else {
            cVSFileStatusArray = null;
        }
        changeList.setFilterStatuses(cVSFileStatusArray);
    }

    private void setDisplayConflictsPanel(boolean displayConflictsPanel) {
        this.getConflictsFilterPanel().setVisible(displayConflictsPanel);
        this.getToolbar().revalidate();
    }

    protected boolean authenticate() {
        if (Boolean.getBoolean("jdev.cvs.stopbugfix4751159")) {
            return true;
        }
        Iterator<String> itr = CVSConnectionNodes.getConnectionListAPI().getConnectionNames().iterator();
        while (itr.hasNext()) {
            CVSConnectionData connection = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(itr.next());
            CVSRootString root = new CVSRootString(connection.getRoot());
            if (!root.isAccessSsh2()) continue;
            CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
            runner.getParameters().setQuiet(!Boolean.getBoolean("jdev.cvs.debugincomingchanges"));
            runner.getParameters().setContext(new CVSRootContext(root));
            runner.setCmdArray_(new String[]{"-nq", "rtag", "-d", "bogus_tag", "bogus_module"});
            final boolean[] success = new boolean[1];
            runner.addErrorMonitor(new CVSProcessStreamMonitor(){

                @Override
                public void streamLine(String line, CVSProcess process) {
                    if (line.indexOf("cannot find module") >= 0) {
                        success[0] = true;
                    }
                }
            });
            try {
                runner.exec_();
                if (success[0]) continue;
                return false;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        return true;
    }

    protected String createDisplayPersistenceKey(Object modeId) {
        return "CVS.PendingChangesWindow." + this.getDisplayPersistenceValue(modeId) + ".DisplaySettings";
    }

    private String getDisplayPersistenceValue(Object modeId) {
        if (modeId == Mode.OUTGOING) {
            return "Outgoing";
        }
        if (modeId == Mode.INCOMING) {
            return "Incoming";
        }
        if (modeId == Mode.CANDIDATES) {
            return "Candidates";
        }
        if (modeId == Mode.WATCHERS) {
            return "Watchers";
        }
        return null;
    }

    public String getTitleName() {
        return CVSArb.get("PENDING_CHANGES_TITLE");
    }

    public Icon getTabIcon() {
        return VCSIconArb.getIcon((String)"pendingchanges.png");
    }

    protected String getModePersistenceKey() {
        return MODE_PERSISTENCE_KEY;
    }

    protected String getModePersistenceValue(Object modeId) {
        return ((Mode)((Object)modeId)).name();
    }

    protected Object getModePersistenceObject(String value) {
        return Mode.valueOf(value);
    }

    public ChangeList getOutgoingChangeList() {
        return this.getChangeList((Object)Mode.OUTGOING);
    }

    public ChangeList getIncomingChangeList() {
        return this.getChangeList((Object)Mode.INCOMING);
    }

    public ChangeList getCandidatesChangeList() {
        return this.getChangeList((Object)Mode.CANDIDATES);
    }

    public ChangeList getWatchersChangeList() {
        return this.getChangeList((Object)Mode.WATCHERS);
    }

    private static URL getConfigURL() {
        oracle.ide.ExtensionRegistry er = oracle.ide.ExtensionRegistry.getExtensionRegistry();
        return URLFactory.newURL((URL)er.getSystemDirectory("oracle.jdeveloper.cvs"), (String)FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delayedInitialization() {
        Class<CVSChangeListWindow> clazz = CVSChangeListWindow.class;
        synchronized (CVSChangeListWindow.class) {
            if (_threadPool == null) {
                _threadPool = new VCSThreadPool(10, "CVSChangeListWindow");
                LOG.trace("CVS: Pending Changes: Created thread pool.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            HashStructureIO io = new HashStructureIO(SETTINGS_NAMESPACE_URI, SETTINGS_ROOT_TAG);
            HashStructure customizerSettings = null;
            try {
                URL configUrl = CVSChangeListWindow.getConfigURL();
                customizerSettings = URLFileSystem.exists((URL)configUrl) ? (HashStructure)io.load(configUrl) : null;
            }
            catch (IOException ioe) {
                FeedbackManager.reportException((Throwable)ioe);
            }
            if (customizerSettings != null) {
                HashMap<CVSOptionId, Object> customizerOptionsMap = new HashMap<CVSOptionId, Object>();
                Iterator itr = customizerSettings.keySet().iterator();
                while (itr.hasNext()) {
                    String key = itr.next().toString();
                    CVSOptionId optionId = CVSOptionId.valueOf(key);
                    if (optionId == CVSOptionId.UPDATE_CLEAN_UPDATE) continue;
                    Object value = customizerSettings.getObject(key);
                    if (value instanceof Boolean) {
                        Object object = value = (Boolean)value != false ? Boolean.TRUE : Boolean.FALSE;
                    }
                    if (optionId == null) continue;
                    customizerOptionsMap.put(optionId, value);
                }
                customizerOptionsMap.remove((Object)CVSOptionId.UPDATE_CLEAN_UPDATE);
                CVSClient.getInstance().getChangeListOptionsCustomizer().setOptions(customizerOptionsMap);
            }
            this._preferencesListener = new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (!VCSConfigUtils.isSignificantStructureChange((StructureChangeEvent)e)) {
                        return;
                    }
                    if (CVSClient.getInstance() != null) {
                        CVSChangeListWindow.this.prefsChanged();
                    }
                }
            };
            CVSVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).addStructureChangeListener(this._preferencesListener);
            super.delayedInitialization();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postDeinitialization() {
        super.postDeinitialization();
        if (this._preferencesListener != null) {
            CVSVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).removeStructureChangeListener(this._preferencesListener);
            this._preferencesListener = null;
        }
        Class<CVSChangeListWindow> clazz = CVSChangeListWindow.class;
        synchronized (CVSChangeListWindow.class) {
            if (_threadPool != null) {
                _threadPool.destroy();
                LOG.trace("CVS: Pending Changes: Destroyed thread pool.");
            }
            _threadPool = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void preferencesChanged() {
        super.preferencesChanged();
        ((IncomingChangeList)this.getIncomingChangeList()).timerIntervalChanged();
    }

    public boolean isUsingCommitDialog() {
        String pref = CVSVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getChangelistCommitDialog();
        if ("changelist_commit_dialog_always".equals(pref)) {
            return true;
        }
        if ("changelist_commit_dialog_never".equals(pref)) {
            return false;
        }
        return !this.getChangeList().isOptionsVisible();
    }

    protected void updateEllipsisItems() {
        boolean showEllipsis = this.isUsingCommitDialog();
        this.setEllipsisVisible(this.getLocalAction(CVSCommandConstants.OPERATION_COMMIT_CMD_ID), showEllipsis);
    }

    protected void setCommentsVisible(boolean visible) {
        super.setCommentsVisible(visible);
        this.updateEllipsisItems();
    }

    protected void addToolbarActions(Toolbar toolbar) {
        super.addToolbarActions(toolbar);
        this.setEllipsisVisible(this.getLocalAction(CVSCommandConstants.OPERATION_UNEDIT_CMD_ID), false);
        this.setEllipsisVisible(this.getLocalAction(CVSCommandConstants.OPERATION_UPDATE_CMD_ID), false);
        this.setEllipsisVisible(this.getLocalAction(CVSCommandConstants.OPERATION_ADD_CMD_ID), false);
    }

    protected void updateVisibleToolbarActions(Toolbar toolbar) {
        toolbar.removeAll();
        super.addRefreshToolbarAction(toolbar);
        if (this.getModeId() == Mode.OUTGOING) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_COMMIT_CMD_ID));
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_UNDO_CHANGES_CMD_ID));
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_MERGE_CMD_ID));
        }
        if (this.getModeId() == Mode.INCOMING) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_UPDATE_CMD_ID));
        }
        if (this.getModeId() == Mode.CANDIDATES) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_ADD_CMD_ID));
        }
        if (this.getModeId() == Mode.OUTGOING) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_DIFF_CMD_ID));
            toolbar.addSeparator();
            super.addCommentsToolbarAction(toolbar);
            toolbar.add((Component)new ToggleToolButton(CVSChangeListWindow.getDisplayConflictsAction()));
            toolbar.add(this.createCommitOptionsDropDown());
            toolbar.add((Component)this.getConflictsFilterPanel());
        }
        if (this.getModeId() == Mode.INCOMING) {
            // empty if block
        }
        if (this.getModeId() == Mode.CANDIDATES) {
            // empty if block
        }
        if (this.getModeId() == Mode.WATCHERS) {
            toolbar.add(Box.createGlue());
            toolbar.add((Component)((WatchersChangeList)this.getWatchersChangeList()).getLastUpdatedLabel());
        }
        if (this.getModeId() == Mode.OUTGOING) {
            toolbar.addSeparator();
            toolbar.addToggleButton((ToggleAction)((ChangeSetChangeList)this.getOutgoingChangeList()).getToggleChangeSetsAction((ChangeListWindow)this));
        }
        toolbar.validate();
        toolbar.invalidate();
        toolbar.repaint();
    }

    protected void updateBusyTickerVisible() {
        if (this.getModeId() == Mode.WATCHERS) {
            WatchersChangeList watchersChangeList = (WatchersChangeList)this.getWatchersChangeList();
            watchersChangeList.getLastUpdatedLabel().setVisible(!watchersChangeList.isBusy());
        }
        super.updateBusyTickerVisible();
    }

    private Component createCommitOptionsDropDown() {
        IdeAction optionsAction = ActionUtil.getAction(Resource.class, (int)Ide.findOrCreateCmdID((String)"CVSChangeListWindow.Options"), null, (String)"CHANGELIST_OPTIONS", (String)"settings.png");
        IdeAction forceCommitAction = IdeAction.findOrCreate((int)FORCE_COMMIT_CMD_ID, null, (String)CVSArb.get("COMMIT_FORCE_COMMIT"), (String)"", (Integer)new Integer(0), null, null, (boolean)true);
        forceCommitAction.putValue("Check", (Object)Boolean.TRUE);
        Action[] operationActions = this.getLocalOperationActions();
        if (this._optionsStateListener == null) {
            this._optionsStateListener = new OptionsStateListener((Action)optionsAction, operationActions);
        }
        this.addPropertyChangeListeners(operationActions, this._optionsStateListener);
        this._optionsStateListener.updateOptionsState();
        Map options = CVSClient.getInstance().getChangeListOptionsCustomizer().getOptions();
        Boolean currentValue = (Boolean)options.get((Object)CVSOptionId.COMMIT_FORCE_COMMIT);
        forceCommitAction.setState(currentValue == null ? false : currentValue);
        forceCommitAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals("State")) {
                    Map options = CVSClient.getInstance().getChangeListOptionsCustomizer().getOptions();
                    options.put(CVSOptionId.COMMIT_FORCE_COMMIT, pce.getNewValue());
                    HashStructure customizerSettings = HashStructure.newInstance();
                    for (Map.Entry entry : options.entrySet()) {
                        if (!(entry.getKey() instanceof CVSOptionId)) continue;
                        customizerSettings.putBoolean(((CVSOptionId)((Object)entry.getKey())).name(), ((Boolean)entry.getValue()).booleanValue());
                    }
                    HashStructureIO io = new HashStructureIO(SETTINGS_NAMESPACE_URI, CVSChangeListWindow.SETTINGS_ROOT_TAG);
                    try {
                        io.save(CVSChangeListWindow.getConfigURL(), (Object)customizerSettings);
                    }
                    catch (IOException ioe) {
                        FeedbackManager.reportException((Throwable)ioe);
                    }
                    CVSClient.getInstance().getChangeListOptionsCustomizer().setOptions(options);
                }
            }
        });
        MenuToolButton popupButton = new MenuToolButton(new ToggleAction[0], (ToggleAction)optionsAction);
        popupButton.addPopupItem((ToggleAction)forceCommitAction);
        return popupButton;
    }

    private Action[] getLocalOperationActions() {
        int[] cmdIds = new int[]{CVSCommandConstants.OPERATION_COMMIT_CMD_ID, CVSCommandConstants.OPERATION_COMMIT_ALL_CMD_ID};
        return this.getLocalActions(cmdIds);
    }

    private Action[] getLocalActions(int[] cmdIds) {
        Action[] actions = new Action[cmdIds.length];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = this.getLocalAction(cmdIds[i]);
        }
        return actions;
    }

    private void addPropertyChangeListeners(Action[] actions, PropertyChangeListener l) {
        for (int i = 0; i < actions.length; ++i) {
            actions[i].removePropertyChangeListener(l);
            actions[i].addPropertyChangeListener(l);
        }
    }

    public static final Object getIncomingChangesMutexLock() {
        return _incomingChangesMutexLock;
    }

    protected String[] getPreferencesPath() {
        return VCSNavigableUtils.getSystemNavigablePath((String)Resource.get("CVS_SHORT_NAME"), (String[])new String[]{Resource.get("VERSION_TOOLS_TRAVERSABLE_TITLE")});
    }

    static {
        F1_HELP_INFO = new HelpInfo("f1_cvspendingchanges_html");
        LOG = new Log("vcs-cvs");
        SETTINGS_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)SETTINGS_ROOT_TAG);
        _incomingChangesMutexLock = new Object();
    }

    private static class WatchersStatusCache
    extends AsynchronousStatusCache {
        private WatchersStatusCache() {
        }

        protected final void getImpl(URL[] urls, ChangeListStatus[] statuses) throws Exception {
            for (int i = 0; i < statuses.length; ++i) {
                statuses[i] = WatchersStatus.NO_WATCHER;
            }
        }
    }

    private static class WatchersStatusTask
    extends AsynchronousStatusTaskImpl {
        WatchersStatusTask(ChangeList changeList, VCSThreadPool threadPool) {
            super(changeList, threadPool);
        }

        protected boolean isChangeListVisible() {
            return CVSChangeListWindow.getChangeListWindow().isChangeListVisible(CVSChangeListWindow.getChangeListWindow().getWatchersChangeList());
        }

        protected void populateStatusCacheMap(final Map<VCSHashURL, Object> statusCacheMap, Collection<VCSHashURL> directoriesToQuery) throws Exception {
            for (final VCSHashURL directoryUrl : directoriesToQuery) {
                CVSRunner runner = this.createRunner();
                runner.setCmdArray_(new String[]{"watchers"});
                runner.setDirURL_(directoryUrl.getURL());
                runner.addOutputMonitor(new CVSProcessStreamMonitor(){
                    private VCSHashURL _currentUrl = null;

                    @Override
                    protected void streamLine(String line, CVSProcess process) throws Exception {
                        String[] values = DelimitedStrings.getTabSeparatedInstance().parse(line);
                        if (values.length < 2) {
                            return;
                        }
                        if (!values[0].equals("")) {
                            this._currentUrl = new VCSHashURL(URLFileSystem.canonicalize((URL)URLFactory.newURL((URL)directoryUrl.getURL(), (String)values[0])));
                        }
                        if (values[0].equals("") && this._currentUrl == null) {
                            return;
                        }
                        if (line.indexOf("tedit") >= 0) {
                            this.getCachedStatus().getEditors().add(values[1]);
                        } else {
                            this.getCachedStatus().getWatchers().add(values[1]);
                        }
                    }

                    private WatchersStatus getCachedStatus() {
                        WatchersStatus status = (WatchersStatus)((Object)statusCacheMap.get(this._currentUrl));
                        if (status == null) {
                            status = WatchersStatus.createWatchersStatus();
                            statusCacheMap.put(this._currentUrl, status);
                        }
                        return status;
                    }
                });
                runner.exec_();
            }
        }
    }

    private static abstract class AsynchronousChangeListImpl
    extends AsynchronousChangeList {
        protected AsynchronousChangeListImpl(Object modeId) {
            super(modeId);
        }

        protected void clearPerformanceCache() {
            CVSUtil.clearPerformanceCaches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected VCSThreadPool getThreadPool() {
            Class<CVSChangeListWindow> clazz = CVSChangeListWindow.class;
            synchronized (CVSChangeListWindow.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return _threadPool;
            }
        }
    }

    private static abstract class AsynchronousStatusTaskImpl
    extends AsynchronousStatusTask {
        protected AsynchronousStatusTaskImpl(ChangeList changeList, VCSThreadPool threadPool) {
            super(changeList, threadPool);
        }

        protected boolean isClientReady() {
            return CVSFileURLFileSystemHelper.checkForCVS();
        }

        protected boolean isControlled(URL directoryUrl) {
            return CVSUtil.isOpenSessionSandbox(directoryUrl);
        }

        protected String getViewId() {
            return CVSClient.CHANGE_LIST_ID;
        }

        protected CVSRunner createRunner() {
            CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
            runner.getParameters().setQuiet(!Boolean.getBoolean("jdev.cvs.debugincomingchanges"));
            if (runner instanceof CVSInternalClientRunner) {
                ((CVSInternalClientRunner)runner).setPrompter(new CancelPrompter());
            }
            runner.setThreadPool_(this.getThreadPool());
            return runner;
        }

        private class CancelPrompter
        extends OCVSPrompter {
            private CancelPrompter() {
            }

            public char[] promptPassword(OCVSRoot root, String message) {
                return null;
            }

            public boolean promptSsh2YesNo(String message) {
                return false;
            }

            public char[] promptSsh2Passphrase(String message) {
                return null;
            }

            public char[] promptSsh2Password(String message) {
                return null;
            }
        }
    }

    private static class WatchersStatus
    extends Enum
    implements ChangeListStatus {
        public static final WatchersStatus NO_WATCHER = new WatchersStatus("NO_WATCHER");
        public static final WatchersStatus WATCHER = new WatchersStatus("WATCHER");
        private static final WatchersStatus[] PRIVATE_VALUES = new WatchersStatus[]{NO_WATCHER};
        private static int _nextOrdinal = 0;
        private final Collection<String> _editors = new HashSet<String>();
        private final Collection<String> _watchers = new HashSet<String>();

        private WatchersStatus(String name) {
            super(name, _nextOrdinal++);
        }

        public static final WatchersStatus valueOf(String name) {
            return (WatchersStatus)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final WatchersStatus[] values() throws CloneNotSupportedException {
            return (WatchersStatus[])PRIVATE_VALUES.clone();
        }

        public String getChangeListLabel() {
            return this.toString();
        }

        public boolean isChangeListCellHighlighted() {
            return false;
        }

        public Collection getEditors() {
            return this._editors;
        }

        public Collection getWatchers() {
            return this._watchers;
        }

        public boolean equals(Object o) {
            return o instanceof WatchersStatus && this.name().equals(((WatchersStatus)((Object)o)).name());
        }

        static final WatchersStatus createWatchersStatus() {
            return new WatchersStatus(WATCHER.name());
        }
    }

    public static class WatchersChangeList
    extends AsynchronousChangeListImpl {
        private static final DisplayProperty DISPLAY_PROPERTY_EDITOR = new ClientDisplayProperty(CVSArb.get("DISPLAY_PROPERTY_EDITOR"), (Object)"(3) example,user,list", Collection.class);
        private static final DisplayProperty DISPLAY_PROPERTY_WATCHER = new ClientDisplayProperty(CVSArb.get("DISPLAY_PROPERTY_WATCHER"), (Object)"(3) example,user,list", Collection.class);
        private final JLabel _lastUpdatedLabel = new JLabel(" ");

        WatchersChangeList() {
            super((Object)Mode.WATCHERS);
        }

        protected TimerTask createStatusTask(VCSThreadPool threadPool) {
            return new WatchersStatusTask((ChangeList)this, threadPool);
        }

        protected ChangeListEventQueue createEventQueue() {
            ChangeListEventQueue eventQueue = super.createEventQueue();
            eventQueue.addEventListener(new ChangeListEventListener(){

                public void eventProcessed(ChangeListEvent cle) {
                    if (cle.getKind() == 0) {
                        _lastUpdatedLabel.setText(CVSArb.format("WATCHERS_LAST_UPDATED", DateFormat.getDateTimeInstance().format(System.currentTimeMillis())));
                    }
                }
            });
            return eventQueue;
        }

        protected Icon getModeIcon() {
            return null;
        }

        protected String getModeLabel() {
            return CVSArb.get("WATCHERS_BUTTON");
        }

        protected String getModeLongLabel() {
            return CVSArb.get("WATCHERS_LONG_LABEL");
        }

        protected void initializeChangeList() {
            this.setStatusCache((ChangeListStatusCache)new WatchersStatusCache());
            this.setOverlayItemProducer(CVSClient.getInstance().getChangeListOverlayItemProducer());
            this.setVisibleStatuses(new WatchersStatus[]{WatchersStatus.WATCHER});
        }

        protected DisplayProperty[] createDisplayProperties() {
            return new DisplayProperty[]{DISPLAY_PROPERTY_WATCHER, DISPLAY_PROPERTY_EDITOR};
        }

        protected Object getModelValue(URL url, DisplayProperty displayProperty) throws Exception {
            if (displayProperty == DISPLAY_PROPERTY_WATCHER) {
                WatchersStatus status = this.getStatusCache() != null && url != null ? (WatchersStatus)((Object)this.getStatusCache().getValue(url)) : WatchersStatus.NO_WATCHER;
                return status.getWatchers();
            }
            if (displayProperty == DISPLAY_PROPERTY_EDITOR) {
                WatchersStatus status = this.getStatusCache() != null && url != null ? (WatchersStatus)((Object)this.getStatusCache().getValue(url)) : WatchersStatus.NO_WATCHER;
                return status.getEditors();
            }
            return super.getModelValue(url, displayProperty);
        }

        protected String getBusyStatusMessage() {
            return CVSArb.get("WATCHERS_BUSY");
        }

        protected String getTabToggleKey() {
            return CVSChangeListWindow.WATCHERS_VISIBLE_PERSISTENCE_KEY;
        }

        private JLabel getLastUpdatedLabel() {
            return this._lastUpdatedLabel;
        }
    }

    public static class OpenIncomingCommand
    extends OpenCommand {
        public OpenIncomingCommand() {
            super(OPEN_INCOMING_CMD_ID);
        }

        protected void openDefaultEditorInFrame(Context context) {
            try {
                IdeAction.find((int)CVSCommandConstants.OPERATION_DIFF_HEAD_CMD_ID).performAction(context);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private static class UpdateStatusCache
    extends AsynchronousStatusCache {
        private UpdateStatusCache() {
        }

        protected final void getImpl(URL[] urls, ChangeListStatus[] statuses) throws Exception {
            for (int i = 0; i < statuses.length; ++i) {
                statuses[i] = UpdateStatus.STATUS_NOT_KNOWN;
            }
        }
    }

    private static class UpdateStatusTask
    extends AsynchronousStatusTaskImpl {
        UpdateStatusTask(ChangeList changeList, VCSThreadPool threadPool) {
            super(changeList, threadPool);
        }

        protected boolean isChangeListVisible() {
            return CVSChangeListWindow.getChangeListWindow().isChangeListVisible(CVSChangeListWindow.getChangeListWindow().getIncomingChangeList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateStatusCacheMap(final Map<VCSHashURL, Object> updateStatusCacheMap, Collection<VCSHashURL> directoriesToQuery) throws Exception {
            for (final VCSHashURL directoryUrl : directoriesToQuery) {
                CVSRunner runner = this.createRunner();
                runner.getParameters().setKeepCachedFiles(true);
                runner.setCmdList_(Arrays.asList("-nq", "update", "-d"));
                runner.setDirURL_(directoryUrl.getURL());
                runner.addOutputMonitor(new CVSProcessStreamMonitor(){
                    private final Pattern _pattern = Pattern.compile("^([\\p{Upper}\\?]) (.*)");

                    @Override
                    protected void streamLine(String line, CVSProcess process) throws Exception {
                        Matcher matcher = this._pattern.matcher(line);
                        if (!matcher.matches()) {
                            return;
                        }
                        char updateCode = matcher.group(1).charAt(0);
                        VCSHashURL url = new VCSHashURL(URLFileSystem.canonicalize((URL)URLFactory.newURL((URL)directoryUrl.getURL(), (String)matcher.group(2))));
                        if (GlobalIgnoreList.isGloballyIgnored((URL)url.getURL())) {
                            return;
                        }
                        updateStatusCacheMap.put(url, UpdateStatus.STATUS_NOT_KNOWN);
                        if (updateCode == 'U' || updateCode == 'P') {
                            UpdateStatus status = URLFileSystem.exists((URL)url.getURL()) ? UpdateStatus.REMOTELY_UPDATED : UpdateStatus.REMOTELY_UPDATED_NEW;
                            updateStatusCacheMap.put(url, status);
                        }
                        if (updateCode == 'C') {
                            updateStatusCacheMap.put(url, UpdateStatus.CONFLICTS_ON_MERGE);
                        }
                        if (updateCode == 'M') {
                            updateStatusCacheMap.put(url, UpdateStatus.LOCALLY_MODIFIED);
                        }
                        if (updateCode == 'A') {
                            updateStatusCacheMap.put(url, UpdateStatus.LOCALLY_ADDED);
                        }
                        if (updateCode == 'R') {
                            updateStatusCacheMap.put(url, UpdateStatus.LOCALLY_REMOVED);
                        }
                        if (updateCode == 'D') {
                            updateStatusCacheMap.put(url, UpdateStatus.LOCALLY_REMOVED);
                        }
                        if (updateCode == '?') {
                            if (URLFileSystem.isDirectory((URL)url.getURL())) {
                                updateStatusCacheMap.remove(url);
                                return;
                            }
                            updateStatusCacheMap.put(url, UpdateStatus.QUESTIONABLE_FILE);
                        }
                    }
                });
                runner.addErrorMonitor(new CVSProcessStreamMonitor(){
                    private final Pattern _pattern1 = Pattern.compile(".*: (.*) is no longer in the repository.*");
                    private final Pattern _pattern2 = Pattern.compile(".*: New directory `(.*)' -- ignored.*");

                    @Override
                    protected void streamLine(String line, CVSProcess process) throws Exception {
                        VCSHashURL url;
                        Matcher matcher1 = this._pattern1.matcher(line);
                        Matcher matcher2 = this._pattern2.matcher(line);
                        if (matcher1.matches() && !GlobalIgnoreList.isGloballyIgnored((URL)(url = new VCSHashURL(URLFactory.newURL((URL)directoryUrl.getURL(), (String)matcher1.group(1)))).getURL())) {
                            updateStatusCacheMap.put(url, UpdateStatus.REMOTELY_REMOVED);
                        }
                        if (matcher2.matches() && !GlobalIgnoreList.isGloballyIgnored((URL)(url = new VCSHashURL(URLFactory.newDirURL((URL)directoryUrl.getURL(), (String)matcher2.group(1)))).getURL())) {
                            updateStatusCacheMap.put(url, UpdateStatus.REMOTELY_UPDATED_NEW);
                        }
                    }
                });
                if (this.canExit()) {
                    return;
                }
                Object object = CVSChangeListWindow.getIncomingChangesMutexLock();
                synchronized (object) {
                    runner.exec_();
                }
            }
            if (this.canExit()) {
                return;
            }
            CVSClient client = CVSClient.getInstance();
            Iterator<Map.Entry<VCSHashURL, Object>> itr = updateStatusCacheMap.entrySet().iterator();
            while (client != null && itr.hasNext()) {
                Map.Entry<VCSHashURL, Object> entry = itr.next();
                if (entry.getValue() != UpdateStatus.CONFLICTS_ON_MERGE) continue;
                VCSHashURL url = entry.getKey();
                StatusCache<VCSStatus> statusCache = client.getStatusCache();
                if (statusCache == null || statusCache.get(url.getURL()) != CVSFileStatus.STATUS_CONFLICTS) continue;
                itr.remove();
            }
            if (updateStatusCacheMap.values().contains((Object)UpdateStatus.LOCALLY_MODIFIED)) {
                final CVSRunner runner = this.createRunner();
                runner.getParameters().setKeepCachedFiles(true);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("-nq");
                cmd.add("diff");
                if (!(runner instanceof CVSInternalClientRunner)) {
                    cmd.add("--brief");
                }
                cmd.add("-rHEAD");
                cmd.add("-rBASE");
                runner.setCmdList_(cmd);
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Map.Entry<VCSHashURL, Object> entry : updateStatusCacheMap.entrySet()) {
                    if (entry.getValue() != UpdateStatus.LOCALLY_MODIFIED) continue;
                    urls.add(entry.getKey().getURL());
                }
                VCSDirectoryInvokable invokable = new VCSDirectoryInvokable((VCSInvokableState)new VCSDirectoryInvokableState(urls.toArray(new URL[0])), 10){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected boolean doInvocation(URL parent, URL[] invokeUrlArgs) throws Exception {
                        String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrlArgs);
                        runner.setDirURL_(parent);
                        runner.getParameters().setFiles(Arrays.asList(filenames));
                        if (this.canExit()) {
                            return false;
                        }
                        Object object = CVSChangeListWindow.getIncomingChangesMutexLock();
                        synchronized (object) {
                            runner.exec_();
                        }
                        String output = runner.getOutputText_();
                        for (int i = 0; i < invokeUrlArgs.length; ++i) {
                            if (output.indexOf("Index: " + URLFileSystem.getFileName((URL)invokeUrlArgs[i])) < 0) continue;
                            updateStatusCacheMap.put(new VCSHashURL(invokeUrlArgs[i]), UpdateStatus.REMOTELY_UPDATED);
                        }
                        return true;
                    }
                };
                if (!invokable.runInvokable()) {
                    return;
                }
            }
        }
    }

    private static class UpdateStatus
    extends Enum
    implements ChangeListStatus {
        public static final UpdateStatus REMOTELY_UPDATED = new UpdateStatus("REMOTELY_UPDATED", "REMOTELY_UPDATED");
        public static final UpdateStatus REMOTELY_UPDATED_NEW = new UpdateStatus("REMOTELY_UPDATED_NEW", "REMOTELY_UPDATED_NEW");
        public static final UpdateStatus REMOTELY_REMOVED = new UpdateStatus("REMOTELY_REMOVED", "REMOTELY_REMOVED");
        public static final UpdateStatus CONFLICTS_ON_MERGE = new UpdateStatus("CONFLICTS_ON_MERGE", "CONFLICTS_ON_MERGE");
        public static final UpdateStatus LOCALLY_MODIFIED = new UpdateStatus("LOCALLY_MODIFIED", "LOCALLY_MODIFIED");
        public static final UpdateStatus LOCALLY_ADDED = new UpdateStatus("LOCALLY_ADDED", "LOCALLY_ADDED");
        public static final UpdateStatus LOCALLY_REMOVED = new UpdateStatus("LOCALLY_REMOVED", "LOCALLY_REMOVED");
        public static final UpdateStatus QUESTIONABLE_FILE = new UpdateStatus("QUESTIONABLE_FILE");
        public static final UpdateStatus STATUS_NOT_KNOWN = new UpdateStatus("STATUS_NOT_KNOWN");
        private static final UpdateStatus[] PRIVATE_VALUES = new UpdateStatus[]{REMOTELY_UPDATED, REMOTELY_UPDATED_NEW, REMOTELY_REMOVED, CONFLICTS_ON_MERGE, LOCALLY_MODIFIED, LOCALLY_ADDED, LOCALLY_REMOVED, QUESTIONABLE_FILE, STATUS_NOT_KNOWN};
        private static int _nextOrdinal = 0;
        private final String _label;

        private UpdateStatus(String name) {
            this(name, null);
        }

        private UpdateStatus(String name, String labelResourceIndex) {
            super(name, _nextOrdinal++);
            this._label = labelResourceIndex != null ? CVSArb.get(labelResourceIndex) : null;
        }

        public static final UpdateStatus valueOf(String name) {
            return (UpdateStatus)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final UpdateStatus[] values() {
            return (UpdateStatus[])PRIVATE_VALUES.clone();
        }

        public String getChangeListLabel() {
            return this._label;
        }

        public boolean isChangeListCellHighlighted() {
            return ((Object)((Object)this)).equals((Object)CONFLICTS_ON_MERGE);
        }
    }

    private static class CandidatesChangeListEventQueue
    extends ChangeListEventQueue {
        CandidatesChangeListEventQueue(ChangeList changeList) {
            super(changeList);
        }

        protected int getBatchCount() {
            return 50;
        }

        protected void filterByStatus(Collection<VCSHashURL> urls) throws Exception {
            CVSIgnorePatternList.filterIgnored(VCSHashURL.convertToURLs(urls));
            super.filterByStatus(urls);
        }
    }

    private static class OutgoingChangeListEventQueue
    extends ChangeListEventQueue {
        OutgoingChangeListEventQueue(ChangeList changeList) {
            super(changeList);
        }

        protected int getBatchCount() {
            return 50;
        }

        protected final boolean supportsRemovedEntries() {
            return true;
        }

        protected final void addRemovedEntryURLs(Collection<VCSHashURL> urls, URL directoryUrl, VCSCancellable cancellable) {
            if (!CVSUtil.isOpenSessionSandbox(directoryUrl)) {
                return;
            }
            Collection<CVSEntry> entries = null;
            try {
                entries = CVSEntriesCache.getInstance().getEntries(directoryUrl);
            }
            catch (IOException ioe) {
                Assert.printStackTrace((Throwable)ioe);
            }
            if (entries == null) {
                return;
            }
            Iterator<CVSEntry> itr = entries.iterator();
            while (itr.hasNext() && !cancellable.isCancelled()) {
                URL url;
                CVSEntry entry = itr.next();
                if (entry.isDirectory() || !entry.isRemoved() || GlobalIgnoreList.isGloballyIgnored((URL)(url = URLFactory.newURL((URL)directoryUrl, (String)entry.getName()))) || URLFileSystem.exists((URL)url)) continue;
                urls.add(new VCSHashURL(url));
            }
        }
    }

    public static class CandidatesChangeList
    extends ChangeList {
        private ContextMenuListener _candidatesContextMenuListener;

        CandidatesChangeList() {
            super((Object)Mode.CANDIDATES);
            this.setExcludeDirectories(true);
        }

        protected Icon getModeIcon() {
            return null;
        }

        protected String getModeLabel() {
            return CVSArb.get("CANDIDATE_FILES_BUTTON");
        }

        protected String getModeLongLabel() {
            return CVSArb.get("CANDIDATE_FILES_LONG_LABEL");
        }

        protected void initializeChangeList() {
            this.setPolicyStatusCache(CVSClient.getStatusCache());
            this.setOverlayItemProducer(CVSClient.getInstance().getChangeListOverlayItemProducer());
            this.setVisibleStatuses(new CVSFileStatus[]{CVSFileStatus.STATUS_UNADDED});
        }

        protected ChangeListEventQueue createEventQueue() {
            return new CandidatesChangeListEventQueue(this);
        }

        protected String getBusyStatusMessage() {
            return CVSArb.get("CANDIDATES_BUSY");
        }

        protected String getTabToggleKey() {
            return CVSChangeListWindow.CANDIDATES_VISIBLE_PERSISTENCE_KEY;
        }

        protected void addContextMenuListeners(ContextMenu contextMenu) {
            this._candidatesContextMenuListener = new CandidatesContextMenuListener(this);
            contextMenu.addContextMenuListener(this._candidatesContextMenuListener);
        }

        protected void removeContextMenuListeners(ContextMenu contextMenu) {
            contextMenu.removeContextMenuListener(this._candidatesContextMenuListener);
            this._candidatesContextMenuListener = null;
        }
    }

    public static class IncomingChangeList
    extends AsynchronousChangeListImpl {
        private ContextMenuListener _incomingContextMenuListener;

        IncomingChangeList() {
            super((Object)Mode.INCOMING);
            this.setExcludeDirectories(false);
        }

        protected Icon getModeIcon() {
            return null;
        }

        protected String getModeLabel() {
            return CVSArb.get("INCOMING_CHANGES_BUTTON");
        }

        protected String getModeLongLabel() {
            return CVSArb.get("INCOMING_CHANGES_LONG_LABEL");
        }

        protected void initializeChangeList() {
            this.setStatusCache((ChangeListStatusCache)new UpdateStatusCache());
            this.setOverlayItemProducer(CVSClient.getInstance().getChangeListOverlayItemProducer());
            this.setVisibleStatuses(new UpdateStatus[]{UpdateStatus.REMOTELY_UPDATED, UpdateStatus.REMOTELY_UPDATED_NEW, UpdateStatus.REMOTELY_REMOVED, UpdateStatus.CONFLICTS_ON_MERGE});
        }

        protected DisplayProperty[] createDisplayProperties() {
            return new ClientDisplayProperty[]{new ClientDisplayProperty(CVSArb.get("DISPLAY_PROPERTY_INCOMING_STATUS"), (Object)CVSArb.get("CONFLICTS_ON_MERGE"), ChangeListStatus.class)};
        }

        protected Integer getTimerIntervalImpl() {
            int timer = CVSVersionToolsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getChangelistTimer();
            long timerMillis = timer * 1000;
            if (timerMillis <= 0L) {
                timerMillis = Integer.MAX_VALUE;
            }
            return new Integer((int)timerMillis);
        }

        protected TimerTask createStatusTask(VCSThreadPool threadPool) {
            return new UpdateStatusTask((ChangeList)this, threadPool);
        }

        protected String getBusyStatusMessage() {
            return CVSArb.get("INCOMING_BUSY");
        }

        protected void addContextMenuListeners(ContextMenu contextMenu) {
            this._incomingContextMenuListener = new IncomingContextMenuListener((ChangeList)this);
            contextMenu.addContextMenuListener(this._incomingContextMenuListener);
        }

        protected void removeContextMenuListeners(ContextMenu contextMenu) {
            contextMenu.removeContextMenuListener(this._incomingContextMenuListener);
            this._incomingContextMenuListener = null;
        }

        protected String getTabToggleKey() {
            return CVSChangeListWindow.INCOMING_VISIBLE_PERSISTENCE_KEY;
        }
    }

    public static class OutgoingChangeList
    extends ChangeSetChangeList {
        private ContextMenuListener _outgoingContextMenuListener;
        private ResetFilterEventListener _resetFilterEventListener;

        OutgoingChangeList() {
            super((Object)Mode.OUTGOING, "oracle.jdeveloper.cvs");
            this.setExcludeDirectories(true);
        }

        protected Icon getModeIcon() {
            return null;
        }

        protected String getModeLabel() {
            return CVSArb.get("OUTGOING_CHANGES_BUTTON");
        }

        protected String getModeLongLabel() {
            return CVSArb.get("OUTGOING_CHANGES_LONG_LABEL");
        }

        protected void initializeChangeList() {
            this.setPolicyStatusCache(CVSClient.getStatusCache());
            this.setOverlayItemProducer(CVSClient.getInstance().getChangeListOverlayItemProducer());
            this.setVisibleStatuses(new CVSFileStatus[]{CVSFileStatus.STATUS_ADDED, CVSFileStatus.STATUS_REMOVED, CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_CONFLICTS});
            this.setOptionsCustomizer(CVSClient.getInstance().getChangeListOptionsCustomizer());
            boolean showComments = Ide.getDTCache().getBoolean("CVS.ChangeListWindow.CommentsVisible", false);
            this.setOptionsVisible(showComments);
        }

        protected DisplayProperty[] createDisplayProperties() {
            return new ClientDisplayProperty[]{new ClientDisplayProperty(CVSArb.get("DISPLAY_PROPERTY_OUTGOING_STATUS"), (Object)CVSArb.get("LABEL_ADDED"), VCSStatus.class)};
        }

        protected void defaultOptionsOnInitialInsert() {
            super.defaultOptionsOnInitialInsert();
            String currentComments = this.getCommentsCustomizer().getCommentText();
            String defaultTemplate = CVSUtil.readCommentsTemplate(Arrays.asList(this.getElements()));
            if (currentComments == null || defaultTemplate == null) {
                return;
            }
            String preferencesDefaultTemplate = this.getCommentsCustomizer().getDefaultTemplate();
            if ((currentComments.equals("") || preferencesDefaultTemplate != null && currentComments.equals(preferencesDefaultTemplate)) && this.isUseCommentTemplatesSet()) {
                this.getCommentsCustomizer().setCommentText(defaultTemplate);
                return;
            }
            if (currentComments.equals(defaultTemplate) && !this.isUseCommentTemplatesSet()) {
                this.getCommentsCustomizer().clear();
                return;
            }
        }

        protected ChangeListEventQueue createEventQueue() {
            OutgoingChangeListEventQueue eventQueue = new OutgoingChangeListEventQueue((ChangeList)this);
            this._resetFilterEventListener = new ResetFilterEventListener(eventQueue);
            eventQueue.addEventListener(this._resetFilterEventListener);
            return eventQueue;
        }

        protected void startImpl() {
            super.startImpl();
            ChangeListEvent cle = new ChangeListEvent(2);
            cle.setRunnable(new Runnable(){

                @Override
                public void run() {
                    _resetFilterEventListener.setEnabled(true);
                }
            });
            this.getEventQueue().enqueue(cle);
        }

        protected String getBusyStatusMessage() {
            return CVSArb.get("OUTGOING_BUSY");
        }

        protected void addContextMenuListeners(ContextMenu contextMenu) {
            this._outgoingContextMenuListener = new OutgoingContextMenuListener(this);
            contextMenu.addContextMenuListener(this._outgoingContextMenuListener);
        }

        protected void removeContextMenuListeners(ContextMenu contextMenu) {
            contextMenu.removeContextMenuListener(this._outgoingContextMenuListener);
            this._outgoingContextMenuListener = null;
        }

        private boolean isUseCommentTemplatesSet() {
            return CVSCommandOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getUseCommentTemplates();
        }

        private ChangeListCommentsCustomizer getCommentsCustomizer() {
            return (ChangeListCommentsCustomizer)CVSClient.getInstance().getChangeListOptionsCustomizer();
        }

        class ResetFilterEventListener
        extends ChangeListEventListener {
            private final ChangeListEventQueue _eventQueue;
            private ChangeListEvent _cle = null;
            private Object _filterStatuses = null;
            private boolean _enabled;

            ResetFilterEventListener(ChangeListEventQueue eventQueue) {
                this._eventQueue = eventQueue;
            }

            void setEnabled(boolean enabled) {
                this._enabled = enabled;
            }

            public void eventDispatched(ChangeListEvent cle) {
                if (!this._enabled) {
                    return;
                }
                this._cle = cle;
                this._filterStatuses = OutgoingChangeList.this.getFilterStatuses();
            }

            public void eventProcessed(ChangeListEvent cle) {
                if (!this._enabled) {
                    return;
                }
                if (this._cle != cle) {
                    return;
                }
                if (OutgoingChangeList.this.getFilterStatuses() != this._filterStatuses) {
                    this._eventQueue.removeEventListener((ChangeListEventListener)this);
                    cle = new ChangeListEvent(2);
                    cle.setRunnable(new Runnable(){

                        @Override
                        public void run() {
                            ResetFilterEventListener.this._eventQueue.addEventListener((ChangeListEventListener)ResetFilterEventListener.this);
                        }
                    });
                    this._eventQueue.enqueue(cle);
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CVSChangeListWindow.getDisplayConflictsAction().getState() && OutgoingChangeList.this.getElements().length <= 0) {
                            CVSChangeListWindow.getChangeListWindow().setDisplayOutgoingConflicts(false);
                        }
                    }
                });
            }
        }
    }

    private class OptionsStateListener
    implements PropertyChangeListener {
        private final Action _optionsAction;
        private final Action[] _operationActions;

        OptionsStateListener(Action optionsAction, Action[] operationActions) {
            this._optionsAction = optionsAction;
            this._operationActions = operationActions;
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("enabled")) {
                this.updateOptionsState();
            }
        }

        private void updateOptionsState() {
            this._optionsAction.setEnabled(this.getState());
        }

        private boolean getState() {
            for (int i = 0; i < this._operationActions.length; ++i) {
                if (!this._operationActions[i].isEnabled()) continue;
                return true;
            }
            return false;
        }
    }

    private static class CandidatesContextMenuListener
    extends ChangeListContextMenuListener {
        CandidatesContextMenuListener(ChangeList changeList) {
            super(changeList);
        }

        public void menuWillShowImpl(ContextMenu popup) {
            if (this.getLocatableSelection(popup.getContext()).length > 0) {
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_ADD_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_ADD_BINARY_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_ADD_ALL_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_IGNORE_FILE_CMD_ID)), 2.1f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_IGNORE_FILE_TYPE_CMD_ID)), 2.1f);
            }
            this.addMenuItemRefresh(popup);
            this.addMenuItemCopyFileList(popup);
            this.addMenuItemSelectInNavigator(popup);
            this.addMenuItemPreferences(popup);
        }
    }

    private static class IncomingContextMenuListener
    extends ChangeListContextMenuListener {
        IncomingContextMenuListener(ChangeList changeList) {
            super(changeList);
        }

        protected IdeAction getDefaultAction() {
            return IdeAction.find((int)OPEN_INCOMING_CMD_ID);
        }

        public void menuWillShowImpl(ContextMenu popup) {
            if (this.getLocatableSelection(popup.getContext()).length > 0) {
                popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)ChangeListWindow.OPEN_CMD_ID)), 1.9f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_UPDATE_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_UPDATE_ALL_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_OPEN_HEAD_REVISION_CMD_ID)), 1.9f);
                this.addMenuItemCompare(popup);
            }
            this.addMenuItemCopyFileList(popup);
            this.addMenuItemRefresh(popup);
            this.addMenuItemSelectInNavigator(popup);
            this.addMenuItemPreferences(popup);
        }
    }

    private static class OutgoingContextMenuListener
    extends ChangeSetChangeList.ChangeSetContextMenuListener {
        OutgoingContextMenuListener(ChangeSetChangeList changeList) {
            super(changeList);
        }

        protected IdeAction getDefaultAction(Context context) {
            IdeAction mergeAction = this.getContextualMergeAction(context);
            return mergeAction.isEnabled() ? mergeAction : super.getDefaultAction(context);
        }

        public void menuWillShowImpl(ContextMenu popup) {
            if (this.getLocatableSelection(popup.getContext()).length > 0 && !this.getChangeList().isFocusInOptions()) {
                IdeAction mergeAction = this.getContextualMergeAction(popup.getContext());
                if (mergeAction.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)mergeAction), 1.9f);
                }
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_COMMIT_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_COMMIT_ALL_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_UNEDIT_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_ADD_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_UNDO_CHANGES_CMD_ID)), 2.0f);
                this.addMenuItemCompare(popup);
                ReplaceMenuManager replaceMenuMgr = ReplaceMenuManager.getInstance();
                if (replaceMenuMgr != null) {
                    popup.add((Component)ReplaceMenuManager.getInstance().getContextReplaceMenu(), 4.0f);
                }
            }
            popup.add((Component)Ide.getMenubar().createMenuItem(CVSChangeListWindow.getDisplayConflictsAction()), 4.9f);
            popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.get((int)FORCE_COMMIT_CMD_ID)), 4.9f);
            this.addMenuItemRefresh(popup);
            this.addMenuItemPreferences(popup);
        }

        private IdeAction getContextualMergeAction(Context context) {
            IdeAction mergeAction = this.getLocalAction(context, CVSCommandConstants.OPERATION_MERGE_CMD_ID);
            mergeAction.updateAction(context);
            return mergeAction;
        }
    }

    private static class Mode
    extends Enum {
        public static final Mode OUTGOING = new Mode("OUTGOING");
        public static final Mode INCOMING = new Mode("INCOMING");
        public static final Mode CANDIDATES = new Mode("CANDIDATES");
        public static final Mode WATCHERS = new Mode("WATCHERS");
        private static final Mode[] PRIVATE_VALUES = new Mode[]{OUTGOING, INCOMING, CANDIDATES, WATCHERS};
        private static int _nextOrdinal = 0;

        private Mode(String name) {
            super(name, _nextOrdinal++);
        }

        public static final Mode valueOf(String name) {
            return (Mode)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final Mode[] values() {
            return (Mode[])PRIVATE_VALUES.clone();
        }
    }
}

