/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.maps.core.Layer;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.layer.WorkspaceLayer;
import oracle.mdeditor.ui.ProgressDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.mdeditor.wfs.layer.WFSLayer;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.spatial.edit.ui.DisableVersioningTableModel;
import oracle.spatial.edit.util.MVConnection;

public class RemoveEditSessionPanel
extends JPanel {
    private DisableVersioningTableModel tableModel = new DisableVersioningTableModel();
    private JTable table = new JTable(this.tableModel);
    private JScrollPane statusScrollPane = new JScrollPane(this.table);
    private JLabel edsessionLabel = new JLabel(MessagesBundle.getMessage("Label_edit_session"));
    private JTextField edsessionTxt = new JTextField();
    private JLabel layerLabel = new JLabel(MessagesBundle.getMessage("Layers_for_disable_versioning"));
    private JButton removeButton = new JButton(MessagesBundle.getMessage("Remove_session"));
    private JTextArea infoArea = new JTextArea();
    private JScrollPane scrollInfoArea = new JScrollPane(this.infoArea);
    private Frame frame = null;
    private MDSEditSession editSession = null;
    private boolean removed = false;
    private Collection<EditSession> loadedSessions = null;

    public RemoveEditSessionPanel(Frame frameForThread, MDSEditSession editSession, Collection<EditSession> loadedSessions) {
        if (editSession == null) {
            throw new IllegalArgumentException("editSession is null");
        }
        this.loadedSessions = loadedSessions;
        this.frame = frameForThread;
        this.editSession = editSession;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(360, 348));
        this.edsessionTxt.setEditable(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveEditSessionPanel.this.removeButton_actionPerformed(e);
            }
        });
        if (this.editSession != null) {
            this.edsessionTxt.setText(this.editSession.getName());
        }
        this.add((Component)this.edsessionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.edsessionTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.layerLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.statusScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.scrollInfoArea, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.fillTable();
    }

    private void fillTable() {
        for (Layer l : this.editSession.getLayers()) {
            if (!(l instanceof WorkspaceLayer) || l instanceof WFSLayer) continue;
            WorkspaceLayer layer = (WorkspaceLayer)l;
            try {
                ArrayList<EditSession> sessions;
                String baseTable = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
                boolean hasAnotherVersionedSession = false;
                if (baseTable != null && this.loadedSessions != null && (sessions = new ArrayList<EditSession>(this.loadedSessions)).size() > 0) {
                    for (int i = 0; i < sessions.size(); ++i) {
                        EditSession s = sessions.get(i);
                        if (!(s instanceof MDSEditSession) || s == this || !((MDSEditSession)s).isVersioned() || (MDSEditSession)s == MVConnection.DataSource.getNullSessionMarker() || this.editSession.getName().equalsIgnoreCase(s.getName())) continue;
                        for (Layer ls : s.getLayers()) {
                            String lsBaseTable;
                            if (ls instanceof WFSLayer || !(ls instanceof AbstractDataSetLayer) || !baseTable.equalsIgnoreCase(lsBaseTable = ((AbstractDataSetLayer)ls).getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable"))) continue;
                            hasAnotherVersionedSession = true;
                        }
                        if (hasAnotherVersionedSession) break;
                    }
                }
                if (hasAnotherVersionedSession || !layer.isVersionEnabled() || !layer.canDisableVersioning()) continue;
                this.tableModel.addStatusRow(-1, layer.getName(), false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int rows = this.tableModel.getRowCount() + 1;
        this.statusScrollPane.setPreferredSize(new Dimension(0, rows * 22));
    }

    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    private void setWaitCursor() {
        this.setCursor(new Cursor(3));
    }

    private void setDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void removeButton_actionPerformed(ActionEvent e) {
        if (this.editSession == null) {
            return;
        }
        ProgressDialog dlg = new ProgressDialog(this.frame);
        dlg.disableCancelButton();
        RemoveSessionThread rmthread = new RemoveSessionThread(dlg);
        rmthread.start();
        dlg.setVisible(true);
        dlg.dispose();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    private class RemoveSessionThread
    extends Thread {
        ProgressDialog pdlg = null;
        private boolean completed = false;

        public RemoveSessionThread(ProgressDialog dlg) {
            this.pdlg = dlg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.pdlg.setTitle("Remove Edit Session");
            this.pdlg.setTaskMessage("Starting process...");
            RemoveEditSessionPanel.this.infoArea.append("Starting process...\n");
            ArrayList<String> disableVersionTables = new ArrayList<String>();
            int numTables = RemoveEditSessionPanel.this.tableModel.getRowCount();
            for (int i = 0; i < numTables; ++i) {
                String name = RemoveEditSessionPanel.this.tableModel.getValueAt(i, 0).toString();
                Boolean disable = (Boolean)RemoveEditSessionPanel.this.tableModel.getValueAt(i, 1);
                if (!disable.booleanValue()) continue;
                disableVersionTables.add(name);
            }
            this.pdlg.setTaskMessage("Removing edit session " + RemoveEditSessionPanel.this.editSession.getName() + "...");
            RemoveEditSessionPanel.this.infoArea.append("Removing edit session " + RemoveEditSessionPanel.this.editSession.getName() + "...\n");
            if (!RemoveEditSessionPanel.this.editSession.simpleDelete(false)) {
                RemoveEditSessionPanel.this.infoArea.append("Unable to remove edit session.\n");
                this.pdlg.setVisible(false);
                return;
            }
            RemoveEditSessionPanel.this.infoArea.append("Done: edit session removed.\n");
            RemoveEditSessionPanel.this.removed = true;
            AbstractDataAccessObject dataAccess = RemoveEditSessionPanel.this.editSession.getDataSource().getDataAccessObject();
            if (disableVersionTables.size() > 0) {
                try {
                    this.pdlg.setTaskMessage(MessagesBundle.getMessage("Task_disabling_versioning_on_tables"));
                    RemoveEditSessionPanel.this.infoArea.append(MessagesBundle.getMessage("Task_disabling_versioning_on_tables") + "\n");
                    dataAccess.openConnection();
                    for (int i = 0; i < disableVersionTables.size(); ++i) {
                        String name = (String)disableVersionTables.get(i);
                        this.pdlg.setTaskMessage(MessagesBundle.getFormattedMessage("Task_disabling_versioning", name));
                        RemoveEditSessionPanel.this.infoArea.append(MessagesBundle.getFormattedMessage("Table_name_id", name));
                        try {
                            dataAccess.disableVersioning(name, false, true, true);
                            RemoveEditSessionPanel.this.infoArea.append(MessagesBundle.getFormattedMessage("Task_done_disabling", name) + "\n");
                            continue;
                        }
                        catch (Exception ex) {
                            RemoveEditSessionPanel.this.infoArea.append(ex.getMessage() + "\n");
                            RemoveEditSessionPanel.this.infoArea.append(MessagesBundle.getFormattedMessage("Task_unable_toprocess_table", name) + "\n");
                            continue;
                        }
                        catch (MDSException ex) {
                            RemoveEditSessionPanel.this.infoArea.append(ex.getMessage() + "\n");
                            RemoveEditSessionPanel.this.infoArea.append(MessagesBundle.getFormattedMessage("Task_unable_toprocess_table", name) + "\n");
                        }
                    }
                }
                catch (Exception ex) {
                    RemoveEditSessionPanel.this.infoArea.append(ex.getMessage() + "\n");
                }
                finally {
                    if (dataAccess != null) {
                        try {
                            dataAccess.closeConnection();
                        }
                        catch (Exception ep) {
                            ep.printStackTrace();
                        }
                    }
                }
            }
            RemoveEditSessionPanel.this.infoArea.append(MessagesBundle.getMessage("Task_process_completed"));
            RemoveEditSessionPanel.this.removeButton.setEnabled(false);
            this.pdlg.setVisible(false);
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void checkTimeout(long timeout) {
            try {
                this.join(timeout);
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }
}

