/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model;

import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.WorkSpace;
import oracle.maps.util.GeoJsonParser;
import oracle.mapviewer.share.AnnotationTextMetadata;
import oracle.mapviewer.share.DimensionInfo;
import oracle.mapviewer.share.FeatureConflictDescriptor;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.MVThemeMetadata;
import oracle.mapviewer.share.MVTileLayerMetadata;
import oracle.mapviewer.share.NetworkMetadata;
import oracle.mapviewer.share.Sequence;
import oracle.mapviewer.share.SpatialColumnExtent;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.mapviewer.share.TopologyEdge;
import oracle.mapviewer.share.TopologyFace;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mapviewer.share.TopologyNode;
import oracle.mapviewer.share.TopologyPrimitives;
import oracle.mapviewer.share.TopologyRelation;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.session.SessionXMLUtils;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.util.GMLGeometryUtils;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.SSLUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataModel;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.XMLDataSource;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.edit.model.topology.TopologySet;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.spatial.edit.util.TableAttributesMetadata;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.Node;
import oracle.spatial.util.GML2;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Encoder;

public class XMLDataAccessObject
extends AbstractDataAccessObject {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private HttpConnection conn = null;
    private final String editResponseTag = "edit_response";

    public XMLDataAccessObject(XMLDataSource dsrc) {
        super(dsrc);
    }

    @Override
    public boolean openConnection() throws Exception {
        this.conn = new HttpConnection();
        boolean status = this.conn.connect(this.dataSource.getConnectionProperties().getProperty("serverURL") + "/dataserver/" + this.dataSource.getConnectionProperties().getProperty("dataSource"));
        if (status) {
            this.conn.setContentTypeProperty("application/x-www-form-urlencoded");
            String jsessionid = this.dataSource.getConnectionProperties().getProperty("jsessionID");
            if (jsessionid != null && !jsessionid.trim().isEmpty()) {
                this.conn.setRequestProperty("Cookie", "JSESSIONID=" + jsessionid);
            }
        }
        return status;
    }

    @Override
    public boolean closeConnection() throws Exception {
        if (this.conn != null) {
            this.conn.disConnect();
            return true;
        }
        return false;
    }

    @Override
    public long getSequenceNextValue(String sequence) throws Exception, MDSException {
        String requestTag = "get_sequence_next_value";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("sequence", sequence);
        String request = this.createGenericRequest("get_sequence_next_value", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_sequence_next_value", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_sequence_next_value/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            XMLNode reqNode = (XMLNode)doc.selectSingleNode("/edit_response/get_sequence_next_value");
            XMLNode nvNode = (XMLNode)reqNode.selectSingleNode("next_value");
            if (nvNode != null) {
                try {
                    return Long.parseLong(nvNode.getTextContent());
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                    throw new Exception(ex.getMessage());
                }
            }
            throw new Exception("next value returned null");
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_sequence_next_value/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_sequence_next_value operation failed, no error message returned");
    }

    @Override
    public long getSequenceCurrentValue(String sequence) throws Exception, MDSException {
        String requestTag = "get_sequence_current_value";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("sequence", sequence);
        String request = this.createGenericRequest("get_sequence_current_value", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_sequence_current_value", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_sequence_current_value/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            XMLNode reqNode = (XMLNode)doc.selectSingleNode("/edit_response/get_sequence_current_value");
            XMLNode nvNode = (XMLNode)reqNode.selectSingleNode("current_value");
            if (nvNode != null) {
                try {
                    return Long.parseLong(nvNode.getTextContent());
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                    throw new Exception(ex.getMessage());
                }
            }
            throw new Exception("current value returned null");
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_sequence_current_value/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_sequence_current_value operation failed, no error message returned");
    }

    @Override
    public boolean sequenceExists(String sequence) throws Exception, MDSException {
        String requestTag = "sequence_exists";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("sequence", sequence);
        String request = this.createGenericRequest("sequence_exists", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("sequence_exists", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/sequence_exists/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            XMLNode reqNode = (XMLNode)doc.selectSingleNode("/edit_response/sequence_exists");
            XMLNode nvNode = (XMLNode)reqNode.selectSingleNode("value");
            if (nvNode != null) {
                try {
                    return Boolean.parseBoolean(nvNode.getTextContent());
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                    throw new Exception(ex.getMessage());
                }
            }
            throw new Exception("value returned null");
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/sequence_exists/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("sequence_exists operation failed, no error message returned");
    }

    @Override
    public boolean createSequence(String sequence, long startWith) throws Exception, MDSException {
        String requestTag = "create_sequence";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("sequence", sequence);
        reqAttrs.put("starts_with", startWith + "");
        String request = this.createGenericRequest("create_sequence", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("create_sequence", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/create_sequence/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/create_sequence/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("create_sequence operation failed, no error message returned");
    }

    @Override
    public Vector<Sequence> getSequences() throws Exception, MDSException {
        String requestTag = "get_sequences";
        String request = this.createGenericRequest("get_sequences", false, null, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_sequences", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_sequences/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            NodeList seqList = doc.selectNodes("/edit_response/get_sequences/sequence");
            Vector<Sequence> seqVec = new Vector<Sequence>(seqList.getLength());
            for (int i = 0; i < seqList.getLength(); ++i) {
                XMLNode seqNode = (XMLNode)seqList.item(i);
                NamedNodeMap map = seqNode.getAttributes();
                String name = null;
                if (map.getNamedItem("name") != null) {
                    name = map.getNamedItem("name").getNodeValue();
                }
                double minValue = 1.0;
                if (map.getNamedItem("min_value") != null) {
                    try {
                        String v = map.getNamedItem("min_value").getNodeValue();
                        minValue = Double.parseDouble(v);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                double maxValue = Double.MAX_VALUE;
                if (map.getNamedItem("max_value") != null) {
                    try {
                        String v = map.getNamedItem("max_value").getNodeValue();
                        maxValue = Double.parseDouble(v);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                int incrementBy = 1;
                if (map.getNamedItem("increment_by") != null) {
                    try {
                        String iby = map.getNamedItem("increment_by").getNodeValue();
                        incrementBy = Integer.parseInt(iby);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                Sequence seq = new Sequence();
                seq.setName(name);
                seq.setMinValue(minValue);
                seq.setMaxValue(maxValue);
                seq.setIncrementBy(incrementBy);
                seqVec.add(seq);
            }
            return seqVec;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_sequences/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_sequences operation failed, no error message returned");
    }

    private void updateProgressStatus(PropertyChangeSupport prop, String string) {
        if (prop != null) {
            prop.firePropertyChange("progressString", null, string);
        }
    }

    public InputStream httpRequest(PropertyChangeSupport propSupport, String method, String urlString, Map<Object, Object> params, String username, String password, int timeout) throws MalformedURLException, UnsupportedEncodingException, ProtocolException, IOException, InterruptedException {
        SSLSocketFactory sslFactory;
        boolean debugPrint = false;
        StringBuilder paramSB = new StringBuilder();
        if (params != null) {
            boolean first = true;
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    paramSB.append("&");
                }
                paramSB.append(URLEncoder.encode(entry.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
        }
        URL url = null;
        url = "GET".equalsIgnoreCase(method) && paramSB.length() > 0 ? new URL(urlString + "?" + paramSB.toString()) : new URL(urlString);
        HttpURLConnection conn = null;
        try {
            this.updateProgressStatus(propSupport, MessagesBundle.getFormattedMessage("Progressbar_connectingto", urlString));
            conn = (HttpURLConnection)url.openConnection();
            String jsessionid = this.dataSource.getConnectionProperties().getProperty("jsessionID");
            if (jsessionid != null && !jsessionid.trim().isEmpty()) {
                conn.setRequestProperty("Cookie", "JSESSIONID=" + jsessionid);
            }
            if (debugPrint) {
                System.out.println("Connecting to:" + urlString);
            }
        }
        catch (IOException ex) {
            XMLDataAccessObject.close(null, conn);
            throw ex;
        }
        if (url.getProtocol().equalsIgnoreCase("HTTPS") && (sslFactory = SSLUtil.getSSLSocketFactory((String)url.getHost())) != null) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslFactory);
        }
        conn.setReadTimeout(timeout);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Connection", "close");
        conn.setRequestProperty("Accept-Encoding", "gzip");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        if (username != null && password != null) {
            BASE64Encoder encoder = new BASE64Encoder();
            String auth = username + ";" + password;
            conn.setRequestProperty("Authorization", "Basic " + encoder.encode(auth.getBytes("UTF-8")));
        }
        if ("POST".equalsIgnoreCase(method) && paramSB.length() > 0) {
            this.updateProgressStatus(propSupport, MessagesBundle.getMessage("Progressbar_sendingrequest"));
            conn.setDoOutput(true);
            OutputStream os = null;
            try {
                os = conn.getOutputStream();
            }
            catch (IOException ex) {
                XMLDataAccessObject.close(os, conn);
                throw ex;
            }
            OutputStreamWriter osw = new OutputStreamWriter(os);
            try {
                osw.write(paramSB.toString());
                osw.flush();
                if (debugPrint) {
                    StringBuilder nonEncoded = new StringBuilder();
                    if (params != null) {
                        boolean first = true;
                        for (Map.Entry<Object, Object> entry : params.entrySet()) {
                            if (first) {
                                first = false;
                            } else {
                                nonEncoded.append("&");
                            }
                            nonEncoded.append(entry.getKey().toString() + "=" + entry.getValue().toString());
                        }
                    }
                    System.out.println("Writing:" + nonEncoded.toString());
                }
            }
            catch (IOException ex) {
                XMLDataAccessObject.close(osw, conn);
                throw ex;
            }
        }
        if (Thread.interrupted()) {
            XMLDataAccessObject.close(null, conn);
            throw new InterruptedException();
        }
        InputStream is = null;
        try {
            propSupport.firePropertyChange("progressIndeterminate", null, (Object)true);
            this.updateProgressStatus(propSupport, MessagesBundle.getMessage("Progressbar_waitingresponse"));
            is = conn.getResponseCode() == 200 ? conn.getInputStream() : conn.getErrorStream();
            propSupport.firePropertyChange("progressIndeterminate", null, (Object)false);
            is = new ProgressInputStream(propSupport, is);
        }
        catch (IOException ex) {
            String exurl = conn.getURL().toString();
            System.err.println("Exception loading:\n" + exurl);
            XMLDataAccessObject.close(is, conn);
            throw ex;
        }
        if (Thread.interrupted()) {
            XMLDataAccessObject.close(is, conn);
            throw new InterruptedException();
        }
        String encoding = conn.getContentEncoding();
        if (debugPrint) {
            System.out.println("Response is in " + encoding + " encoding");
        }
        int contentLength = conn.getContentLength();
        if (debugPrint) {
            System.out.println("Content length is:" + contentLength);
        }
        if ("gzip".equalsIgnoreCase(encoding)) {
            try {
                is = new GZIPInputStream(is);
            }
            catch (IOException ex) {
                XMLDataAccessObject.close(is, conn);
                throw ex;
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Closeable obj, HttpURLConnection conn) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public int loadDataInto(Vector<AbstractFeature> into, Callable callable, PropertyChangeSupport propSupport, Rectangle2D mbr, WorkSpace workspace, String dataType, String query, String baseTable, String spatialColumn, long srid, boolean isGeodeticSRID) throws Exception, MDSException {
        String url = this.dataSource.getConnectionProperties().getProperty("serverURL") + "/dataserver/" + this.dataSource.getConnectionProperties().getProperty("dataSource");
        Properties props = new Properties();
        if (query != null && !query.isEmpty()) {
            props.setProperty("sql", query);
        }
        if (baseTable != null && !baseTable.isEmpty()) {
            props.setProperty("base_table", baseTable);
        }
        if (spatialColumn != null && !spatialColumn.isEmpty()) {
            props.setProperty("geom_col", spatialColumn);
        }
        if (dataType != null && !dataType.equals(AbstractDataSet.GEOMETRY_SET)) {
            props.setProperty("geom_type", dataType);
        } else {
            props.setProperty("t", "THEME");
        }
        String topology = null;
        if (topology != null && !topology.isEmpty()) {
            props.setProperty("topology", topology);
        }
        if (workspace != null && !workspace.getName().isEmpty()) {
            props.setProperty("workspace", workspace.getName());
        }
        if (srid > 0L) {
            props.setProperty("to_srid", Long.toString(srid));
        }
        if (mbr != null) {
            props.setProperty("bbox", mbr.getMinX() + "," + mbr.getMinY() + "," + mbr.getMaxX() + "," + mbr.getMaxY());
        }
        props.setProperty("dadp", "10");
        InputStream is = this.httpRequest(propSupport, "GET", url, props, null, null, 30000);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.updateProgressStatus(propSupport, MessagesBundle.getMessage("Progressbar_parsingdata"));
        return this.parseJSONDataInto(into, callable, is);
    }

    private int parseJSONDataInto(Vector<AbstractFeature> into, Callable callable, InputStream is) throws Exception, MDSException {
        int counter = 0;
        JsonParser jp = null;
        try {
            JsonFactory f = new JsonFactory();
            jp = f.createJsonParser(is);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new Exception("Malformed JSON: Invalid start of data");
            }
            int srid = -1;
            boolean sridRead = false;
            Hashtable<String, String> attrtypes = null;
            ArrayList<String> attrs = null;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jp.getCurrentName();
                jp.nextToken();
                if ("error".equalsIgnoreCase(fieldName) || "mds_error".equalsIgnoreCase(fieldName)) {
                    String code = null;
                    String message = null;
                    String details = null;
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String errorField = jp.getCurrentName();
                        jp.nextToken();
                        if ("code".equalsIgnoreCase(errorField)) {
                            code = jp.getText();
                            continue;
                        }
                        if ("message".equalsIgnoreCase(errorField)) {
                            message = jp.getText();
                            continue;
                        }
                        if (!"details".equalsIgnoreCase(errorField)) continue;
                        details = jp.getText();
                    }
                    MDSException ex = new MDSException(message);
                    ex.setCode(code);
                    ex.setDetails(details);
                    throw ex;
                }
                if ("srs".equalsIgnoreCase(fieldName)) {
                    srid = jp.getIntValue();
                    sridRead = true;
                    continue;
                }
                if ("attr_names".equalsIgnoreCase(fieldName)) {
                    attrs = new ArrayList<String>();
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        String attrName = jp.getText();
                        if (attrName == null || attrName.isEmpty()) {
                            throw new Exception("Invalid 'attr_names' item in position " + (attrs.size() + 1));
                        }
                        attrs.add(attrName);
                    }
                    continue;
                }
                if ("attr_types".equalsIgnoreCase(fieldName)) {
                    if (attrs == null) {
                        throw new Exception("Wrong order: Define 'attr_names' before 'attr_types'");
                    }
                    attrtypes = new Hashtable<String, String>();
                    int i = 0;
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        String attrType = jp.getText();
                        if (attrType == null || attrType.isEmpty()) {
                            throw new Exception("Invalid 'attr_types' item in position " + (i + 1));
                        }
                        String attrName = null;
                        try {
                            attrName = (String)attrs.get(i);
                        }
                        catch (IndexOutOfBoundsException ex) {
                            throw new Exception("Size mismatch: 'attr_types' has more elements than 'attr_names'");
                        }
                        attrtypes.put(attrName, attrType);
                        ++i;
                    }
                    if (attrtypes.size() == attrs.size()) continue;
                    throw new Exception("Size mismatch: 'attr_names' has more elements than 'attr_types'");
                }
                if ("features".equalsIgnoreCase(fieldName)) {
                    if (!sridRead) {
                        throw new Exception("Wrong order: Define 'srs' before 'features'");
                    }
                    if (attrtypes == null) {
                        throw new Exception("Wrong order: Define 'attr_names' and 'attr_types' before 'features'");
                    }
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        into.add(GeoJsonParser.GeoJson2Feature(jp, srid, attrtypes));
                        ++counter;
                        if (callable == null) continue;
                        callable.call();
                    }
                    continue;
                }
                jp.skipChildren();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return counter;
    }

    @Override
    public Vector<AbstractFeature> loadData(Rectangle2D mbr, WorkSpace workspace, String dataType, String query, String baseTable, String spatialColumn, long srid, boolean isGeodeticSRID) throws Exception, MDSException {
        Vector<AbstractFeature> vec = new Vector<AbstractFeature>();
        this.loadDataInto(vec, null, null, mbr, workspace, dataType, query, baseTable, spatialColumn, srid, isGeodeticSRID);
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopologyPrimitives parseJSONTopoPrimitives(String data) throws Exception, MDSException {
        JsonParser jp = null;
        TopologyPrimitives primitives = null;
        try {
            JsonFactory f = new JsonFactory();
            jp = f.createJsonParser(data);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new Exception("Malformed JSON: Invalid start of data");
            }
            int srid = -1;
            boolean sridRead = false;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jp.getCurrentName();
                jp.nextToken();
                if ("error".equalsIgnoreCase(fieldName) || "mds_error".equalsIgnoreCase(fieldName)) {
                    String code = null;
                    String message = null;
                    String details = null;
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String errorField = jp.getCurrentName();
                        jp.nextToken();
                        if ("code".equalsIgnoreCase(errorField)) {
                            code = jp.getText();
                            continue;
                        }
                        if ("message".equalsIgnoreCase(errorField)) {
                            message = jp.getText();
                            continue;
                        }
                        if (!"details".equalsIgnoreCase(errorField)) continue;
                        details = jp.getText();
                    }
                    MDSException ex = new MDSException(message);
                    ex.setCode(code);
                    ex.setDetails(details);
                    throw ex;
                }
                if ("srs".equalsIgnoreCase(fieldName)) {
                    srid = jp.getIntValue();
                    sridRead = true;
                    continue;
                }
                if ("primitives".equalsIgnoreCase(fieldName)) {
                    if (!sridRead) {
                        throw new Exception("Wrong order: Define 'srs' before 'primitives'");
                    }
                    primitives = new TopologyPrimitives();
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        Object prim = GeoJsonParser.GeoJson2TopoPrimitive(jp, srid);
                        if (prim instanceof TopologyNode) {
                            primitives.addNode((TopologyNode)prim);
                            continue;
                        }
                        if (prim instanceof TopologyEdge) {
                            primitives.addEdge((TopologyEdge)prim);
                            continue;
                        }
                        if (prim instanceof TopologyFace) {
                            primitives.addFace((TopologyFace)prim);
                            continue;
                        }
                        throw new Exception("Undefined primitive type");
                    }
                    continue;
                }
                jp.skipChildren();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return primitives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<AbstractFeature> parseJSONTopoFeatures(String data) throws Exception, MDSException {
        Vector<AbstractFeature> result = new Vector<AbstractFeature>();
        JsonParser jp = null;
        try {
            JsonFactory f = new JsonFactory();
            jp = f.createJsonParser(data);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new Exception("Malformed JSON: Invalid start of data");
            }
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jp.getCurrentName();
                jp.nextToken();
                if ("error".equalsIgnoreCase(fieldName) || "mds_error".equalsIgnoreCase(fieldName)) {
                    String code = null;
                    String message = null;
                    String details = null;
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String errorField = jp.getCurrentName();
                        jp.nextToken();
                        if ("code".equalsIgnoreCase(errorField)) {
                            code = jp.getText();
                            continue;
                        }
                        if ("message".equalsIgnoreCase(errorField)) {
                            message = jp.getText();
                            continue;
                        }
                        if (!"details".equalsIgnoreCase(errorField)) continue;
                        details = jp.getText();
                    }
                    MDSException ex = new MDSException(message);
                    ex.setCode(code);
                    ex.setDetails(details);
                    throw ex;
                }
                if ("features".equalsIgnoreCase(fieldName)) {
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        TopologyFeature feat = (TopologyFeature)GeoJsonParser.GeoJson2Feature(jp, 0, null);
                        result.add(feat);
                    }
                    continue;
                }
                jp.skipChildren();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    public Vector<AbstractFeature> loadFeatures(String[] keys, String table, String keyColumn, String spatialColumn, WorkSpace workspace, int accessMode) throws Exception {
        throw new Exception("To be implemented");
    }

    @Override
    public NetworkMetadata loadNetworkMetadata(String network) throws Exception, MDSException {
        String requestTag = "get_network_metadata";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("network", network);
        String request = this.createGenericRequest("get_network_metadata", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_network_metadata", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_network_metadata/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            NetworkMetadata nmd = new NetworkMetadata();
            nmd.setNetworkName(network);
            XMLNode mdNode = (XMLNode)doc.selectSingleNode("/edit_response/get_network_metadata");
            XMLNode ownerNode = (XMLNode)mdNode.selectSingleNode("owner");
            if (ownerNode != null) {
                nmd.setNetworkOwner(ownerNode.getTextContent());
            }
            return nmd;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_network_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_network_metadata operation failed, no error message returned");
    }

    @Override
    public TopologyMetadata loadTopologyMetadata(String topology, String featureTable, String topoColumn) throws Exception, MDSException {
        String requestTag = "get_topology_metadata";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(3);
        reqAttrs.put("topology", topology);
        if (featureTable != null && topoColumn != null) {
            reqAttrs.put("topo_table", featureTable);
            reqAttrs.put("topo_column", topoColumn);
        }
        String request = this.createGenericRequest("get_topology_metadata", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_topology_metadata", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_topology_metadata/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            TopologyMetadata tmd = new TopologyMetadata();
            XMLNode mdNode = (XMLNode)doc.selectSingleNode("/edit_response/get_topology_metadata");
            XMLNode node = (XMLNode)mdNode.selectSingleNode("topology");
            if (node != null) {
                tmd.setTopology(node.getTextContent());
            } else {
                tmd.setTopology(topology.toUpperCase());
            }
            node = (XMLNode)mdNode.selectSingleNode("owner");
            if (node != null) {
                tmd.setTopologyOwner(node.getTextContent());
            }
            if ((node = (XMLNode)mdNode.selectSingleNode("topology_id")) != null) {
                tmd.setTopologyId(Integer.parseInt(node.getTextContent()));
            }
            if ((node = (XMLNode)mdNode.selectSingleNode("tolerance")) != null) {
                tmd.setTolerance(Double.parseDouble(node.getTextContent()));
            }
            if ((node = (XMLNode)mdNode.selectSingleNode("srid")) != null) {
                tmd.setSrid(Long.parseLong(node.getTextContent()));
            }
            if ((node = (XMLNode)mdNode.selectSingleNode("node_sequence")) != null) {
                tmd.setNodeSequence(node.getTextContent());
            }
            if ((node = (XMLNode)mdNode.selectSingleNode("edge_sequence")) != null) {
                tmd.setEdgeSequence(node.getTextContent());
            }
            if ((node = (XMLNode)mdNode.selectSingleNode("face_sequence")) != null) {
                tmd.setFaceSequence(node.getTextContent());
            }
            if ((node = (XMLNode)mdNode.selectSingleNode("tg_sequence")) != null) {
                tmd.setTopoGeometrySequence(node.getTextContent());
            }
            if ((node = (XMLNode)mdNode.selectSingleNode("digits_right_of_decimal")) != null) {
                tmd.setDigitsRightOfDecimal(Integer.parseInt(node.getTextContent()));
            }
            if (featureTable != null && topoColumn != null) {
                node = (XMLNode)mdNode.selectSingleNode("table_name");
                if (node != null) {
                    tmd.setFeatureTable(node.getTextContent());
                } else {
                    tmd.setFeatureTable(featureTable.toUpperCase());
                }
                node = (XMLNode)mdNode.selectSingleNode("column_name");
                if (node != null) {
                    tmd.setTopoColumn(node.getTextContent());
                } else {
                    tmd.setTopoColumn(topoColumn.toUpperCase());
                }
                node = (XMLNode)mdNode.selectSingleNode("table_owner");
                if (node != null) {
                    tmd.setFeatureTableOwner(node.getTextContent());
                }
                if ((node = (XMLNode)mdNode.selectSingleNode("tg_layer_id")) != null) {
                    tmd.setTopoLayerId(Integer.parseInt(node.getTextContent()));
                }
                if ((node = (XMLNode)mdNode.selectSingleNode("tg_layer_type")) != null) {
                    tmd.setTopoLayerType(node.getTextContent());
                }
                if ((node = (XMLNode)mdNode.selectSingleNode("tg_layer_level")) != null) {
                    tmd.setTopoLayerLevel(Integer.parseInt(node.getTextContent()));
                }
                if ((node = (XMLNode)mdNode.selectSingleNode("child_layer_id")) != null) {
                    tmd.setChildLayerId(Integer.parseInt(node.getTextContent()));
                }
            }
            return tmd;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_topology_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_topology_metadata operation failed, no error message returned");
    }

    @Override
    public TopologyMetadata[] loadTopologyLayersMetadata(String topology) throws Exception, MDSException {
        String requestTag = "get_topology_layers_metadata";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(3);
        reqAttrs.put("topology", topology);
        String request = this.createGenericRequest("get_topology_layers_metadata", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_topology_layers_metadata", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_topology_layers_metadata/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            ArrayList<TopologyMetadata> metadatas = new ArrayList<TopologyMetadata>();
            NodeList layerNodes = doc.selectNodes("/edit_response/get_topology_layers_metadata/layer");
            if (layerNodes != null && layerNodes.getLength() > 0) {
                for (int i = 0; i < layerNodes.getLength(); ++i) {
                    TopologyMetadata tmd = new TopologyMetadata();
                    XMLNode mdNode = (XMLNode)layerNodes.item(i);
                    XMLNode node = (XMLNode)mdNode.selectSingleNode("topology");
                    if (node != null) {
                        tmd.setTopologyOwner(node.getTextContent());
                    } else {
                        tmd.setTopology(topology.toUpperCase());
                    }
                    node = (XMLNode)mdNode.selectSingleNode("owner");
                    if (node != null) {
                        tmd.setTopologyOwner(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("topology_id")) != null) {
                        tmd.setTopologyId(Integer.parseInt(node.getTextContent()));
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("tolerance")) != null) {
                        tmd.setTolerance(Double.parseDouble(node.getTextContent()));
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("srid")) != null) {
                        tmd.setSrid(Long.parseLong(node.getTextContent()));
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("node_sequence")) != null) {
                        tmd.setNodeSequence(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("edge_sequence")) != null) {
                        tmd.setEdgeSequence(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("face_sequence")) != null) {
                        tmd.setFaceSequence(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("tg_sequence")) != null) {
                        tmd.setTopoGeometrySequence(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("digits_right_of_decimal")) != null) {
                        tmd.setDigitsRightOfDecimal(Integer.parseInt(node.getTextContent()));
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("table_name")) != null) {
                        tmd.setFeatureTable(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("column_name")) != null) {
                        tmd.setTopoColumn(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("table_owner")) != null) {
                        tmd.setFeatureTableOwner(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("tg_layer_id")) != null) {
                        tmd.setTopoLayerId(Integer.parseInt(node.getTextContent()));
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("tg_layer_type")) != null) {
                        tmd.setTopoLayerType(node.getTextContent());
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("tg_layer_level")) != null) {
                        tmd.setTopoLayerLevel(Integer.parseInt(node.getTextContent()));
                    }
                    if ((node = (XMLNode)mdNode.selectSingleNode("child_layer_id")) != null) {
                        tmd.setChildLayerId(Integer.parseInt(node.getTextContent()));
                    }
                    metadatas.add(tmd);
                }
            }
            if (metadatas.size() == 0) {
                return null;
            }
            return metadatas.toArray(new TopologyMetadata[metadatas.size()]);
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_topology_layers_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_topology_layers_metadata operation failed, no error message returned");
    }

    @Override
    public TopologyPrimitives loadTopologyPrimitives(String topology, Rectangle2D mbr, WorkSpace workspace) throws Exception, MDSException {
        if (topology == null || topology.isEmpty()) {
            throw new Exception("Topology name is null or empty");
        }
        StringBuilder urlSB = new StringBuilder(this.dataSource.getConnectionProperties().getProperty("serverURL") + "/dataserver/" + this.dataSource.getConnectionProperties().getProperty("dataSource"));
        urlSB.append("?topology=" + topology);
        if (mbr != null) {
            urlSB.append("&bbox=" + mbr.getMinX() + "," + mbr.getMinY() + "," + mbr.getMaxX() + "," + mbr.getMaxY());
        }
        if (workspace != null && !workspace.getName().isEmpty()) {
            urlSB.append("&workspace=" + workspace.getName());
        }
        String response = Util.issueGZIPHttpGetRequest((String)urlSB.toString());
        return this.parseJSONTopoPrimitives(response);
    }

    @Override
    public TopologyPrimitives loadTopologyPrimitives(String topology, int[] faceIds, int[] edgeIds, int[] nodeIds, WorkSpace workspace) throws Exception, MDSException {
        int i;
        if (topology == null || topology.isEmpty()) {
            throw new Exception("Topology name is null or empty");
        }
        StringBuilder urlSB = new StringBuilder(this.dataSource.getConnectionProperties().getProperty("serverURL") + "/dataserver/" + this.dataSource.getConnectionProperties().getProperty("dataSource"));
        urlSB.append("?topology=" + topology);
        if (workspace != null && !workspace.getName().isEmpty()) {
            urlSB.append("&workspace=" + workspace.getName());
        }
        if (faceIds != null && faceIds.length > 0) {
            urlSB.append("&face_ids=");
            for (i = 0; i < faceIds.length; ++i) {
                if (i != 0) {
                    urlSB.append(",");
                }
                urlSB.append(faceIds[i]);
            }
        }
        if (edgeIds != null && edgeIds.length > 0) {
            urlSB.append("&edge_ids=");
            for (i = 0; i < edgeIds.length; ++i) {
                if (i != 0) {
                    urlSB.append(",");
                }
                urlSB.append(edgeIds[i]);
            }
        }
        if (nodeIds != null && nodeIds.length > 0) {
            urlSB.append("&node_ids=");
            for (i = 0; i < nodeIds.length; ++i) {
                if (i != 0) {
                    urlSB.append(",");
                }
                urlSB.append(nodeIds[i]);
            }
        }
        String response = Util.issueGZIPHttpGetRequest((String)urlSB.toString());
        return this.parseJSONTopoPrimitives(response);
    }

    @Override
    public Vector<AbstractFeature> loadTopologyFeatures(String topology, String featureTable, String topoColumn, Rectangle2D mbr, WorkSpace workspace) throws Exception, MDSException {
        if (topology == null || topology.isEmpty()) {
            throw new Exception("Topology name is null or empty");
        }
        if (featureTable == null || featureTable.isEmpty()) {
            throw new Exception("Feature table name is null or empty");
        }
        if (topoColumn == null || topoColumn.isEmpty()) {
            throw new Exception("Topology column name is null or empty");
        }
        StringBuilder urlSB = new StringBuilder(this.dataSource.getConnectionProperties().getProperty("serverURL") + "/dataserver/" + this.dataSource.getConnectionProperties().getProperty("dataSource"));
        urlSB.append("?topology=" + topology);
        urlSB.append("&base_table=" + featureTable);
        urlSB.append("&geom_col=" + topoColumn);
        if (mbr != null) {
            urlSB.append("&bbox=" + mbr.getMinX() + "," + mbr.getMinY() + "," + mbr.getMaxX() + "," + mbr.getMaxY());
        }
        if (workspace != null && !workspace.getName().isEmpty()) {
            urlSB.append("&workspace=" + workspace.getName());
        }
        String response = Util.issueGZIPHttpGetRequest((String)urlSB.toString());
        return this.parseJSONTopoFeatures(response);
    }

    @Override
    public String[] getTopologyFeatureTables(String topology) throws Exception, MDSException {
        String requestTag = "get_topology_feature_tables";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("topology_name", topology);
        String request = this.createGenericRequest("get_topology_feature_tables", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_topology_feature_tables", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_topology_feature_tables/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node tablesNode = doc.selectSingleNode("/edit_response/get_topology_feature_tables/tables");
            if (tablesNode != null && tablesNode.getFirstChild() != null) {
                String tables = tablesNode.getFirstChild().getNodeValue();
                if (tables == null) {
                    return null;
                }
                ArrayList tbs = Util.splitBy((String)tables, (String)",");
                if (tbs == null || tbs.size() == 0) {
                    return null;
                }
                return tbs.toArray(new String[tbs.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_topology_feature_tables/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_topology_feature_tables operation failed, no error message returned");
    }

    @Override
    public String[] getFeatureTableTopologies(String featureTable, String topoColumn) throws Exception, MDSException {
        String requestTag = "get_feature_table_topologies";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("table_name", featureTable);
        reqAttrs.put("column_name", topoColumn);
        String request = this.createGenericRequest("get_feature_table_topologies", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_feature_table_topologies", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_feature_table_topologies/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node tablesNode = doc.selectSingleNode("/edit_response/get_feature_table_topologies/topologies");
            if (tablesNode != null && tablesNode.getFirstChild() != null) {
                String topologies = tablesNode.getFirstChild().getNodeValue();
                if (topologies == null) {
                    return null;
                }
                ArrayList tbs = Util.splitBy((String)topologies, (String)",");
                if (tbs == null || tbs.size() == 0) {
                    return null;
                }
                return tbs.toArray(new String[tbs.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_feature_table_topologies/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_feature_table_topologies operation failed, no error message returned");
    }

    @Override
    public TopologyRelation[] getRelationsForTopologyPrimitive(String topology, int topo_id, int topo_type, WorkSpace workspace) throws Exception, MDSException {
        String requestTag = "get_relations_for_topo_primitive";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("topology_name", topology);
        reqAttrs.put("topo_id", "" + topo_id);
        reqAttrs.put("topo_type", "" + topo_type);
        if (workspace != null && !workspace.getName().isEmpty()) {
            reqAttrs.put("workspace_name", workspace.getName());
        }
        String request = this.createGenericRequest("get_relations_for_topo_primitive", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_relations_for_topo_primitive", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_relations_for_topo_primitive/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            NodeList relationNodes = doc.selectNodes("/edit_response/get_relations_for_topo_primitive/relations/relation");
            if (relationNodes != null && relationNodes.getLength() > 0) {
                ArrayList<TopologyRelation> relations = new ArrayList<TopologyRelation>();
                for (int i = 0; i < relationNodes.getLength(); ++i) {
                    org.w3c.dom.Node relNode = relationNodes.item(0);
                    String tgLayerId = relNode.getAttributes().getNamedItem("tg_layer_id").getNodeValue();
                    String tgId = relNode.getAttributes().getNamedItem("tg_id").getNodeValue();
                    String topoId = relNode.getAttributes().getNamedItem("topo_id").getNodeValue();
                    String topoType = relNode.getAttributes().getNamedItem("topo_type").getNodeValue();
                    TopologyRelation relation = new TopologyRelation(Integer.parseInt(tgLayerId), Integer.parseInt(tgId), Integer.parseInt(topoId), Integer.parseInt(topoType));
                    relations.add(relation);
                }
                if (relations.size() == 0) {
                    return null;
                }
                return relations.toArray(new TopologyRelation[relations.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_relations_for_topo_primitive/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_relations_for_topo_primitive operation failed, no error message returned");
    }

    @Override
    public TopologyRelation[] getRelationsForTopologyChildFeature(String topology, int child_layer_id, int feature_id, WorkSpace workspace) throws Exception, MDSException {
        String requestTag = "get_relations_for_topo_child_feature";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("topology_name", topology);
        reqAttrs.put("child_layer_id", "" + child_layer_id);
        reqAttrs.put("feature_id", "" + feature_id);
        if (workspace != null && !workspace.getName().isEmpty()) {
            reqAttrs.put("workspace_name", workspace.getName());
        }
        String request = this.createGenericRequest("get_relations_for_topo_child_feature", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_relations_for_topo_child_feature", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_relations_for_topo_child_feature/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            NodeList relationNodes = doc.selectNodes("/edit_response/get_relations_for_topo_child_feature/relations/relation");
            if (relationNodes != null && relationNodes.getLength() > 0) {
                ArrayList<TopologyRelation> relations = new ArrayList<TopologyRelation>();
                for (int i = 0; i < relationNodes.getLength(); ++i) {
                    org.w3c.dom.Node relNode = relationNodes.item(0);
                    String tgLayerId = relNode.getAttributes().getNamedItem("tg_layer_id").getNodeValue();
                    String tgId = relNode.getAttributes().getNamedItem("tg_id").getNodeValue();
                    String topoId = relNode.getAttributes().getNamedItem("topo_id").getNodeValue();
                    String topoType = relNode.getAttributes().getNamedItem("topo_type").getNodeValue();
                    TopologyRelation relation = new TopologyRelation(Integer.parseInt(tgLayerId), Integer.parseInt(tgId), Integer.parseInt(topoId), Integer.parseInt(topoType));
                    relations.add(relation);
                }
                if (relations.size() == 0) {
                    return null;
                }
                return relations.toArray(new TopologyRelation[relations.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_relations_for_topo_child_feature/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_relations_for_topo_child_feature operation failed, no error message returned");
    }

    @Override
    public String[] getTopologyNames() throws Exception, MDSException {
        String requestTag = "get_topology_names";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        String request = this.createGenericRequest("get_topology_names", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_topology_names", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_topology_names/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node tablesNode = doc.selectSingleNode("/edit_response/get_topology_names/topologies");
            if (tablesNode != null && tablesNode.getFirstChild() != null) {
                String topologies = tablesNode.getFirstChild().getNodeValue();
                if (topologies == null) {
                    return null;
                }
                ArrayList tbs = Util.splitBy((String)topologies, (String)",");
                if (tbs == null || tbs.size() == 0) {
                    return null;
                }
                return tbs.toArray(new String[tbs.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_topology_names/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_topology_names operation failed, no error message returned");
    }

    @Override
    public String[] getNetworkNames() throws Exception, MDSException {
        String requestTag = "get_network_names";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        String request = this.createGenericRequest("get_network_names", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_network_names", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_network_names/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node tablesNode = doc.selectSingleNode("/edit_response/get_network_names/networks");
            if (tablesNode != null && tablesNode.getFirstChild() != null) {
                String networks = tablesNode.getFirstChild().getNodeValue();
                if (networks == null) {
                    return null;
                }
                ArrayList tbs = Util.splitBy((String)networks, (String)",");
                if (tbs == null || tbs.size() == 0) {
                    return null;
                }
                return tbs.toArray(new String[tbs.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_network_names/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_network_names operation failed, no error message returned");
    }

    @Override
    public AnnotationTextMetadata loadAnnotationTextMetadata(String table, String column) throws Exception, MDSException {
        String requestTag = "get_annotation_text_metadata";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("table", table);
        reqAttrs.put("column", column);
        String request = this.createGenericRequest("get_annotation_text_metadata", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_annotation_text_metadata", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_annotation_text_metadata/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            XMLNode textAttributesNode;
            XMLNode textExpressionNode;
            AnnotationTextMetadata atmd = new AnnotationTextMetadata();
            atmd.setName(table);
            atmd.setSpatialColumn(column);
            XMLNode mdNode = (XMLNode)doc.selectSingleNode("/edit_response/get_annotation_text_metadata");
            XMLNode baseScaleNode = (XMLNode)mdNode.selectSingleNode("base_scale");
            if (baseScaleNode != null) {
                try {
                    atmd.setMapBaseScale(Double.parseDouble(baseScaleNode.getTextContent()));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            if ((textExpressionNode = (XMLNode)mdNode.selectSingleNode("text_expression")) != null) {
                atmd.setTextExpression(textExpressionNode.getTextContent());
            }
            if ((textAttributesNode = (XMLNode)mdNode.selectSingleNode("text_attributes")) != null) {
                atmd.setTextAttributes(textAttributesNode.getTextContent());
            }
            return atmd;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_annotation_text_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_annotation_text_metadata operation failed, no error message returned");
    }

    @Override
    public boolean createAnnotationTextMetadata(String table, String column, Double baseScale, String textExpression, String textAttributes) throws Exception, MDSException {
        String requestTag = "create_annotation_text_metadata";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("table", table);
        reqAttrs.put("column", column);
        StringBuilder rB = new StringBuilder("");
        if (!Double.isNaN(baseScale)) {
            rB.append("\t\t\t<base_scale>" + baseScale + "</base_scale>\n");
        }
        if (textExpression != null) {
            rB.append("\t\t\t<text_expression>" + textExpression + "</text_expression>\n");
        }
        String textAttrDefault = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<textAttributes xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n                xsi:noNamespaceSchemaLocation=\"../../annotation_text.xsd\">\n  <textStyle fontFamily=\"Serif\" fontSize=\"14\" fill=\"#ff0000\"/>\n  <textlayout/>\n</textAttributes>";
        if (textAttributes == null) {
            rB.append("\t\t\t<text_attributes> <![CDATA[" + textAttrDefault + "]]></text_attributes>\n");
        } else {
            rB.append("\t\t\t<text_attributes> <![CDATA[" + textAttributes + "]]></text_attributes>\n");
        }
        String request = this.createGenericRequest("create_annotation_text_metadata", false, reqAttrs, rB);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("create_annotation_text_metadata", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/create_annotation_text_metadata/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/create_annotation_text_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("create_annotation_text_metadata operation failed, no error message returned");
    }

    @Override
    public boolean updateAnnotationTextMetadata(String table, String column, Double baseScale, String textExpression, String textAttributes) throws Exception, MDSException {
        String requestTag = "update_annotation_text_metadata";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("table", table);
        reqAttrs.put("column", column);
        StringBuilder rB = new StringBuilder("");
        if (!Double.isNaN(baseScale)) {
            rB.append("\t\t\t<base_scale>" + baseScale + "</base_scale>\n");
        }
        if (textExpression != null) {
            rB.append("\t\t\t<text_expression>" + textExpression + "</text_expression>\n");
        }
        if (textAttributes != null) {
            rB.append("\t\t\t<text_attributes> <![CDATA[" + textAttributes + "]]></text_attributes>\n");
        }
        String request = this.createGenericRequest("update_annotation_text_metadata", false, reqAttrs, rB);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("update_annotation_text_metadata", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/update_annotation_text_metadata/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/update_annotation_text_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("update_annotation_text_metadata operation failed, no error message returned");
    }

    @Override
    public boolean createTopology(String topology, double tolerance, int srid) throws Exception, MDSException {
        String requestTag = "create_topology";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("topology_name", topology);
        reqAttrs.put("tolerance", "" + tolerance);
        reqAttrs.put("srid", "" + srid);
        StringBuilder rB = new StringBuilder("");
        String request = this.createGenericRequest("create_topology", false, reqAttrs, rB);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("create_topology", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/create_topology/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/create_topology/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("create_topology operation failed, no error message returned");
    }

    @Override
    public boolean relateFeatureTableWithTopology(String topology, String featureTable, String topoColumn, String topoFeatureType, int childLayerId) throws Exception, MDSException {
        String requestTag = "relate_topotable_with_topology";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("topology_name", topology);
        reqAttrs.put("topo_table_name", "" + featureTable);
        reqAttrs.put("topo_column_name", "" + topoColumn);
        reqAttrs.put("topo_feature_type", "" + topoFeatureType);
        reqAttrs.put("child_layer_id", "" + childLayerId);
        StringBuilder rB = new StringBuilder("");
        String request = this.createGenericRequest("relate_topotable_with_topology", false, reqAttrs, rB);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("relate_topotable_with_topology", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/relate_topotable_with_topology/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/relate_topotable_with_topology/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("relate_topotable_with_topology operation failed, no error message returned");
    }

    @Override
    public boolean saveDataSet(AbstractDataSet set) throws Exception, MDSException {
        String requestTag = "save_session_layer";
        String insertFeaturesTag = "insert_features";
        String updateFeaturesTag = "update_features";
        String deleteFeaturesTag = "delete_features";
        if (set == null) {
            throw new Exception("Data set is null.");
        }
        if (set.getMode() == AbstractDataSet.READ_ONLY_SET) {
            throw new Exception("Data set is read only.");
        }
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        StringBuilder sbRequest = new StringBuilder("\t\t<layer ");
        sbRequest.append("base_table=\"" + set.getBaseTable() + "\" ");
        sbRequest.append("key_column=\"" + set.getKeyColumn() + "\" ");
        sbRequest.append("spatial_column=\"" + set.getGeometryColumn() + "\" ");
        sbRequest.append("spatial_type=\"" + set.getType() + "\" ");
        sbRequest.append("workspace=\"" + set.getWorkspace() + "\">\n");
        sbRequest.append("\t\t\t<insert_features>\n");
        String[] newFeatures = set.getNewFeatures();
        if (newFeatures != null && newFeatures.length > 0) {
            for (int i = 0; i < newFeatures.length; ++i) {
                AbstractFeature gf = set.getFeature(newFeatures[i]);
                if (gf == null) continue;
                sbRequest.append("\t\t\t\t<feature key=\"" + newFeatures[i] + "\">\n");
                Field[] attrs = gf.getAttributes();
                for (int j = 0; j < attrs.length; ++j) {
                    sbRequest.append("\t\t\t\t\t<attribute name=\"" + attrs[j].getName() + "\" type=\"" + attrs[j].getShortJavaTypeName() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t<value>" + attrs[j].getValue() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t</attribute>\n");
                }
                sbRequest.append("\t\t\t\t\t<attribute name=\"" + set.getGeometryColumn() + "\" type=\"" + set.getType().toLowerCase() + "\">\n");
                sbRequest.append("\t\t\t\t\t\t<value>" + this.toGML(gf.getSpatialAttribute()) + "</value>\n");
                sbRequest.append("\t\t\t\t\t</attribute>\n");
                sbRequest.append("\t\t\t\t</feature>\n");
            }
        }
        sbRequest.append("\t\t\t</insert_features>\n");
        sbRequest.append("\t\t\t<update_features>\n");
        String[] modFeatures = set.getModifiedFeatures();
        if (modFeatures != null && modFeatures.length > 0) {
            for (int i = 0; i < modFeatures.length; ++i) {
                int j;
                AbstractFeature gf = set.getFeature(modFeatures[i]);
                if (gf == null) continue;
                sbRequest.append("\t\t\t\t<feature key=\"" + modFeatures[i] + "\">\n");
                Field[] attrs = gf.getAttributes();
                String[] modAttrs = set.getChangedAttributesOfModifiedFeature(modFeatures[i]);
                ArrayList<String> modifiedAttrs = new ArrayList<String>();
                String keyColumn = set.getKeyColumn();
                if (modAttrs != null && modAttrs.length > 0) {
                    for (j = 0; j < modAttrs.length; ++j) {
                        modifiedAttrs.add(modAttrs[j].toUpperCase());
                    }
                }
                for (j = 0; j < attrs.length; ++j) {
                    if (!modifiedAttrs.contains(attrs[j].getName().toUpperCase()) && !attrs[j].getName().equalsIgnoreCase(keyColumn)) continue;
                    sbRequest.append("\t\t\t\t\t<attribute name=\"" + attrs[j].getName() + "\" type=\"" + attrs[j].getShortJavaTypeName() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t<value>" + attrs[j].getValue() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t</attribute>\n");
                }
                if (set.hasSpatialAttributeChanged(modFeatures[i])) {
                    sbRequest.append("\t\t\t\t\t<attribute name=\"" + set.getGeometryColumn() + "\" type=\"" + set.getType().toLowerCase() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t<value>" + this.toGML(gf.getSpatialAttribute()) + "</value>\n");
                    sbRequest.append("\t\t\t\t\t</attribute>\n");
                }
                sbRequest.append("\t\t\t\t</feature>\n");
            }
        }
        sbRequest.append("\t\t\t</update_features>\n");
        sbRequest.append("\t\t\t<delete_features>\n");
        String[] remFeatures = set.getRemovedFeatures();
        if (remFeatures != null && remFeatures.length > 0) {
            for (int i = 0; i < remFeatures.length; ++i) {
                sbRequest.append("\t\t\t\t<feature key=\"" + remFeatures[i] + "\"/>\n");
            }
        }
        sbRequest.append("\t\t\t</delete_features>\n");
        sbRequest.append("\t\t</layer>\n");
        String request = this.createGenericRequest("save_session_layer", false, null, sbRequest);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("save_session_layer", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/save_session_layer/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/save_session_layer/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("save_session_layer operation failed, no error message returned");
    }

    private void parseErrorAndThrowException(XMLNode errorNode) throws MDSException {
        MDSException ex = null;
        try {
            if (errorNode.selectSingleNode("message") != null) {
                String message = errorNode.selectSingleNode("message").getTextContent();
                ex = new MDSException(message);
            } else {
                ex = new MDSException();
            }
            if (errorNode.selectSingleNode("code") != null) {
                String code = errorNode.selectSingleNode("code").getTextContent();
                ex.setCode(code);
            }
            if (errorNode.selectSingleNode("details") != null) {
                String details = errorNode.selectSingleNode("details").getTextContent();
                ex.setDetails(details);
            }
            throw ex;
        }
        catch (XSLException e) {
            throw new MDSException("Error in the error message");
        }
    }

    @Override
    public boolean saveDataModel(AbstractDataModel model) throws Exception, MDSException {
        Object nd;
        Enumeration<Object> enumer;
        String requestTag = "save_session_model";
        String insertFeaturesTag = "insert_features";
        String updateFeaturesTag = "update_features";
        String deleteFeaturesTag = "delete_features";
        if (model == null) {
            throw new Exception("Data model is null.");
        }
        if (model.getMode() == AbstractDataSet.READ_ONLY_SET) {
            throw new Exception("Data mode is read only.");
        }
        if (model.getType() != AbstractDataModel.TOPOLOGY_MODEL) {
            throw new Exception("Model type [" + model.getType() + "] is not supported.");
        }
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        StringBuilder sbRequest = new StringBuilder("\t\t<model name=\"" + model.getName() + "\" type=\"" + model.getType() + "\">\n");
        sbRequest.append("\t\t\t<topo_primitives>\n");
        TopologyModel topoModel = (TopologyModel)model;
        Hashtable<String, Node> addedNodes = topoModel.getAddedNodes();
        Hashtable<String, Edge> addedEdges = topoModel.getAddedEdges();
        Hashtable<String, Face> addedFaces = topoModel.getAddedFaces();
        Hashtable<String, Node> changedNodes = topoModel.getChangedNodes();
        Hashtable<String, Edge> changedEdges = topoModel.getChangedEdges();
        Hashtable<String, Face> changedFaces = topoModel.getChangedFaces();
        Hashtable<String, Integer> deletedNodes = topoModel.getDeletedNodes();
        Hashtable<String, Integer> deletedEdges = topoModel.getDeletedEdges();
        Hashtable<String, Integer> deletedFaces = topoModel.getDeletedFaces();
        if (addedNodes != null && addedNodes.size() > 0 || changedNodes != null && changedNodes.size() > 0 || deletedNodes != null && deletedNodes.size() > 0) {
            sbRequest.append("\t\t\t\t<nodes>\n");
            if (addedNodes != null && addedNodes.size() > 0) {
                sbRequest.append("\t\t\t\t\t<insert_features>\n");
                enumer = addedNodes.elements();
                while (enumer.hasMoreElements()) {
                    nd = enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + nd.getId() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"node_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + nd.getId() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + nd.getStartEdge() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"face_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + nd.getContainFace() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t<attribute name=\"geometry\" type=\"geometry\">\n");
                    sbRequest.append("\t\t\t\t\t\t<value>" + this.toGML(topoModel.getNodeGeometry(nd.getId())) + "</value>\n");
                    sbRequest.append("\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</insert_features>\n");
            }
            if (changedNodes != null && changedNodes.size() > 0) {
                sbRequest.append("\t\t\t\t\t<update_features>\n");
                enumer = changedNodes.elements();
                while (enumer.hasMoreElements()) {
                    nd = (Node)enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + nd.getId() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"node_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + nd.getId() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + nd.getStartEdge() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"face_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + nd.getContainFace() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t<attribute name=\"geometry\" type=\"geometry\">\n");
                    sbRequest.append("\t\t\t\t\t\t<value>" + this.toGML(topoModel.getNodeGeometry(nd.getId())) + "</value>\n");
                    sbRequest.append("\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</update_features>\n");
            }
            if (deletedNodes != null && deletedNodes.size() > 0) {
                sbRequest.append("\t\t\t\t\t<delete_features>\n");
                enumer = deletedNodes.elements();
                while (enumer.hasMoreElements()) {
                    nd = (Integer)enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + (Integer)nd + "\">\n");
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</delete_features>\n");
            }
            sbRequest.append("\t\t\t\t</nodes>\n");
        }
        if (addedEdges != null && addedEdges.size() > 0 || changedEdges != null && changedEdges.size() > 0 || deletedEdges != null && deletedEdges.size() > 0) {
            Object ed;
            sbRequest.append("\t\t\t\t<edges>\n");
            if (addedEdges != null && addedEdges.size() > 0) {
                sbRequest.append("\t\t\t\t\t<insert_features>\n");
                enumer = addedEdges.elements();
                while (enumer.hasMoreElements()) {
                    ed = (Edge)enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + ed.getId() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getId() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"start_node_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getOriginNode() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"end_node_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getEndNode() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"next_left_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getNextEdgeL() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"prev_left_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getPrevEdgeL() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"next_right_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getNextEdgeR() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"prev_right_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getPrevEdgeR() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"left_face_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getBoundedFaceL() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"right_face_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getBoundedFaceR() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t<attribute name=\"geometry\" type=\"geometry\">\n");
                    sbRequest.append("\t\t\t\t\t\t<value>" + this.toGML(topoModel.getEdgeGeometry(ed.getId())) + "</value>\n");
                    sbRequest.append("\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</insert_features>\n");
            }
            if (changedEdges != null && changedEdges.size() > 0) {
                sbRequest.append("\t\t\t\t\t<update_features>\n");
                enumer = changedEdges.elements();
                while (enumer.hasMoreElements()) {
                    ed = (Edge)enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + ed.getId() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getId() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"start_node_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getOriginNode() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"end_node_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getEndNode() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"next_left_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getNextEdgeL() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"prev_left_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getPrevEdgeL() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"next_right_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getNextEdgeR() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"prev_right_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getPrevEdgeR() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"left_face_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getBoundedFaceL() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"right_face_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + ed.getBoundedFaceR() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t<attribute name=\"geometry\" type=\"geometry\">\n");
                    sbRequest.append("\t\t\t\t\t\t<value>" + this.toGML(topoModel.getEdgeGeometry(ed.getId())) + "</value>\n");
                    sbRequest.append("\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</update_features>\n");
            }
            if (deletedEdges != null && deletedEdges.size() > 0) {
                sbRequest.append("\t\t\t\t\t<delete_features>\n");
                enumer = deletedEdges.elements();
                while (enumer.hasMoreElements()) {
                    ed = (Integer)enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + (Integer)ed + "\">\n");
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</delete_features>\n");
            }
            sbRequest.append("\t\t\t\t</edges>\n");
        }
        if (addedFaces != null && addedFaces.size() > 0 || changedFaces != null && changedFaces.size() > 0 || deletedFaces != null && deletedFaces.size() > 0) {
            int i;
            int[] islandNodes;
            String isledge;
            int[] islandEdges;
            Face fc;
            sbRequest.append("\t\t\t\t<faces>\n");
            if (addedFaces != null && addedFaces.size() > 0) {
                sbRequest.append("\t\t\t\t\t<insert_features>\n");
                enumer = addedFaces.elements();
                while (enumer.hasMoreElements()) {
                    fc = (Face)enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + fc.getID() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"face_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + fc.getID() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"boundary_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + fc.getBoundaryEdge() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"island_edge_id_list\" type=\"MDSYS.SDO_LIST_TYPE\">\n");
                    islandEdges = fc.getIslandEdges();
                    if (islandEdges == null || islandEdges.length == 0) {
                        sbRequest.append("\t\t\t\t\t\t\t\t<value></value>\n");
                    } else {
                        isledge = "" + islandEdges[0];
                        for (int i2 = 1; i2 < islandEdges.length; ++i2) {
                            isledge = isledge + "," + islandEdges[i2];
                        }
                        sbRequest.append("\t\t\t\t\t\t\t\t<value>" + isledge + "</value>\n");
                    }
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"island_node_id_list\" type=\"MDSYS.SDO_LIST_TYPE\">\n");
                    islandNodes = fc.getIslandNodes();
                    if (islandNodes == null || islandNodes.length == 0) {
                        sbRequest.append("\t\t\t\t\t\t\t\t<value></value>\n");
                    } else {
                        String islnode = "" + islandNodes[0];
                        for (i = 1; i < islandNodes.length; ++i) {
                            islnode = islnode + "," + islandNodes[i];
                        }
                        sbRequest.append("\t\t\t\t\t\t\t\t<value>" + islnode + "</value>\n");
                    }
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    if (fc.getID() != -1) {
                        sbRequest.append("\t\t\t\t\t<attribute name=\"mbr_geometry\" type=\"geometry\">\n");
                        sbRequest.append("\t\t\t\t\t\t<value>" + this.toGML(topoModel.getFaceMBRGeometry(fc.getID())) + "</value>\n");
                        sbRequest.append("\t\t\t\t\t</attribute>\n");
                    }
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</insert_features>\n");
            }
            if (changedFaces != null && changedFaces.size() > 0) {
                sbRequest.append("\t\t\t\t\t<update_features>\n");
                enumer = changedFaces.elements();
                while (enumer.hasMoreElements()) {
                    fc = (Face)enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + fc.getID() + "\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"face_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + fc.getID() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"boundary_edge_id\" type=\"int\">\n");
                    sbRequest.append("\t\t\t\t\t\t\t\t<value>" + fc.getBoundaryEdge() + "</value>\n");
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"island_edge_id_list\" type=\"MDSYS.SDO_LIST_TYPE\">\n");
                    islandEdges = fc.getIslandEdges();
                    if (islandEdges == null || islandEdges.length == 0) {
                        sbRequest.append("\t\t\t\t\t\t\t\t<value></value>\n");
                    } else {
                        isledge = "" + islandEdges[0];
                        for (int i3 = 1; i3 < islandEdges.length; ++i3) {
                            isledge = isledge + "," + islandEdges[i3];
                        }
                        sbRequest.append("\t\t\t\t\t\t\t\t<value>" + isledge + "</value>\n");
                    }
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"island_node_id_list\" type=\"MDSYS.SDO_LIST_TYPE\">\n");
                    islandNodes = fc.getIslandNodes();
                    if (islandNodes == null || islandNodes.length == 0) {
                        sbRequest.append("\t\t\t\t\t\t\t\t<value></value>\n");
                    } else {
                        String islnode = "" + islandNodes[0];
                        for (i = 1; i < islandNodes.length; ++i) {
                            islnode = islnode + "," + islandNodes[i];
                        }
                        sbRequest.append("\t\t\t\t\t\t\t\t<value>" + islnode + "</value>\n");
                    }
                    sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                    if (fc.getID() != -1) {
                        sbRequest.append("\t\t\t\t\t<attribute name=\"mbr_geometry\" type=\"geometry\">\n");
                        sbRequest.append("\t\t\t\t\t\t<value>" + this.toGML(topoModel.getFaceMBRGeometry(fc.getID())) + "</value>\n");
                        sbRequest.append("\t\t\t\t\t</attribute>\n");
                    }
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</update_features>\n");
            }
            if (deletedFaces != null && deletedFaces.size() > 0) {
                sbRequest.append("\t\t\t\t\t<delete_features>\n");
                enumer = deletedFaces.elements();
                while (enumer.hasMoreElements()) {
                    nd = (Integer)enumer.nextElement();
                    sbRequest.append("\t\t\t\t\t\t<feature key=\"" + (Integer)nd + "\">\n");
                    sbRequest.append("\t\t\t\t</feature>\n");
                }
                sbRequest.append("\t\t\t\t\t</delete_features>\n");
            }
            sbRequest.append("\t\t\t\t</faces>\n");
        }
        sbRequest.append("\t\t\t</topo_primitives>\n");
        TopologySet[] sets = topoModel.getRegisteredSets();
        if (sets != null && sets.length > 0) {
            sbRequest.append("\t\t\t<layers>\n");
            for (int k = 0; k < sets.length; ++k) {
                if (!sets[k].isModified()) continue;
                sbRequest.append("\t\t\t\t<layer name=\"" + sets[k].getName() + "\">\n");
                sbRequest.append("\t\t\t\t\t<insert_features>\n");
                String[] newFeatures = sets[k].getNewFeatures();
                if (newFeatures != null && newFeatures.length > 0) {
                    for (int i = 0; i < newFeatures.length; ++i) {
                        AbstractFeature gf = sets[k].getFeature(newFeatures[i]);
                        if (gf == null) continue;
                        sbRequest.append("\t\t\t\t\t\t<feature key=\"" + newFeatures[i] + "\">\n");
                        Field[] attrs = gf.getAttributes();
                        for (int j = 0; j < attrs.length; ++j) {
                            sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"" + attrs[j].getName() + "\" type=\"" + attrs[j].getShortJavaTypeName() + "\">\n");
                            sbRequest.append("\t\t\t\t\t\t\t\t<value>" + attrs[j].getValue() + "</value>\n");
                            sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                        }
                        sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"" + sets[k].getGeometryColumn() + "\" type=\"" + sets[k].getType().toLowerCase() + "\">\n");
                        sbRequest.append("\t\t\t\t\t\t\t\t<value>" + this.toGML(gf.getSpatialAttribute()) + "</value>\n");
                        sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                        sbRequest.append("\t\t\t\t\t\t</feature>\n");
                    }
                }
                sbRequest.append("\t\t\t\t\t</insert_features>\n");
                sbRequest.append("\t\t\t\t\t<update_features>\n");
                String[] modFeatures = sets[k].getModifiedFeatures();
                if (modFeatures != null && modFeatures.length > 0) {
                    for (int i = 0; i < modFeatures.length; ++i) {
                        int j;
                        AbstractFeature gf = sets[k].getFeature(modFeatures[i]);
                        if (gf == null) continue;
                        sbRequest.append("\t\t\t\t\t\t<feature key=\"" + modFeatures[i] + "\">\n");
                        Field[] attrs = gf.getAttributes();
                        String[] modAttrs = sets[k].getChangedAttributesOfModifiedFeature(modFeatures[i]);
                        ArrayList<String> modifiedAttrs = new ArrayList<String>();
                        String keyColumn = sets[k].getKeyColumn();
                        if (modAttrs != null && modAttrs.length > 0) {
                            for (j = 0; j < modAttrs.length; ++j) {
                                modifiedAttrs.add(modAttrs[j].toUpperCase());
                            }
                        }
                        for (j = 0; j < attrs.length; ++j) {
                            if (!modifiedAttrs.contains(attrs[j].getName().toUpperCase()) && !attrs[j].getName().equalsIgnoreCase(keyColumn)) continue;
                            sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"" + attrs[j].getName() + "\" type=\"" + attrs[j].getShortJavaTypeName() + "\">\n");
                            sbRequest.append("\t\t\t\t\t\t\t\t<value>" + attrs[j].getValue() + "</value>\n");
                            sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                        }
                        if (sets[k].hasSpatialAttributeChanged(modFeatures[i])) {
                            sbRequest.append("\t\t\t\t\t\t\t<attribute name=\"" + sets[k].getGeometryColumn() + "\" type=\"" + sets[k].getType().toLowerCase() + "\">\n");
                            sbRequest.append("\t\t\t\t\t\t\t\t<value>" + this.toGML(gf.getSpatialAttribute()) + "</value>\n");
                            sbRequest.append("\t\t\t\t\t\t\t</attribute>\n");
                        }
                        sbRequest.append("\t\t\t\t\t\t</feature>\n");
                    }
                }
                sbRequest.append("\t\t\t\t\t</update_features>\n");
                sbRequest.append("\t\t\t\t\t<delete_features>\n");
                String[] remFeatures = sets[k].getRemovedFeatures();
                if (remFeatures != null && remFeatures.length > 0) {
                    for (int i = 0; i < remFeatures.length; ++i) {
                        sbRequest.append("\t\t\t\t\t\t<feature key=\"" + remFeatures[i] + "\"/>\n");
                    }
                }
                sbRequest.append("\t\t\t\t\t</delete_features>\n");
                sbRequest.append("\t\t\t\t\t\t</layer>\n");
            }
            sbRequest.append("\t\t\t</layers>\n");
        }
        sbRequest.append("\t\t</model>\n");
        Hashtable<String, String> attrs = new Hashtable<String, String>(1);
        attrs.put("layer_name", model.getLayer().getName());
        String request = this.createGenericRequest("save_session_model", false, attrs, sbRequest);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("save_session_model", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/save_session_model/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/save_session_model/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("save_session_model operation failed, no error message returned");
    }

    @Override
    public boolean goToWorkspace(WorkSpace workspace) throws Exception {
        return true;
    }

    @Override
    public long getNetworkMaxId(String network, String netEntity) throws Exception, MDSException {
        String requestTag = "get_network_entity_max_id";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("network", network);
        reqAttrs.put("entity", netEntity);
        String request = this.createGenericRequest("get_network_entity_max_id", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_network_entity_max_id", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_network_entity_max_id/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            XMLNode reqNode = (XMLNode)doc.selectSingleNode("/edit_response/get_network_entity_max_id");
            XMLNode nvNode = (XMLNode)reqNode.selectSingleNode("value");
            if (nvNode != null) {
                try {
                    return Long.parseLong(nvNode.getTextContent());
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                    throw new Exception(ex.getMessage());
                }
            }
            throw new Exception("value returned null");
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_network_entity_max_id/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_network_entity_max_id operation failed, no error message returned");
    }

    @Override
    public boolean dataTableExists(String table) throws Exception {
        return true;
    }

    @Override
    public long getRecordCount(String table, String whereClause) throws Exception {
        return 1L;
    }

    @Override
    public boolean topoFacesHaveMismatchOfFeatures(String topoModel, long faceLeft, long faceRight) throws Exception {
        return true;
    }

    @Override
    public boolean topoEdgesHaveMismatchOfFeatures(String topoModel, long firstEdge, long secondEdge) throws Exception {
        return true;
    }

    @Override
    public boolean tableHasAttributeWithValue(String table, String attr, String value, String workspace) throws Exception, MDSException {
        String requestTag = "table_value_exists";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(3);
        reqAttrs.put("table", table);
        reqAttrs.put("column", attr);
        reqAttrs.put("value", value);
        if (workspace != null) {
            reqAttrs.put("workspace", workspace);
        }
        String request = this.createGenericRequest("table_value_exists", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("table_value_exists", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/table_value_exists/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return "true".equalsIgnoreCase(doc.selectSingleNode("/edit_response/table_value_exists").getTextContent());
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/table_value_exists/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("table_value_exists operation failed, no error message returned");
    }

    private XMLDocument parse(String s) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setValidationMode(0);
        parser.setPreserveWhitespace(false);
        XMLDocument doc = null;
        StringReader reader = new StringReader(s);
        try {
            parser.parse((Reader)reader);
            doc = parser.getDocument();
        }
        catch (Exception e) {
            throw new Exception("Could not parse server response.");
        }
        finally {
            reader.close();
        }
        return doc;
    }

    private String createGenericRequest(String type, boolean includeSessionName, Hashtable<String, String> attrs, StringBuilder xmlChild) {
        StringBuilder request = new StringBuilder("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        request.append("<edit_request>\n");
        request.append("\t<" + type);
        request.append(" data_source=\"" + this.dataSource.getConnectionProperties().getProperty("dataSource") + "\"");
        request.append(" editor=\"" + this.dataSource.getConnectionProperties().getProperty("editor") + "\"");
        if (includeSessionName) {
            request.append(" session_name=\"" + this.props.getProperty("sessionName") + "\"");
        }
        if (attrs != null && attrs.size() > 0) {
            Enumeration<String> keys = attrs.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                request.append(" " + key + "=\"" + attrs.get(key) + "\"");
            }
        }
        if (xmlChild == null || xmlChild.length() == 0) {
            request.append("/>\n");
        } else {
            request.append(">\n");
            request.append((CharSequence)xmlChild);
            request.append("\t</" + type + ">\n");
        }
        request.append("</edit_request>\n");
        return request.toString();
    }

    private void encodeGeomFull(StringBuilder sb, String tag, JGeometry geom) throws Exception {
        if (sb == null) {
            return;
        }
        sb.append("\t\t<" + tag + ">\n");
        sb.append("\t\t\t" + this.toGML(geom) + "\n");
        sb.append("\t\t</" + tag + ">\n");
    }

    private void encodeGeomReference(StringBuilder sb, String tag, AbstractFeature geom) throws Exception {
        if (sb == null) {
            return;
        }
        AbstractDataSetLayer layer = (AbstractDataSetLayer)geom.getLayer();
        String tableName = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        String spatialAttr = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        String keyAttr = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
        String workSpace = layer.getWorkspace().getName();
        sb.append("\t\t<" + tag);
        sb.append(" table_name=\"" + tableName + "\"");
        sb.append(" spatial_attribute=\"" + spatialAttr + "\"");
        sb.append(" key_attribute=\"" + keyAttr + "\"");
        sb.append(" workspace_name=\"" + workSpace + "\"");
        sb.append(">\n");
        sb.append("\t\t\t<key_value");
        if (tag.equalsIgnoreCase("other_geom")) {
            sb.append("s");
        }
        if (keyAttr != null && keyAttr.equalsIgnoreCase("ROWID")) {
            sb.append(">" + XMLUtil.doXMLescape((String)geom.getKey().toString()));
        } else {
            sb.append(">" + geom.getKey().toString());
        }
    }

    private JGeometry performGeometryOperation(String type, double tolerance, Object sourceGeom, Object[] otherGeoms) throws Exception, MDSException {
        String requestTag = "geometry_operation";
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (sourceGeom == null) {
            throw new Exception("Source geometry is null");
        }
        if (otherGeoms == null || otherGeoms.length == 0) {
            throw new Exception("At least one other geometry must be defined.");
        }
        StringBuilder rB = new StringBuilder();
        if (sourceGeom instanceof JGeometry) {
            this.encodeGeomFull(rB, "source_geom", (JGeometry)sourceGeom);
        } else {
            AbstractFeature geom = (AbstractFeature)sourceGeom;
            AbstractDataSet ds = ((AbstractDataSetLayer)geom.getLayer()).getIndexedDataSet().getDataSet();
            String key = geom.getKey().toString();
            boolean optimizeGeom = false;
            try {
                String val = geom.getLayer().getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.optimizeGeometryOperation");
                if (val != null) {
                    optimizeGeom = Boolean.parseBoolean(val);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!optimizeGeom || ds.isNewFeature(key) || ds.hasSpatialAttributeChanged(key)) {
                this.encodeGeomFull(rB, "source_geom", (JGeometry)geom.getSpatialAttribute());
            } else {
                this.encodeGeomReference(rB, "source_geom", (AbstractFeature)sourceGeom);
                rB.append("</key_value>\n");
                rB.append("\t\t</source_geom>\n");
            }
        }
        StringBuilder otherFullBuilder = new StringBuilder();
        Hashtable<String, StringBuilder> otherGeomBuilders = new Hashtable<String, StringBuilder>();
        for (Object other : otherGeoms) {
            if (other instanceof JGeometry) {
                this.encodeGeomFull(otherFullBuilder, "other_geom", (JGeometry)other);
                continue;
            }
            if (!(other instanceof AbstractFeature)) continue;
            AbstractFeature geom = (AbstractFeature)other;
            AbstractDataSet ds = ((AbstractDataSetLayer)geom.getLayer()).getIndexedDataSet().getDataSet();
            String key = geom.getKey().toString();
            boolean optimizeGeom = false;
            try {
                String val = geom.getLayer().getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.optimizeGeometryOperation");
                if (val != null) {
                    optimizeGeom = Boolean.parseBoolean(val);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!optimizeGeom || ds.isNewFeature(key) || ds.hasSpatialAttributeChanged(key)) {
                this.encodeGeomFull(otherFullBuilder, "other_geom", (JGeometry)geom.getSpatialAttribute());
                continue;
            }
            AbstractDataSetLayer layer = (AbstractDataSetLayer)geom.getLayer();
            String tableName = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
            String spatialAttr = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
            String keyAttr = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
            String workSpace = layer.getWorkspace().getName();
            StringBuilder bldr = (StringBuilder)otherGeomBuilders.get(keyAttr + "@" + spatialAttr + "@" + tableName + "@" + workSpace);
            if (bldr == null) {
                bldr = new StringBuilder();
                this.encodeGeomReference(bldr, "other_geom", geom);
                otherGeomBuilders.put(keyAttr + "@" + spatialAttr + "@" + tableName + "@" + workSpace, bldr);
                continue;
            }
            bldr.append(",");
            bldr.append(geom.getKey().toString());
        }
        rB.append("\t\t<other_geoms>\n");
        if (otherFullBuilder.length() > 0) {
            rB.append((CharSequence)otherFullBuilder);
        }
        for (StringBuilder bldr : otherGeomBuilders.values()) {
            bldr.append("</key_values>\n");
            bldr.append("\t\t</other_geom>\n");
            rB.append((CharSequence)bldr);
        }
        rB.append("\t\t</other_geoms>\n");
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("type", type);
        reqAttrs.put("tolerance", Double.toString(tolerance));
        String request = this.createGenericRequest("geometry_operation", false, reqAttrs, rB);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("geometry_operation", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/geometry_operation/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node outGeom = doc.selectSingleNode("/edit_response/geometry_operation/output_geom");
            if (outGeom.hasChildNodes()) {
                return GMLGeometryUtils.parseGML((org.w3c.dom.Node)outGeom);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/geometry_operation/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("geometry_operation operation failed, no error message returned");
    }

    @Override
    public JGeometry union(JGeometry sourceGeom, JGeometry[] otherGeoms, double tolerance) throws Exception, MDSException {
        return this.performGeometryOperation("union", tolerance, sourceGeom, otherGeoms);
    }

    @Override
    public JGeometry difference(JGeometry sourceGeom, JGeometry[] otherGeoms, double tolerance) throws Exception, MDSException {
        return this.performGeometryOperation("difference", tolerance, sourceGeom, otherGeoms);
    }

    @Override
    public JGeometry intersection(JGeometry sourceGeom, JGeometry[] otherGeoms, double tolerance) throws Exception, MDSException {
        return this.performGeometryOperation("intersection", tolerance, sourceGeom, otherGeoms);
    }

    @Override
    public JGeometry union(AbstractFeature sourceGeom, AbstractFeature[] otherGeoms, double tolerance) throws Exception, MDSException {
        return this.performGeometryOperation("union", tolerance, sourceGeom, otherGeoms);
    }

    @Override
    public JGeometry difference(AbstractFeature sourceGeom, AbstractFeature[] otherGeoms, double tolerance) throws Exception, MDSException {
        return this.performGeometryOperation("difference", tolerance, sourceGeom, otherGeoms);
    }

    @Override
    public JGeometry intersection(AbstractFeature sourceGeom, AbstractFeature[] otherGeoms, double tolerance) throws Exception, MDSException {
        return this.performGeometryOperation("intersection", tolerance, sourceGeom, otherGeoms);
    }

    @Override
    public Hashtable<String, String> validateFeatureGeometries(String keyAttribute, AbstractFeature[] features, double tolerance) throws Exception, MDSException {
        String requestTag = "validate_geometry";
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (keyAttribute == null) {
            throw new Exception("key attribute name must be defined.");
        }
        if (features == null || features.length == 0) {
            throw new Exception("At least one feature must be defined.");
        }
        StringBuilder rB = new StringBuilder("\t\t<features>\n");
        for (int i = 0; i < features.length; ++i) {
            String key = features[i].getAttribute(keyAttribute).getValue().toString();
            if (key == null) {
                throw new Exception("There is a feature with null key value.");
            }
            rB.append("\t\t\t<feature key_value=\"" + key + "\">\n");
            rB.append("\t\t\t\t" + this.toGML(features[i].getSpatialAttribute()) + "\n");
            rB.append("\t\t\t</feature>\n");
        }
        rB.append("\t\t</features>\n");
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("tolerance", Double.toString(tolerance));
        String request = this.createGenericRequest("validate_geometry", false, reqAttrs, rB);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("validate_geometry", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/validate_geometry/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            NodeList featuresList = doc.selectNodes("/edit_response/validate_geometry/features/feature");
            Hashtable<String, String> validation = new Hashtable<String, String>(featuresList.getLength());
            for (int i = 0; i < featuresList.getLength(); ++i) {
                org.w3c.dom.Node feat = featuresList.item(i);
                String nodeKey = feat.getAttributes().getNamedItem("key_value").getNodeValue();
                validation.put(nodeKey, feat.getFirstChild().getNodeValue());
            }
            return validation;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/validate_geometry/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("validate_geometry operation failed, no error message returned");
    }

    @Override
    public String getTablePrimaryKey(String table) throws Exception, MDSException {
        String requestTag = "get_table_primary_key";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("table_name", table);
        String request = this.createGenericRequest("get_table_primary_key", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_table_primary_key", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_table_primary_key/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            if (doc.selectSingleNode("/edit_response/get_table_primary_key").getFirstChild() != null) {
                return doc.selectSingleNode("/edit_response/get_table_primary_key").getFirstChild().getNodeValue();
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_table_primary_key/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_table_primary_key operation failed, no error message returned");
    }

    @Override
    public boolean setTablePrimaryKey(String table, String keyAttribute) throws Exception, MDSException {
        String requestTag = "set_table_primary_key";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("table_name", table);
        reqAttrs.put("key_attribute", keyAttribute);
        String request = this.createGenericRequest("set_table_primary_key", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("set_table_primary_key", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/set_table_primary_key/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/set_table_primary_key/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("set_table_primary_key operation failed, no error message returned");
    }

    @Override
    public boolean enableVersioning(String dataName, String workspace, boolean isTopology, String historyMode, String undoSpace) throws Exception, MDSException {
        String requestTag = "enable_versioning";
        if (workspace == null || workspace.trim().isEmpty()) {
            return false;
        }
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        if (!isTopology) {
            reqAttrs.put("table_name", dataName);
        } else {
            reqAttrs.put("topology_name", dataName);
        }
        reqAttrs.put("workspace", workspace);
        if (historyMode != null) {
            reqAttrs.put("history_mode", historyMode);
        }
        if (undoSpace != null) {
            reqAttrs.put("undo_space", undoSpace);
        }
        String request = this.createGenericRequest("enable_versioning", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("enable_versioning", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/enable_versioning/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/enable_versioning/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("enable_versioning operation failed, no error message returned");
    }

    @Override
    public boolean isTableVersioned(String table, String workspace) throws Exception, MDSException {
        String requestTag = "is_table_versioned";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("table_name", table);
        if (workspace != null) {
            reqAttrs.put("workspace", workspace);
        }
        String request = this.createGenericRequest("is_table_versioned", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("is_table_versioned", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/is_table_versioned/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return "true".equalsIgnoreCase(doc.selectSingleNode("/edit_response/is_table_versioned").getTextContent());
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/is_table_versioned/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("is_table_versioned operation failed, no error message returned");
    }

    @Override
    public boolean disableVersioning(String dataName, boolean isTopology, boolean force, boolean ignoreLastError) throws Exception, MDSException {
        String requestTag = "disable_versioning";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        if (!isTopology) {
            reqAttrs.put("table_name", dataName);
        } else {
            reqAttrs.put("topology_name", dataName);
        }
        reqAttrs.put("force", String.valueOf(force));
        reqAttrs.put("ignore_last_error", String.valueOf(ignoreLastError));
        String request = this.createGenericRequest("disable_versioning", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("disable_versioning", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/disable_versioning/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/disable_versioning/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("disable_versioning operation failed, no error message returned");
    }

    @Override
    public Vector<FeatureConflictDescriptor> getTableWorkspaceConflicts(String workspace, String baseTable, String keyColumn) throws Exception, MDSException {
        String requestTag = "get_workspace_conflicts";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("child_workspace", workspace);
        reqAttrs.put("table_name", baseTable);
        reqAttrs.put("key_attribute", keyColumn);
        String request = this.createGenericRequest("get_workspace_conflicts", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_workspace_conflicts", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_workspace_conflicts/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            NodeList conflictList = doc.selectNodes("/edit_response/get_workspace_conflicts/conflict");
            Vector<FeatureConflictDescriptor> fdcVec = new Vector<FeatureConflictDescriptor>(conflictList.getLength());
            for (int i = 0; i < conflictList.getLength(); ++i) {
                XMLNode conflict = (XMLNode)conflictList.item(i);
                String key = conflict.selectSingleNode("feature_key").getFirstChild().getNodeValue();
                String parValue = null;
                String childValue = null;
                NamedNodeMap fA = conflict.selectSingleNode("feature_attribute").getAttributes();
                String attr_name = fA.getNamedItem("name").getNodeValue();
                String attr_spatial_type = null;
                if (fA.getNamedItem("spatial_type") != null) {
                    attr_spatial_type = fA.getNamedItem("spatial_type").getNodeValue();
                }
                if (attr_spatial_type != null) {
                    if (attr_spatial_type.equalsIgnoreCase("geometry")) {
                        parValue = GMLGeometryUtils.parseGML((org.w3c.dom.Node)conflict.selectSingleNode("parent_workspace_value"));
                        childValue = GMLGeometryUtils.parseGML((org.w3c.dom.Node)conflict.selectSingleNode("child_workspace_value"));
                    } else if (attr_spatial_type.equalsIgnoreCase("annotation")) {
                        parValue = AnnotationText.fromXMLNodeToAnnotationText((org.w3c.dom.Node)conflict.selectSingleNode("parent_workspace_value").getFirstChild());
                        childValue = AnnotationText.fromXMLNodeToAnnotationText((org.w3c.dom.Node)conflict.selectSingleNode("child_workspace_value").getFirstChild());
                    } else if (attr_spatial_type.equalsIgnoreCase("topofeature")) {
                        parValue = conflict.selectSingleNode("parent_workspace_value").getFirstChild().getNodeValue();
                        childValue = conflict.selectSingleNode("child_workspace_value").getFirstChild().getNodeValue();
                    }
                } else {
                    parValue = conflict.selectSingleNode("parent_workspace_value").getFirstChild().getNodeValue();
                    childValue = conflict.selectSingleNode("child_workspace_value").getFirstChild().getNodeValue();
                }
                String remPar = conflict.selectSingleNode("removed_on_parent").getFirstChild().getNodeValue();
                String remChild = conflict.selectSingleNode("removed_on_child").getFirstChild().getNodeValue();
                fdcVec.add(new FeatureConflictDescriptor(key, attr_name, (Object)parValue, (Object)childValue, remPar, remChild, null));
            }
            return fdcVec;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_workspace_conflicts/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_workspace_conflicts operation failed, no error message returned");
    }

    @Override
    public int resolveTableWorkspaceConflicts(String workspace, String baseTable, String keyAttribute, Vector<FeatureConflictDescriptor> conflicts) throws Exception, MDSException {
        String requestTag = "resolve_workspace_conflicts";
        Hashtable<String, StringBuilder> requestHash = new Hashtable<String, StringBuilder>();
        int toSolve = 0;
        for (int i = 0; i < conflicts.size(); ++i) {
            StringBuilder rB;
            FeatureConflictDescriptor fcd = conflicts.get(i);
            if (fcd.getResolveWorkspace() == null) continue;
            if (!requestHash.containsKey(fcd.getKey())) {
                rB = new StringBuilder("\t\t<feature>\n");
                rB.append("\t\t\t<key_value>" + fcd.getKey() + "</key_value>\n");
                requestHash.put(fcd.getKey(), rB);
            } else {
                rB = (StringBuilder)requestHash.get(fcd.getKey());
            }
            rB.append("\t\t\t<resolve_conflict>\n");
            rB.append("\t\t\t\t<attribute_name>" + fcd.getAttribute() + "</attribute_name>\n");
            Object resolveValue = null;
            if (fcd.getResolveWorkspace().equalsIgnoreCase("child")) {
                resolveValue = fcd.getChildValue();
                rB.append("\t\t\t\t<use_workspace_value>YES</use_workspace_value>\n");
            } else {
                resolveValue = fcd.getParentValue();
                rB.append("\t\t\t\t<use_workspace_value>NO</use_workspace_value>\n");
            }
            if (resolveValue instanceof JGeometry) {
                rB.append("\t\t\t\t<spatial_type>geometry</spatial_type>\n");
            } else if (resolveValue instanceof AnnotationText) {
                rB.append("\t\t\t\t<spatial_type>annotationtext</spatial_type>\n");
            }
            rB.append("\t\t\t</resolve_conflict>\n");
            ++toSolve;
        }
        StringBuilder fullReqBuilder = new StringBuilder();
        for (StringBuilder rB : requestHash.values()) {
            rB.append("\t\t</feature>\n");
            fullReqBuilder.append((CharSequence)rB);
        }
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("child_workspace", workspace);
        reqAttrs.put("table_name", baseTable);
        reqAttrs.put("key_attribute", keyAttribute);
        String request = this.createGenericRequest("resolve_workspace_conflicts", false, reqAttrs, fullReqBuilder);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("resolve_workspace_conflicts", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/resolve_workspace_conflicts/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return toSolve;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/resolve_workspace_conflicts/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("resolve_workspace_conflicts operation failed, no error message returned");
    }

    @Override
    public boolean mergeTableWorkspaces(String sessionName, String layerName) throws Exception, MDSException {
        String requestTag = "merge_workspaces";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("child_workspace", sessionName);
        reqAttrs.put("table_name", layerName);
        String request = this.createGenericRequest("merge_workspaces", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("merge_workspaces", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/merge_workspaces/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/merge_workspaces/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("merge_workspaces operation failed, no error message returned");
    }

    @Override
    public String[] getSessionWorkspaceModifiedLayers(String sessionName) throws Exception, MDSException {
        String requestTag = "is_session_workspace_modified";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("session_name", sessionName);
        String request = this.createGenericRequest("is_session_workspace_modified", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("is_session_workspace_modified", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/is_session_workspace_modified/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            String modified = doc.selectSingleNode("/edit_response/is_session_workspace_modified/@modified").getNodeValue();
            if (modified.equalsIgnoreCase("false")) {
                return null;
            }
            org.w3c.dom.Node layersNode = doc.selectSingleNode("/edit_response/is_session_workspace_modified/layers");
            if (layersNode != null && layersNode.getFirstChild() != null) {
                String layers = layersNode.getFirstChild().getNodeValue();
                if (layers == null) {
                    throw new Exception("is_session_workspace_modified inconsistent response, no layers returned but modified is true.");
                }
                ArrayList lys = Util.splitBy((String)layers, (String)",");
                if (lys == null || lys.size() == 0) {
                    throw new Exception("is_session_workspace_modified inconsistent response, no layers returned but modified is true.");
                }
                return lys.toArray(new String[lys.size()]);
            }
            throw new Exception("is_session_workspace_modified inconsistent response, no layers returned but modified is true.");
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/is_session_workspace_modified/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("is_session_workspace_modified operation failed, no error message returned");
    }

    @Override
    public String[] getModifiedTablesForWorkspace(String workspaceName) throws Exception, MDSException {
        String requestTag = "get_modified_tables_for_workspace";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("workspace_name", workspaceName);
        String request = this.createGenericRequest("get_modified_tables_for_workspace", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_modified_tables_for_workspace", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_modified_tables_for_workspace/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node tablesNode = doc.selectSingleNode("/edit_response/get_modified_tables_for_workspace/tables");
            if (tablesNode != null && tablesNode.getFirstChild() != null) {
                String tables = tablesNode.getFirstChild().getNodeValue();
                if (tables == null) {
                    return null;
                }
                ArrayList tbs = Util.splitBy((String)tables, (String)",");
                if (tbs == null || tbs.size() == 0) {
                    return null;
                }
                return tbs.toArray(new String[tbs.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_modified_tables_for_workspace/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_modified_tables_for_workspace operation failed, no error message returned");
    }

    @Override
    public String[] getModifiedWorkspacesForTable(String tableName) throws Exception, MDSException {
        String requestTag = "get_modified_workspaces_for_table";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("table_name", tableName);
        String request = this.createGenericRequest("get_modified_workspaces_for_table", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_modified_workspaces_for_table", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_modified_workspaces_for_table/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node wkspNode = doc.selectSingleNode("/edit_response/get_modified_workspaces_for_table/workspaces");
            if (wkspNode != null && wkspNode.getFirstChild() != null) {
                String workspaces = wkspNode.getFirstChild().getNodeValue();
                if (workspaces == null) {
                    return null;
                }
                ArrayList wks = Util.splitBy((String)workspaces, (String)",");
                if (wks == null || wks.size() == 0) {
                    return null;
                }
                return wks.toArray(new String[wks.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_modified_workspaces_for_table/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_modified_workspaces_for_table operation failed, no error message returned");
    }

    @Override
    public String[] getModifiedWorkspacesForTopology(String topologyName) throws Exception, MDSException {
        String requestTag = "get_modified_workspaces_for_topology";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("topology_name", topologyName);
        String request = this.createGenericRequest("get_modified_workspaces_for_topology", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_modified_workspaces_for_topology", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_modified_workspaces_for_topology/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node wkspNode = doc.selectSingleNode("/edit_response/get_modified_workspaces_for_topology/workspaces");
            if (wkspNode != null && wkspNode.getFirstChild() != null) {
                String workspaces = wkspNode.getFirstChild().getNodeValue();
                if (workspaces == null) {
                    return null;
                }
                ArrayList wks = Util.splitBy((String)workspaces, (String)",");
                if (wks == null || wks.size() == 0) {
                    return null;
                }
                return wks.toArray(new String[wks.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_modified_workspaces_for_topology/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_modified_workspaces_for_topology operation failed, no error message returned");
    }

    @Override
    public String[] getVersionedTables() throws Exception, MDSException {
        String requestTag = "get_versioned_tables";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        String request = this.createGenericRequest("get_versioned_tables", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_versioned_tables", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_versioned_tables/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node tablesNode = doc.selectSingleNode("/edit_response/get_versioned_tables/tables");
            if (tablesNode != null && tablesNode.getFirstChild() != null) {
                String tables = tablesNode.getFirstChild().getNodeValue();
                if (tables == null) {
                    return null;
                }
                ArrayList tbs = Util.splitBy((String)tables, (String)",");
                if (tbs == null || tbs.size() == 0) {
                    return null;
                }
                return tbs.toArray(new String[tbs.size()]);
            }
            return null;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_versioned_tables/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_versioned_tables operation failed, no error message returned");
    }

    @Override
    public String[] getGeometryAttributes(String table) throws Exception, MDSException {
        String requestTag = "get_geometry_attributes";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("table", table);
        String request = this.createGenericRequest("get_geometry_attributes", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_geometry_attributes", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_geometry_attributes/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return doc.selectSingleNode("/edit_response/get_geometry_attributes").getFirstChild().getNodeValue().split(",");
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_geometry_attributes/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_geometry_attributes operation failed, no error message returned");
    }

    @Override
    public String[] getNonComplexAttributes(String table) throws Exception, MDSException {
        String requestTag = "get_noncomplex_attributes";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("table", table);
        String request = this.createGenericRequest("get_noncomplex_attributes", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_noncomplex_attributes", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_noncomplex_attributes/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return doc.selectSingleNode("/edit_response/get_noncomplex_attributes").getFirstChild().getNodeValue().split(",");
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_noncomplex_attributes/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_noncomplex_attributes operation failed, no error message returned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<MVThemeMetadata> getMapViewerThemesMetadata() throws Exception {
        String type;
        String name;
        XMLNode theme;
        int i;
        NodeList themeList;
        String response;
        String dsrc = this.dataSource.getConnectionProperties().getProperty("dataSource");
        StringBuilder request = new StringBuilder("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        request.append("<non_map_request>\n");
        request.append("\t<list_predefined_themes_metadata data_source=\"" + dsrc + "\"/>\n");
        request.append("</non_map_request>");
        HttpConnection omsconn = new HttpConnection();
        String url = this.dataSource.getConnectionProperties().getProperty("serverURL") + "/omserver";
        if (!omsconn.connect(url)) {
            throw new Exception("Could not connect to the mapviewer server at: " + url);
        }
        omsconn.setContentTypeProperty("application/x-www-form-urlencoded");
        boolean reqException = false;
        try {
            omsconn.sendXMLRequest("xml_request", request.toString());
            response = omsconn.getXMLResponse();
        }
        catch (Exception e) {
            reqException = true;
            throw e;
        }
        finally {
            if (reqException) {
                omsconn.disConnect();
            }
        }
        Vector<MVThemeMetadata> themeVec = new Vector<MVThemeMetadata>();
        XMLDocument doc = this.parse(response);
        String succeed = doc.selectSingleNode("/non_map_response/predefined_theme_metadata_list/@succeed").getNodeValue();
        if (succeed.equalsIgnoreCase("true")) {
            themeList = doc.selectNodes("/non_map_response/predefined_theme_metadata_list/predefined_theme");
            for (i = 0; i < themeList.getLength(); ++i) {
                theme = (XMLNode)themeList.item(i);
                name = theme.getAttributes().getNamedItem("name").getNodeValue();
                type = theme.selectSingleNode("type").getFirstChild().getNodeValue().trim();
                String base_table = theme.selectSingleNode("base_table").getFirstChild().getNodeValue().trim();
                String spatial_column = theme.selectSingleNode("spatial_column").getFirstChild().getNodeValue().trim();
                String srid = theme.selectSingleNode("srid").getFirstChild().getNodeValue().trim();
                String xmin = theme.selectSingleNode("xmin").getFirstChild().getNodeValue().trim();
                String xmax = theme.selectSingleNode("xmax").getFirstChild().getNodeValue().trim();
                String xtolerance = theme.selectSingleNode("xtolerance").getFirstChild().getNodeValue().trim();
                String ymin = theme.selectSingleNode("ymin").getFirstChild().getNodeValue().trim();
                String ymax = theme.selectSingleNode("ymax").getFirstChild().getNodeValue().trim();
                String ytolerance = theme.selectSingleNode("ytolerance").getFirstChild().getNodeValue().trim();
                MVThemeMetadata mvtm = new MVThemeMetadata();
                mvtm.setName(name);
                mvtm.setType(type);
                mvtm.setBaseTable(base_table);
                mvtm.setSpatialColumn(spatial_column);
                mvtm.setSRID(Integer.parseInt(srid));
                mvtm.setXMin(Double.parseDouble(xmin));
                mvtm.setXMax(Double.parseDouble(xmax));
                mvtm.setXTolerance(Double.parseDouble(xtolerance));
                mvtm.setYMin(Double.parseDouble(ymin));
                mvtm.setYMax(Double.parseDouble(ymax));
                mvtm.setYTolerance(Double.parseDouble(ytolerance));
                themeVec.add(mvtm);
            }
        } else {
            omsconn.disConnect();
            throw new Exception("Server returned success=false");
        }
        request = new StringBuilder("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        request.append("<non_map_request>\n");
        request.append("\t<list_predefined_themes_type data_source=\"" + dsrc + "\" types=\"customgeom,wfs,wms,wmts\"/>\n");
        request.append("</non_map_request>");
        reqException = false;
        try {
            omsconn.sendXMLRequest("xml_request", request.toString());
            response = omsconn.getXMLResponse();
        }
        catch (Exception e) {
            reqException = true;
        }
        finally {
            omsconn.disConnect();
        }
        if (reqException) {
            return themeVec;
        }
        doc = this.parse(response);
        succeed = doc.selectSingleNode("/non_map_response/predefined_theme_type_list/@succeed").getNodeValue();
        if (succeed.equalsIgnoreCase("true")) {
            themeList = doc.selectNodes("/non_map_response/predefined_theme_type_list/predefined_theme");
            for (i = 0; i < themeList.getLength(); ++i) {
                theme = (XMLNode)themeList.item(i);
                name = theme.getAttributes().getNamedItem("name").getNodeValue();
                type = theme.getAttributes().getNamedItem("type").getNodeValue();
                boolean exists = false;
                int size = themeVec.size();
                for (int j = 0; j < size; ++j) {
                    if (!themeVec.get(j).getName().equalsIgnoreCase(name)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                MVThemeMetadata mvtm = new MVThemeMetadata();
                mvtm.setName(name);
                mvtm.setType(type);
                themeVec.add(mvtm);
            }
        }
        return themeVec;
    }

    @Override
    public Vector<MVTileLayerMetadata> getMapViewerTileLayersMetadata() throws Exception {
        String response;
        StringBuilder request = new StringBuilder("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        request.append("<non_map_request>\n");
        request.append("\t<list_tile_layers data_source=\"" + this.dataSource.getConnectionProperties().getProperty("dataSource") + "\"/>\n");
        request.append("</non_map_request>");
        HttpConnection omsconn = new HttpConnection();
        String url = this.dataSource.getConnectionProperties().getProperty("serverURL") + "/omserver";
        if (!omsconn.connect(url)) {
            throw new Exception("Could not connect to the mapviewer server at: " + url);
        }
        omsconn.setContentTypeProperty("application/x-www-form-urlencoded");
        try {
            omsconn.sendXMLRequest("xml_request", request.toString());
            response = omsconn.getXMLResponse();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            omsconn.disConnect();
        }
        XMLDocument doc = this.parse(response);
        String succeed = doc.selectSingleNode("/non_map_response/tile_layer_list/@succeed").getNodeValue();
        if (succeed.equalsIgnoreCase("true")) {
            NodeList tileList = doc.selectNodes("/non_map_response/tile_layer_list/tile_layer");
            Vector<MVTileLayerMetadata> tileVec = new Vector<MVTileLayerMetadata>(tileList.getLength());
            for (int i = 0; i < tileList.getLength(); ++i) {
                XMLNode tile = (XMLNode)tileList.item(i);
                String name = tile.getAttributes().getNamedItem("name").getNodeValue();
                String srid = tile.getAttributes().getNamedItem("srid").getNodeValue();
                String xmin = tile.getAttributes().getNamedItem("minx").getNodeValue();
                String ymin = tile.getAttributes().getNamedItem("miny").getNodeValue();
                String xmax = tile.getAttributes().getNamedItem("maxx").getNodeValue();
                String ymax = tile.getAttributes().getNamedItem("maxy").getNodeValue();
                MVTileLayerMetadata mvtl = new MVTileLayerMetadata();
                mvtl.setName(name);
                mvtl.setSRID(Integer.parseInt(srid));
                if (xmin != null && !xmin.equals("NaN")) {
                    mvtl.setMinX(Double.parseDouble(xmin));
                }
                if (ymin != null && !ymin.equals("NaN")) {
                    mvtl.setMinY(Double.parseDouble(ymin));
                }
                if (xmax != null && !xmax.equals("NaN")) {
                    mvtl.setMaxX(Double.parseDouble(xmax));
                }
                if (ymax != null && !ymax.equals("NaN")) {
                    mvtl.setMaxY(Double.parseDouble(ymax));
                }
                tileVec.add(mvtl);
            }
            return tileVec;
        }
        throw new Exception("Server returned success=false");
    }

    @Override
    public Vector<SpatialTableMetadata> getSpatialTablesMetadata() throws Exception, MDSException {
        String requestTag = "get_spatial_table_metadata";
        String request = this.createGenericRequest("get_spatial_table_metadata", false, null, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_spatial_table_metadata", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_spatial_table_metadata/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            NodeList tableList = doc.selectNodes("/edit_response/get_spatial_table_metadata/spatial_table");
            Vector<SpatialTableMetadata> stmVec = new Vector<SpatialTableMetadata>(tableList.getLength());
            for (int i = 0; i < tableList.getLength(); ++i) {
                XMLNode table = (XMLNode)tableList.item(i);
                String name = table.selectSingleNode("name").getFirstChild().getNodeValue();
                String type = table.selectSingleNode("type").getFirstChild().getNodeValue();
                String spatialColumn = table.selectSingleNode("spatial_column").getFirstChild().getNodeValue();
                String srid = table.selectSingleNode("srid").getFirstChild().getNodeValue();
                String owner = table.selectSingleNode("owner").getFirstChild().getNodeValue();
                if (name.toUpperCase().endsWith("_LT")) continue;
                SpatialTableMetadata stm = new SpatialTableMetadata();
                stm.setName(name);
                stm.setType(type);
                stm.setSpatialColumn(spatialColumn);
                stm.setSRID(Integer.parseInt(srid));
                stm.setOwner(owner);
                stmVec.add(stm);
            }
            return stmVec;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_spatial_table_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_spatial_table_metadata operation failed, no error message returned");
    }

    @Override
    public boolean createEditSession(String sessionName, String description, boolean versionEnabled) throws Exception, MDSException {
        String requestTag = "create_session";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("session_name", sessionName);
        if (description != null) {
            reqAttrs.put("description", description);
        }
        if (!versionEnabled) {
            reqAttrs.put("version_enabled", "false");
        } else {
            reqAttrs.put("version_enabled", "true");
        }
        String request = this.createGenericRequest("create_session", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("create_session", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/create_session/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/create_session/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("create_session operation failed, no error message returned");
    }

    @Override
    public boolean removeEditSession(String sessionName) throws Exception, MDSException {
        String requestTag = "remove_session";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("session_name", sessionName);
        String request = this.createGenericRequest("remove_session", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("remove_session", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/remove_session/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/remove_session/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("remove_session operation failed, no error message returned");
    }

    @Override
    public boolean updateEditSession(MDSEditSession editSession) throws Exception, MDSException {
        String requestTag = "update_session_attributes";
        StringBuilder xmlChild = new StringBuilder(SessionXMLUtils.sessionToXMLString(editSession));
        xmlChild.append("<description>" + editSession.getDescription() + "</description>\n");
        String areaStr = "null";
        Rectangle2D area = editSession.getArea();
        if (area != null) {
            areaStr = this.toGML(new JGeometry(area.getMinX(), area.getMinY(), area.getMaxX(), area.getMaxY(), editSession.getSRID()));
        }
        xmlChild.append("<area>" + areaStr + "</area>\n");
        xmlChild.append("<status>" + editSession.getStatus() + "</status>\n");
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("session_name", editSession.getName());
        String request = this.createGenericRequest("update_session_attributes", false, reqAttrs, xmlChild);
        this.conn.sendXMLRequest("xml_request", URLEncoder.encode(request, "UTF-8"));
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("update_session_attributes", response);
        XMLDocument doc = this.parse(response);
        String success = doc.selectSingleNode("/edit_response/update_session_attributes/@success").getNodeValue();
        if (success.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/update_session_attributes/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("update_session_attributes operation failed, no error message returned");
    }

    public boolean updateAnnotationTextMetadata(AnnotationTextMetadata atmd) throws Exception, MDSException {
        String requestTag = "update_annotation_text_metadata";
        String table = atmd.getName();
        String column = atmd.getSpatialColumn();
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(2);
        reqAttrs.put("table", table);
        reqAttrs.put("column", column);
        if (table == null || column == null) {
            throw new Exception("The table or the column in the metadata is null.");
        }
        StringBuilder reqChild = new StringBuilder();
        if (!Double.isNaN(atmd.getMapBaseScale())) {
            reqChild.append("\t<base_scale>" + atmd.getMapBaseScale() + "</base_scale>\n");
        }
        if (atmd.getTextExpression() != null) {
            reqChild.append("\t<text_expression>" + atmd.getTextExpression() + "</text_expression>\n");
        }
        if (atmd.getTextAtttributes() != null) {
            reqChild.append("\t<text_attributes><![CDATA[" + atmd.getTextAtttributes() + "]]></text_attributes>\n");
        }
        String request = this.createGenericRequest("update_annotation_text_metadata", false, reqAttrs, reqChild);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("update_annotation_text_metadata", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/update_annotation_text_metadata/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/update_annotation_text_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("update_annotation_text_metadata operation failed, no error message returned");
    }

    @Override
    public String[] getEditorSessions() throws Exception, MDSException {
        String requestTag = "get_editor_sessions";
        String request = this.createGenericRequest("get_editor_sessions", false, null, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_editor_sessions", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_editor_sessions/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            org.w3c.dom.Node sessions = doc.selectSingleNode("/edit_response/get_editor_sessions").getFirstChild();
            if (sessions == null) {
                return new String[0];
            }
            return sessions.getNodeValue().split(",");
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_editor_sessions/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_editor_sessions operation failed, no error message returned");
    }

    private void validateEditResponse(String requestTag, String response) throws Exception {
        if (requestTag == null || response == null) {
            throw new Exception("Invalid edit request [" + requestTag + "] or invalide edit response [" + response + "].");
        }
        if (response.indexOf("edit_response") == -1) {
            log.warning("Invalid response for edit request [" + requestTag + "]:\n" + response);
            throw new Exception("Invalid response for edit request [" + requestTag + "]. See log for detailed response.");
        }
    }

    @Override
    public String getEditSession(String sessionName) throws Exception, MDSException {
        String requestTag = "get_session_definition";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("session_name", sessionName);
        String request = this.createGenericRequest("get_session_definition", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_session_definition", response);
        XMLDocument doc = this.parse(response);
        String success = doc.selectSingleNode("/edit_response/get_session_definition/@success").getNodeValue();
        if (success.equalsIgnoreCase("true")) {
            XMLNode defNode = (XMLNode)doc.selectSingleNode("/edit_response/get_session_definition/session_definition");
            StringWriter sw = new StringWriter(200);
            try {
                defNode.print(new PrintWriter(sw));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return sw.toString();
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_session_definition/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_session_definition operation failed, no error message returned");
    }

    @Override
    public boolean endEditingSession(String sessionName) throws Exception, MDSException {
        String requestTag = "end_session";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("session_name", sessionName);
        String request = this.createGenericRequest("end_session", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("end_session", response);
        XMLDocument doc = this.parse(response);
        String success = doc.selectSingleNode("/edit_response/end_session/@success").getNodeValue();
        if (success.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/end_session/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("end_session operation failed, no error message returned");
    }

    @Override
    public boolean startEditingSession(String sessionName, JGeometry area) throws Exception, MDSException {
        String requestTag = "start_session";
        StringBuilder pReq = new StringBuilder("<area>\n");
        pReq.append(this.toGML(area));
        pReq.append("</area>\n");
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("session_name", sessionName);
        String request = this.createGenericRequest("start_session", false, reqAttrs, pReq);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("start_session", response);
        XMLDocument doc = this.parse(response);
        String success = doc.selectSingleNode("/edit_response/start_session/@success").getNodeValue();
        if (success.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/start_session/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("start_session operation failed, no error message returned");
    }

    @Override
    public boolean clearCachedSessions() throws Exception, MDSException {
        String requestTag = "clear_cached_sessions";
        String request = this.createGenericRequest("clear_cached_sessions", false, null, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("clear_cached_sessions", response);
        XMLDocument doc = this.parse(response);
        String success = doc.selectSingleNode("/edit_response/clear_cached_sessions/@success").getNodeValue();
        if (success.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/clear_cached_sessions/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("clear_cached_sessions operation failed, no error message returned");
    }

    @Override
    public TableAttributesMetadata getTableAttributesMetadata(String table, String spatialColumn, String spatialType) throws Exception, MDSException {
        String requestTag = "get_table_attributes_metadata";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(3);
        reqAttrs.put("table", table);
        reqAttrs.put("spatial_column", spatialColumn);
        reqAttrs.put("spatial_type", spatialType);
        String request = this.createGenericRequest("get_table_attributes_metadata", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_table_attributes_metadata", response);
        XMLDocument doc = this.parse(response);
        String success = doc.selectSingleNode("/edit_response/get_table_attributes_metadata/@success").getNodeValue();
        if (success.equalsIgnoreCase("true")) {
            TableAttributesMetadata tam = new TableAttributesMetadata(table);
            tam.setSpatialColumn(spatialColumn);
            tam.setSRID(Long.parseLong(doc.selectSingleNode("/edit_response/get_table_attributes_metadata/spatial_column/@srid").getNodeValue()));
            tam.setGeodeticSRID("true".equalsIgnoreCase(doc.selectSingleNode("/edit_response/get_table_attributes_metadata/spatial_column/@geodetic").getNodeValue()));
            NodeList attrList = doc.selectNodes("/edit_response/get_table_attributes_metadata/simple_attributes/attribute");
            Hashtable<String, String> attrTypes = new Hashtable<String, String>(attrList.getLength());
            for (int i = 0; i < attrList.getLength(); ++i) {
                XMLNode attrNode = (XMLNode)attrList.item(i);
                String name = attrNode.selectSingleNode("@name").getNodeValue();
                String type = attrNode.selectSingleNode("@javatype").getNodeValue();
                attrTypes.put(name, type);
            }
            tam.setAttributesJavaType(attrTypes);
            org.w3c.dom.Node nnaNode = doc.selectSingleNode("/edit_response/get_table_attributes_metadata/non_null_attributes");
            if (nnaNode != null) {
                String[] nnattrs = nnaNode.getFirstChild().getNodeValue().split(",");
                Vector<String> nnAttrsVec = new Vector<String>(nnattrs.length);
                for (int i = 0; i < nnattrs.length; ++i) {
                    nnAttrsVec.add(nnattrs[i]);
                }
                tam.setNonNullAttributes(nnAttrsVec);
            }
            return tam;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_table_attributes_metadata/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_table_attributes_metadata operation failed, no error message returned");
    }

    @Override
    public boolean createTable(String tableName, String[] columns, String[] types, boolean[] notNull, String primaryKey, Vector<SpatialTableMetadata> spatialMetadata) throws Exception, MDSException {
        int i;
        String requestTag = "create_table";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("table", tableName);
        StringBuilder rB = new StringBuilder("\t\t<table_columns>\n");
        for (i = 0; i < columns.length; ++i) {
            rB.append("\t\t\t<column name=\"" + columns[i] + "\" type=\"" + types[i] + "\"");
            if (notNull[i]) {
                rB.append(" notnull=\"true\"");
            }
            if (primaryKey.equalsIgnoreCase(columns[i])) {
                rB.append(" primary_key=\"true\"");
            }
            rB.append("/>\n");
        }
        rB.append("\t\t</table_columns>\n");
        if (spatialMetadata != null && spatialMetadata.size() > 0) {
            rB.append("\t\t<spatial_metadata>\n");
            for (i = 0; i < spatialMetadata.size(); ++i) {
                SpatialTableMetadata stm = spatialMetadata.get(i);
                rB.append("\t\t\t<column name=\"" + stm.getSpatialColumn() + "\" srid=\"" + stm.getSRID() + "\">\n");
                Vector dimInfoVec = stm.getDimensionInfo();
                if (dimInfoVec != null && dimInfoVec.size() > 0) {
                    for (int j = 0; j < dimInfoVec.size(); ++j) {
                        DimensionInfo di = (DimensionInfo)dimInfoVec.get(j);
                        rB.append("\t\t\t\t<dimension name=\"" + di.getName() + "\" min=\"" + di.getMin() + "\" max=\"" + di.getMax() + "\" tolerance=\"" + di.getTolerance() + "\"/>\n");
                    }
                }
                rB.append("\t\t\t</column>\n");
            }
            rB.append("\t\t</spatial_metadata>\n");
        }
        String request = this.createGenericRequest("create_table", false, reqAttrs, rB);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("create_table", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/create_table/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/create_table/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("create_table operation failed, no error message returned");
    }

    @Override
    public SpatialColumnExtent getSpatialColumnExtent(String owner, String tableName, String spatialColumn, String spatialType) throws Exception, MDSException {
        String requestTag = "get_spatialindex_extent";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(3);
        reqAttrs.put("table", tableName);
        reqAttrs.put("spatial_column", spatialColumn);
        if (owner != null) {
            reqAttrs.put("owner", owner);
        }
        if (spatialType != null) {
            reqAttrs.put("spatial_type", spatialType);
        }
        String request = this.createGenericRequest("get_spatialindex_extent", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_spatialindex_extent", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_spatialindex_extent/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            if (doc.selectSingleNode("/edit_response/get_spatialindex_extent/srid") == null && doc.selectSingleNode("/edit_response/get_spatialindex_extent/mbr") == null) {
                return null;
            }
            int srid = Integer.parseInt(doc.selectSingleNode("/edit_response/get_spatialindex_extent/srid").getFirstChild().getNodeValue());
            String[] mbrStr = doc.selectSingleNode("/edit_response/get_spatialindex_extent/mbr").getFirstChild().getNodeValue().split(",");
            double[] mbr = new double[mbrStr.length];
            for (int i = 0; i < mbrStr.length; ++i) {
                mbr[i] = Double.parseDouble(mbrStr[i]);
            }
            SpatialColumnExtent sce = new SpatialColumnExtent();
            sce.setTableName(tableName);
            sce.setColumnName(spatialColumn);
            sce.setSRID(srid);
            sce.setExtent(mbr);
            return sce;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_spatialindex_extent/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_spatialindex_extent operation failed, no error message returned");
    }

    @Override
    public SRS getSRS(String srid) throws Exception, MDSException {
        String requestTag = "get_srs";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("srid", "" + srid);
        String request = this.createGenericRequest("get_srs", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("get_srs", response);
        XMLDocument doc = this.parse(response);
        String status = doc.selectSingleNode("/edit_response/get_srs/@success").getNodeValue();
        if (status.equalsIgnoreCase("true")) {
            String oracle_srid = null;
            try {
                oracle_srid = doc.selectSingleNode("/edit_response/get_srs/oracle_srid").getFirstChild().getNodeValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
            String wkt = null;
            try {
                wkt = doc.selectSingleNode("/edit_response/get_srs/wktext").getFirstChild().getNodeValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (oracle_srid == null) {
                oracle_srid = srid;
            }
            SRS srs = null;
            if (wkt != null && oracle_srid != null) {
                srs = Util.WKTtoSRS((int)Integer.parseInt(oracle_srid), (String)wkt);
            }
            return srs;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/get_srs/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("get_srs operation failed, no error message returned");
    }

    private String toGML(Object object) throws Exception {
        if (object instanceof JGeometry) {
            return this.toGML((JGeometry)object);
        }
        if (object instanceof AnnotationText) {
            return ((AnnotationText)object).toXML();
        }
        if (object instanceof TopologyGeometry) {
            return this.toGML((TopologyGeometry)object);
        }
        return "";
    }

    @Override
    public Vector<String> getMapViewerBaseMaps() throws Exception, MDSException {
        String response;
        StringBuilder request = new StringBuilder("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        request.append("<non_map_request>\n");
        request.append("\t<list_maps data_source=\"" + this.dataSource.getConnectionProperties().getProperty("dataSource") + "\"/>\n");
        request.append("</non_map_request>");
        HttpConnection omsconn = new HttpConnection();
        String url = this.dataSource.getConnectionProperties().getProperty("serverURL") + "/omserver";
        if (!omsconn.connect(url)) {
            throw new Exception("Could not connect to the mapviewer server at: " + url);
        }
        omsconn.setContentTypeProperty("application/x-www-form-urlencoded");
        try {
            omsconn.sendXMLRequest("xml_request", request.toString());
            response = omsconn.getXMLResponse();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            omsconn.disConnect();
        }
        XMLDocument doc = this.parse(response);
        String succeed = doc.selectSingleNode("/non_map_response/map_list/@succeed").getNodeValue();
        if (succeed.equalsIgnoreCase("true")) {
            NodeList bmapList = doc.selectNodes("/non_map_response/map_list/map");
            Vector<String> bmapVec = new Vector<String>(bmapList.getLength());
            for (int i = 0; i < bmapList.getLength(); ++i) {
                XMLNode theme = (XMLNode)bmapList.item(i);
                String name = theme.getAttributes().getNamedItem("name").getNodeValue();
                bmapVec.add(name);
            }
            return bmapVec;
        }
        throw new Exception("Server returned success=false");
    }

    @Override
    public String[] getMapViewerBasemapThemeNames(String basemap) throws Exception, MDSException {
        String response;
        if (basemap == null) {
            return null;
        }
        StringBuilder request = new StringBuilder("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        request.append("<non_map_request>\n");
        request.append("\t<list_predefined_themes data_source=\"" + this.dataSource.getConnectionProperties().getProperty("dataSource") + "\"" + " map=\"" + basemap + "\"/>\n");
        request.append("</non_map_request>");
        HttpConnection omsconn = new HttpConnection();
        String url = this.dataSource.getConnectionProperties().getProperty("serverURL") + "/omserver";
        if (!omsconn.connect(url)) {
            throw new Exception("Could not connect to the mapviewer server at: " + url);
        }
        omsconn.setContentTypeProperty("application/x-www-form-urlencoded");
        try {
            omsconn.sendXMLRequest("xml_request", request.toString());
            response = omsconn.getXMLResponse();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            omsconn.disConnect();
        }
        XMLDocument doc = this.parse(response);
        String succeed = doc.selectSingleNode("/non_map_response/predefined_theme_list/@succeed").getNodeValue();
        if (succeed.equalsIgnoreCase("true")) {
            NodeList bmapList = doc.selectNodes("/non_map_response/predefined_theme_list/predefined_theme");
            Vector<String> bmapVec = new Vector<String>(bmapList.getLength());
            for (int i = 0; i < bmapList.getLength(); ++i) {
                XMLNode theme = (XMLNode)bmapList.item(i);
                String name = theme.getAttributes().getNamedItem("name").getNodeValue();
                bmapVec.add(name);
            }
            if (bmapVec.size() == 0) {
                return null;
            }
            return bmapVec.toArray(new String[bmapVec.size()]);
        }
        throw new Exception("Server returned success=false");
    }

    @Override
    public boolean lockTopologyRows(String workspace, String topology, double xmin, double ymin, double xmax, double ymax) throws Exception, MDSException {
        String requestTag = "lock_topology_rows";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("workspace_name", workspace);
        reqAttrs.put("topology_name", topology);
        reqAttrs.put("xmin", "" + xmin);
        reqAttrs.put("ymin", "" + ymin);
        reqAttrs.put("xmax", "" + xmax);
        reqAttrs.put("ymax", "" + ymax);
        String request = this.createGenericRequest("lock_topology_rows", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("lock_topology_rows", response);
        XMLDocument doc = this.parse(response);
        String success = doc.selectSingleNode("/edit_response/lock_topology_rows/@success").getNodeValue();
        if (success.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/lock_topology_rows/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("lock_topology_rows operation failed, no error message returned");
    }

    @Override
    public boolean unlockTopologyRows(String workspace, String topology, double xmin, double ymin, double xmax, double ymax) throws Exception, MDSException {
        String requestTag = "unlock_topology_rows";
        Hashtable<String, String> reqAttrs = new Hashtable<String, String>(1);
        reqAttrs.put("workspace_name", workspace);
        reqAttrs.put("topology_name", topology);
        reqAttrs.put("xmin", "" + xmin);
        reqAttrs.put("ymin", "" + ymin);
        reqAttrs.put("xmax", "" + xmax);
        reqAttrs.put("ymax", "" + ymax);
        String request = this.createGenericRequest("unlock_topology_rows", false, reqAttrs, null);
        this.conn.sendXMLRequest("xml_request", request);
        String response = this.conn.getXMLResponse();
        this.validateEditResponse("unlock_topology_rows", response);
        XMLDocument doc = this.parse(response);
        String success = doc.selectSingleNode("/edit_response/unlock_topology_rows/@success").getNodeValue();
        if (success.equalsIgnoreCase("true")) {
            return true;
        }
        XMLNode errorNode = (XMLNode)doc.selectSingleNode("/edit_response/unlock_topology_rows/error");
        if (errorNode != null) {
            this.parseErrorAndThrowException(errorNode);
        }
        throw new Exception("unlock_topology_rows operation failed, no error message returned");
    }

    private String toGML(JGeometry geom) throws Exception {
        return GMLGeometryUtils.toGML((JGeometry)geom);
    }

    private String toGML(TopologyGeometry tpgeom) {
        TopoChildFeatureDescriptor[] tcfds;
        if (tpgeom == null) {
            return "";
        }
        String out = "<topo_geometry>\n";
        out = out + "  <tg_id>" + tpgeom.getId() + "</tg_id>\n";
        out = out + "  <tg_layer_id>" + tpgeom.getLayerId() + "</tg_layer_id>\n";
        out = out + "  <tg_type>" + tpgeom.getTopoTypeIntValue() + "</tg_type>\n";
        TopoPrimitiveDescriptor[] tpds = tpgeom.getTopoPrimitives();
        if (tpds != null && tpds.length > 0) {
            out = out + "   <topo_primitives>\n";
            for (int i = 0; i < tpds.length; ++i) {
                out = out + "      <topo_primitive topo_id=\"" + tpds[i].getTopoId() + "\" topo_type=\"" + tpds[i].getTopoType() + "\" />\n";
            }
            out = out + "   </topo_primitives>\n";
        }
        if ((tcfds = tpgeom.getChildFeatures()) != null && tcfds.length > 0) {
            out = out + "   <child_features>\n";
            for (int i = 0; i < tcfds.length; ++i) {
                out = out + "      <child_feature layer_id=\"" + tcfds[i].getLayerId() + "\" feature_id=\"" + tcfds[i].getFeatureId() + "\" />\n";
            }
            out = out + "   </child_features>\n";
        }
        out = out + "</topo_geometry>";
        return out;
    }

    private String collectionToGML(JGeometry geom) {
        try {
            StringBuilder gmlout = new StringBuilder("<gml:MultiGeometry srsName=\"SDO:");
            if (geom.getSRID() != 0) {
                gmlout.append(geom.getSRID());
            }
            gmlout.append("\" xmlns:gml=\"http://www.opengis.net/gml\">");
            JGeometry[] elements = geom.getElements();
            for (int i = 0; i < elements.length; ++i) {
                gmlout.append("<gml:geometryMember>");
                gmlout.append(GML2.to_GMLGeometry((JGeometry)elements[i]));
                gmlout.append("</gml:geometryMember>");
            }
            gmlout.append("</gml:MultiGeometry>");
            return gmlout.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private class ProgressInputStream
    extends FilterInputStream {
        private PropertyChangeSupport prop;
        private int progress;
        private int marked;

        public ProgressInputStream(PropertyChangeSupport prop, InputStream in) {
            super(in);
            this.prop = null;
            this.progress = 0;
            this.marked = 0;
            this.prop = prop;
        }

        private void updateProgress(int value, boolean sum) {
            int old = this.progress;
            int n = this.progress = sum ? this.progress + value : value;
            if (this.prop != null) {
                int available = 0;
                try {
                    available += this.in.available();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                int newProgress = (int)(100.0 * (double)this.progress / (double)(this.progress + available));
                this.prop.firePropertyChange("progress", 0, newProgress);
            }
        }

        @Override
        public int read() throws IOException {
            int c = this.in.read();
            if (c >= 0) {
                this.updateProgress(1, true);
            }
            return c;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int nr = this.in.read(b);
            if (nr > 0) {
                this.updateProgress(nr, true);
            }
            return nr;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nr = this.in.read(b, off, len);
            if (nr > 0) {
                this.updateProgress(nr, true);
            }
            return nr;
        }

        @Override
        public long skip(long n) throws IOException {
            long nr = this.in.skip(n);
            if (nr > 0L) {
                this.updateProgress((int)nr, true);
            }
            return nr;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.marked = this.progress;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
            this.updateProgress(this.marked, false);
        }
    }
}

