/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectableLayer;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.tools.FeaturePickTool;
import oracle.mapviewer.share.Field;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.FeaturePickByAttributePanel;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.actiongroup.BasicToolsPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.AbstractDataSet;

public class FeatureToolsPane
extends BasicToolsPane {
    protected JToggleButton select = new JToggleButton(Icons.getIcon("selectobject_qualifier.png"));
    protected JToggleButton multiselect = new JToggleButton(Icons.getIcon("multiselectobject.png"));
    protected JButton selectbyattribute = new JButton(Icons.getIcon("selbyattr.png"));
    protected JButton unselect = new JButton(Icons.getIcon("unselectobject.png"));
    protected JButton attribute = new JButton(Icons.getIcon("attributeedit_ena.png"));
    protected JButton copyfeature = new JButton(Icons.getIcon("duplicate.png"));
    protected JButton delete = new JButton(Icons.getIcon("delete.png"));

    public FeatureToolsPane(MainAppPanel mainApp) {
        super(mainApp);
        this.buttons = new AbstractButton[]{this.select, this.multiselect, this.selectbyattribute, this.unselect, this.delete, this.copyfeature, this.attribute};
        this.setName(MessagesBundle.getMessage("Feature"));
        this.select.setToolTipText(MessagesBundle.getMessage("Tooltip_select_feature"));
        this.select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = FeatureToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    FeatureToolsPane.this.getMainApp().setTool(new FeaturePickTool(canvas));
                }
            }
        });
        this.multiselect.setToolTipText(MessagesBundle.getMessage("Tooltip_select_multiple_features"));
        this.multiselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = FeatureToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    FeaturePickTool tool = new FeaturePickTool(canvas);
                    tool.setMultiSelection(true);
                    FeatureToolsPane.this.getMainApp().setTool(tool);
                }
            }
        });
        this.selectbyattribute.setToolTipText(MessagesBundle.getMessage("Tooltip_select_by_attribute_value"));
        this.selectbyattribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = FeatureToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                LayerManager lm = canvas.getLayerManager();
                LayerManager selectionLayers = canvas.getLayerManager().filterSetByTags(new String[]{"selectionLayer"});
                if (selectionLayers.size() == 0) {
                    return;
                }
                ArrayList<AbstractDataSetLayer> selLayers = new ArrayList<AbstractDataSetLayer>();
                for (Layer layer : selectionLayers) {
                    if (!(layer instanceof AbstractDataSetLayer)) continue;
                    selLayers.add((AbstractDataSetLayer)layer);
                }
                if (selLayers.size() == 0) {
                    return;
                }
                FeaturePickByAttributePanel fppanel = new FeaturePickByAttributePanel(selLayers.toArray(new AbstractDataSetLayer[selLayers.size()]));
                OlafDialog fpdlg = new OlafDialog(canvas.getFrameForDialog(), MessagesBundle.getMessage("Feature_selection_by_atribute"), fppanel, 0.9f);
                fpdlg.setSize(400, 230);
                fpdlg.setVisible(true);
                if (!fpdlg.isCancelled()) {
                    fpdlg.dispose();
                    Field attrField = fppanel.getAttributeValue();
                    if (attrField == null) {
                        return;
                    }
                    AbstractDataSetLayer absL = fppanel.getSelectedLayer();
                    Vector<GeoObject> toAdd = new Vector<GeoObject>();
                    List<GeoObject> hits = absL.getIndexedDataSet().getFeaturesByAttribute(canvas.getMapRegion().getDataWindow(), attrField);
                    for (GeoObject feat : hits) {
                        if (absL.isSelected(feat)) continue;
                        AbstractFeature clone = ((AbstractFeature)feat).clone();
                        toAdd.add(clone);
                    }
                    if (fppanel.appendSelections()) {
                        absL.select(toAdd);
                    } else {
                        absL.setSelection(toAdd);
                    }
                    if (absL instanceof HoverableLayer) {
                        absL.clearHover();
                    }
                } else {
                    fpdlg.dispose();
                }
            }
        });
        this.unselect.setToolTipText(MessagesBundle.getMessage("Tooltip_unselect_features"));
        this.unselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = FeatureToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                for (Layer l : canvas.getLayerManager()) {
                    if (l instanceof SelectableLayer) {
                        ((SelectableLayer)l).clearSelection();
                    }
                    if (!(l instanceof HoverableLayer)) continue;
                    ((HoverableLayer)l).clearHover();
                }
            }
        });
        this.delete.setToolTipText(MessagesBundle.getMessage("Tooltip_delete_features"));
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = FeatureToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                Layer targetLayer = canvas.getLayerManager().getLayerByTag("targetLayer");
                if (targetLayer == null) {
                    return;
                }
                if (targetLayer instanceof TopologyPrimitiveLayer) {
                    TopologyPrimitiveLayer tpl = (TopologyPrimitiveLayer)targetLayer;
                    List<GeoObject> feats = tpl.getSelection();
                    if (feats == null || feats.size() == 0) {
                        return;
                    }
                    try {
                        int id = Integer.parseInt(feats.get(0).getKey().toString());
                        if (tpl.getPrimitiveType() == TopologyPrimitiveLayer.NODE_TYPE) {
                            tpl.removeNode(id);
                        } else if (tpl.getPrimitiveType() == TopologyPrimitiveLayer.EDGE_TYPE) {
                            tpl.removeEdge(id);
                        }
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toremove_topo_primitive") + "\n" + ex.getMessage(), MessagesBundle.getMessage("Error"), 0);
                        return;
                    }
                    tpl.clearSelection();
                    return;
                }
                AbstractDataSetLayer layer = (AbstractDataSetLayer)targetLayer;
                List<GeoObject> features = layer.getSelection();
                if (features == null || features.size() == 0) {
                    return;
                }
                String[] keys = new String[features.size()];
                for (int i = 0; i < features.size(); ++i) {
                    keys[i] = features.get(i).getKey().toString();
                }
                if (layer instanceof TopologySetLayer) {
                    try {
                        boolean canremove = ((TopologySetLayer)layer).canRemoveFeatures(keys);
                        if (!canremove) {
                            ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toremove_features"), MessagesBundle.getMessage("Error"), 0);
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toremove_features"), MessagesBundle.getMessage("Error"), 0);
                        return;
                    }
                }
                layer.deleteObjects(keys);
                layer.clearSelection();
            }
        });
        this.copyfeature.setToolTipText(MessagesBundle.getMessage("Tooltip_duplicate_features"));
        this.copyfeature.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = FeatureToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                AbstractDataSetLayer targetLayer = (AbstractDataSetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                if (targetLayer == null || targetLayer instanceof TopologySetLayer) {
                    return;
                }
                List<GeoObject> selected = canvas.getLayerManager().getAllSelections();
                ArrayList<AbstractFeature> sameTargetFeats = new ArrayList<AbstractFeature>();
                ArrayList<GeoObject> allNewFeats = new ArrayList<GeoObject>();
                Hashtable<Layer, Boolean> copiedFromLayers = new Hashtable<Layer, Boolean>();
                String changeName = MessagesBundle.getMessage("Change_duplicate_feature");
                canvas.getUndoManager().startChangeBlock(changeName);
                try {
                    for (int i = 0; i < selected.size(); ++i) {
                        AbstractFeature selFeat = (AbstractFeature)selected.get(i);
                        AbstractFeature newFeat = null;
                        Vector<String> nonNullAttrs = null;
                        AbstractDataSet dset = targetLayer.getDataSet();
                        String keyColumn = dset.getKeyColumn();
                        if (selFeat.getLayer() == targetLayer) {
                            newFeat = selFeat.deepClone();
                            newFeat.setKey(null);
                        } else {
                            if (selFeat.getLayer().getClass() != targetLayer.getClass()) continue;
                            newFeat = (AbstractFeature)selFeat.getClass().newInstance();
                            newFeat.setSpatialAttribute(selFeat.getSpatialAttributeClone());
                            newFeat.setLayer(targetLayer);
                            nonNullAttrs = targetLayer.getDataSet().getNonNullAttributes();
                        }
                        if (newFeat.getKey() == null || nonNullAttrs.size() > 0) {
                            Field[] fields = targetLayer.getFieldsForFeature(newFeat, false);
                            if (fields == null || fields.length == 0) continue;
                            newFeat.setAttributes(fields);
                        }
                        targetLayer.insertObject(newFeat.getAttribute(keyColumn).getValue().toString(), newFeat);
                        if (selFeat.getLayer() == targetLayer) {
                            sameTargetFeats.add(newFeat);
                            continue;
                        }
                        allNewFeats.add(newFeat);
                        copiedFromLayers.put(selFeat.getLayer(), true);
                    }
                    if (sameTargetFeats.size() > 0) {
                        AffineTransform at = new AffineTransform(canvas.getMapRegion().getViewportTransform().createInverse());
                        at.translate(10.0, 10.0);
                        at.concatenate(canvas.getMapRegion().getViewportTransform());
                        targetLayer.transformFeatures(sameTargetFeats.toArray(new AbstractFeature[sameTargetFeats.size()]), at);
                    }
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_tocopy_features"), MessagesBundle.getMessage("Error"), 0);
                }
                finally {
                    canvas.getUndoManager().endChangeBlock(changeName);
                }
                allNewFeats.addAll(sameTargetFeats);
                if (allNewFeats.size() > 0) {
                    for (Layer layer : copiedFromLayers.keySet()) {
                        ((SelectableLayer)layer).clearSelection();
                    }
                    targetLayer.setSelection(allNewFeats);
                }
            }
        });
        this.attribute.setToolTipText(MessagesBundle.getMessage("Tooltip_edit_feature_attributes"));
        this.attribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = FeatureToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                AbstractDataSetLayer layer = (AbstractDataSetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                if (layer == null) {
                    return;
                }
                List<GeoObject> objs = layer.getSelection();
                if (objs == null || objs.size() == 0) {
                    return;
                }
                AbstractFeature feature = (AbstractFeature)objs.get(0);
                if (feature == null) {
                    return;
                }
                Field[] updFields = layer.getFieldsForFeature(feature, true);
                if (updFields == null) {
                    return;
                }
                if (updFields.length > 0) {
                    try {
                        layer.updateObjectAttributes(feature.getKey().toString(), updFields);
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), "Could not update object attributes", "Error", 2);
                    }
                }
            }
        });
        ButtonGroup grp = mainApp.getButtonGroup("toolsBG");
        for (AbstractButton btn : this.buttons) {
            if (btn instanceof JToggleButton) {
                grp.add(btn);
            }
            this.add(btn);
        }
        this.updateUIStatus();
    }

    @Override
    public void updateButtonsStatus() {
        LayerManager selectionLayers;
        boolean editable;
        MapCanvas canvas;
        EditSession editSession = this.mainApp.getEditSessionPanel().getEditSession();
        if (editSession == null) {
            return;
        }
        Layer tool = this.mainApp.getTool();
        if (tool instanceof FeaturePickTool) {
            if (((FeaturePickTool)tool).isMultiSelection()) {
                this.multiselect.setSelected(true);
            } else {
                this.select.setSelected(true);
            }
        }
        if ((canvas = this.getMapCanvas()) == null) {
            return;
        }
        LayerManager lm = canvas.getLayerManager();
        Layer sl = lm.getLayerByTag("selectionLayer");
        SelectableLayer selectionLayer = null;
        if (sl instanceof SelectableLayer) {
            selectionLayer = (SelectableLayer)sl;
        }
        Layer tl = lm.getLayerByTag("targetLayer");
        SelectableLayer targetLayer = null;
        if (tl instanceof SelectableLayer) {
            targetLayer = (SelectableLayer)tl;
        }
        boolean bl = editable = targetLayer instanceof EditableLayer && ((EditableLayer)((Object)targetLayer)).isEditable();
        if (selectionLayer != null) {
            this.select.setEnabled(true);
            this.multiselect.setEnabled(true);
            if (selectionLayer.numSelected() > 0 && editable && targetLayer instanceof AbstractDataSetLayer && selectionLayer.getClass() == targetLayer.getClass()) {
                this.copyfeature.setEnabled(true);
            }
        }
        if (editable && targetLayer.numSelected() > 0) {
            this.delete.setEnabled(true);
            if (targetLayer.numSelected() == 1) {
                if (targetLayer instanceof AbstractDataSetLayer) {
                    this.attribute.setEnabled(true);
                }
            } else if (!(targetLayer instanceof AbstractDataSetLayer)) {
                this.delete.setEnabled(false);
            }
        }
        if ((selectionLayers = canvas.getLayerManager().filterSetByTags(new String[]{"selectionLayer"})).size() > 0) {
            for (Layer selLayer : selectionLayers) {
                if (!(selLayer instanceof AbstractDataSetLayer)) continue;
                this.selectbyattribute.setEnabled(true);
                break;
            }
        }
        for (Layer selLayer : canvas.getLayerManager()) {
            if (!(selLayer instanceof SelectableLayer) || ((SelectableLayer)selLayer).numSelected() <= 0) continue;
            this.unselect.setEnabled(true);
            break;
        }
    }
}

