/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.AbstractFeature;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.ui.AttributeValueTablePanel;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometryElementInfo;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.geometry.JGeometry;

public class InvalidGeometryPanel
extends JPanel {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private AttributeValueTablePanel invalidTable = new AttributeValueTablePanel();
    private Hashtable<String, AbstractFeature> features = null;
    private Hashtable<String, JGeometry[]> errorGeoms = new Hashtable();
    private MapCanvas drawPanel = null;
    private IndexedGeometrySet geomSet = null;
    private AbstractDataAccessObject dataAccess = null;
    private JLabel invalidLabel = new JLabel();
    private JButton fixButton = new JButton();
    private JButton zoomFeatButton = new JButton();
    private JButton zoomErrorButton = new JButton();
    private GeometrySetLayer gsLayer = null;

    public InvalidGeometryPanel(AbstractDataAccessObject da, IndexedGeometrySet gset, Hashtable<String, AbstractFeature> feats, MapCanvas dp, GeometrySetLayer layer) {
        this.features = feats;
        this.drawPanel = dp;
        this.dataAccess = da;
        this.geomSet = gset;
        this.gsLayer = layer;
        this.invalidTable.getTableModel().setColumnName(0, MessagesBundle.getMessage("Key_value"));
        this.invalidTable.getTableModel().setColumnName(1, MessagesBundle.getMessage("Error_code"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(445, 311));
        this.setPreferredSize(new Dimension(445, 310));
        this.invalidLabel.setText(MessagesBundle.getMessage("Invalid_features"));
        this.fixButton.setText(MessagesBundle.getMessage("Fix"));
        this.fixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvalidGeometryPanel.this.fixButton_actionPerformed(e);
            }
        });
        this.fixButton.setEnabled(false);
        this.zoomFeatButton.setText(MessagesBundle.getMessage("Zoom_to_feature"));
        this.zoomFeatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvalidGeometryPanel.this.zoomFeatButton_actionPerformed(e);
            }
        });
        this.zoomFeatButton.setEnabled(false);
        this.zoomErrorButton.setText(MessagesBundle.getMessage("Zoom_to_error"));
        this.zoomErrorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvalidGeometryPanel.this.zoomErrorButton_actionPerformed(e);
            }
        });
        this.zoomErrorButton.setEnabled(false);
        this.add((Component)this.invalidLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.invalidTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fixButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
        this.add((Component)this.zoomFeatButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 70, 10, 0), 0, 0));
        this.add((Component)this.zoomErrorButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 200, 10, 0), 0, 0));
        TableColumnModel cmodel = this.invalidTable.getTable().getColumnModel();
        TableColumn keyColumn = cmodel.getColumn(0);
        keyColumn.setMaxWidth(150);
        this.invalidTable.getTable().setSelectionMode(0);
        this.invalidTable.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selectedRow = InvalidGeometryPanel.this.invalidTable.getTable().getSelectedRow();
                InvalidGeometryPanel.this.highlightFeatureErrors(selectedRow);
            }
        });
    }

    public void updateTable(Hashtable<String, String> invalidFeats) {
        this.invalidTable.getTableModel().clearData();
        this.errorGeoms.clear();
        this.fixButton.setEnabled(false);
        this.zoomFeatButton.setEnabled(false);
        this.zoomErrorButton.setEnabled(false);
        if (invalidFeats == null || invalidFeats.size() == 0) {
            return;
        }
        Enumeration<String> el = invalidFeats.keys();
        while (el.hasMoreElements()) {
            String key = el.nextElement();
            String error = invalidFeats.get(key);
            this.invalidTable.addRow(key, error, false);
        }
    }

    private void highlightFeatureErrors(int featIndex) {
        this.fixButton.setEnabled(false);
        this.zoomFeatButton.setEnabled(false);
        this.zoomErrorButton.setEnabled(false);
        if (this.features == null || this.features.size() == 0 || this.drawPanel == null) {
            return;
        }
        if (featIndex < 0 || featIndex >= this.features.size()) {
            return;
        }
        if (this.gsLayer != null) {
            this.gsLayer.setHighliteGeometries(null);
        }
        String key = (String)this.invalidTable.getTableModel().getValueAt(featIndex, 0);
        AbstractFeature feat = this.features.get(key);
        JGeometry geom = (JGeometry)feat.getSpatialAttribute();
        JGeometry[] invalidGeoms = this.errorGeoms.get(key);
        String error = (String)this.invalidTable.getTableModel().getValueAt(featIndex, 1);
        if (error == null) {
            return;
        }
        int idx = error.indexOf(" ");
        if (idx == -1) {
            return;
        }
        String code = error.substring(0, idx);
        this.zoomFeatButton.setEnabled(true);
        if (code.equalsIgnoreCase("TRUE")) {
            return;
        }
        if (code.equals("13356") || code.equals("13367")) {
            this.fixButton.setEnabled(true);
        }
        if (invalidGeoms == null) {
            if (code.equals("13343") || code.equals("13367")) {
                int elemIdx;
                int ring;
                int element = this.getErrorElementValue(error, "Element", idx);
                if (element > 0 && (ring = this.getErrorElementValue(error, "Ring", elemIdx = error.indexOf("Element", idx))) > 0) {
                    JGeometry[] geomElems = geom.getElements();
                    int[] einfo = geomElems[element - 1].getElemInfo();
                    int numRings = einfo.length / 3;
                    double[] oords = geomElems[element - 1].getOrdinatesArray();
                    int start = einfo[3 * (ring - 1)] - 1;
                    int end = oords.length;
                    if (numRings > ring) {
                        end = einfo[3 * ring];
                    }
                    double[] suboords = new double[end - start];
                    int count = 0;
                    for (int i = start; i < end; ++i) {
                        suboords[count++] = oords[i];
                    }
                    JGeometry g1 = new JGeometry(2, geom.getSRID(), new int[]{1, 2, 1}, suboords);
                    invalidGeoms = new JGeometry[]{g1};
                    this.errorGeoms.put(key, invalidGeoms);
                }
            } else if (code.equals("13349")) {
                int edge1Idx;
                int edge2;
                int ringIdx;
                int edge1;
                int elemIdx;
                int ring;
                int element = this.getErrorElementValue(error, "Element", idx);
                if (element > 0 && (ring = this.getErrorElementValue(error, "Ring", elemIdx = error.indexOf("Element", idx))) > 0 && (edge1 = this.getErrorElementValue(error, "Edge", ringIdx = error.indexOf("Ring", elemIdx))) > 0 && (edge2 = this.getErrorElementValue(error, "Edge", (edge1Idx = error.indexOf("Edge", ringIdx)) + 5)) > 0) {
                    JGeometry[] geomElems = geom.getElements();
                    int dim = geomElems[element - 1].getDimensions();
                    double[] oords = geomElems[element - 1].getOrdinatesArray();
                    if (ring > 1) {
                        int[] einfo = geomElems[element - 1].getElemInfo();
                        edge1 = (einfo[3 * (ring - 1)] - 1) / dim - 1 + edge1;
                        edge2 = (einfo[3 * (ring - 1)] - 1) / dim - 1 + edge2;
                    }
                    double[] oordsE1 = new double[2 * dim];
                    oordsE1[0] = oords[(edge1 - 1) * dim];
                    oordsE1[1] = oords[(edge1 - 1) * dim + 1];
                    oordsE1[dim] = oords[edge1 * dim];
                    oordsE1[dim + 1] = oords[edge1 * dim + 1];
                    JGeometry g1 = new JGeometry(2, geom.getSRID(), new int[]{1, 2, 1}, oordsE1);
                    double[] oordsE2 = new double[2 * dim];
                    oordsE2[0] = oords[(edge2 - 1) * dim];
                    oordsE2[1] = oords[(edge2 - 1) * dim + 1];
                    oordsE2[dim] = oords[edge2 * dim];
                    oordsE2[dim + 1] = oords[edge2 * dim + 1];
                    JGeometry g2 = new JGeometry(2, geom.getSRID(), new int[]{1, 2, 1}, oordsE2);
                    invalidGeoms = new JGeometry[]{g1, g2};
                    this.errorGeoms.put(key, invalidGeoms);
                }
            } else if (code.equals("13350") || code.equals("13351") || code.equals("13366")) {
                int element1 = this.getErrorElementValue(error, "Element", idx);
                if (element1 > 0) {
                    int elem1Idx = error.indexOf("Element", idx);
                    int[] rings = this.getErrorElementValues(error, "Rings", elem1Idx);
                    if (rings != null && rings.length > 0) {
                        int edge;
                        int ringsIdx = error.indexOf("Rings", elem1Idx);
                        ArrayList<JGeometry> geomList = new ArrayList<JGeometry>();
                        int pos = ringsIdx;
                        JGeometry[] geomElems = geom.getElements();
                        for (int k = 0; k < rings.length && (edge = this.getErrorElementValue(error, "Edge", pos)) >= 0; ++k) {
                            int edgeIdx = error.indexOf("Edge", pos);
                            int dim1 = geomElems[element1 - 1].getDimensions();
                            double[] oords1 = geomElems[element1 - 1].getOrdinatesArray();
                            int[] einfo1 = geomElems[element1 - 1].getElemInfo();
                            int nrings1 = einfo1.length / 3;
                            double[] oordsE1 = null;
                            if (edge > 0) {
                                if (rings[k] > 1) {
                                    edge = (einfo1[3 * (rings[k] - 1)] - 1) / dim1 - 1 + edge;
                                }
                                oordsE1 = new double[2 * dim1];
                                oordsE1[0] = oords1[(edge - 1) * dim1];
                                oordsE1[1] = oords1[(edge - 1) * dim1 + 1];
                                oordsE1[dim1] = oords1[edge * dim1];
                                oordsE1[dim1 + 1] = oords1[edge * dim1 + 1];
                            } else {
                                int start = einfo1[3 * (rings[k] - 1)];
                                int end = oords1.length;
                                if (nrings1 > rings[k]) {
                                    end = einfo1[3 * rings[k]];
                                }
                                oordsE1 = new double[end - start + 1];
                                int count = 0;
                                for (int i = start - 1; i < end; ++i) {
                                    oordsE1[count++] = oords1[i];
                                }
                            }
                            JGeometry g1 = new JGeometry(2, geom.getSRID(), new int[]{1, 2, 1}, oordsE1);
                            geomList.add(g1);
                            pos += edgeIdx + 4;
                        }
                        if (geomList.size() > 0) {
                            invalidGeoms = geomList.toArray(new JGeometry[geomList.size()]);
                            this.errorGeoms.put(key, invalidGeoms);
                        }
                    } else {
                        int ring2Idx;
                        int edge2;
                        int elem2Idx;
                        int ring2;
                        int edge1Idx;
                        int element2;
                        int ring1Idx;
                        int edge1;
                        int ring1 = this.getErrorElementValue(error, "Ring", elem1Idx);
                        if (ring1 > 0 && (edge1 = this.getErrorElementValue(error, "Edge", ring1Idx = error.indexOf("Ring", elem1Idx))) >= 0 && (element2 = this.getErrorElementValue(error, "Element", edge1Idx = error.indexOf("Edge", ring1Idx))) > 0 && (ring2 = this.getErrorElementValue(error, "Ring", elem2Idx = error.indexOf("Element", edge1Idx))) > 0 && (edge2 = this.getErrorElementValue(error, "Edge", ring2Idx = error.indexOf("Ring", elem2Idx))) >= 0) {
                            JGeometry[] geomElems = geom.getElements();
                            int dim1 = geomElems[element1 - 1].getDimensions();
                            double[] oords1 = geomElems[element1 - 1].getOrdinatesArray();
                            int[] einfo1 = geomElems[element1 - 1].getElemInfo();
                            int nrings1 = einfo1.length / 3;
                            double[] oordsE1 = null;
                            if (edge1 > 0) {
                                if (ring1 > 1) {
                                    edge1 = (einfo1[3 * (ring1 - 1)] - 1) / dim1 - 1 + edge1;
                                }
                                oordsE1 = new double[2 * dim1];
                                oordsE1[0] = oords1[(edge1 - 1) * dim1];
                                oordsE1[1] = oords1[(edge1 - 1) * dim1 + 1];
                                oordsE1[dim1] = oords1[edge1 * dim1];
                                oordsE1[dim1 + 1] = oords1[edge1 * dim1 + 1];
                            } else {
                                int start = einfo1[3 * (ring1 - 1)];
                                int end = oords1.length;
                                if (nrings1 > ring1) {
                                    end = einfo1[3 * ring1];
                                }
                                oordsE1 = new double[end - start + 1];
                                int count = 0;
                                for (int i = start - 1; i < end; ++i) {
                                    oordsE1[count++] = oords1[i];
                                }
                            }
                            JGeometry g1 = new JGeometry(2, geom.getSRID(), new int[]{1, 2, 1}, oordsE1);
                            int dim2 = geomElems[element2 - 1].getDimensions();
                            double[] oords2 = geomElems[element2 - 1].getOrdinatesArray();
                            int[] einfo2 = geomElems[element2 - 1].getElemInfo();
                            int nrings2 = einfo2.length / 3;
                            double[] oordsE2 = null;
                            if (edge2 > 0) {
                                if (ring2 > 1) {
                                    edge2 = (einfo2[3 * (ring2 - 1)] - 1) / dim2 - 1 + edge2;
                                }
                                oordsE2 = new double[2 * dim2];
                                oordsE2[0] = oords2[(edge2 - 1) * dim2];
                                oordsE2[1] = oords2[(edge2 - 1) * dim2 + 1];
                                oordsE2[dim2] = oords2[edge2 * dim2];
                                oordsE2[dim2 + 1] = oords2[edge2 * dim2 + 1];
                            } else {
                                int start = einfo2[3 * (ring2 - 1)];
                                int end = oords2.length;
                                if (nrings2 > ring2) {
                                    end = einfo2[3 * ring2];
                                }
                                oordsE2 = new double[end - start + 1];
                                int count = 0;
                                for (int i = start - 1; i < end; ++i) {
                                    oordsE2[count++] = oords2[i];
                                }
                            }
                            JGeometry g2 = new JGeometry(2, geom.getSRID(), new int[]{1, 2, 1}, oordsE2);
                            invalidGeoms = new JGeometry[]{g1, g2};
                            this.errorGeoms.put(key, invalidGeoms);
                        }
                    }
                }
            } else if (code.equals("13356")) {
                int elemIdx;
                int coordinate;
                int element = this.getErrorElementValue(error, "Element", idx);
                if (element > 0 && (coordinate = this.getErrorElementValue(error, "Coordinate", elemIdx = error.indexOf("Element", idx))) > 0) {
                    JGeometry[] geomElems = geom.getElements();
                    int dim = geomElems[element - 1].getDimensions();
                    double[] oords = geomElems[element - 1].getOrdinatesArray();
                    int coordIdx = error.indexOf("Coordinate", elemIdx);
                    int ring = this.getErrorElementValue(error, "Ring", coordIdx);
                    if (ring > 1) {
                        int[] einfo = geomElems[element - 1].getElemInfo();
                        coordinate = (einfo[3 * (ring - 1)] - 1) / dim + coordinate;
                    }
                    double x = oords[(coordinate - 1) * dim];
                    double y = oords[(coordinate - 1) * dim + 1];
                    JGeometry outGeom = new JGeometry(x, y, geom.getSRID());
                    invalidGeoms = new JGeometry[]{outGeom};
                    this.errorGeoms.put(key, invalidGeoms);
                }
            } else {
                log.info("Code [" + code + "] not supported for highliting.");
            }
        }
        if (invalidGeoms != null) {
            this.zoomErrorButton.setEnabled(true);
            if (this.gsLayer != null) {
                this.gsLayer.setHighliteGeometries(invalidGeoms);
            }
        }
        this.zoomFeatButton_actionPerformed(null);
    }

    private int getErrorElementValue(String error, String type, int fromIndex) {
        if (error == null || type == null || fromIndex == -1) {
            return -1;
        }
        int idx = error.indexOf(type, fromIndex);
        if (idx != -1) {
            int ini = error.indexOf("<", idx);
            int end = error.indexOf(">", idx);
            String value = error.substring(ini + 1, end);
            return Integer.valueOf(value);
        }
        return -1;
    }

    private int[] getErrorElementValues(String error, String type, int fromIndex) {
        int end;
        if (error == null || type == null || fromIndex == -1) {
            return null;
        }
        int idx = error.indexOf(type, fromIndex);
        if (idx != -1 && (end = error.indexOf("]", idx)) != -1) {
            String values = error.substring(idx + type.length(), end);
            if (values == null || values.length() == 0) {
                return null;
            }
            ArrayList ids = Util.splitBy((String)values, (String)",");
            if (ids == null || ids.size() == 0) {
                return null;
            }
            int[] out = new int[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                String id = ((String)ids.get(i)).trim();
                out[i] = Integer.valueOf(id);
            }
            return out;
        }
        return null;
    }

    private void fixButton_actionPerformed(ActionEvent e) {
        block22: {
            if (this.dataAccess == null || this.geomSet == null || this.features == null) {
                return;
            }
            int row = this.invalidTable.getTable().getSelectedRow();
            if (row < 0) {
                return;
            }
            String keyColumn = this.geomSet.getGeometrySet().getKeyColumn();
            if (keyColumn == null) {
                return;
            }
            String key = (String)this.invalidTable.getTableModel().getValueAt(row, 0);
            if (key == null) {
                return;
            }
            String error = (String)this.invalidTable.getTableModel().getValueAt(row, 1);
            if (error == null) {
                return;
            }
            int idx = error.indexOf(" ");
            if (idx == -1) {
                return;
            }
            AbstractFeature feat = this.features.get(key);
            if (feat == null) {
                return;
            }
            JGeometry featGeom = (JGeometry)feat.getSpatialAttribute();
            if (featGeom == null) {
                return;
            }
            JGeometry spatialChange = null;
            String code = error.substring(0, idx);
            if (code.equals("13356")) {
                int elemIdx;
                int coordinate;
                int element = this.getErrorElementValue(error, "Element", idx);
                if (element > 0 && (coordinate = this.getErrorElementValue(error, "Coordinate", elemIdx = error.indexOf("Element", idx))) > 0) {
                    try {
                        int coordIdx = error.indexOf("Coordinate", elemIdx);
                        int ring = this.getErrorElementValue(error, "Ring", coordIdx);
                        spatialChange = ring < 2 ? this.removeDuplicatedVertex(featGeom, element - 1, -1, coordinate - 1) : this.removeDuplicatedVertex(featGeom, element - 1, ring - 2, coordinate - 1);
                        if (spatialChange == null) {
                            ErrorDialog.showErrorDialog(null, this.drawPanel.getFrameForDialog(), MessagesBundle.getMessage("Unable_tofix_geometry") + " Null geometry returned.", MessagesBundle.getMessage("Error"), 0);
                            return;
                        }
                        this.gsLayer.getIndexedDataSet().updateSpatialAttribute(key, spatialChange);
                        String valid = this.validatedFeature(key);
                        if (valid != null && valid.length() > 0 && !valid.equalsIgnoreCase("TRUE")) {
                            this.invalidTable.getTableModel().setValueAt(valid, row, 1);
                            this.highlightFeatureErrors(row);
                            break block22;
                        }
                        this.invalidTable.getTableModel().removeRecord(row);
                        this.fixButton.setEnabled(false);
                        this.zoomErrorButton.setEnabled(false);
                        this.errorGeoms.remove(key);
                        this.gsLayer.setHighliteGeometries(null);
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(null, this.drawPanel.getFrameForDialog(), MessagesBundle.getMessage("Unable_tofix_geometry") + " " + ex.getMessage(), MessagesBundle.getMessage("Error"), 0);
                    }
                }
            } else if (code.equals("13367")) {
                int element = this.getErrorElementValue(error, "Element", idx);
                if (element > 0) {
                    try {
                        int elemIdx = error.indexOf("Element", idx);
                        int ring = this.getErrorElementValue(error, "Ring", elemIdx);
                        if (ring <= 0) break block22;
                        spatialChange = ring == 1 ? this.changePolygonElementOrientation(featGeom, element - 1, -1) : this.changePolygonElementOrientation(featGeom, element - 1, ring - 2);
                        if (spatialChange == null) {
                            ErrorDialog.showErrorDialog(null, this.drawPanel.getFrameForDialog(), MessagesBundle.getMessage("Unable_tofix_geometry") + " Null geometry returned.", MessagesBundle.getMessage("Error"), 0);
                            return;
                        }
                        this.gsLayer.getIndexedDataSet().updateSpatialAttribute(key, spatialChange);
                        String valid = this.validatedFeature(key);
                        if (valid != null && valid.length() > 0 && !valid.equalsIgnoreCase("TRUE")) {
                            this.invalidTable.getTableModel().setValueAt(valid, row, 1);
                            this.highlightFeatureErrors(row);
                            break block22;
                        }
                        this.invalidTable.getTableModel().removeRecord(row);
                        this.fixButton.setEnabled(false);
                        this.zoomErrorButton.setEnabled(false);
                        this.errorGeoms.remove(key);
                        this.gsLayer.setHighliteGeometries(null);
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(null, this.drawPanel.getFrameForDialog(), MessagesBundle.getMessage("Unable_tofix_geometry") + " " + ex.getMessage(), MessagesBundle.getMessage("Error"), 0);
                    }
                }
            } else {
                log.info("Error code [" + code + "] is not supported for fix.");
                return;
            }
        }
    }

    private void zoomFeatButton_actionPerformed(ActionEvent e) {
        int row = this.invalidTable.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        String key = (String)this.invalidTable.getTableModel().getValueAt(row, 0);
        AbstractFeature feat = this.features.get(key);
        JGeometry geom = (JGeometry)feat.getSpatialAttribute();
        if (geom == null) {
            return;
        }
        int dim = geom.getDimensions();
        double[] geommbr = geom.getMBR();
        double xmin = geommbr[0];
        double xmax = geommbr[dim];
        double ymin = geommbr[1];
        double ymax = geommbr[dim + 1];
        double dx = xmax - xmin;
        double dy = ymax - ymin;
        double size = dy + 0.25 * dy;
        if (dx > dy) {
            size = dx + 0.25 * dx;
        }
        Rectangle2D mbr = this.drawPanel.getMapRegion().getDataWindow();
        if (dx == 0.0 && dy == 0.0) {
            size = 0.1 * mbr.getHeight();
        } else if (dy == 0.0) {
            size = 0.1 * mbr.getHeight();
        }
        this.drawPanel.getMapRegion().setDataWindowByHeight(xmin + dx / 2.0, ymin + dy / 2.0, size);
    }

    private void zoomErrorButton_actionPerformed(ActionEvent e) {
        int row = this.invalidTable.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        String key = (String)this.invalidTable.getTableModel().getValueAt(row, 0);
        AbstractFeature feat = this.features.get(key);
        JGeometry geom = (JGeometry)feat.getSpatialAttribute();
        if (geom == null) {
            return;
        }
        int dim = geom.getDimensions();
        JGeometry[] invalidGeoms = this.errorGeoms.get(key);
        if (invalidGeoms == null || invalidGeoms.length == 0) {
            return;
        }
        JGeometry g = invalidGeoms[0];
        double[] mbr = g.getMBR();
        double xmin = mbr[0];
        double ymin = mbr[1];
        double xmax = mbr[dim];
        double ymax = mbr[dim + 1];
        for (int i = 1; i < invalidGeoms.length; ++i) {
            mbr = invalidGeoms[i].getMBR();
            xmin = Math.min(xmin, mbr[0]);
            ymin = Math.min(ymin, mbr[1]);
            xmax = Math.max(xmax, mbr[dim]);
            ymax = Math.max(ymax, mbr[dim + 1]);
        }
        double dx = xmax - xmin;
        double dy = ymax - ymin;
        double size = dy + 0.3 * dy;
        if (dx > 0.0) {
            size = dx + 0.3 * dx;
        }
        if (size == 0.0) {
            double[] gmbr = geom.getMBR();
            size = (gmbr[dim + 1] - gmbr[1]) * 0.2;
        }
        this.drawPanel.getMapRegion().setDataWindowByHeight(xmin + dx / 2.0, ymin + dy / 2.0, size);
    }

    private JGeometry removeDuplicatedVertex(JGeometry geom, int elemIndex, int subelemIndex, int coordinateIndex) {
        if (geom == null || elemIndex < 0) {
            System.out.println("Invalid geometry (null) or geometry element index (< 0)");
            return null;
        }
        if (coordinateIndex < 0) {
            System.out.println("Invalid geometry sub-element index (< 0)");
            return null;
        }
        JGeometry[] elements = JGeometryUtil.getElements((JGeometry)geom);
        if (elements == null || elements.length < elemIndex + 1) {
            System.out.println("Invalid geometry element.");
            return null;
        }
        JGeometry elem = elements[elemIndex];
        if (elem.getType() != 2 && elem.getType() != 3) {
            System.out.println("Invalid geometry element type. Must be a line or polygon.");
            return null;
        }
        int[] geomInfo = geom.getElemInfo();
        double[] geomOords = geom.getOrdinatesArray();
        int geomDim = geom.getDimensions();
        int gtype = geom.getType();
        JGeometryElementInfo[] elemInfoDesc = JGeometryUtil.getElementsInfo((JGeometry)geom, (int)(elemIndex + 1));
        int einfoStart = elemInfoDesc[0].getElementInfoStart();
        if (subelemIndex > -1) {
            einfoStart = elemInfoDesc[0].getElementInfoStart() + 3 * subelemIndex;
        }
        int[] outEInfo = new int[geomInfo.length];
        for (int i = 0; i < geomInfo.length; i += 3) {
            outEInfo[i] = i > einfoStart ? geomInfo[i] - geomDim : geomInfo[i];
            outEInfo[i + 1] = geomInfo[i + 1];
            outEInfo[i + 2] = geomInfo[i + 2];
        }
        int oordsStart = geomInfo[einfoStart] - 1 + coordinateIndex * geomDim;
        double[] outOords = new double[geomOords.length - geomDim];
        int pos = 0;
        for (int i = 0; i < geomOords.length; i += geomDim) {
            if (i == oordsStart) continue;
            for (int k = 0; k < geomDim; ++k) {
                outOords[pos++] = geomOords[i + k];
            }
        }
        int outtype = gtype + geom.getDimensions() * 1000;
        return new JGeometry(outtype, geom.getSRID(), outEInfo, outOords);
    }

    private JGeometry changePolygonElementOrientation(JGeometry geom, int geomElemIndex, int voidElemIndex) {
        if (geom == null || geomElemIndex < 0) {
            System.out.println("Invalid geometry (null) or geometry element index (< 0)");
            return null;
        }
        JGeometry[] elements = JGeometryUtil.getElements((JGeometry)geom);
        if (elements == null || elements.length < geomElemIndex + 1) {
            System.out.println("Invalid geometry element.");
            return null;
        }
        JGeometry elem = elements[geomElemIndex];
        if (elem.getType() != 3) {
            System.out.println("Geometry element index [" + geomElemIndex + "] is not a polygon.");
            return null;
        }
        int[] geomInfo = geom.getElemInfo();
        double[] geomOords = geom.getOrdinatesArray();
        int geomDim = geom.getDimensions();
        int gtype = geom.getType();
        int[] elemInfo = elem.getElemInfo();
        int numVoids = elemInfo.length / 3 - 1;
        if (voidElemIndex > -1 && numVoids < voidElemIndex + 1) {
            System.out.println("Polygon void element index [" + voidElemIndex + "] is out of array range.");
            return null;
        }
        JGeometryElementInfo[] elemInfoDesc = JGeometryUtil.getElementsInfo((JGeometry)geom, (int)(geomElemIndex + 1));
        int oordsChangeStart = -1;
        int oordsChangeEnd = -1;
        if (voidElemIndex < 0) {
            oordsChangeStart = elemInfoDesc[0].getElementOordStart();
            oordsChangeEnd = numVoids == 0 ? elemInfoDesc[0].getElementOordEnd() : geomInfo[elemInfoDesc[0].getElementInfoStart() + 3] - 2;
        } else {
            oordsChangeStart = geomInfo[elemInfoDesc[0].getElementInfoStart() + 3 * (voidElemIndex + 1)] - 1;
            oordsChangeEnd = numVoids == voidElemIndex + 1 ? elemInfoDesc[0].getElementOordEnd() : geomInfo[elemInfoDesc[0].getElementInfoStart() + 3 * (voidElemIndex + 2)] - 2;
        }
        int[] outEInfo = new int[geomInfo.length];
        System.arraycopy(geomInfo, 0, outEInfo, 0, geomInfo.length);
        double[] outOords = new double[geomOords.length];
        System.arraycopy(geomOords, 0, outOords, 0, geomOords.length);
        double[] tempOords = new double[oordsChangeEnd - oordsChangeStart + 1];
        int pos = 0;
        for (int i = oordsChangeStart; i <= oordsChangeEnd; ++i) {
            tempOords[pos++] = geomOords[i];
        }
        double[] revTempOords = GeometryUtil.reverseCoordinates((double[])tempOords, (int)geomDim);
        pos = 0;
        for (int i = oordsChangeStart; i <= oordsChangeEnd; ++i) {
            outOords[i] = revTempOords[pos++];
        }
        if (numVoids > 0 && voidElemIndex < 0) {
            boolean isClockwise = GeometryUtil.isClockwise((double[])revTempOords);
            for (int k = 1; k <= numVoids; ++k) {
                int ini = geomInfo[elemInfoDesc[0].getElementInfoStart() + 3 * k] - 1;
                int end = -1;
                end = k == numVoids ? elemInfoDesc[0].getElementOordEnd() : geomInfo[elemInfoDesc[0].getElementInfoStart() + 3 * (k + 1)] - 2;
                double[] voidOords = new double[end - ini + 1];
                pos = 0;
                for (int i = ini; i <= end; ++i) {
                    voidOords[pos++] = geomOords[i];
                }
                boolean voidIsClockwise = GeometryUtil.isClockwise((double[])voidOords);
                if ((!isClockwise || !voidIsClockwise) && (isClockwise || voidIsClockwise)) continue;
                voidOords = GeometryUtil.reverseCoordinates((double[])voidOords, (int)geomDim);
                pos = 0;
                for (int i = ini; i <= end; ++i) {
                    outOords[i] = voidOords[pos++];
                }
            }
        }
        int outtype = gtype + geom.getDimensions() * 1000;
        return new JGeometry(outtype, geom.getSRID(), outEInfo, outOords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String validatedFeature(String key) {
        if (this.dataAccess == null || this.geomSet == null) {
            return null;
        }
        try {
            this.dataAccess.openConnection();
            AbstractFeature feat = this.features.get(key);
            JGeometry featGeom = (JGeometry)feat.getSpatialAttribute();
            AbstractFeature[] abfeats = new AbstractFeature[]{feat};
            Hashtable<String, String> validOutput = this.dataAccess.validateFeatureGeometries(key, abfeats, 5.0E-7);
            String string = validOutput.get(key);
            return string;
        }
        catch (MDSException mde) {
            log.warning("Unabel to validade feature [" + key + "]. " + mde.getMessage());
        }
        catch (Exception ex) {
            log.warning("Unabel to validade feature [" + key + "]. " + ex.getMessage());
        }
        finally {
            try {
                this.dataAccess.closeConnection();
            }
            catch (Exception re) {
                re.printStackTrace();
            }
        }
        return null;
    }
}

