/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import oracle.mapviewer.share.ScaleBar;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.spatial.edit.util.SelectionBoxListener;

public class GeometryViewPanel
extends JPanel {
    private MapMaker mapMaker = null;
    private Image mapImage = null;
    private LocalTheme baseTheme = null;
    private LocalTheme highliteTheme = null;
    private LocalTheme selectionTheme = null;
    Vector<StyledFeatureI> baseFeatures = new Vector();
    Vector<StyledFeatureI> highliteFeatures = new Vector();
    Vector<StyledFeatureI> selectionFeatures = new Vector();
    private Style baseStyle = new StyleColor(Color.blue, Color.blue);
    private Style highliteStyle = new StyleColor(Color.red, Color.red);
    private Style selectionStyle = new StyleColor(Color.yellow, Color.yellow);
    private String action = null;
    public static final String IDENTIFY = "identify";
    public static final String ZOOMIN = "zoomin";
    public static final String ZOOMOUT = "zoomout";
    public static final String ZOOMBOX = "zoombox";
    public static final String PAN = "pan";
    private boolean startDrag = false;
    private int startDragX = 0;
    private int startDragY = 0;
    private int lastDragX = -1;
    private int lastDragY = -1;
    private SelectionBoxListener boxListener = null;

    public GeometryViewPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mapMaker = new MapMaker();
        this.mapMaker.setAntiAliasing(true);
        ScaleBar bar = new ScaleBar();
        bar.setMode("DUAL_MODES");
        bar.setLabelHaloSize(2.5f);
        this.mapMaker.getVisContext().setScaleBar(bar);
        this.baseTheme = new LocalTheme("base_theme", this.baseFeatures);
        this.highliteTheme = new LocalTheme("highlite_theme", this.highliteFeatures);
        this.selectionTheme = new LocalTheme("selection_theme", this.selectionFeatures);
        this.mapMaker.addTheme((Theme)this.baseTheme);
        this.mapMaker.addTheme((Theme)this.highliteTheme);
        this.mapMaker.addTheme((Theme)this.selectionTheme);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(500, 500));
        this.setPreferredSize(new Dimension(500, 500));
        this.setBackground(new Color(166, 202, 240));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        this.setBorder(BorderFactory.createTitledBorder(blackline, MessagesBundle.getMessage("Drawing_area")));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GeometryViewPanel.this.this_componentResized(e);
            }
        });
        _mouseListener ml = new _mouseListener();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void setBoxSelectionListener(SelectionBoxListener box) {
        this.boxListener = box;
    }

    private void this_componentResized(ComponentEvent e) {
        if (this.mapMaker == null) {
            return;
        }
        if (this.mapMaker.getThemes() == null || this.mapMaker.getThemes().size() == 0) {
            this.clearPaintArea();
            return;
        }
        Rectangle2D mbr = this.mapMaker.getQueryWindow();
        if (mbr == null) {
            this.renderData(Double.NaN, Double.NaN, Double.NaN);
        } else {
            this.renderData(mbr.getCenterX(), mbr.getCenterY(), mbr.getHeight());
        }
    }

    private void renderMovingImg(Graphics g, int x, int y) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        int currentHeight = this.getHeight() - insets.top - insets.bottom;
        int offx = x - this.startDragX;
        int offy = y - this.startDragY;
        if (this.mapImage != null) {
            g.drawImage(this.mapImage, insets.left + offx, insets.top + offy, this.mapImage.getWidth(null), this.mapImage.getHeight(null), null);
        }
    }

    public Theme getBaseTheme() {
        return this.baseTheme;
    }

    public void refresh() {
        Rectangle2D mbr = this.mapMaker.getQueryWindow();
        if (mbr == null) {
            this.renderData(Double.NaN, Double.NaN, Double.NaN);
        } else {
            this.renderData(mbr.getCenterX(), mbr.getCenterY(), mbr.getHeight());
        }
    }

    public void renderData() {
        this.renderData(Double.NaN, Double.NaN, Double.NaN);
    }

    public void renderData(double centerX, double centerY, double size) {
        if (this.mapMaker == null) {
            return;
        }
        this.mapImage = null;
        if (this.mapMaker.getThemes() == null || this.mapMaker.getThemes().size() == 0) {
            return;
        }
        this.unprepareThemes();
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        int currentHeight = this.getHeight() - insets.top - insets.bottom;
        this.mapMaker.setDeviceSize(0.0, 0.0, (double)currentWidth, (double)currentHeight);
        try {
            this.mapImage = Double.isNaN(centerX) || Double.isNaN(centerY) || Double.isNaN(size) ? this.mapMaker.renderMap() : this.mapMaker.renderMap(centerX, centerY, size);
        }
        catch (Exception ex) {
            this.mapImage = null;
        }
        this.repaint();
    }

    public void unprepareThemes() {
        if (this.mapMaker == null) {
            return;
        }
        Vector themes = this.mapMaker.getThemes();
        if (themes != null) {
            for (int i = 0; i < themes.size(); ++i) {
                Theme t = (Theme)themes.get(i);
                t.getDecorator().setPrepared(false);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        int currentHeight = this.getHeight() - insets.top - insets.bottom;
        if (this.mapImage != null) {
            g.drawImage(this.mapImage, insets.left, insets.top, this.mapImage.getWidth(null), this.mapImage.getHeight(null), null);
        }
    }

    public void clearPaintArea() {
        this.mapImage = null;
        this.repaint();
    }

    public void setBaseGeometries(JSDOGeometry[] geoms) {
        this.baseFeatures.clear();
        if (geoms != null && geoms.length > 0) {
            for (int i = 0; i < geoms.length; ++i) {
                if (geoms[i] == null) continue;
                StyledFeature feat = new StyledFeature();
                feat.setDataSource(this.mapMaker.getMasterDataSource());
                feat.setGeometry(geoms[i]);
                feat.setFeatureStyle(this.baseStyle);
                this.baseFeatures.add((StyledFeatureI)feat);
            }
        }
        ((LocalThemeDataProducer)this.baseTheme.getProducer()).setStyledFeatures(this.baseFeatures.toArray(new StyledFeatureI[this.baseFeatures.size()]));
    }

    public void setHighliteGeometries(JSDOGeometry[] geoms) {
        this.highliteFeatures.clear();
        if (geoms != null && geoms.length > 0) {
            for (int i = 0; i < geoms.length; ++i) {
                if (geoms[i] == null) continue;
                StyledFeature feat = new StyledFeature();
                feat.setDataSource(this.mapMaker.getMasterDataSource());
                feat.setGeometry(geoms[i]);
                feat.setFeatureStyle(this.highliteStyle);
                this.highliteFeatures.add((StyledFeatureI)feat);
            }
        }
        ((LocalThemeDataProducer)this.highliteTheme.getProducer()).setStyledFeatures(this.highliteFeatures.toArray(new StyledFeatureI[this.highliteFeatures.size()]));
    }

    public void setSelectionGeometries(JSDOGeometry[] geoms) {
        this.selectionFeatures.clear();
        if (geoms != null && geoms.length > 0) {
            for (int i = 0; i < geoms.length; ++i) {
                if (geoms[i] == null) continue;
                StyledFeature feat = new StyledFeature();
                feat.setDataSource(this.mapMaker.getMasterDataSource());
                feat.setGeometry(geoms[i]);
                feat.setFeatureStyle(this.selectionStyle);
                this.selectionFeatures.add((StyledFeatureI)feat);
            }
        }
        ((LocalThemeDataProducer)this.selectionTheme.getProducer()).setStyledFeatures(this.selectionFeatures.toArray(new StyledFeatureI[this.selectionFeatures.size()]));
    }

    public Rectangle2D getMapArea() {
        if (this.mapMaker == null) {
            return null;
        }
        Rectangle2D area = this.mapMaker.getQueryWindow();
        return area;
    }

    public Image getMapImage() {
        return this.mapImage;
    }

    public void setAction(String action) {
        this.action = action;
    }

    private double[] getWC(int x, int y) {
        if (this.mapMaker == null) {
            return null;
        }
        int[] dc = new int[]{x, y};
        double[] dataC = new double[2];
        if (!this.mapMaker.inverse(dc, dataC)) {
            return null;
        }
        return dataC;
    }

    class _mouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        _mouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (GeometryViewPanel.this.startDrag) {
                if (GeometryViewPanel.ZOOMBOX.equalsIgnoreCase(GeometryViewPanel.this.action) || GeometryViewPanel.IDENTIFY.equalsIgnoreCase(GeometryViewPanel.this.action)) {
                    int y;
                    int x;
                    Graphics g2 = null;
                    if (GeometryViewPanel.this.lastDragX >= 0 && GeometryViewPanel.this.lastDragY >= 0) {
                        g2 = (Graphics2D)GeometryViewPanel.this.getGraphics();
                        g2.setColor(Color.red);
                        g2.setXORMode(Color.white);
                        x = Math.min(GeometryViewPanel.this.startDragX, GeometryViewPanel.this.lastDragX);
                        y = Math.min(GeometryViewPanel.this.startDragY, GeometryViewPanel.this.lastDragY);
                        g2.drawRect(x, y, Math.abs(GeometryViewPanel.this.lastDragX - GeometryViewPanel.this.startDragX), Math.abs(GeometryViewPanel.this.lastDragY - GeometryViewPanel.this.startDragY));
                    }
                    if (g2 == null) {
                        g2 = (Graphics2D)GeometryViewPanel.this.getGraphics();
                    }
                    g2.setColor(Color.red);
                    g2.setXORMode(Color.white);
                    x = Math.min(GeometryViewPanel.this.startDragX, e.getX());
                    y = Math.min(GeometryViewPanel.this.startDragY, e.getY());
                    g2.drawRect(x, y, Math.abs(e.getX() - GeometryViewPanel.this.startDragX), Math.abs(e.getY() - GeometryViewPanel.this.startDragY));
                    g2.dispose();
                } else if (GeometryViewPanel.PAN.equalsIgnoreCase(GeometryViewPanel.this.action)) {
                    Graphics g2 = null;
                    if (GeometryViewPanel.this.lastDragX >= 0 && GeometryViewPanel.this.lastDragY >= 0) {
                        g2 = GeometryViewPanel.this.getGraphics();
                        GeometryViewPanel.this.renderMovingImg(g2, e.getX(), e.getY());
                        g2.dispose();
                    }
                }
                GeometryViewPanel.this.lastDragX = e.getX();
                GeometryViewPanel.this.lastDragY = e.getY();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int button = e.getButton();
            if (GeometryViewPanel.this.action == null) {
                return;
            }
            if (!(GeometryViewPanel.this.action.equals(GeometryViewPanel.ZOOMBOX) || GeometryViewPanel.this.action.equals(GeometryViewPanel.IDENTIFY) || GeometryViewPanel.this.action.equals(GeometryViewPanel.PAN))) {
                GeometryViewPanel.this.startDrag = false;
                GeometryViewPanel.this.startDragX = -1;
                GeometryViewPanel.this.startDragY = -1;
                GeometryViewPanel.this.lastDragX = -1;
                GeometryViewPanel.this.lastDragY = -1;
            } else {
                GeometryViewPanel.this.startDrag = true;
                GeometryViewPanel.this.startDragX = e.getX();
                GeometryViewPanel.this.startDragY = e.getY();
                GeometryViewPanel.this.lastDragX = -1;
                GeometryViewPanel.this.lastDragY = -1;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (GeometryViewPanel.this.startDrag) {
                GeometryViewPanel.this.startDrag = false;
                if (GeometryViewPanel.ZOOMBOX.equalsIgnoreCase(GeometryViewPanel.this.action) || GeometryViewPanel.IDENTIFY.equalsIgnoreCase(GeometryViewPanel.this.action)) {
                    Graphics2D g2 = null;
                    if (GeometryViewPanel.this.lastDragX < 0 || GeometryViewPanel.this.lastDragY < 0) {
                        return;
                    }
                    g2 = (Graphics2D)GeometryViewPanel.this.getGraphics();
                    g2.setColor(Color.red);
                    g2.setXORMode(Color.white);
                    int x = Math.min(GeometryViewPanel.this.startDragX, GeometryViewPanel.this.lastDragX);
                    int y = Math.min(GeometryViewPanel.this.startDragY, GeometryViewPanel.this.lastDragY);
                    g2.drawRect(x, y, Math.abs(GeometryViewPanel.this.lastDragX - GeometryViewPanel.this.startDragX), Math.abs(GeometryViewPanel.this.lastDragY - GeometryViewPanel.this.startDragY));
                    g2.dispose();
                    Insets is = ((JPanel)e.getComponent()).getInsets();
                    if (GeometryViewPanel.ZOOMBOX.equalsIgnoreCase(GeometryViewPanel.this.action)) {
                        int[] dc = new int[]{(Math.min(GeometryViewPanel.this.startDragX, e.getX()) + Math.max(GeometryViewPanel.this.startDragX, e.getX())) / 2 - is.left, (Math.min(GeometryViewPanel.this.startDragY, e.getY()) + Math.max(GeometryViewPanel.this.startDragY, e.getY())) / 2 - is.top};
                        double[] dataC = new double[2];
                        if (!GeometryViewPanel.this.mapMaker.inverse(dc, dataC)) {
                            return;
                        }
                        double WCheight = GeometryViewPanel.this.mapMaker.getQueryWindow().getHeight();
                        GeometryViewPanel.this.renderData(dataC[0], dataC[1], WCheight * ((double)(Math.max(GeometryViewPanel.this.startDragY, e.getY()) - Math.min(GeometryViewPanel.this.startDragY, e.getY())) / (double)GeometryViewPanel.this.mapMaker.getDeviceHeight()));
                    } else if (GeometryViewPanel.this.boxListener != null) {
                        int[] llDC = new int[]{Math.min(GeometryViewPanel.this.startDragX, e.getX()) - is.left, Math.max(GeometryViewPanel.this.startDragY, e.getY()) - is.top};
                        double[] llWC = new double[2];
                        if (!GeometryViewPanel.this.mapMaker.inverse(llDC, llWC)) {
                            return;
                        }
                        int[] urDC = new int[]{Math.max(GeometryViewPanel.this.startDragX, e.getX()) - is.left, Math.min(GeometryViewPanel.this.startDragY, e.getY()) - is.top};
                        double[] urWC = new double[2];
                        if (!GeometryViewPanel.this.mapMaker.inverse(urDC, urWC)) {
                            return;
                        }
                        GeometryViewPanel.this.boxListener.processBox(new Rectangle2D.Double(llWC[0], llWC[1], urWC[0] - llWC[0], urWC[1] - llWC[1]), e.isShiftDown());
                    }
                } else if (GeometryViewPanel.PAN.equalsIgnoreCase(GeometryViewPanel.this.action)) {
                    Graphics g = GeometryViewPanel.this.getGraphics();
                    GeometryViewPanel.this.renderMovingImg(g, e.getX(), e.getY());
                    g.dispose();
                    Insets is = ((JPanel)e.getComponent()).getInsets();
                    int offx = e.getX() - GeometryViewPanel.this.startDragX;
                    int offy = e.getY() - GeometryViewPanel.this.startDragY;
                    int currentWidth = GeometryViewPanel.this.getWidth() - is.left - is.right;
                    int currentHeight = GeometryViewPanel.this.getHeight() - is.top - is.bottom;
                    int x = is.left + currentWidth / 2 - offx;
                    int y = is.top + currentHeight / 2 - offy;
                    try {
                        GeometryViewPanel.this.unprepareThemes();
                        GeometryViewPanel.this.mapImage = GeometryViewPanel.this.mapMaker.pan(x, y);
                        GeometryViewPanel.this.repaint();
                    }
                    catch (Exception ex) {
                        GeometryViewPanel.this.mapImage = null;
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            block11: {
                if (e.getButton() != 1 || GeometryViewPanel.this.mapMaker == null) {
                    return;
                }
                if (GeometryViewPanel.this.action == null) {
                    return;
                }
                Insets is = ((JPanel)e.getComponent()).getInsets();
                int x = e.getX() - is.left;
                int y = e.getY() - is.top;
                try {
                    if (GeometryViewPanel.this.action.equals(GeometryViewPanel.ZOOMIN) || GeometryViewPanel.this.action.equals(GeometryViewPanel.IDENTIFY)) {
                        int[] dc = new int[]{x, y};
                        double[] dataC = new double[2];
                        if (!GeometryViewPanel.this.mapMaker.inverse(dc, dataC)) {
                            return;
                        }
                        if (GeometryViewPanel.this.action.equals(GeometryViewPanel.ZOOMIN)) {
                            double WCheight = GeometryViewPanel.this.mapMaker.getQueryWindow().getHeight();
                            GeometryViewPanel.this.renderData(dataC[0], dataC[1], WCheight / 1.5);
                        } else if (GeometryViewPanel.this.boxListener != null) {
                            double pixel = GeometryViewPanel.this.mapMaker.getQueryWindow().getHeight() / (double)GeometryViewPanel.this.mapMaker.getDeviceHeight();
                            Rectangle2D.Double rect = new Rectangle2D.Double(dataC[0] - 3.0 * pixel, dataC[1] - 3.0 * pixel, 6.0 * pixel, 6.0 * pixel);
                            GeometryViewPanel.this.boxListener.processBox(rect, e.isShiftDown());
                        }
                        break block11;
                    }
                    if (GeometryViewPanel.this.action.equals(GeometryViewPanel.ZOOMOUT)) {
                        GeometryViewPanel.this.unprepareThemes();
                        GeometryViewPanel.this.mapImage = GeometryViewPanel.this.mapMaker.zoomOut(1.5, x, y);
                        break block11;
                    }
                    if (GeometryViewPanel.this.action.equals(GeometryViewPanel.PAN)) {
                        GeometryViewPanel.this.unprepareThemes();
                        GeometryViewPanel.this.mapImage = GeometryViewPanel.this.mapMaker.pan(x, y);
                        break block11;
                    }
                    return;
                }
                catch (Exception ex) {
                    GeometryViewPanel.this.mapImage = null;
                }
            }
            GeometryViewPanel.this.repaint();
        }
    }
}

