/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.GeometryFeature;
import oracle.mdeditor.ui.GeometryElementsTree;
import oracle.mdeditor.ui.TextAreaPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.geometry.JGeometry;

public class GeometryElementsPanel
extends JPanel {
    private GeometryFeature feature = null;
    private IndexedGeometrySet geomset = null;
    private MapCanvas drawPanel = null;
    private JLabel featLabel = new JLabel();
    private JTextField featText = new JTextField();
    private GeometryElementsTree tree = null;
    private JScrollPane treeScrollPane = new JScrollPane();
    private JLabel elemtypeLabel = new JLabel();
    private JTextField elemtypeTxt = new JTextField();
    private JLabel elempointLabel = new JLabel();
    private JTextField elempointTxt = new JTextField();
    private JLabel eleminfoLabel = new JLabel();
    private TextAreaPanel eleminfoText = new TextAreaPanel();
    private JLabel oordsLabel = new JLabel();
    private TextAreaPanel oordsText = new TextAreaPanel();
    private JButton zoomfeatButton = new JButton();
    private JButton zoomelemButton = new JButton();
    private JButton zoomvoidButton = new JButton();
    private JButton removeButton = new JButton();
    private JButton undoButton = new JButton();
    private JLabel fillerLabel = new JLabel();
    private int currentElement = -1;
    private int currentVoid = -1;
    private int maxOordsToShow = 500;
    private GeometrySetLayer gsLayer = null;

    public GeometryElementsPanel(IndexedGeometrySet gset, GeometryFeature feat, MapCanvas dp, GeometrySetLayer layer) {
        this.feature = feat;
        this.geomset = gset;
        this.drawPanel = dp;
        JGeometry geom = null;
        if (feat != null) {
            geom = feat.getSpatialAttribute();
        }
        this.tree = new GeometryElementsTree(geom);
        this.treeScrollPane.getViewport().add(this.tree);
        this.gsLayer = layer;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JGeometry[] elements;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(390, 580));
        this.featLabel.setText(MessagesBundle.getMessage("Label_feature"));
        this.featText.setEditable(false);
        this.elemtypeLabel.setText(MessagesBundle.getMessage("Label_element_type"));
        this.elemtypeTxt.setEditable(false);
        this.elempointLabel.setText(MessagesBundle.getMessage("Label_element_point"));
        this.elempointTxt.setEditable(false);
        this.eleminfoLabel.setText(MessagesBundle.getMessage("Element_info_array"));
        this.oordsLabel.setText(MessagesBundle.getMessage("Element_oordinates"));
        this.zoomfeatButton.setText(MessagesBundle.getMessage("Zoom_to_feature"));
        this.zoomfeatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryElementsPanel.this.zoomfeatButton_actionPerformed(e);
            }
        });
        this.zoomelemButton.setText(MessagesBundle.getMessage("Zoom_to_element"));
        this.zoomelemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryElementsPanel.this.zoomelemButton_actionPerformed(e);
            }
        });
        this.zoomvoidButton.setText(MessagesBundle.getMessage("Zoom_to_void"));
        this.zoomvoidButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryElementsPanel.this.zoomvoidButton_actionPerformed(e);
            }
        });
        this.removeButton.setText(MessagesBundle.getMessage("Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryElementsPanel.this.removeButton_actionPerformed(e);
            }
        });
        this.undoButton.setText(MessagesBundle.getMessage("Undo"));
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryElementsPanel.this.undoButton_actionPerformed(e);
            }
        });
        this.add((Component)this.featLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.featText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, -90, 0, 0), 0, 0));
        this.add((Component)this.treeScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 100, 120));
        this.add((Component)this.zoomfeatButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.zoomelemButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(35, 10, 0, 10), 0, 0));
        this.add((Component)this.zoomvoidButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(60, 10, 0, 10), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(85, 10, 0, 10), 0, 0));
        this.add((Component)this.undoButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(110, 10, 0, 10), 0, 0));
        this.add((Component)this.elemtypeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.elemtypeTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, -58, 0, 0), 0, 0));
        this.add((Component)this.elempointLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.elempointTxt, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, -58, 0, 10), 0, 0));
        this.add((Component)this.eleminfoLabel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.eleminfoText, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 18, 2, new Insets(-5, 0, 0, 0), 100, 40));
        this.add((Component)this.oordsLabel, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.oordsText, new GridBagConstraints(0, 8, 3, 1, 1.0, 0.0, 18, 2, new Insets(-5, 0, 0, 0), 100, 100));
        this.add((Component)this.fillerLabel, new GridBagConstraints(0, 9, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node;
                GeometryElementsPanel.this.currentElement = -1;
                GeometryElementsPanel.this.currentVoid = -1;
                if (GeometryElementsPanel.this.drawPanel != null) {
                    // empty if block
                }
                if ((node = (DefaultMutableTreeNode)GeometryElementsPanel.this.tree.getLastSelectedPathComponent()) == null || GeometryElementsPanel.this.tree.getGeometry() == null) {
                    return;
                }
                Object nodeInfo = node.getUserObject();
                String nodeName = nodeInfo.toString();
                JGeometry[] elements = JGeometryUtil.getElements((JGeometry)GeometryElementsPanel.this.tree.getGeometry());
                int level = node.getLevel();
                if (level == 0) {
                    GeometryElementsPanel.this.zoomelemButton.setEnabled(false);
                    GeometryElementsPanel.this.zoomvoidButton.setEnabled(false);
                    GeometryElementsPanel.this.removeButton.setEnabled(false);
                    GeometryElementsPanel.this.updateElementInformation(0);
                    GeometryElementsPanel.this.currentElement = 0;
                    GeometryElementsPanel.this.highlightCurrentElement();
                } else if (level == 1) {
                    if (elements.length < 2) {
                        GeometryElementsPanel.this.removeButton.setEnabled(false);
                    }
                    GeometryElementsPanel.this.zoomelemButton.setEnabled(true);
                    GeometryElementsPanel.this.zoomvoidButton.setEnabled(false);
                    int idx = nodeName.indexOf("_");
                    GeometryElementsPanel.this.currentElement = Integer.valueOf(nodeName.substring(idx + 1, nodeName.length()));
                    GeometryElementsPanel.this.updateElementInformation(GeometryElementsPanel.this.currentElement);
                    GeometryElementsPanel.this.highlightCurrentElement();
                } else if (level == 2) {
                    GeometryElementsPanel.this.zoomelemButton.setEnabled(true);
                    GeometryElementsPanel.this.zoomvoidButton.setEnabled(true);
                    int idxV = nodeName.indexOf("_");
                    GeometryElementsPanel.this.currentVoid = Integer.valueOf(nodeName.substring(idxV + 1, nodeName.length()));
                    TreeNode parent = node.getParent();
                    nodeName = parent.toString();
                    int idx = nodeName.indexOf("_");
                    GeometryElementsPanel.this.currentElement = Integer.valueOf(nodeName.substring(idx + 1, nodeName.length()));
                    GeometryElementsPanel.this.updateElementInformation(GeometryElementsPanel.this.currentElement);
                    GeometryElementsPanel.this.highlightCurrentVoidElement();
                }
            }
        });
        if (this.geomset != null && this.feature != null) {
            String keyColumn = this.geomset.getGeometrySet().getKeyColumn();
            this.featText.setText(this.feature.getAttribute(keyColumn).getValue().toString());
        }
        this.eleminfoText.setTextLineWrap(true);
        this.oordsText.setTextLineWrap(true);
        this.zoomfeatButton.setEnabled(true);
        this.zoomelemButton.setEnabled(false);
        this.zoomvoidButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.undoButton.setEnabled(false);
        if (this.tree.getGeometry() != null && (elements = this.tree.getGeometry().getElements()) != null && elements.length > 0) {
            this.tree.setSelectionInterval(0, 0);
        }
    }

    private void zoomfeatButton_actionPerformed(ActionEvent e) {
        if (this.feature == null || this.drawPanel == null) {
            return;
        }
        this.zoomToGeometry(this.feature.getSpatialAttribute());
    }

    private void zoomelemButton_actionPerformed(ActionEvent e) {
        if (this.currentElement == -1) {
            return;
        }
        JGeometry geom = this.tree.getGeometry();
        if (geom == null) {
            return;
        }
        JGeometry[] elems = JGeometryUtil.getElements((JGeometry)geom);
        this.zoomToGeometry(elems[this.currentElement - 1]);
    }

    private void zoomvoidButton_actionPerformed(ActionEvent e) {
        if (this.currentElement == -1 || this.currentVoid == -1) {
            return;
        }
        JGeometry geom = this.tree.getGeometry();
        if (geom == null) {
            return;
        }
        JGeometry[] elems = JGeometryUtil.getElements((JGeometry)geom);
        JGeometry voidGeom = this.getVoidBoundaryAsGeometry(elems[this.currentElement - 1]);
        this.zoomToGeometry(voidGeom);
        voidGeom = null;
    }

    private JGeometry getVoidBoundaryAsGeometry(JGeometry geom) {
        if (geom == null) {
            return null;
        }
        double[] oords = geom.getOrdinatesArray();
        int[] eInfo = geom.getElemInfo();
        int nrings = eInfo.length / 3;
        int oordStart = eInfo[3 * this.currentVoid];
        int oordEnd = oords.length + 1;
        if (this.currentVoid < nrings - 1) {
            oordEnd = eInfo[3 * (this.currentVoid + 1)];
        }
        double[] voidOords = new double[oordEnd - oordStart];
        int count = 0;
        for (int i = oordStart - 1; i < oordEnd - 1; ++i) {
            voidOords[count++] = oords[i];
        }
        JGeometry voidGeom = new JGeometry(2, geom.getSRID(), new int[]{1, 2, 1}, voidOords);
        return voidGeom;
    }

    private void removeButton_actionPerformed(ActionEvent e) {
        System.out.println("To be implemented.");
    }

    private void undoButton_actionPerformed(ActionEvent e) {
        System.out.println("To be implemented.");
    }

    private void zoomToGeometry(JGeometry geom) {
        if (geom == null || this.drawPanel == null || this.drawPanel.getMapRegion() == null) {
            return;
        }
        int dim = geom.getDimensions();
        double[] geommbr = geom.getMBR();
        double xmin = geommbr[0];
        double xmax = geommbr[dim];
        double ymin = geommbr[1];
        double ymax = geommbr[dim + 1];
        double dx = xmax - xmin;
        double dy = ymax - ymin;
        Rectangle2D mbr = this.drawPanel.getMapRegion().getDataWindow();
        double size = dy + 0.25 * dy;
        if (dx > dy) {
            size = dx + 0.25 * dx;
        }
        if (dx == 0.0 && dy == 0.0) {
            size = 0.1 * mbr.getHeight();
        } else if (dy == 0.0) {
            size = 0.1 * mbr.getHeight();
        }
        this.drawPanel.getMapRegion().setDataWindowByHeight(xmin + dx / 2.0, ymin + dy / 2.0, size);
    }

    private void updateElementInformation(int element) {
        this.elemtypeTxt.setText("");
        this.elempointTxt.setText("");
        this.eleminfoText.setTextContents("");
        this.oordsText.setTextContents("");
        if (element < 0) {
            return;
        }
        JGeometry geom = this.tree.getGeometry();
        JGeometry[] elems = JGeometryUtil.getElements((JGeometry)geom);
        if (elems == null) {
            return;
        }
        double[] xyz = null;
        if (element == 0) {
            this.elemtypeTxt.setText("" + geom.getType());
            xyz = geom.getLabelPointXYZ();
            this.elemtypeLabel.setText(MessagesBundle.getMessage("Label_geometry_type"));
            this.elempointLabel.setText(MessagesBundle.getMessage("Label_geometry_point"));
            this.eleminfoLabel.setText(MessagesBundle.getMessage("Geometry_info_array"));
            this.oordsLabel.setText(MessagesBundle.getMessage("Geometry_oordinates"));
        } else {
            this.elemtypeTxt.setText("" + elems[element - 1].getType());
            xyz = elems[element - 1].getLabelPointXYZ();
            this.elemtypeLabel.setText(MessagesBundle.getMessage("Label_element_type"));
            this.elempointLabel.setText(MessagesBundle.getMessage("Label_element_point"));
            this.eleminfoLabel.setText(MessagesBundle.getMessage("Element_info_array"));
            this.oordsLabel.setText(MessagesBundle.getMessage("Element_oordinates"));
        }
        String xyzStr = "";
        if (!Double.isNaN(xyz[0])) {
            xyzStr = "" + xyz[0];
            if (!Double.isNaN(xyz[1])) {
                xyzStr = xyzStr + "," + xyz[1];
                if (!Double.isNaN(xyz[2])) {
                    xyzStr = xyzStr + "," + xyz[2];
                }
            }
            this.elempointTxt.setText(xyzStr);
            this.elempointTxt.select(0, 0);
        }
        int[] elemInfo = null;
        elemInfo = element == 0 ? geom.getElemInfo() : elems[element - 1].getElemInfo();
        if (elemInfo != null && elemInfo.length > 0) {
            String einfo = "" + elemInfo[0];
            for (int i = 1; i < elemInfo.length; ++i) {
                einfo = einfo + "," + elemInfo[i];
            }
            this.eleminfoText.setTextContents(einfo);
        }
        double[] oords = null;
        oords = element == 0 ? geom.getOrdinatesArray() : elems[element - 1].getOrdinatesArray();
        if (oords != null && oords.length > 0) {
            StringBuffer buffer = new StringBuffer(5000);
            buffer.append("" + oords[0]);
            for (int i = 1; i < oords.length; ++i) {
                if (i == this.maxOordsToShow) {
                    buffer.append("\n... (showing " + this.maxOordsToShow + " of " + oords.length + " oordinates)");
                    break;
                }
                buffer.append("," + oords[i]);
            }
            this.oordsText.setTextContents(buffer.toString());
        }
    }

    private void highlightCurrentElement() {
        if (this.currentElement == -1 || this.drawPanel == null) {
            return;
        }
        JGeometry geom = this.tree.getGeometry();
        if (geom == null) {
            return;
        }
        JGeometry[] geomTohigh = new JGeometry[1];
        if (this.currentElement == 0) {
            geomTohigh[0] = geom;
        } else {
            JGeometry elemGeom;
            JGeometry[] elems = JGeometryUtil.getElements((JGeometry)geom);
            geomTohigh[0] = elemGeom = elems[this.currentElement - 1];
        }
        if (this.gsLayer != null) {
            this.gsLayer.setHighliteGeometries(geomTohigh);
        }
    }

    private void highlightCurrentVoidElement() {
        if (this.currentElement == -1 || this.currentVoid == -1 || this.drawPanel == null) {
            return;
        }
        JGeometry geom = this.tree.getGeometry();
        if (geom == null) {
            return;
        }
        JGeometry[] elems = JGeometryUtil.getElements((JGeometry)geom);
        JGeometry voidGeom = this.getVoidBoundaryAsGeometry(elems[this.currentElement - 1]);
        if (this.gsLayer != null) {
            this.gsLayer.setHighliteGeometries(new JGeometry[]{voidGeom});
        }
    }
}

