/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.maps.core.Drawable;
import oracle.maps.geoobject.GeometryFeature;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.SRS;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.TextLabeler;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.theme.AnnotationTextThemeProducer;
import oracle.sdovis.util.RectArray;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.geometry.JGeometry;

public class RenderUtils {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);

    public static void renderGeometryObject(Graphics2D g2, AffineTransform transform, GeometryFeature feature, Style renderStyle) {
        if (feature == null || renderStyle == null || transform == null || g2 == null) {
            return;
        }
        Drawable dr = feature.getDrawable(transform);
        if (dr == null) {
            return;
        }
        JGeometry geom = feature.getSpatialAttribute();
        while (dr != null) {
            if (dr.isShape()) {
                try {
                    renderStyle.apply(null, g2, dr.getShape(), geom.getType(), null, null, null, null, null);
                }
                catch (StyleNotApplicableException ex) {
                    ex.printStackTrace();
                }
            } else {
                double orientation = 0.0;
                if (dr.getType() == 4) {
                    orientation = Math.atan2(-dr.getVectorY(), dr.getVectorX());
                }
                RenderUtils.renderStyledPoint(g2, renderStyle, dr.getPoint(), orientation);
            }
            dr = dr.getNext();
        }
    }

    public static void renderStyledPoint(Graphics2D g2, Style renderStyle, Point2D pt, double orientation) {
        if (g2 == null || renderStyle == null || pt == null) {
            return;
        }
        try {
            StyleMarker msty = (StyleMarker)renderStyle;
            double origOrientation = msty.getOrientation();
            if (orientation != 0.0) {
                msty.setOrientation(orientation);
            }
            int width = msty.getDesiredWidth();
            int height = msty.getDesiredHeight();
            Rectangle2D.Float r2 = new Rectangle2D.Float((float)(pt.getX() - (double)(width / 2)), (float)(pt.getY() - (double)(height / 2)), width, height);
            msty.apply(null, g2, (Rectangle2D)r2, null);
            msty.setOrientation(origOrientation);
            return;
        }
        catch (ClassCastException e) {
        }
        catch (StyleNotApplicableException ex) {
            // empty catch block
        }
        try {
            StyleColor csty = (StyleColor)renderStyle;
            boolean draw = false;
            if (csty.getFillColor() != null && csty.getFillColor().getAlpha() != 0) {
                draw = true;
            }
            if (csty.getStrokeColor() != null && csty.getStrokeColor().getAlpha() != 0) {
                draw = true;
            }
            if (draw) {
                int x = (int)pt.getX();
                int y = (int)pt.getY();
                if (csty.getFillColor() != null) {
                    g2.setColor(csty.getFillColor());
                }
                if (csty.getStrokeColor() != null) {
                    g2.setColor(csty.getStrokeColor());
                }
                g2.drawLine(x - 3, y - 3, x + 3, y + 3);
                g2.drawLine(x - 3, y + 3, x + 3, y - 3);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    private static void renderStyledMultiPoint(Graphics2D g2, Style renderStyle, JGeometry geom, Shape shp) {
        if (g2 == null || renderStyle == null || geom == null || shp == null) {
            return;
        }
        int[] elemInfo = geom.getElemInfo();
        double[] oordsArray = geom.getOrdinatesArray();
        float[] segCoords = new float[6];
        PathIterator pi = shp.getPathIterator(null);
        int index = 0;
        while (!pi.isDone()) {
            int t = pi.currentSegment(segCoords);
            if (t == 0 || t == 1) {
                double orientation = 0.0;
                Point2D.Double pt = new Point2D.Double(segCoords[0], segCoords[1]);
                if (geom.isOrientedMultiPoint()) {
                    int orientStart = elemInfo[index * 6 + 3] - 1;
                    double ox = oordsArray[orientStart];
                    double oy = oordsArray[orientStart + 1];
                    orientation = Math.atan2(-oy, ox);
                }
                RenderUtils.renderStyledPoint(g2, renderStyle, pt, orientation);
            }
            pi.next();
            ++index;
        }
    }

    private static void renderStyledCollection(Graphics2D g2, Style renderStyle, JGeometry geom, Shape shp, ArrayList<Drawable> points) {
        if (g2 == null || renderStyle == null || geom == null || shp == null) {
            return;
        }
        try {
            renderStyle.apply(null, g2, shp, geom.getType(), null, null, null, null, null);
        }
        catch (StyleNotApplicableException ex) {
            log.severe(ex.getMessage());
        }
        if (points != null && points.size() > 0) {
            JGeometry[] elems = geom.getElements();
            if (elems == null || elems.length == 0) {
                return;
            }
            int ptcount = 0;
            for (int i = 0; i < elems.length; ++i) {
                if (elems[i].getType() != 1) continue;
                Point2D pt = points.get(ptcount).getPoint();
                double orientation = 0.0;
                if (elems[i].isOrientedPoint()) {
                    double[] coords = geom.getOrdinatesArray();
                    int dim = geom.getDimensions();
                    if (coords != null) {
                        orientation = Math.atan2(-coords[dim + 1], coords[dim]);
                    }
                }
                RenderUtils.renderStyledPoint(g2, renderStyle, pt, orientation);
                ++ptcount;
            }
        }
    }

    public static void renderAnnotationtextObject(Graphics2D g2, AffineTransform transf, AnnotationTextFeature feature, StyleText metadataStyle, String defaultText, double metadataScale, Style leaderlineStyle, Rectangle2D deviceWindow, Rectangle2D dataWindow, SRS srs) {
        if (g2 == null || feature == null) {
            return;
        }
        AnnotationText antext = feature.getSpatialAttribute();
        if (antext == null) {
            return;
        }
        StyleColor transpStyle = new StyleColor(new Color(0, 0, 0, 0));
        VisContext vc = new VisContext();
        vc.setCRArray(new RectArray(10));
        try {
            vc.setDeviceWindow(deviceWindow);
            vc.setQueryWindow(dataWindow);
        }
        catch (Exception e) {
            log.finest("VC area set: " + e.getMessage());
            return;
        }
        vc.setAffineXF(transf);
        vc.setSrs(srs);
        AnnotationTextElement[] elems = antext.getElements();
        if (elems != null && elems.length > 0) {
            String previousText = defaultText;
            for (int i = 0; i < elems.length; ++i) {
                JGeometry leaderline;
                StyledFeature sf;
                String textValue = elems[i].getValue();
                if (textValue == null) {
                    textValue = previousText;
                } else {
                    previousText = textValue;
                }
                if (textValue == null) continue;
                JGeometry location = elems[i].getLocation();
                if (location != null) {
                    StyleText elemStyle = AnnotationTextThemeProducer.getTextStyle((TextAttributesType)elems[i].getAttributes());
                    if (elemStyle == null) {
                        elemStyle = metadataStyle;
                    }
                    if (!Double.isNaN(metadataScale) && metadataScale > 0.0) {
                        double inmeter = metadataScale * 0.0254 / 96.0;
                        float fsize = elemStyle.getFont().getSize2D();
                        SizeDefinition sizeDef = new SizeDefinition((double)(fsize *= (float)inmeter), "m");
                        if (sizeDef != null) {
                            ((TextStyleModel)elemStyle.getModel()).setFontSize((float)sizeDef.getValue(), sizeDef.getUnit());
                        }
                    }
                    sf = new StyledFeature();
                    JSDOGeometry locGeom = JSDOGeometry.recast((JGeometry)location);
                    sf.setGeometry(locGeom);
                    sf.setFeatureStyle((Style)transpStyle);
                    sf.setLabel(textValue);
                    sf.setLabelStyle((Style)elemStyle);
                    sf.setForceLabel(true);
                    sf.setLabelAsOrientedPoint(true);
                    sf.setElementPosition(i);
                    sf.buildShapeFromGeometry(transf);
                    try {
                        TextLabeler.applyTextLabel((Graphics2D)g2, (StyledFeatureI)sf, (StyleText)elemStyle, (String)sf.getLabel(), (boolean)true, (boolean)true, (boolean)false, (VisContext)vc);
                    }
                    catch (StyleNotApplicableException ex) {
                        ex.printStackTrace();
                    }
                }
                if ((leaderline = elems[i].getLeaderLine()) == null || leaderlineStyle == null) continue;
                sf = new StyledFeature();
                sf.setGeometry(JSDOGeometry.recast((JGeometry)leaderline));
                sf.buildShapeFromGeometry(transf);
                try {
                    leaderlineStyle.apply(null, g2, sf.getShape(), leaderline.getType(), null, null, null, null, null);
                    continue;
                }
                catch (StyleNotApplicableException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void renderTopologyObject(Graphics2D g2, AffineTransform transform, TopologyFeature feature, Style renderStyle) {
        if (feature == null || renderStyle == null || transform == null || g2 == null) {
            return;
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom == null) {
            return;
        }
        JGeometry[] geometries = tpgeom.getGeometries(feature.getTopologyModel());
        if (geometries == null || geometries.length == 0) {
            return;
        }
        for (int i = 0; i < geometries.length; ++i) {
            Drawable dr;
            JGeometry geom = geometries[i];
            if (geom == null || (dr = Drawable.createDrawable(geom, transform)) == null) continue;
            while (dr != null) {
                if (dr.isShape()) {
                    try {
                        renderStyle.apply(null, g2, dr.getShape(), geom.getType(), null, null, null, null, null);
                    }
                    catch (StyleNotApplicableException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    double orientation = 0.0;
                    if (geom.isOrientedPoint() || geom.isOrientedMultiPoint()) {
                        double[] coords = geom.getOrdinatesArray();
                        int dim = geom.getDimensions();
                        if (coords != null) {
                            orientation = Math.atan2(-coords[dim + 1], coords[dim]);
                        }
                    }
                    RenderUtils.renderStyledPoint(g2, renderStyle, dr.getPoint(), orientation);
                }
                dr = dr.getNext();
            }
        }
    }
}

