/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectableLayer;
import oracle.maps.geoobject.JGeometryObject;
import oracle.maps.tools.BasicTool;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.index.topology.IndexedTopologyModel;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologySet;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.Node;

public class TopoPrimitivePickTool
extends BasicTool {
    public static final String ASSIGNPRIMITIVE = "assignprimitive";
    public static final String UNASSIGNPRIMITIVE = "removeprimitive";
    public static final String REMOVENODE = "removenode";
    public static final String REMOVELINKOREDGE = "removelinkoredge";
    private String modifier = null;
    private static int nextTempTopoGeometryId = -1;
    private SelectableLayer selectionLayer = null;
    private TopoPrimitiveDescriptor topoElem = null;
    private MainAppPanel mainApp = null;
    private boolean moveEnabled = true;

    public TopoPrimitivePickTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "topoprimitive-pick");
    }

    public void setMainApp(MainAppPanel mainApp) {
        this.mainApp = mainApp;
    }

    @Override
    public void clear() {
        this.topoElem = null;
        this.selectionLayer = null;
        this.moveEnabled = true;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        this.selectionLayer = (SelectableLayer)this.canvas.getLayerManager().getLayerByTag("targetLayer");
        if (this.selectionLayer == null || !this.selectionLayer.isVisible() || !(this.selectionLayer instanceof TopologySetLayer)) {
            return propagate;
        }
        if (evt instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)evt;
            int id = me.getID();
            switch (id) {
                case 500: {
                    this.mouseClicked(me);
                    propagate = false;
                    this.finish();
                    break;
                }
                case 503: {
                    this.mouseMoved(me);
                }
            }
        }
        return propagate;
    }

    private void finish() {
        TopoPrimitiveDescriptor tpdesc = this.getTopoPrimtive();
        if (tpdesc == null) {
            return;
        }
        TopoPrimitiveDescriptor tpd = new TopoPrimitiveDescriptor();
        tpd.setTopoId(tpdesc.getTopoId());
        tpd.setTopoType(tpdesc.getTopoType());
        this.clear();
        Layer targetLayer = this.getCanvas().getLayerManager().getLayerByTag("targetLayer");
        if (targetLayer == null) {
            this.clear();
            return;
        }
        TopologySetLayer tl = (TopologySetLayer)targetLayer;
        List<GeoObject> selected = tl.getSelection();
        if (selected == null || selected.size() > 1) {
            this.clear();
            return;
        }
        TopologySet set = (TopologySet)tl.getIndexedDataSet().getDataSet();
        TopologyMetadata topoMeta = set.getMetadata();
        String topoType = topoMeta.getTopoLayerType();
        if (this.getModifier().equals(ASSIGNPRIMITIVE)) {
            if (tpd.getTopoType() == 1 && !topoType.equalsIgnoreCase("POINT") && !topoType.equalsIgnoreCase("COLLECTION") || tpd.getTopoType() == 2 && !topoType.equalsIgnoreCase("PLINE") && !topoType.equalsIgnoreCase("COLLECTION") || tpd.getTopoType() == 3 && !topoType.equalsIgnoreCase("POLYGON") && !topoType.equalsIgnoreCase("COLLECTION")) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Invalid topology primitive type for topology layer type [" + topoType + "].", "Warning", 2);
                return;
            }
            boolean newFeature = true;
            if (selected.size() == 1) {
                newFeature = false;
            }
            Field[] fields = null;
            if (newFeature && ((fields = tl.getFieldsForFeature(null, false)) == null || fields.length == 0)) {
                this.clear();
                return;
            }
            String keyColumn = tl.getIndexedDataSet().getDataSet().getKeyColumn();
            if (newFeature) {
                TopologyFeature tfeat = new TopologyFeature();
                TopologyGeometry tpgeom = new TopologyGeometry();
                tpgeom.setLayerId(topoMeta.getTopoLayerId());
                tpgeom.setTopoType(topoMeta.getTopoLayerType());
                tpgeom.setId(nextTempTopoGeometryId--);
                tpgeom.addTopoPrimitive(tpd.getTopoId(), tpd.getTopoType());
                tfeat.setTopologyModel(tl.getIndexedTopologyModel().getTopologyModel());
                tfeat.setSpatialAttribute(tpgeom);
                tfeat.setAttributes(fields);
                String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                tfeat.setKey(fkey);
                tfeat.setLayer(tl);
                try {
                    tl.insertObject(fkey, tfeat);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
                }
            } else {
                TopologyFeature tfeat = (TopologyFeature)selected.get(0);
                String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                try {
                    tl.assignPrimitiveToFeature(fkey, tpd.getTopoId(), tpd.getTopoType());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
                }
            }
        } else if (this.getModifier().equals(UNASSIGNPRIMITIVE)) {
            TopologyFeature tfeat;
            if (selected.size() == 1 && (tfeat = (TopologyFeature)selected.get(0)) != null) {
                if (tfeat.getNumberOfTopoPrimitives() == 1) {
                    JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Cannot remove topo primitive from a feature with just one primitive element.", "Warning", 2);
                } else {
                    String keyColumn = tl.getIndexedDataSet().getDataSet().getKeyColumn();
                    String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                    try {
                        tl.removePrimitiveFromFeature(fkey, tpd.getTopoId(), tpd.getTopoType());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
                    }
                }
            }
        } else if (this.getModifier().equals(REMOVENODE)) {
            if (tpd.getTopoType() != 1) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Invalid topology primitive type to remove. Must be a node.", MessagesBundle.getMessage("Warning"), 2);
                return;
            }
            try {
                tl.removeNode(tpd.getTopoId());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), MessagesBundle.getMessage("Warning"), 2);
            }
        } else if (this.getModifier().equals(REMOVELINKOREDGE)) {
            if (tpd.getTopoType() != 2) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Invalid topology primitive type to remove. Must be an edge.", "Warning", 2);
                return;
            }
            try {
                tl.removeEdge(tpd.getTopoId());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
            }
        }
    }

    protected void mouseClicked(MouseEvent evt) {
        if (this.selectionLayer != null && this.selectionLayer instanceof TopologySetLayer) {
            ((TopologySetLayer)this.selectionLayer).clearHover();
        }
        this.processMouseClicked();
    }

    protected void mouseMoved(MouseEvent evt) {
        if (!this.moveEnabled) {
            return;
        }
        List<GeoObject> selected = this.selectionLayer.getSelection();
        if (selected.size() > 1) {
            return;
        }
        TopologySetLayer tl = (TopologySetLayer)this.selectionLayer;
        IndexedTopologyModel indexedModel = tl.getIndexedTopologyModel();
        if (indexedModel == null) {
            return;
        }
        JGeometry geom = null;
        this.topoElem = null;
        Point2D.Double pt = new Point2D.Double();
        try {
            this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(evt.getX(), evt.getY()), pt);
        }
        catch (Exception ex) {
            return;
        }
        double wcTolerance = TransformUtils.getWCTolerance(pt, 3, this.canvas.getViewportTransform());
        String objId = "";
        Node node = indexedModel.identifyNode(pt, wcTolerance);
        if (node != null) {
            geom = indexedModel.getTopologyModel().getNodeGeometry(node.getId());
            this.topoElem = new TopoPrimitiveDescriptor();
            this.topoElem.setTopoId(node.getId());
            this.topoElem.setTopoType(1);
            objId = MessagesBundle.getMessage("Node") + ":" + node.getId();
        } else {
            Edge edge = indexedModel.identifyEdge(pt, wcTolerance);
            if (edge != null) {
                geom = indexedModel.getTopologyModel().getEdgeGeometry(edge.getId());
                this.topoElem = new TopoPrimitiveDescriptor();
                this.topoElem.setTopoId(edge.getId());
                this.topoElem.setTopoType(2);
                objId = MessagesBundle.getMessage("Edge") + ":" + edge.getId();
            } else {
                Face face = indexedModel.identifyFace(pt, wcTolerance);
                if (face != null) {
                    geom = indexedModel.getTopologyModel().getFaceGeometry(face.getID());
                    this.topoElem = new TopoPrimitiveDescriptor();
                    this.topoElem.setTopoId(face.getID());
                    this.topoElem.setTopoType(3);
                    objId = MessagesBundle.getMessage("Face") + ":" + face.getID();
                }
            }
        }
        if (geom != null) {
            Vector<GeoObject> hits = new Vector<GeoObject>();
            JGeometryObject hoverShape = new JGeometryObject(geom, objId, null);
            hits.add(hoverShape);
            tl.setHover(hits);
        } else {
            tl.clearHover();
        }
    }

    public TopoPrimitiveDescriptor getTopoPrimtive() {
        return this.topoElem;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getModifier() {
        return this.modifier;
    }

    private void processMouseClicked() {
        TopoPrimitiveDescriptor tpdesc = this.getTopoPrimtive();
        if (tpdesc == null) {
            return;
        }
        this.moveEnabled = false;
        TopoPrimitiveDescriptor tpd = new TopoPrimitiveDescriptor();
        tpd.setTopoId(tpdesc.getTopoId());
        tpd.setTopoType(tpdesc.getTopoType());
        this.clear();
        Layer targetLayer = this.getCanvas().getLayerManager().getLayerByTag("targetLayer");
        if (targetLayer == null) {
            this.clear();
            return;
        }
        TopologySetLayer tl = (TopologySetLayer)targetLayer;
        List<GeoObject> selected = tl.getSelection();
        if (selected == null || selected.size() > 1) {
            this.clear();
            return;
        }
        TopologySet set = (TopologySet)tl.getIndexedDataSet().getDataSet();
        TopologyMetadata topoMeta = set.getMetadata();
        String topoType = topoMeta.getTopoLayerType();
        if (this.getModifier().equals(ASSIGNPRIMITIVE)) {
            if (tpd.getTopoType() == 1 && !topoType.equalsIgnoreCase("POINT") && !topoType.equalsIgnoreCase("COLLECTION") || tpd.getTopoType() == 2 && !topoType.equalsIgnoreCase("PLINE") && !topoType.equalsIgnoreCase("COLLECTION") || tpd.getTopoType() == 3 && !topoType.equalsIgnoreCase("POLYGON") && !topoType.equalsIgnoreCase("COLLECTION")) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Invalid topology primitive type for topology layer type [" + topoType + "].", "Warning", 2);
                this.clear();
                return;
            }
            boolean newFeature = true;
            if (selected.size() == 1) {
                newFeature = false;
            }
            Field[] fields = null;
            if (newFeature && ((fields = tl.getFieldsForFeature(null, false)) == null || fields.length == 0)) {
                this.clear();
                return;
            }
            String keyColumn = tl.getIndexedDataSet().getDataSet().getKeyColumn();
            if (newFeature) {
                TopologyFeature tfeat = new TopologyFeature();
                TopologyGeometry tpgeom = new TopologyGeometry();
                tpgeom.setLayerId(topoMeta.getTopoLayerId());
                tpgeom.setTopoType(topoMeta.getTopoLayerType());
                tpgeom.setId(tl.getNextTemporaryTopoGeometryId());
                tpgeom.addTopoPrimitive(tpd.getTopoId(), tpd.getTopoType());
                tfeat.setTopologyModel(tl.getIndexedTopologyModel().getTopologyModel());
                tfeat.setSpatialAttribute(tpgeom);
                tfeat.setAttributes(fields);
                String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                tfeat.setKey(fkey);
                tfeat.setLayer(tl);
                try {
                    tl.insertObject(fkey, tfeat);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), MessagesBundle.getMessage("Warning"), 2);
                }
            } else {
                TopologyFeature tfeat = (TopologyFeature)selected.get(0);
                String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                try {
                    tl.assignPrimitiveToFeature(fkey, tpd.getTopoId(), tpd.getTopoType());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
                }
            }
        } else if (this.getModifier().equals(UNASSIGNPRIMITIVE)) {
            TopologyFeature tfeat;
            if (selected.size() == 1 && (tfeat = (TopologyFeature)selected.get(0)) != null) {
                if (tfeat.getNumberOfTopoPrimitives() == 1) {
                    JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Cannot remove topo primitive from a feature with just one primitive element.", MessagesBundle.getMessage("Warning"), 2);
                } else {
                    String keyColumn = tl.getIndexedDataSet().getDataSet().getKeyColumn();
                    String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                    try {
                        tl.removePrimitiveFromFeature(fkey, tpd.getTopoId(), tpd.getTopoType());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
                    }
                }
            }
        } else if (this.getModifier().equals(REMOVENODE)) {
            if (tpd.getTopoType() != 1) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Invalid topology primitive type to remove. Must be a node.", MessagesBundle.getMessage("Warning"), 2);
                this.clear();
                return;
            }
            try {
                tl.removeNode(tpd.getTopoId());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), MessagesBundle.getMessage("Warning"), 2);
            }
        } else if (this.getModifier().equals(REMOVELINKOREDGE)) {
            if (tpd.getTopoType() != 2) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Invalid topology primitive type to remove. Must be an edge.", "Warning", 2);
                this.clear();
                return;
            }
            try {
                tl.removeEdge(tpd.getTopoId());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
            }
        }
        this.moveEnabled = true;
    }
}

