/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import oracle.maps.core.MapCanvas;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.layer.BasicLayer;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mdeditor.session.layer.ConfigurableLayer;
import oracle.mdeditor.ui.ColorIcon;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class SimpleBGLayer
extends BasicLayer
implements ConfigurableLayer {
    public static final String PROPERTY_BACKGROUND = "SimpleBGLayer.background";
    public static final String PROPERTY_BORDER = "SimpleBGLayer.border";
    protected Point2D lastPoint = null;
    protected AnimatedStroke borderStroke = null;
    protected ArrayList<JMenuItem> menuItems = new ArrayList();

    public SimpleBGLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Background Layer");
        this.properties.setDefaultProperty(PROPERTY_BACKGROUND, StyleUtils.getHexidecimalString((Color)new Color(204, 204, 255)));
        this.properties.setDefaultProperty(PROPERTY_BORDER, StyleUtils.getHexidecimalString((Color)Color.gray));
        this.borderStroke = new AnimatedStroke(Color.gray);
        this.borderStroke.setSpeed(5.0f);
        ZoomAL actionListener = new ZoomAL(0, 0);
        JMenuItem mi = new JMenuItem(MessagesBundle.getMessage("Center_here"));
        mi.addActionListener(actionListener);
        mi.setActionCommand("center");
        mi.setMnemonic('c');
        this.menuItems.add(mi);
        mi = new JMenuItem(MessagesBundle.getMessage("Zoom_in"));
        mi.addActionListener(actionListener);
        mi.setActionCommand("zoomin");
        mi.setMnemonic('i');
        this.menuItems.add(mi);
        mi = new JMenuItem(MessagesBundle.getMessage("Zoom_out"));
        mi.addActionListener(actionListener);
        mi.setActionCommand("zoomout");
        mi.setMnemonic('o');
        this.menuItems.add(mi);
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        if (evt instanceof MouseWheelEvent) {
            MouseWheelEvent e = (MouseWheelEvent)evt;
            int notches = e.getWheelRotation();
            if (notches < 0) {
                this.canvas.getMapRegion().zoomIn(e.getPoint());
            } else {
                this.canvas.getMapRegion().zoomOut(e.getPoint());
            }
            propagate = false;
        } else if (evt instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt;
            int x = e.getX();
            int y = e.getY();
            int id = e.getID();
            this.canvas.setCursor(Cursor.getPredefinedCursor(12));
            propagate = false;
            switch (id) {
                case 500: {
                    if (e.getClickCount() != 2) break;
                    this.canvas.getMapRegion().zoomIn(e.getPoint());
                    break;
                }
                case 501: {
                    this.lastPoint = new Point2D.Double(x, y);
                    break;
                }
                case 506: {
                    if (this.lastPoint == null || this.lastPoint.equals(e.getPoint())) break;
                    this.canvas.getMapRegion().pan((int)(this.lastPoint.getX() - (double)x), (int)((double)y - this.lastPoint.getY()));
                    this.lastPoint.setLocation(e.getPoint());
                    break;
                }
                case 502: {
                    this.lastPoint = null;
                    break;
                }
                default: {
                    propagate = true;
                }
            }
            this.setupPopupMenu(x, y);
        }
        return propagate;
    }

    public ArrayList<JMenuItem> getMenuItems() {
        return this.menuItems;
    }

    private void setupPopupMenu(int x, int y) {
        JPopupMenu popup = this.canvas.getPopupMenu();
        if (popup != null) {
            if (popup.getComponentCount() > 0) {
                popup.addSeparator();
            }
            for (JMenuItem mi : this.menuItems) {
                for (ActionListener l : mi.getActionListeners()) {
                    if (l instanceof ZoomAL) {
                        ((ZoomAL)l).setCoordinates(x, y);
                    }
                    popup.add(mi);
                }
            }
        }
    }

    @Override
    public long render(Graphics2D g) {
        long t1 = System.currentTimeMillis();
        Dimension size = this.canvas.getSize();
        if (size == null) {
            return 0L;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, (int)size.getWidth(), (int)size.getHeight());
        return System.currentTimeMillis() - t1;
    }

    @Override
    public void update(long elapsedTime) {
        this.borderStroke.update(elapsedTime);
    }

    public Color getBackground() {
        try {
            Integer i = Integer.decode(this.getProperty(PROPERTY_BACKGROUND));
            return new Color(i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setBackground(Color background) {
        this.setProperty(PROPERTY_BACKGROUND, StyleUtils.getHexidecimalString((Color)background));
    }

    public Color getBorderColor() {
        try {
            Integer i = Integer.decode(this.getProperty(PROPERTY_BORDER));
            return new Color(i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setBorderColor(Color borderColor) {
        this.setProperty(PROPERTY_BORDER, StyleUtils.getHexidecimalString((Color)borderColor));
        this.borderStroke = new AnimatedStroke(borderColor);
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        JLabel label = new JLabel(MessagesBundle.getMessage("Label_background_color"));
        ColorIcon colorIcon = new ColorIcon(32, 16, this.getBackground());
        JButton button = new JButton(colorIcon);
        button.addActionListener(new ColorButtonActionListener(colorIcon, parent));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)button, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private class ColorButtonActionListener
    implements ActionListener {
        ColorIcon colorIcon = null;
        Component parent = null;

        public ColorButtonActionListener(ColorIcon colorIcon, Component parent) {
            this.colorIcon = colorIcon;
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color c = JColorChooser.showDialog(this.parent, MessagesBundle.getMessage("Choose_color"), this.colorIcon.getColor());
            if (c != null) {
                this.colorIcon.setColor(c);
                SimpleBGLayer.this.setBackground(c);
            }
        }
    }

    private class ZoomAL
    implements ActionListener {
        private int x = 0;
        private int y = 0;

        public ZoomAL(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void setCoordinates(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("zoomin".equalsIgnoreCase(e.getActionCommand())) {
                SimpleBGLayer.this.canvas.getMapRegion().zoomIn(new Point2D.Double(this.x, this.y));
            } else if ("zoomout".equalsIgnoreCase(e.getActionCommand())) {
                SimpleBGLayer.this.canvas.getMapRegion().zoomOut(new Point2D.Double(this.x, this.y));
            } else if ("center".equalsIgnoreCase(e.getActionCommand())) {
                double cx = (double)SimpleBGLayer.this.canvas.getWidth() / 2.0;
                double cy = (double)SimpleBGLayer.this.canvas.getHeight() / 2.0;
                SimpleBGLayer.this.canvas.getMapRegion().pan((int)((double)this.x - cx), (int)(cy - (double)this.y));
            }
        }
    }
}

