/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.maps.core.MapCanvas;
import oracle.maps.layer.ServerMapLayer;
import oracle.maps.producer.MVImageProducer;

public class OracleTileLayer
extends ServerMapLayer {
    private String mapViewerUrl;
    private String dataSource;
    private String tileLayer;

    public OracleTileLayer(MapCanvas canvas) {
        super(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileLayer(String mapViewerUrl, String dataSource, String tileLayer) {
        this.mapViewerUrl = mapViewerUrl.substring(0, mapViewerUrl.indexOf("/mapviewer")) + "/mapviewer/omserver";
        this.dataSource = dataSource;
        this.tileLayer = tileLayer;
        super.clear();
        ThemeDescriptor td = new ThemeDescriptor();
        td.name = tileLayer;
        td.type = 9;
        td.cacheMapSource = tileLayer;
        MVImageProducer producer = new MVImageProducer(null, this.mapViewerUrl, dataSource);
        this.setGeoDataProducer(producer);
        try {
            this.canvas.getProgressIndicator().taskStarted();
        }
        catch (Exception ex) {
            System.err.println("Error: cannot load tile layer config.");
        }
        finally {
            this.canvas.getProgressIndicator().taskCompleted();
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getMapViewerUrl() {
        return this.mapViewerUrl;
    }

    public String getTileLayer() {
        return this.tileLayer;
    }
}

