/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.favoritesNavigator;

import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.ResourceBundle;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.OneDModelListenerWrapperImpl;
import oracle.help.library.Book;
import oracle.help.library.Library;

public abstract class FavoritesModel {
    public static final String FAVORITES_NAME = "favorites";
    public static final String FAVORITE_ITEM_NAME = "favoriteitem";
    public static final String TEXT_ATTR_NAME = "text";
    public static final String TARGET_ATTR_NAME = "target";
    public static final String HSTITLE_ATTR_NAME = "hstitle";
    public static final String URL_ATTR_NAME = "url";
    private boolean _initialized = false;
    private ResourceBundle _miscBundle;
    private URL _location;
    private Library _library;
    private TopicTreeNode _favoritesNode;

    public FavoritesModel(URL location, Library library) {
        this._location = location;
        this._library = library;
        this._miscBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle", StaticLocaleContext.getLocale());
        this._favoritesNode = new TopicTreeNode(null, (Topic)new SimpleTopic(this._miscBundle.getString("addfavoriteitem.favorites")));
        TopicTreeNode dummyRoot = new TopicTreeNode(null, null);
        dummyRoot.addChild(this._favoritesNode);
    }

    public void addFavoriteItem(String text, String target, String hstitle, String url, TopicTreeNode parent) {
        int parentIndex;
        TopicTreeNode grandParent;
        if (parent == null) {
            parent = this._favoritesNode;
        }
        FavoriteItemTopicTreeNode favoriteItem = new FavoriteItemTopicTreeNode(text, target, hstitle, url);
        parent.addChild((TopicTreeNode)favoriteItem);
        int index = parent.getNumChildren() - 1;
        Enumeration listeners = parent.getListenerManager().getListeners();
        if (listeners != null) {
            this._fireAddEvent(listeners, index);
        }
        if ((grandParent = parent.getParent()) != null && (parentIndex = grandParent.getChildren().indexOf(parent)) != -1 && (listeners = grandParent.getListenerManager().getListeners()) != null) {
            this._fireInvalidateEvent(listeners, parentIndex);
        }
        this.saveFavorites();
    }

    public void renameFavoriteItem(TopicTreeNode item, String topicName) {
        if (item != null && topicName != null) {
            Enumeration listeners;
            TopicTreeNode parent;
            int index;
            Topic topic = item.getTopic();
            if (topic instanceof SimpleTopic) {
                SimpleTopic st = (SimpleTopic)topic;
                st.setLabel(topicName);
            }
            if ((index = (parent = item.getParent()).getChildren().indexOf(item)) != -1 && (listeners = parent.getListenerManager().getListeners()) != null) {
                this._fireItemTextChangedEvent(listeners, index);
            }
            this.saveFavorites();
        }
    }

    public void removeFavoriteItem(TopicTreeNode node) {
        if (node != null) {
            int parentIndex;
            TopicTreeNode grandParent;
            TopicTreeNode parent = node.getParent();
            int index = parent.removeChild(node);
            Enumeration listeners = parent.getListenerManager().getListeners();
            if (listeners != null) {
                while (listeners.hasMoreElements()) {
                    EventListener listener = (EventListener)listeners.nextElement();
                    if (!(listener instanceof OneDModelListenerWrapperImpl)) continue;
                    ((OneDModelListenerWrapperImpl)((Object)listener)).itemRemoved(index);
                }
            }
            if (parent.getNumChildren() == 0 && (grandParent = parent.getParent()) != null && (parentIndex = grandParent.getChildren().indexOf(parent)) != -1 && (listeners = grandParent.getListenerManager().getListeners()) != null) {
                this._fireInvalidateEvent(listeners, parentIndex);
            }
            this.saveFavorites();
        }
    }

    public TopicTreeNode getFavoritesRoot() {
        if (!this._initialized) {
            this._initialized = true;
            this.restoreFavorites();
        }
        return this._favoritesNode;
    }

    protected abstract void saveFavorites();

    protected abstract void restoreFavorites();

    protected URL getLocation() {
        return this._location;
    }

    private void _fireAddEvent(Enumeration listeners, int index) {
        while (listeners.hasMoreElements()) {
            EventListener listener = (EventListener)listeners.nextElement();
            if (!(listener instanceof OneDModelListenerWrapperImpl)) continue;
            ((OneDModelListenerWrapperImpl)((Object)listener)).itemAdded(index);
        }
    }

    private void _fireInvalidateEvent(Enumeration listeners, int index) {
        while (listeners.hasMoreElements()) {
            EventListener listener = (EventListener)listeners.nextElement();
            if (!(listener instanceof OneDModelListenerWrapperImpl)) continue;
            ((OneDModelListenerWrapperImpl)((Object)listener)).itemInvalidated(index);
        }
    }

    private void _fireItemTextChangedEvent(Enumeration listeners, int index) {
        while (listeners.hasMoreElements()) {
            EventListener listener = (EventListener)listeners.nextElement();
            if (!(listener instanceof OneDModelListenerWrapperImpl)) continue;
            ((OneDModelListenerWrapperImpl)((Object)listener)).itemTextChanged(index);
        }
    }

    private Topic _createTopic(String text, String targetName, String hstitle, String urlString) {
        Book book = this._library.getBookByName(hstitle);
        IndirectTarget target = null;
        if (targetName != null && book != null) {
            target = new IndirectTarget(book, targetName);
        } else {
            if (urlString == null) {
                if (targetName == null) {
                    return new SimpleTopic(text);
                }
                URL url = this._library.mapIDToURL(targetName);
                if (url != null) {
                    urlString = url.toString();
                }
            }
            if (urlString != null) {
                target = new SimpleURLTarget(null, urlString);
            }
        }
        SimpleTopic topic = new SimpleTopic(text, (Target)target);
        return topic;
    }

    protected class FavoriteItemTopicTreeNode
    extends TopicTreeNode {
        public String target;
        public String hstitle;
        public String url;

        public FavoriteItemTopicTreeNode(String text, String target, String hstitle, String url) {
            super(null, FavoritesModel.this._createTopic(text, target, hstitle, url));
            this.target = target;
            this.hstitle = hstitle;
            this.url = url;
        }
    }
}

