/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.util.ArrayList;
import oracle.help.common.View;
import oracle.help.navigator.Navigator;

public abstract class LazyNavigator
extends Navigator {
    private boolean _isInitialized = false;
    private ArrayList _initialViews;

    protected abstract void doInitializationNow();

    protected abstract void addViewNow(View var1);

    protected abstract void removeViewNow(View var1);

    public void initNavigator(View[] initalViewsArray) {
        if (initalViewsArray != null) {
            this._initialViews = new ArrayList(initalViewsArray.length);
            for (int i = 0; i < initalViewsArray.length; ++i) {
                this._initialViews.add(initalViewsArray[i]);
            }
        } else {
            this._initialViews = new ArrayList(0);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.isInitialized()) {
            this.initializeLazyNavigator();
        }
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void addView(View view) {
        if (this.isInitialized()) {
            this.addViewNow(view);
        } else {
            this._initialViews.add(view);
        }
    }

    public void removeView(View view) {
        if (this.isInitialized()) {
            this.removeViewNow(view);
        } else {
            this._initialViews.remove(view);
        }
    }

    public void initializeLazyNavigator() {
        this._isInitialized = true;
        this.doInitializationNow();
    }

    protected View[] getInitialViewsArray() {
        if (this._initialViews.size() > 0) {
            View[] initialViewsArray = new View[this._initialViews.size()];
            this._initialViews.toArray(initialViewsArray);
            return initialViewsArray;
        }
        return null;
    }
}

