/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.ssh;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.ssh.SSHTunnelConfiguration;
import oracle.jdeveloper.db.ssh.SSHTunnelException;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public abstract class SSHTunnel {
    public String getLocalHost() {
        return "localhost";
    }

    public abstract int getLocalPort();

    public abstract void disconnect() throws SSHTunnelException;

    public String getLocalConnectionURL(DatabaseProvider pro) throws SQLException {
        return SSHTunnelConfiguration.getConfiguration(pro).getLocalConnectionURL(this);
    }

    public Connection wrapConnection(Connection conn) throws SQLException {
        Class<?> clz = conn.getClass();
        return (Connection)Connection.class.cast(Proxy.newProxyInstance(clz.getClassLoader(), DatabaseProviderHelper.getAllInterfaces(clz), (InvocationHandler)new IHandler(this, conn)));
    }

    private class IHandler
    implements InvocationHandler {
        private SSHTunnel m_tunnel;
        private Connection m_conn;

        IHandler(SSHTunnel tunnel, Connection conn) {
            this.m_tunnel = tunnel;
            this.m_conn = conn;
        }

        @Override
        public Object invoke(final Object connProxy, Method method, Object[] args) throws Throwable {
            try {
                Object retval = method.invoke((Object)this.m_conn, args);
                if (retval instanceof Statement) {
                    Object stmtProxy;
                    final Statement stmt = (Statement)retval;
                    Class<?> clz = stmt.getClass();
                    retval = stmtProxy = Proxy.newProxyInstance(clz.getClassLoader(), DatabaseProviderHelper.getAllInterfaces(clz), new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            try {
                                Object retval = method.invoke((Object)stmt, args);
                                if (retval == IHandler.this.m_conn) {
                                    retval = connProxy;
                                }
                                return retval;
                            }
                            catch (InvocationTargetException ite) {
                                throw ite.getCause();
                            }
                        }
                    });
                }
                Object object = retval;
                return object;
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
            finally {
                if (method.getName().equals("close")) {
                    this.m_tunnel.disconnect();
                }
            }
        }
    }
}

