/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComboBox;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.JDBCParameterInfo;
import oracle.jdeveloper.db.adapter.JDBCParametersParser;
import oracle.jdevimpl.db.resource.ConnBundle;

public final class JDBCParametersPanel
implements Traversable {
    private final JDBCParamsTable m_table = new JDBCParamsTable();
    private final Map<String, JDBCParameterInfo> m_infos = new TreeMap<String, JDBCParameterInfo>();
    private final JComboBox m_nameCombo = new JComboBox();
    private ConnectionCreator m_connCreator;

    public Component getComponent() {
        return this.m_table.getComponent();
    }

    public String getHelpID() {
        return "f1_dbconnectionparams_html";
    }

    public void onEntry(TraversableContext dataContext) {
        Properties jdbcParams;
        block7: {
            ConnectionCreator connCreator;
            Properties connProps = (Properties)dataContext.get("NewObject");
            String paramString = connProps.getProperty("parameters");
            jdbcParams = new Properties();
            if (ModelUtil.hasLength((String)paramString)) {
                JDBCParametersParser.parseParameterString((String)paramString, (Properties)jdbcParams);
            }
            if ((connCreator = (ConnectionCreator)dataContext.get(ConnectionCreator.class)) != this.m_connCreator) {
                this.m_infos.clear();
                this.m_nameCombo.removeAllItems();
                this.m_connCreator = connCreator;
                if (this.m_connCreator != null) {
                    try {
                        Collection infos = this.m_connCreator.listJDBCParameterInfos(connProps);
                        if (infos != null) {
                            for (JDBCParameterInfo info : infos) {
                                this.m_infos.put(info.getName(), info);
                            }
                            this.m_table.setKeys(this.m_infos.keySet());
                        }
                    }
                    catch (SQLException sqe) {
                        if (sqe instanceof SQLFeatureNotSupportedException) break block7;
                        DBLog.getLogger((Object)this).warning("Could not populate JDBC parameters: " + sqe.getMessage());
                    }
                }
            }
        }
        this.m_table.setParameters(jdbcParams);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_table.stopCellEditing();
        Properties connProps = (Properties)dataContext.get("NewObject");
        String paramString = JDBCParametersParser.createParameterString((Properties)this.m_table.getParameters());
        if (ModelUtil.hasLength((String)paramString)) {
            connProps.setProperty("parameters", paramString);
        } else {
            connProps.remove("parameters");
        }
    }

    public Object getExitTransition() {
        return null;
    }

    private static Vector createTableDataVector(Properties props) {
        Vector retval = new Vector(props.size());
        TreeSet<String> names = new TreeSet<String>(props.stringPropertyNames());
        for (String name : names) {
            Vector<String> row = new Vector<String>(2);
            row.add(name);
            row.add(props.getProperty(name));
            retval.add(row);
        }
        return retval;
    }

    private static Vector getColumnNames() {
        Vector<String> retval = new Vector<String>();
        retval.add(ConnBundle.get("JDBC_PARAMS_NAME"));
        retval.add(ConnBundle.get("JDBC_PARAMS_VALUE"));
        return retval;
    }

    public static void editParameters(Component parent, ConnectionCreator connCreator, Properties connectionProps) {
        JDBCParametersPanel panel = new JDBCParametersPanel();
        Namespace data = new Namespace();
        data.put("NewObject", (Object)connectionProps);
        data.put(ConnectionCreator.class.getName(), (Object)connCreator);
        TDialogLauncher launcher = new TDialogLauncher(parent, ConnBundle.get("JDBC_PARAMS"), (Traversable)panel, data);
        launcher.initDialog().setName("JDBCParametersDialog");
        launcher.showDialog();
    }

    private class JDBCParamsTable
    extends KeyValueTable {
        JDBCParamsTable() {
            super(ConnBundle.get("JDBC_PARAMS"), "JDBCParametersPanel");
        }

        protected String getAddActionText() {
            return ConnBundle.get("JDBDC_PARAMS_ADD");
        }

        protected String getDeleteActionText() {
            return ConnBundle.get("JDBDC_PARAMS_DEL");
        }

        protected String getDefaultValue(String key) {
            JDBCParameterInfo info;
            String retval = null;
            if (JDBCParametersPanel.this.m_infos != null && (info = (JDBCParameterInfo)JDBCParametersPanel.this.m_infos.get(key)) != null) {
                retval = info.getDefaultValue();
            }
            return retval;
        }

        void setParameters(Properties jdbcParams) {
            this.setModel(new PropertiesTableModel(jdbcParams));
        }

        Properties getParameters() throws TraversalException {
            return ((PropertiesTableModel)this.getModel()).getProperties();
        }

        private class PropertiesTableModel
        extends ExtendedTable.StringTableModel {
            public PropertiesTableModel(Properties props) {
                super((ExtendedTable)JDBCParamsTable.this, JDBCParametersPanel.createTableDataVector(props), JDBCParametersPanel.getColumnNames());
            }

            public Properties getProperties() throws TraversalException {
                Properties retval = new Properties();
                HashSet<String> names = new HashSet<String>();
                for (Vector row : this.getDataVector()) {
                    String name = (String)row.get(0);
                    if (!ModelUtil.hasLength((String)name)) {
                        throw new TraversalException(ConnBundle.get("JDBC_PARAMS_NULL_NAME_ERR"));
                    }
                    if (names.contains(name)) {
                        throw new TraversalException(ConnBundle.format("JDBC_PARAMS_DUP_ERR", name));
                    }
                    if ("user".equals(name) || "password".equals(name)) {
                        throw new TraversalException(ConnBundle.format("JDBC_PARAMS_ILLEGAL", name));
                    }
                    this.checkChars(name);
                    String value = (String)row.get(1);
                    if (!ModelUtil.hasLength((String)value)) {
                        throw new TraversalException(ConnBundle.format("JDBC_PARAMS_NULL_VAL_ERR", name));
                    }
                    this.checkChars(value);
                    retval.setProperty(name, value);
                    names.add(name);
                }
                return retval;
            }

            private void checkChars(String value) throws TraversalException {
                for (char c : new char[]{'=', ',', ';'}) {
                    if (value.indexOf(c) <= 0) continue;
                    throw new TraversalException(ConnBundle.format("JDBC_PARAMS_CHAR_ERR", value, Character.valueOf(c)));
                }
            }
        }
    }
}

