/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.controls.ReadOnlyScrollPane;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.resource.ConnBundle;
import oracle.jdevimpl.db.resource.ConnPropsBundle;

public class ConnectionEditorPanel
extends DefaultTraversablePanel {
    public static final String CONNECTION_NAME_KEY = "ConnectionNameKey";
    public static final String CONNECTION_ORIG_NAME_KEY = "ConnectionOrigNameKey";
    public static final String CONNECTION_SUBTYPES_KEY = "ConnectionsSubTypesKey";
    private JPanel m_headerPanel = new JPanel(new GridBagLayout());
    private JPanel m_customPanelContainer = new JPanel(new BorderLayout());
    private JLabel m_connNameLbl = new JLabel();
    private JLabel m_connTypeLbl = new JLabel();
    private JLabel m_usernameLbl = new JLabel();
    private JLabel m_passwordLbl = new JLabel();
    private JLabel m_roleLbl = new JLabel();
    private JTextField m_connNameFld = new JTextField();
    private DefaultComboBoxModel m_connTypeListModel = new NonNullableComboBoxModel();
    private JComboBox m_connTypeCmb = new JComboBox(this.m_connTypeListModel);
    private ItemListener m_connTypeListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            ConnectionEditorPanel.this.commitConnectionType();
            ConnectionEditorPanel.this.updateUI(ConnectionEditorPanel.this.getSelectedConnectionType());
        }
    };
    private JTextField m_usernameFld = new JTextField();
    private JComboBox m_roleCmb = new JComboBox(new DefaultComboBoxModel());
    private JTextField m_roleFld = new JTextField();
    private List<String> m_preSetRoleList;
    private JPasswordField m_passwordPwd = new JPasswordField();
    private JCheckBox m_savePasswordChk = new JCheckBox();
    private Traversable m_customConnTypeSubPanel;
    private Properties m_connectionProps = null;
    private TraversableContext m_dataContext;
    private boolean m_errorOnEntry;
    private ReadOnlyScrollPane m_feedback = new ReadOnlyScrollPane();
    private JButton m_testBut = new JButton();
    private DatabaseConnections m_connectionsInstance;
    private List<DatabaseConnectionHook.ConnectionType> m_connectionTypes = DatabaseConnectionHook.getHook().getConnectionTypes();

    public ConnectionEditorPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "layout error", e);
        }
    }

    private void layoutComponents() {
        ResourceUtils.resLabel((JLabel)this.m_connNameLbl, (Component)this.m_connNameFld, (String)ConnBundle.get("CONNECTION_NAME_LABEL"));
        ResourceUtils.resLabel((JLabel)this.m_connTypeLbl, (Component)this.m_connTypeCmb, (String)(ConnPropsBundle.get("subtype") + ":"));
        ResourceUtils.resLabel((JLabel)this.m_usernameLbl, (Component)this.m_usernameFld, (String)(ConnPropsBundle.get("user") + ":"));
        ResourceUtils.resLabel((JLabel)this.m_passwordLbl, (Component)this.m_passwordPwd, (String)(ConnPropsBundle.get("password") + ":"));
        ResourceUtils.resButton((AbstractButton)this.m_savePasswordChk, (String)ConnBundle.get("CONNECTION_SAVE_PASSWORD_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.m_testBut, (String)ConnBundle.get("CONNECTION_TEST_LABEL"));
        this.m_feedback.getAccessibleContext().setAccessibleName(ConnBundle.get("DB_CONN_TEST_RESULTS"));
        String pnlName = "ConnectionEditorPanel.";
        this.m_connNameFld.setName("ConnectionEditorPanel.ConnectionName");
        this.m_connTypeCmb.setName("ConnectionEditorPanel.ConnectionType");
        this.m_usernameFld.setName("ConnectionEditorPanel.Username");
        this.m_passwordPwd.setName("ConnectionEditorPanel.Password");
        this.m_roleCmb.setName("ConnectionEditorPanel.Role");
        this.m_roleFld.setName("ConnectionEditorPanel.Role");
        this.m_savePasswordChk.setName("ConnectionEditorPanel.SavePassword");
        this.m_testBut.setName("ConnectionEditorPanel.Test");
        this.m_feedback.getTextArea().setName("ConnectionEditorPanel.TestResults");
        this.populateTypeCombo(null);
        this.setLayout(new GridBagLayout());
        this.add(this.m_headerPanel, this.gbc(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0)));
        this.add(this.m_customPanelContainer, this.gbc(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(15, 0, 0, 0)));
        this.m_testBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionEditorPanel.this.testConnection();
            }
        });
        this.add(this.m_testBut, this.gbc(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0)));
        this.add((Component)this.m_feedback, this.gbc(0, 3, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 0)));
        this.add(Box.createVerticalStrut(60), this.gbc(3, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0)));
        this.setHelpID("f1_dbconnection_html");
    }

    private void populateTypeCombo(String[] allowedSubTypes) {
        this.m_connTypeCmb.removeItemListener(this.m_connTypeListener);
        List<String> allowed = allowedSubTypes == null ? null : Arrays.asList(allowedSubTypes);
        this.m_connTypeListModel.removeAllElements();
        for (DatabaseConnectionHook.ConnectionType ct : this.m_connectionTypes) {
            if (allowed != null && !allowed.contains(ct.getSubtype())) continue;
            this.m_connTypeListModel.addElement(ct);
        }
        this.m_connTypeCmb.addItemListener(this.m_connTypeListener);
        if (allowedSubTypes != null && this.m_connTypeListModel.getSize() == 0) {
            this.populateTypeCombo(null);
        }
    }

    private DatabaseConnectionHook.ConnectionType getSelectedConnectionType() {
        return (DatabaseConnectionHook.ConnectionType)this.m_connTypeCmb.getSelectedItem();
    }

    private DatabaseConnectionHook.ConnectionType findConnectionType(String connType) {
        DatabaseConnectionHook.ConnectionType retval = null;
        for (DatabaseConnectionHook.ConnectionType ct : this.m_connectionTypes) {
            if (!ModelUtil.areEqual((Object)connType, (Object)ct.getSubtype())) continue;
            retval = ct;
            break;
        }
        return retval;
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_connectionProps = (Properties)dataContext.get("NewObject");
        this.m_connectionsInstance = (DatabaseConnections)dataContext.get(DatabaseConnections.class);
        String connName = (String)dataContext.get(CONNECTION_NAME_KEY);
        this.populateTypeCombo((String[])dataContext.get(CONNECTION_SUBTYPES_KEY));
        if (ModelUtil.hasLength((String)connName)) {
            this.m_connNameFld.setText(connName);
            this.m_connNameFld.setEditable(dataContext.get(CONNECTION_ORIG_NAME_KEY) == null);
            String connType = (String)this.m_connectionProps.get("subtype");
            DatabaseConnectionHook.ConnectionType connTypeObject = this.findConnectionType(connType);
            this.m_connTypeCmb.removeItemListener(this.m_connTypeListener);
            this.m_connTypeCmb.setSelectedItem(connTypeObject);
            this.m_connTypeCmb.addItemListener(this.m_connTypeListener);
            this.m_dataContext = dataContext;
            this.m_connNameFld.setEnabled(true);
            this.m_connTypeCmb.setEnabled(true);
        }
        this.initialiseUI();
        this.m_connNameFld.requestFocusInWindow();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
        if (!this.m_errorOnEntry) {
            this.m_customConnTypeSubPanel.onExit(this.m_dataContext);
        }
    }

    private void initialiseUI() {
        this.m_headerPanel.removeAll();
        this.m_customPanelContainer.removeAll();
        DatabaseConnectionHook.ConnectionType connType = this.getSelectedConnectionType();
        this.m_headerPanel.add((Component)this.m_connNameLbl, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connNameFld, this.gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 12, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connTypeLbl, this.gbc(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connTypeCmb, this.gbc(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
        if (this.m_connectionProps != null) {
            this.addUserNamePasswordPanel(connType, false);
            this.addCustomPanel(connType);
        } else {
            this.m_connNameFld.setEnabled(false);
            this.m_connNameFld.setText("");
            this.m_connTypeCmb.setEnabled(false);
        }
        this.updateTestConnection(connType);
        this.validateAndPack();
    }

    private void addCustomPanel(DatabaseConnectionHook.ConnectionType connType) {
        this.m_customConnTypeSubPanel = null;
        try {
            Class<? extends Traversable> clz = connType.getPanelClass();
            this.m_customConnTypeSubPanel = clz.newInstance();
        }
        catch (Exception e) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Failed to instantiate panel", e);
        }
        if (this.m_customConnTypeSubPanel != null) {
            StringBuilder sb = new StringBuilder(" ");
            sb.append(ConnBundle.format("CONNECTION_TYPE_BORDER_TITLE", this.getSelectedConnectionType().getDisplayName()));
            sb.append(" ");
            MatteBorder empty = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY);
            TitledBorder border = BorderFactory.createTitledBorder(empty, sb.toString());
            this.m_customPanelContainer.setBorder(border);
            this.m_customPanelContainer.add(Box.createHorizontalStrut(540), "North");
            this.m_customPanelContainer.add(this.m_customConnTypeSubPanel.getComponent(), "Center");
            try {
                this.m_customConnTypeSubPanel.onEntry(this.m_dataContext);
                this.m_errorOnEntry = false;
            }
            catch (Exception e) {
                DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Error entering connection panel.", e);
                this.m_errorOnEntry = true;
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                JTextArea errorText = new JTextArea(sw.getBuffer().toString());
                errorText.setEditable(false);
                this.m_customPanelContainer.add((Component)new JScrollPane(errorText), "Center");
            }
        }
    }

    private void validateAndPack() {
        this.validate();
        Window win = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)((Object)this));
        if (win != null) {
            win.pack();
        }
        this.repaint();
    }

    private void testConnection() {
        try {
            this.onExit(this.m_dataContext);
            this.m_feedback.setText(ConnBundle.get("CONNECTION_TEST_WORKING"), false);
            ConnectionTester ct = new ConnectionTester(this.m_connNameFld.getText());
            ct.testConnection(this.m_connectionsInstance, this.m_connectionProps);
        }
        catch (TraversalException te) {
            this.m_feedback.setText(te.getMessage(), true);
        }
    }

    private void commit() throws MissingDBConnValueException {
        ConnectionCreator cc;
        Collection keys;
        MissingDBConnValueException.check(this.m_connNameFld.getText(), this.m_connNameLbl);
        this.m_dataContext.put(CONNECTION_NAME_KEY, (Object)this.m_connNameFld.getText());
        DatabaseConnectionHook.ConnectionType ct = this.getSelectedConnectionType();
        String connType = ct.getSubtype();
        if (ModelUtil.areDifferent((Object)connType, (Object)this.m_connectionProps.getProperty("subtype"))) {
            this.commitConnectionType();
        }
        if ((keys = (cc = ct.getConnectionCreator()).listAllowedProperties()).contains("user")) {
            if (cc.listRequiredProperties().contains("user")) {
                MissingDBConnValueException.check(this.m_usernameFld.getText(), this.m_usernameLbl);
            }
            this.m_connectionProps.remove("user");
            this.m_connectionProps.put("user", this.m_usernameFld.getText());
        }
        if (keys.contains("role")) {
            this.m_connectionProps.remove("role");
            String roleName = null;
            roleName = this.m_preSetRoleList == null ? this.m_roleFld.getText() : (this.m_roleCmb.isEditable() ? (String)this.m_roleCmb.getEditor().getItem() : (String)this.m_roleCmb.getSelectedItem());
            if (ModelUtil.hasLength((String)roleName)) {
                this.m_connectionProps.put("role", roleName);
            }
        }
        if (keys.contains("password")) {
            this.m_connectionProps.remove("password");
            char[] passwd = this.m_passwordPwd.getPassword();
            if (passwd != null && passwd.length > 0) {
                this.m_connectionProps.put("password", new String(passwd));
            }
            this.m_connectionProps.remove("SavePassword");
            if (!this.m_savePasswordChk.isSelected()) {
                this.m_connectionProps.put("SavePassword", Boolean.FALSE.toString());
            }
        }
    }

    private void commitConnectionType() {
        String connType = this.getSelectedConnectionType().getSubtype();
        String username = (String)this.m_connectionProps.get("user");
        String password = (String)this.m_connectionProps.get("password");
        this.m_connectionProps.clear();
        this.m_connectionProps.put("subtype", connType);
        if (username != null) {
            this.m_connectionProps.put("user", username);
        }
        if (password != null) {
            this.m_connectionProps.put("password", password);
        }
    }

    private void addUserNamePasswordPanel(DatabaseConnectionHook.ConnectionType connType, boolean remove) {
        boolean saveShown = false;
        if (remove) {
            Component[] comp = this.m_headerPanel.getComponents();
            int i = this.m_headerPanel.getComponentCount();
            while (--i >= 0) {
                if (comp[i] == this.m_connNameFld || comp[i] == this.m_connNameLbl || comp[i] == this.m_connTypeCmb || comp[i] == this.m_connTypeLbl) continue;
                this.m_headerPanel.remove(i);
            }
        }
        JPanel usernameAndPasswordPanel = new JPanel();
        usernameAndPasswordPanel.setLayout(new GridBagLayout());
        int unpwSize = 1;
        Collection keys = connType.getConnectionCreator().listAllowedProperties();
        if (keys.contains("user")) {
            this.m_usernameFld.setText((String)this.m_connectionProps.get("user"));
            this.m_headerPanel.add((Component)this.m_usernameLbl, this.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0)));
            usernameAndPasswordPanel.add((Component)this.m_usernameFld, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
        }
        if (keys.contains("password")) {
            this.m_passwordPwd.setText((String)this.m_connectionProps.get("password"));
            this.m_headerPanel.add((Component)this.m_passwordLbl, this.gbc(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0)));
            usernameAndPasswordPanel.add((Component)this.m_passwordPwd, this.gbc(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
            unpwSize = 2;
            JPanel pnlPasswdCheckBoxes = new JPanel(new GridBagLayout());
            String saveValue = (String)this.m_connectionProps.get("SavePassword");
            pnlPasswdCheckBoxes.add((Component)this.m_savePasswordChk, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
            saveShown = true;
            boolean saveCheck = saveValue == null ? true : Boolean.valueOf(saveValue);
            this.m_savePasswordChk.setSelected(saveCheck);
            pnlPasswdCheckBoxes.add(Box.createHorizontalGlue(), this.gbc(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
            this.m_headerPanel.add((Component)pnlPasswdCheckBoxes, this.gbc(2, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 24, 0, 5)));
        }
        this.m_headerPanel.add((Component)usernameAndPasswordPanel, this.gbc(1, 3, 1, unpwSize, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
        if (keys.contains("role")) {
            this.m_preSetRoleList = connType.getPresetRoles();
            String roleValue = (String)this.m_connectionProps.get("role");
            this.m_headerPanel.add((Component)this.m_roleLbl, this.gbc(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0)));
            double roleWeight = 1.0;
            GridBagConstraints roleCons = this.gbc(3, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 5));
            String roleLabel = ConnPropsBundle.get("role") + ":";
            if (this.m_preSetRoleList == null) {
                this.m_headerPanel.add((Component)this.m_roleFld, roleCons);
                ResourceUtils.resLabel((JLabel)this.m_roleLbl, (Component)this.m_roleFld, (String)roleLabel);
                this.m_roleFld.setText(roleValue);
            } else {
                this.m_headerPanel.add((Component)this.m_roleCmb, roleCons);
                ResourceUtils.resLabel((JLabel)this.m_roleLbl, (Component)this.m_roleCmb, (String)roleLabel);
                DefaultComboBoxModel boxModel = (DefaultComboBoxModel)this.m_roleCmb.getModel();
                boxModel.removeAllElements();
                boxModel.addElement("");
                for (String role : this.m_preSetRoleList) {
                    boxModel.addElement(role);
                }
                boolean anyRole = connType.allowAnyRole();
                this.m_roleCmb.setEditable(anyRole);
                if (anyRole) {
                    this.m_roleCmb.getEditor().setItem(roleValue);
                } else {
                    this.m_roleCmb.setSelectedItem(roleValue);
                }
            }
        }
    }

    private void updateTestConnection(DatabaseConnectionHook.ConnectionType connTypeObject) {
        boolean showConnectionTest = connTypeObject.showTestConnection();
        this.m_testBut.setVisible(showConnectionTest);
        this.m_feedback.setVisible(showConnectionTest);
        this.m_feedback.setText("", false);
    }

    private void updateUI(DatabaseConnectionHook.ConnectionType connTypeObject) {
        this.updateTestConnection(connTypeObject);
        this.addUserNamePasswordPanel(connTypeObject, true);
        this.m_customPanelContainer.removeAll();
        this.addCustomPanel(connTypeObject);
        this.validateAndPack();
    }

    public Component getDefaultFocusComponent() {
        return this.m_connNameFld;
    }

    private class ConnectionTester
    extends ProgressRunnable {
        private DatabaseConnections m_connectionsInstance;
        private Properties m_connectionProperties;
        private String m_message = null;

        public ConnectionTester(String connName) {
            this.setTitle(ConnBundle.get("TITLE_CONNECTING"));
            this.setMessage(ConnBundle.format("MESSAGE_CONNECTING", connName));
        }

        protected Object doWork() throws ConnectionException {
            this.m_connectionsInstance.testConnection(this.m_connectionProperties, new DatabaseConnections.DatabaseConnectionTester(){

                @Override
                public void testConnection(Connection conn) throws ConnectionException {
                    StringBuilder msg = new StringBuilder();
                    msg.append(ConnBundle.get("CONNECTION_TEST_SUCCESS")).append("\n");
                    try {
                        DatabaseMetaData md = conn.getMetaData();
                        String name = md.getDatabaseProductName();
                        String ver = md.getDatabaseProductVersion();
                        msg.append(ConnBundle.get("CONNECTION_TEST_CONNECTED")).append(" ");
                        if (!ver.contains(name)) {
                            msg.append(name).append(" ");
                        }
                        msg.append(ver);
                    }
                    catch (SQLException sqe) {
                        msg.append(sqe.getMessage());
                    }
                    msg.append("\n");
                    try {
                        Database db = DatabaseFactory.createStandaloneDatabase((String)ConnectionEditorPanel.this.m_connNameFld.getText(), (Connection)conn);
                        String apidesc = db.getDescriptor().getDatabaseName();
                        msg.append(ConnBundle.get("CONNECTION_TEST_RECOGN_AS")).append(" ").append(apidesc);
                    }
                    catch (DBException dbe) {
                        msg.append(dbe.getMessage());
                    }
                    ConnectionTester.this.m_message = msg.toString();
                }
            });
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void testConnection(DatabaseConnections connectionsInstance, Properties connectionProperties) {
            this.m_connectionsInstance = connectionsInstance;
            this.m_connectionProperties = new Properties();
            this.m_connectionProperties.putAll((Map<?, ?>)connectionProperties);
            this.m_connectionProperties.setProperty("SavePassword", Boolean.TRUE.toString());
            try {
                this.start(SwingUtilities.isEventDispatchThread());
            }
            catch (ProgressException e) {
                Exception ex = (Exception)e.getCause();
                while (ex instanceof DBException) {
                    Throwable cause = ex.getCause();
                    if (cause == null || !(cause instanceof Exception)) continue;
                    ex = (Exception)cause;
                }
                this.m_message = ex.getMessage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionEditorPanel.this.m_feedback.setText(ConnectionTester.this.m_message, true);
                    }
                });
            }
            catch (Exception e2) {
                this.m_message = e2.getMessage();
                {
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        protected void doCancel() {
            super.doCancel();
            this.m_message = ConnBundle.get("CONNECTION_TEST_CANCELLED");
        }
    }
}

