/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHTunnelManager;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.panels.ConnectionComponentCache;
import oracle.jdevimpl.db.panels.JDBCParametersPanel;
import oracle.jdevimpl.db.panels.SSHTunnelConfigurationPanel;
import oracle.jdevimpl.db.resource.ConnBundle;

public abstract class AbstractConnectionDetailsPanel
extends ConnectionComponentCache
implements Traversable {
    private JPanel m_panel;
    private JCheckBox m_chkCustomURL;
    private JTextArea m_txtCustomURL;
    private JScrollPane m_spCustomURL;
    private String m_defaultURL;
    private JButton m_btnSSH;
    private JButton m_btnParams;
    private JPanel m_detailsPanel;
    private Properties m_connectionProps;

    public AbstractConnectionDetailsPanel(String subType, String panelName) {
        super(subType, panelName);
    }

    public String getHelpID() {
        return "f1_dbconnection_html";
    }

    public Component getComponent() {
        if (this.m_panel == null) {
            this.m_panel = new JPanel();
            this.m_panel.setName(this.getPanelName());
            DBUILayoutHelper layout = new DBUILayoutHelper(this.m_panel);
            layout.setMargins(0);
            this.layoutComponents(this.m_panel, layout, this.getResourceHelper());
            layout.layout();
        }
        return this.m_panel;
    }

    protected void layoutComponents(JPanel panel, DBUILayoutHelper layout, DBUIResourceHelper resHelp) {
        boolean custom;
        this.m_detailsPanel = this.createDetailsPanel(resHelp);
        final ConnectionCreator connCreator = this.getConnectionCreator();
        Collection props = connCreator.listAllowedProperties();
        if (connCreator instanceof SSHConnectionCreator && SSHTunnelManager.getInstance() != null) {
            this.m_btnSSH = new JButton();
            resHelp.resButton((AbstractButton)this.m_btnSSH, ConnBundle.get("SSH_BUTTON"), "SSH");
            this.m_btnSSH.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractConnectionDetailsPanel.this.m_connectionProps != null) {
                        SSHTunnelConfigurationPanel.editSSHConfig(AbstractConnectionDetailsPanel.this.m_detailsPanel, AbstractConnectionDetailsPanel.this.getConnectionSubType(), AbstractConnectionDetailsPanel.this.m_connectionProps);
                    }
                }
            });
        }
        if (props.contains("parameters")) {
            this.m_btnParams = new JButton();
            resHelp.resButton((AbstractButton)this.m_btnParams, this.getPropertyLabelText("parameters").replace(":", "..."), "Parameters");
            this.m_btnParams.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractConnectionDetailsPanel.this.m_connectionProps != null) {
                        AbstractConnectionDetailsPanel.this.commitConnectionDetails(AbstractConnectionDetailsPanel.this.m_connectionProps, AbstractConnectionDetailsPanel.this.isCustom());
                        JDBCParametersPanel.editParameters(AbstractConnectionDetailsPanel.this.m_detailsPanel, connCreator, AbstractConnectionDetailsPanel.this.m_connectionProps);
                        AbstractConnectionDetailsPanel.this.populateConnectionDetails(AbstractConnectionDetailsPanel.this.m_connectionProps);
                    }
                }
            });
        }
        if (custom = props.contains("customUrl")) {
            JComponent comp;
            this.m_txtCustomURL = new JTextArea();
            this.m_txtCustomURL.setLineWrap(true);
            this.m_spCustomURL = new JScrollPane(this.m_txtCustomURL, 20, 31);
            if (this.m_detailsPanel == null) {
                JLabel label = new JLabel();
                resHelp.resLabel(label, (Component)this.m_txtCustomURL, this.getPropertyLabelText("customUrl"), "URL");
                comp = label;
            } else {
                this.m_chkCustomURL = new JCheckBox();
                this.m_chkCustomURL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractConnectionDetailsPanel.this.setComponentsVisible(AbstractConnectionDetailsPanel.this.m_chkCustomURL.isSelected());
                    }
                });
                resHelp.resButton((AbstractButton)this.m_chkCustomURL, ConnBundle.get("CONN_CUSTOM_URL"), "Advanced");
                resHelp.setName((Component)this.m_txtCustomURL, "URL");
                comp = this.m_chkCustomURL;
            }
            layout.add((Component)comp);
        }
        if (this.m_btnSSH != null || this.m_btnParams != null) {
            DBUILayoutHelper buttonsLayout = layout.newChildHelper(custom ? 1 : 2, 1, true, false);
            buttonsLayout.add(Box.createHorizontalGlue(), 1, 1, true, false);
            if (this.m_btnParams != null) {
                buttonsLayout.add((Component)this.m_btnParams);
            }
            if (this.m_btnSSH != null) {
                buttonsLayout.add((Component)this.m_btnSSH);
            }
        }
        layout.nextRow();
        if (custom) {
            layout.add((Component)this.m_spCustomURL, 2, 1, true, true);
            layout.nextRow();
        }
        if (this.m_detailsPanel != null) {
            layout.add((Component)this.m_detailsPanel, 2, 1, true, true);
            layout.nextRow();
        }
    }

    protected abstract JPanel createDetailsPanel(DBUIResourceHelper var1);

    private void setComponentsVisible(boolean isCustomURL) {
        if (this.m_txtCustomURL != null) {
            this.resetCustomURL();
            if (this.m_detailsPanel != null) {
                if (isCustomURL) {
                    this.m_detailsPanel.setVisible(false);
                    this.m_spCustomURL.setVisible(true);
                } else {
                    this.m_spCustomURL.setVisible(false);
                    this.m_detailsPanel.setVisible(true);
                }
                this.m_panel.validate();
                this.m_panel.repaint();
            }
        }
    }

    protected final void resetCustomURL() {
        String curr;
        if (this.isCustom() && (!ModelUtil.hasLength((String)(curr = this.m_txtCustomURL.getText())) || ModelUtil.areEqual((Object)curr, (Object)this.m_defaultURL))) {
            this.m_defaultURL = this.getDefaultURL();
            this.m_txtCustomURL.setText(this.m_defaultURL);
        }
    }

    protected String getDefaultURL() {
        String retval = "jdbc:";
        String protocol = this.getDefaultProtocol();
        if (ModelUtil.hasLength((String)protocol)) {
            retval = retval + protocol + ':';
        }
        return retval;
    }

    protected String getDefaultProtocol() {
        String retval = null;
        Map<String, String> dcs = this.getConnectionType().getDriverClasses();
        if (!dcs.isEmpty()) {
            retval = dcs.entrySet().iterator().next().getValue();
        }
        return retval;
    }

    public final void onEntry(TraversableContext dataContext) {
        this.m_connectionProps = (Properties)dataContext.get("NewObject");
        this.populateConnectionDetails(this.m_connectionProps);
    }

    @Override
    protected void populateConnectionDetails(Properties connectionProps) {
        boolean custom;
        String url = connectionProps.getProperty("customUrl");
        boolean bl = custom = url != null;
        if (this.m_txtCustomURL != null) {
            this.m_txtCustomURL.setText(url);
            if (this.m_chkCustomURL != null) {
                this.m_chkCustomURL.setSelected(custom);
            }
        }
        super.populateConnectionDetails(connectionProps);
        this.setComponentsVisible(custom);
    }

    public final void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_connectionProps = (Properties)dataContext.get("NewObject");
        boolean isCustom = this.isCustom();
        this.commitConnectionDetails(this.m_connectionProps, isCustom);
        this.validateConnectionDetails(this.m_connectionProps, isCustom);
    }

    private boolean isCustom() {
        return this.m_detailsPanel == null || this.m_chkCustomURL != null && this.m_chkCustomURL.isSelected();
    }

    protected void validateConnectionDetails(Properties connectionProps, boolean isCustom) throws TraversalException {
        DatabaseConnectionHook.ConnectionType connType = this.getConnectionType();
        if (isCustom) {
            String url = connectionProps.getProperty("customUrl");
            MissingDBConnValueException.check(url, connType.getPropertyDisplayName("customUrl"));
        } else {
            Collection required = this.getConnectionCreator().listRequiredProperties();
            for (String name : required) {
                MissingDBConnValueException.check(connectionProps.getProperty(name), connType.getPropertyDisplayName(name));
                String port = connectionProps.getProperty("port");
                if (!ModelUtil.hasLength((String)port) || !port.equals(String.valueOf(0))) continue;
                MissingDBConnValueException.check(null, connType.getPropertyDisplayName("port"));
            }
        }
    }

    protected void commitConnectionDetails(Properties connectionProps, boolean isCustom) {
        if (isCustom) {
            this.setProperty(connectionProps, "customUrl", this.getTrimmedText(this.m_txtCustomURL));
            for (String prop : this.getRegisteredProperties()) {
                connectionProps.remove(prop);
            }
        } else {
            connectionProps.remove("customUrl");
            super.commitConnectionDetails(connectionProps);
        }
    }

    public Object getExitTransition() {
        return null;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    protected void ensureDialogSize() {
        if (this.m_panel != null) {
            this.m_panel.validate();
            Window win = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.m_panel);
            if (win != null) {
                win.pack();
            }
        }
    }
}

