/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.extension.rules;

import java.sql.SQLException;
import java.util.Map;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Element;
import oracle.ideimpl.db.extension.rules.AbstractRuleFunction;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class ContextHasConnection
extends AbstractRuleFunction {
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        boolean retval = false;
        Element elem = ruleContext.getIdeContext().getElement();
        if (elem != null) {
            ConnectionInfo ci;
            DatabaseProvider ref;
            String storeName = DBObjectNodeUtil.getStoreName((Object)elem);
            String connName = DBObjectNodeUtil.getConnectionName((Object)elem);
            if (storeName != null && connName != null && (ref = (ci = new ConnectionInfo(storeName, connName)).getReferenceable()) != null) {
                String requiredDriver;
                retval = true;
                String requiredSubtype = this.getParameterValue("subtype", parameters);
                if (requiredSubtype != null) {
                    String subtype = ref.getProperty("subtype");
                    retval = ModelUtil.areEqual((Object)requiredSubtype, (Object)subtype);
                }
                if (retval && (requiredDriver = this.getParameterValue("driverClass", parameters)) != null) {
                    try {
                        String driver = ref.getDriverClassName();
                        retval = ModelUtil.areEqual((Object)requiredDriver, (Object)driver);
                    }
                    catch (SQLException sqe) {
                        retval = false;
                    }
                }
            }
        }
        return retval;
    }
}

