/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.panels.Traversable;
import oracle.ideimpl.db.extension.AbstractExtensionHook;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.StoreListener;
import oracle.jdeveloper.db.StoreProvider;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.resource.ConnPropsBundle;

public class DatabaseConnectionHook
extends AbstractExtensionHook {
    private static final String HOOK = "database-connection-hook";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/db", "database-connection-hook");
    private static final String STORE_PROVIDERS = "store-providers";
    private static final String STORE_PROVIDER = "store-provider";
    private static final String STORE_LISTENERS = "store-listeners";
    private static final String STORE_LISTENER = "store-listener";
    private static final String DRIVER_ENTRIES = "jdbc-driver-entries";
    private static final String DRIVER_ENTRY = "jdbc-driver-entry";
    private static final String DRIVER_CLASS = "driver-class";
    private static final String LIBRARY_NAME = "library-name";
    private static final String FORCE_EXT_INIT = "forceExtensionInitialization";
    private static final String CONNECTION_TYPES = "connection-types";
    private static final String CONNECTION_TYPE = "connection-type";
    private static final String SUBTYPE = "subtype";
    private static final String CONNECTION_CREATOR = "connection-creator";
    private static final String DISPLAY_NAME = "display-name";
    private static final String PROPERTY_BUNDLE = "property-bundle";
    private static final String PANEL_CLASS = "panel-class";
    private static final String ROLE_LIST = "role-list";
    private static final String ROLE = "role";
    private static final String ANY = "any";
    private static final String DRIVER_CLASSES = "driver-classes";
    private static final String JDBC_PROTOCOL = "jdbc-protocol";
    private final List<ConnectionType> m_connTypes = new CopyOnWriteArrayList<ConnectionType>();
    private final List<DriverEntry> m_driverEntries = new CopyOnWriteArrayList<DriverEntry>();

    protected void initialize() {
        this.createChildList(STORE_PROVIDERS, STORE_PROVIDER, StoreProvider.class);
        this.createChildList(STORE_LISTENERS, STORE_LISTENER, StoreListener.class);
    }

    protected void processHashStructure(HashStructure hash) {
        super.processHashStructure(hash);
        ArrayList<DriverEntry> drivers = null;
        for (HashStructure deHash : this.getChildList(hash, DRIVER_ENTRIES, DRIVER_ENTRY)) {
            if (drivers == null) {
                drivers = new ArrayList<DriverEntry>();
            }
            drivers.add(new DriverEntry(deHash));
        }
        if (drivers != null) {
            this.m_driverEntries.addAll(drivers);
        }
        ArrayList<ConnectionType> newTypes = null;
        for (HashStructure ctHash : this.getChildList(hash, CONNECTION_TYPES, CONNECTION_TYPE)) {
            if (newTypes == null) {
                newTypes = new ArrayList<ConnectionType>();
            }
            newTypes.add(new ConnectionType(ctHash));
        }
        if (newTypes != null) {
            this.m_connTypes.addAll(newTypes);
        }
    }

    public List<StoreProvider> getStoreProviders() {
        this.checkListenerInit();
        return this.getList(StoreProvider.class);
    }

    public List<StoreListener> getStoreListeners() {
        this.checkListenerInit();
        return this.getList(StoreListener.class);
    }

    public List<DriverEntry> getDriverEntries() {
        this.checkListenerInit();
        return Collections.unmodifiableList(this.m_driverEntries);
    }

    public void checkExtensionLoaded(String driverClass) {
        for (DriverEntry entry : this.getDriverEntries()) {
            if (!ModelUtil.areEqual((Object)entry.getDriverClass(), (Object)driverClass)) continue;
            entry.checkExtensionLoaded();
            break;
        }
    }

    public List<ConnectionType> getConnectionTypes() {
        this.checkListenerInit();
        ArrayList<ConnectionType> retval = new ArrayList<ConnectionType>(this.m_connTypes);
        Collections.sort(retval);
        return retval;
    }

    public static synchronized DatabaseConnectionHook getHook() {
        return (DatabaseConnectionHook)DatabaseConnectionHook.findHook((ElementName)NAME, DatabaseConnectionHook.class);
    }

    public class DriverEntry
    extends HashStructureAdapter {
        private DriverEntry(HashStructure hash) {
            super(hash);
        }

        public String getDriverClass() {
            return DatabaseConnectionHook.this.getText(this.getHashStructure(), DatabaseConnectionHook.DRIVER_CLASS);
        }

        public String getLibraryName() {
            return DatabaseConnectionHook.this.getText(this.getHashStructure(), DatabaseConnectionHook.LIBRARY_NAME);
        }

        private void checkExtensionLoaded() {
            if (this._hash.getBoolean(DatabaseConnectionHook.FORCE_EXT_INIT, false)) {
                DatabaseConnectionHook.this.fullyLoadExtension(this._hash, "Triggered by use of JDBC driver " + this.getDriverClass());
            }
        }
    }

    public class ConnectionType
    extends HashStructureAdapter
    implements Comparable<ConnectionType> {
        private ConnectionCreator m_cc;

        private ConnectionType(HashStructure hash) {
            super(hash);
        }

        public String toString() {
            String retval = this.getDisplayName();
            if (!ModelUtil.hasLength((String)retval)) {
                retval = this.getSubtype();
            }
            return retval;
        }

        public String getSubtype() {
            return DatabaseConnectionHook.this.getText(this.getHashStructure(), DatabaseConnectionHook.SUBTYPE);
        }

        public Class<? extends Traversable> getPanelClass() {
            return DatabaseConnectionHook.this.loadClass(this.getHashStructure(), DatabaseConnectionHook.PANEL_CLASS, Traversable.class);
        }

        public Map<String, String> getDriverClasses() {
            LinkedHashMap<String, String> retval = new LinkedHashMap<String, String>();
            for (HashStructure dcHash : DatabaseConnectionHook.this.getChildList(this.getHashStructure(), DatabaseConnectionHook.DRIVER_CLASSES, DatabaseConnectionHook.DRIVER_CLASS)) {
                String clz = HashStructureHook.getText((HashStructure)dcHash);
                if (clz == null) continue;
                retval.put(clz, dcHash.getString(DatabaseConnectionHook.JDBC_PROTOCOL));
            }
            return retval;
        }

        public String getPropertyDisplayName(String prop) {
            return StringUtils.stripMnemonic((String)this.getPropNLS(prop));
        }

        public String getPropertyLabelText(String prop) {
            return this.getPropNLS(prop) + ":";
        }

        private String getPropNLS(String prop) {
            String retval = null;
            MetaClass bundleClz = DatabaseConnectionHook.this.getSingleChildMeta(this.getHashStructure(), DatabaseConnectionHook.PROPERTY_BUNDLE, ResourceBundle.class);
            if (bundleClz != null) {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(bundleClz.getClassName(), Locale.getDefault(), bundleClz.getClassLoader());
                    retval = this.getResourceNoFail(bundle, prop);
                }
                catch (MissingResourceException mre) {
                    DatabaseConnectionHook.this.logError(this.getHashStructure(), mre.getMessage());
                }
            }
            if (retval == null) {
                retval = this.getResourceNoFail(ConnPropsBundle.getBundle(), prop);
            }
            return retval == null ? prop : retval;
        }

        private String getResourceNoFail(ResourceBundle bundle, String res) {
            String retval;
            try {
                retval = bundle.getString(res);
            }
            catch (MissingResourceException mre) {
                retval = null;
            }
            return retval;
        }

        public String getDisplayName() {
            return DatabaseConnectionHook.this.getText(this.getHashStructure(), DatabaseConnectionHook.DISPLAY_NAME);
        }

        public ConnectionCreator getConnectionCreator() {
            if (this.m_cc == null) {
                MetaClass childMeta = DatabaseConnectionHook.this.getSingleChildMeta(this.getHashStructure(), DatabaseConnectionHook.CONNECTION_CREATOR, ConnectionCreator.class);
                try {
                    this.m_cc = (ConnectionCreator)childMeta.newInstance();
                }
                catch (Throwable e) {
                    DBLog.getLogger((Object)this).warning(e.getMessage());
                }
            }
            return this.m_cc;
        }

        public boolean allowAnyRole() {
            boolean retval = true;
            HashStructure roleList = this.getHashStructure().getHashStructure(DatabaseConnectionHook.ROLE_LIST);
            if (roleList != null && roleList.containsKey(DatabaseConnectionHook.ANY)) {
                retval = roleList.getBoolean(DatabaseConnectionHook.ANY);
            }
            return retval;
        }

        public List<String> getPresetRoles() {
            ArrayList<String> retval = new ArrayList<String>();
            for (HashStructure entry : DatabaseConnectionHook.this.getChildList(this.getHashStructure(), DatabaseConnectionHook.ROLE_LIST, DatabaseConnectionHook.ROLE)) {
                String txt = HashStructureHook.getText((HashStructure)entry);
                if (!ModelUtil.hasLength((String)txt)) continue;
                retval.add(txt);
            }
            return retval;
        }

        public boolean showTestConnection() {
            boolean retval = true;
            String text = DatabaseConnectionHook.this.getText(this.getHashStructure(), "show-test", false);
            if (text != null) {
                retval = !text.equalsIgnoreCase("false");
            }
            return retval;
        }

        @Override
        public int compareTo(ConnectionType o) {
            String otherName;
            String name;
            int retval = o == null ? -1 : (ModelUtil.areEqual((Object)(name = this.getDisplayName()), (Object)(otherName = o.getDisplayName())) ? 0 : (name == null ? 1 : (otherName == null ? -1 : name.compareTo(otherName))));
            return retval;
        }
    }
}

