/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.explorer;

import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.JDBCParametersParser;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;

public class DBConnectionExplorer
extends Explorer {
    private final JTree m_tree = new JTree();
    private final JScrollPane m_gui = new JScrollPane(this.m_tree);
    private final ConnectionsListener m_listener;
    private DatabaseConnections m_store;
    private ConnectionInfo m_current;

    public DBConnectionExplorer() {
        this.m_tree.setCellRenderer(new DBCRend());
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_listener = new ConnectionsListener(){

            @Override
            public void connectionAdded(ConnectionsEvent event) {
            }

            @Override
            public void connectionRemoved(ConnectionsEvent event) {
            }

            @Override
            public void connectionUpdated(ConnectionsEvent event) {
                ConnectionInfo current = DBConnectionExplorer.this.m_current;
                if (current != null && ModelUtil.areEqual((Object)current.getConnectionName(), (Object)event.getName())) {
                    DBConnectionExplorer.this.setConnectionInfo(current);
                }
            }
        };
    }

    public void stateChanged(int state) {
        DatabaseConnections store = this.m_store;
        if (state != 0 && store != null) {
            store.removeListener(this.m_listener);
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
        ConnectionInfo info = stores.getCurrentConnectionInfo(context);
        this.setConnectionInfo(info);
        if (info != null) {
            this.m_store = stores.getStore(info.getStoreName());
            this.m_store.addListener(this.m_listener);
        }
    }

    private void setConnectionInfo(ConnectionInfo info) {
        DefaultMutableTreeNode root;
        this.m_current = info;
        if (info == null) {
            root = new DefaultMutableTreeNode("");
        } else {
            Properties connectionProps;
            root = new DefaultMutableTreeNode(info.getConnectionName());
            DatabaseProvider dp = info.getReferenceable();
            if (dp != null && (connectionProps = dp.getProperties()) != null) {
                ConnectionCreator cc;
                String subtype = connectionProps.getProperty("subtype");
                DatabaseConnectionHook.ConnectionType connType = null;
                DatabaseConnectionHook.ConnectionType genericJDBCType = null;
                for (DatabaseConnectionHook.ConnectionType ct : DatabaseConnectionHook.getHook().getConnectionTypes()) {
                    String ctSubtype = ct.getSubtype();
                    if (ModelUtil.hasLength((String)subtype) && subtype.equals(ctSubtype)) {
                        connType = ct;
                    }
                    if (!"thirdParty".equals(ctSubtype)) continue;
                    genericJDBCType = ct;
                }
                DatabaseConnectionHook.ConnectionType typeToUse = connType == null ? genericJDBCType : connType;
                ConnectionCreator connectionCreator = cc = typeToUse == null ? null : typeToUse.getConnectionCreator();
                if (cc != null) {
                    root.add(new DefaultMutableTreeNode(typeToUse.getPropertyDisplayName("subtype") + " : " + (connType == null ? subtype : connType.getDisplayName())));
                    Set<String> props = connectionProps.stringPropertyNames();
                    props.remove("subtype");
                    props.remove("password");
                    props.remove("SavePassword");
                    Iterator<String> iter = props.iterator();
                    while (iter.hasNext()) {
                        if (!cc.isPassword(iter.next())) continue;
                        iter.remove();
                    }
                    for (DefaultMutableTreeNode child : this.getPropertyNodes(connectionProps, props, typeToUse)) {
                        root.add(child);
                    }
                }
            }
        }
        this.m_tree.setModel(new DefaultTreeModel(root));
        for (int row = 0; row < this.m_tree.getRowCount(); ++row) {
            this.m_tree.expandRow(row);
        }
    }

    private Collection<DefaultMutableTreeNode> getPropertyNodes(Properties connectionProps, Set<String> props, DatabaseConnectionHook.ConnectionType connType) {
        TreeSet<DefaultMutableTreeNode> children = new TreeSet<DefaultMutableTreeNode>(new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
                return String.valueOf(o1).compareTo(String.valueOf(o2));
            }
        });
        for (String prop : props) {
            String label = connType.getPropertyDisplayName(prop);
            String propVal = connectionProps.getProperty(prop);
            if (!ModelUtil.hasLength((String)propVal)) continue;
            if ("parameters".equals(prop)) {
                DefaultMutableTreeNode paramsNode = new DefaultMutableTreeNode(label);
                Properties jdbcParams = new Properties();
                JDBCParametersParser.parseParameterString((String)propVal, (Properties)jdbcParams);
                for (String param : jdbcParams.stringPropertyNames()) {
                    paramsNode.add(new DefaultMutableTreeNode(param + " = " + jdbcParams.getProperty(param)));
                }
                children.add(paramsNode);
                continue;
            }
            children.add(new DefaultMutableTreeNode(label + " : " + propVal));
        }
        return children;
    }

    public Component getGUI() {
        return this.m_gui;
    }

    private static class DBCRend
    extends DefaultTreeCellRenderer {
        DBCRend() {
            this.setLeafIcon(OracleIcons.getIcon((String)"properties.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel retval = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (row == 0) {
                retval.setIcon(OracleIcons.getIcon((String)"database.png"));
            }
            return retval;
        }
    }
}

