/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.CancelledSQLException;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.resource.ConnBundle;
import oracle.jdevimpl.db.resource.ConnPropsBundle;

public class DefaultPasswordPrompter
extends DatabaseProviderHelper.PasswordPrompter {
    private Map<Properties, String> m_passwords = new HashMap<Properties, String>();

    private Properties createCacheVersion(DatabaseProvider pro) {
        Properties cache = pro.getProperties();
        this.removePropertiesForCache(cache);
        return cache;
    }

    private void removePropertiesForCache(Properties cache) {
        cache.remove("password");
        cache.remove("SavePassword");
    }

    private Properties createCacheVersion(Properties props) {
        Properties cache = (Properties)props.clone();
        this.removePropertiesForCache(cache);
        return cache;
    }

    public void cache(Properties props) {
        Properties cacheProps = this.createCacheVersion(props);
        this.m_passwords.put(cacheProps, props.getProperty("password"));
    }

    public void disconnect(Properties props) {
        Properties cacheProps = this.createCacheVersion(props);
        this.m_passwords.remove(cacheProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection promptForPassword(DatabaseProvider pro) throws SQLException {
        String userKey = "user";
        String passKey = "password";
        Properties cacheProps = this.createCacheVersion(pro);
        if (this.m_passwords.containsKey(cacheProps)) {
            String pass = this.m_passwords.get(cacheProps);
            try {
                return pro.getConnection(pro.getProperty("user"), pass);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        int tries = 0;
        Connection conn = null;
        JEWTDialog dialog = null;
        try {
            while (tries < 3) {
                if (conn != null) return conn;
                ++tries;
                if (dialog == null) {
                    dialog = JEWTDialog.createDialog((Component)SwingUtils.getToplevelWindow(), (String)ConnBundle.get("PASSWORD_TITLE"), (int)3);
                }
                PasswordPanel ppanel = new PasswordPanel("user", "password", pro.getName());
                dialog.setContent((Component)ppanel);
                dialog.setInitialFocus((Component)ppanel.m_txtPass);
                dialog.setName("DBPasswordPrompter");
                ppanel.initFrom(pro);
                final Holder dialogResult = new Holder();
                final JEWTDialog d = dialog;
                boolean dialogOK = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            dialogResult.set((Object)d.runDialog());
                        }
                    });
                    dialogOK = (Boolean)dialogResult.get();
                } else {
                    dialogOK = d.runDialog();
                }
                if (!dialogOK) throw new CancelledSQLException();
                Properties prompted = new Properties();
                ppanel.commitTo(prompted);
                String user = prompted.getProperty("user");
                String pass = prompted.getProperty("password");
                try {
                    conn = pro.getConnection(user, pass);
                    this.m_passwords.put(cacheProps, pass);
                    pro.setProperty("password", pass);
                    if (!ModelUtil.areDifferent((Object)pro.getProperty("user"), (Object)user)) continue;
                    pro.setProperty("user", user);
                    this.saveConnection(pro);
                }
                catch (CancelledSQLException ce) {
                    throw ce;
                }
                catch (SQLException sqe) {
                    if (tries > 3) throw sqe;
                    SQLErrorDialog.showErrorDialog((Component)Ide.getMainWindow(), (String)ConnBundle.get("PASSWORD_TITLE"), (SQLException)sqe);
                }
            }
            return conn;
        }
        catch (SQLException sqe) {
            throw sqe;
        }
        catch (Exception e) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Database Password Prompter", e);
            return conn;
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
    }

    private void saveConnection(DatabaseProvider pro) {
        try {
            DatabaseConnections.getInstance().saveConnections();
        }
        catch (Exception e) {
            DBLog.getLogger().log(Level.WARNING, "Password prompter couldn't save connections", e);
        }
    }

    private class PasswordPanel
    extends JPanel {
        private String m_userKey;
        private String m_passKey;
        private JLabel m_lblUser;
        private JTextField m_txtUser;
        private JLabel m_lblPass;
        private JPasswordField m_txtPass;

        private PasswordPanel(String userKey, String passKey, String name) {
            this.m_userKey = userKey;
            this.m_passKey = passKey;
            this.layoutComponents(name);
        }

        private void layoutComponents(String name) {
            HelpUtils.setHelpID((JComponent)this, (String)"f1_connection_info_html");
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(ConnBundle.format("PASSWORD_DESC", name)), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 10, 0), 0, 0));
            GridBagConstraints gbcLabels = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
            GridBagConstraints gbcFields = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
            DBUIResourceHelper reshelp = new DBUIResourceHelper("PasswordPanel");
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                this.m_lblUser = new JLabel();
                this.m_txtUser = new JTextField();
                reshelp.resLabel(this.m_lblUser, (Component)this.m_txtUser, ConnPropsBundle.get("user") + ":", "User");
                this.add((Component)this.m_lblUser, gbcLabels);
                this.add((Component)this.m_txtUser, gbcFields);
                ++gbcLabels.gridy;
                ++gbcFields.gridy;
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                this.m_lblPass = new JLabel();
                this.m_txtPass = new JPasswordField();
                reshelp.resLabel(this.m_lblPass, (Component)this.m_txtPass, ConnPropsBundle.get("password") + ":", "Password");
                this.add((Component)this.m_lblPass, gbcLabels);
                this.add((Component)this.m_txtPass, gbcFields);
            }
        }

        private void initFrom(DatabaseProvider pro) {
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                this.m_txtUser.setText(pro.getProperty(this.m_userKey));
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                this.m_txtPass.setText(pro.getProperty(this.m_passKey));
            }
        }

        private void commitTo(Properties props) {
            boolean saveableChange = false;
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                props.setProperty(this.m_userKey, this.m_txtUser.getText());
                saveableChange = true;
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                char[] pass = this.m_txtPass.getPassword();
                props.setProperty(this.m_passKey, new String(pass));
                for (int i = 0; i < pass.length; ++i) {
                    pass[i] = '\u0000';
                }
                this.m_txtPass.setText(null);
            }
        }
    }
}

