/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Database;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.panels.ConnectionPanelUI;
import oracle.jdeveloper.db.panels.DatabaseFinder;
import oracle.jdevimpl.db.resource.ConnBundle;

public class DatabaseConnectionPanel
extends DefaultTraversablePanel
implements ItemListener {
    public static final String CHOSEN_CONNECTION_NAME = "CHOSEN_DB_CONN_NAME";
    public static final String CHOSEN_CONNECTION = "CHOSEN_DB_CONN";
    private ConnectionPanelUI m_ui;
    private WizardCallbacks m_wizCallbacks;
    private DialogCallbacks m_dlgCallbacks;

    public String getConnectionName() {
        return this.getConnectionUI().getConnectionName();
    }

    public boolean setConnectionName(String name) {
        return this.getConnectionUI().setConnectionName(name);
    }

    protected ConnectionPanelUI createConnectionUI() {
        return new ConnectionPanelUI(true);
    }

    protected final ConnectionPanelUI getConnectionUI() {
        if (this.m_ui == null) {
            this.m_ui = this.createConnectionUI();
            this.m_ui.addComboListener(this);
            this.m_ui.setConnectionPrompt(this.getConnectionPrompt());
            this.setLayout(new BorderLayout());
            this.add(this.m_ui, "Center");
        }
        return this.m_ui;
    }

    public void setConnectionLabel(String label) {
        this.m_ui.setConnectionLabel(label);
    }

    protected String getConnectionPrompt() {
        return ConnBundle.get("MESSAGE_CONNECTION_PROMPT");
    }

    protected String getProviderKey() {
        return "oracle.javatools.db.DBObjectProvider";
    }

    public void onEntry(TraversableContext dataContext) {
        ConnectionPanelUI ui = this.getConnectionUI();
        String name = this.getEntryConnection(dataContext);
        if (ui.resetConnections() > 0 && name != null) {
            ui.setConnectionName(name);
        }
        WizardCallbacks wizardCallbacks = this.m_wizCallbacks = dataContext == null ? null : dataContext.getWizardCallbacks();
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardSetInitialFocus(ui.getDefaultFocusComponent());
        }
        this.m_dlgCallbacks = dataContext == null ? null : dataContext.getDialogCallbacks();
        this.checkWizardButtons();
    }

    protected String getEntryConnection(TraversableContext dataContext) {
        return dataContext == null ? null : (String)dataContext.get(CHOSEN_CONNECTION_NAME);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        block2: {
            ConnectionPanelUI ui = this.getConnectionUI();
            boolean validate = this.validateOnExit(dataContext);
            ConnectionInfo info = ui.getConnectionInfo();
            try {
                this.commitConnectionInfo(info, dataContext);
                ui.saveSettings();
            }
            catch (TraversalException te) {
                if (!validate) break block2;
                throw te;
            }
        }
    }

    protected boolean validateOnExit(TraversableContext dataContext) {
        return dataContext == null || dataContext.getDirection() != 2;
    }

    @Deprecated
    protected void commitConnectionName(String name, TraversableContext dataContext) throws TraversalException {
        this.commitConnectionInfo(new ConnectionInfo(this.getConnectionUI().getStoreName(), name), dataContext);
    }

    protected void commitConnectionInfo(ConnectionInfo info, TraversableContext dataContext) throws TraversalException {
        if (info == null || !info.isValid()) {
            throw new TraversalException(ConnBundle.get("CHOOSE_CONNECTION"));
        }
        if (dataContext != null) {
            String name = info.getConnectionName();
            dataContext.put(CHOSEN_CONNECTION_NAME, (Object)name);
            String key = this.getProviderKey();
            if (ModelUtil.hasLength((String)key) && this.validateOnExit(dataContext)) {
                String qName = info.getQualifiedName();
                Database db = DatabaseFinder.findDatabase(qName);
                dataContext.put(key, (Object)db);
                if (db == null) {
                    throw new TraversalException(null);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.checkWizardButtons();
    }

    public void addItemListener(ItemListener il) {
        this.getConnectionUI().addComboListener(il);
    }

    public void removeItemListener(ItemListener il) {
        this.getConnectionUI().removeComboListener(il);
    }

    public void checkWizardButtons() {
        boolean go = this.canWizardNext();
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardEnableButtons(null, Boolean.valueOf(go), null);
        }
        if (this.m_dlgCallbacks != null) {
            this.m_dlgCallbacks.enableOKButton(go);
        }
    }

    protected boolean canWizardNext() {
        return this.getConnectionName() != null;
    }

    public void enableActiveComponents(boolean boo) {
        this.getConnectionUI().setEnabled(boo);
    }
}

