/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.usages.UsageData;
import oracle.ide.usages.UsagesTracker;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.Connections;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnectionsListener;
import oracle.jdeveloper.db.DisconnectListener;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.StoreContext;
import oracle.jdevimpl.db.adapter.CAConnectionCreator;
import oracle.jdevimpl.db.adapter.CAConnectionCreatorFactory;
import oracle.jdevimpl.db.adapter.DefaultContextWrapper;
import oracle.jdevimpl.db.migration.ConnectionMigrator;
import oracle.jdevimpl.db.resource.ConnBundle;

public class DatabaseConnections
implements Connections {
    private static DatabaseConnections s_instance;
    private static Logger s_logger;
    private final Map<String, Collection<Connection>> m_extraConns = new HashMap<String, Collection<Connection>>();
    private final Collection<DatabaseConnectionsListener> m_lists = new CopyOnWriteArraySet<DatabaseConnectionsListener>();
    private DatabaseContextManager.ContextWrapper m_contextWrapper;
    private final DatabaseFactory.ConnectionCreator m_connCreator;
    private final String m_storeName;
    private NamingListenerBridge m_namingListBridge;
    private DBObjectProviderListener m_proListBridge;
    private boolean m_privateStore;

    protected DatabaseConnections(String storeName, DatabaseContextManager.ContextWrapper contextWrapper, DatabaseFactory.ConnectionCreator connCreator) {
        this.m_storeName = storeName;
        this.m_contextWrapper = contextWrapper;
        this.m_connCreator = connCreator;
        if (this.m_connCreator == null) {
            throw new NullPointerException("ConnectionCreator cannot be null");
        }
        CAConnectionCreatorFactory.cacheCreator(storeName, this.m_connCreator);
    }

    private synchronized DatabaseContextManager.ContextWrapper getWrapper() {
        if (this.isCentralStore() && this.m_contextWrapper == null) {
            this.m_contextWrapper = DatabaseContextManager.getContextWrapper();
            ConnectionMigrator.finishMigration(this);
        }
        if (this.m_contextWrapper == null) {
            throw new IllegalStateException(ConnBundle.get("DB_CONN_NO_CONTEXT"));
        }
        Context connContext = this.m_contextWrapper.getDatabaseContext();
        if (connContext instanceof EventContext) {
            if (this.m_namingListBridge == null) {
                this.m_namingListBridge = new NamingListenerBridge();
            }
            try {
                this.m_namingListBridge.listenToContext((EventContext)connContext);
            }
            catch (NamingException nme) {
                DatabaseConnections.getLogger().warning("Couldn't register listener on context: " + nme);
                this.m_namingListBridge = null;
            }
        }
        return this.m_contextWrapper;
    }

    private synchronized void checkListenerInit() {
        if (this.m_proListBridge == null) {
            this.m_proListBridge = new ProviderListenerBridge();
            DBObjectProviderFactory.registerProviderListener((String)"db", (DBObjectProviderListener)this.m_proListBridge);
        }
    }

    protected synchronized void closeStore() {
        if (this.m_namingListBridge != null) {
            this.m_namingListBridge.removeFromContext();
            this.m_namingListBridge = null;
        }
        this.closeOpenConnections();
        if (this.m_connCreator != null && !this.isCentralStore()) {
            CAConnectionCreatorFactory.uncacheCreator(this.m_storeName, this.m_connCreator);
        }
    }

    protected void closeOpenConnections() {
        for (String connName : this.listOpenConnections()) {
            try {
                this.disconnect(connName, true);
            }
            catch (ConnectionException ce) {
                DatabaseConnections.getLogger().log(Level.WARNING, ce.getMessage());
            }
        }
    }

    @Override
    public void addListener(ConnectionsListener l) {
        if (l != null) {
            this.addListener(DatabaseConnectionsListener.adapt(l));
        }
    }

    @Override
    public boolean removeListener(ConnectionsListener l) {
        return l == null ? false : this.removeListener(DatabaseConnectionsListener.adapt(l));
    }

    protected Collection<DatabaseConnectionsListener> getListeners() {
        return Collections.unmodifiableCollection(this.m_lists);
    }

    @Override
    public void addDisconnectListener(DisconnectListener l) {
        if (l != null) {
            this.addListener(DatabaseConnectionsListener.adapt(l));
        }
    }

    @Override
    public boolean removeDisconnectListener(DisconnectListener l) {
        return l == null ? false : this.removeListener(DatabaseConnectionsListener.adapt(l));
    }

    public void addListener(DatabaseConnectionsListener dcl) {
        if (dcl != null) {
            this.checkListenerInit();
            this.m_lists.add(dcl);
        }
    }

    public boolean removeListener(DatabaseConnectionsListener dcl) {
        return this.m_lists.remove(dcl);
    }

    @Deprecated
    protected Collection<? extends DisconnectListener> getDisconnectListeners() {
        return this.getListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionAdded(ConnectionsEvent ce) {
        for (ConnectionsListener connectionsListener : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                connectionsListener.connectionAdded(ce);
            }
            catch (Exception e) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for add connection", time, connectionsListener.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for add connection", time, connectionsListener.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for add connection", time, connectionsListener.getClass().getName());
        }
        this.logConnectionUsage(ce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionRemoved(ConnectionsEvent ce) {
        for (ConnectionsListener connectionsListener : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                connectionsListener.connectionRemoved(ce);
            }
            catch (Exception e) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for remove connection", time, connectionsListener.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for remove connection", time, connectionsListener.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for remove connection", time, connectionsListener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionUpdated(ConnectionsEvent ce) {
        for (ConnectionsListener connectionsListener : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                connectionsListener.connectionUpdated(ce);
            }
            catch (Exception e) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for update connection", time, connectionsListener.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for update connection", time, connectionsListener.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for update connection", time, connectionsListener.getClass().getName());
        }
        this.logConnectionUsage(ce);
    }

    private void logConnectionUsage(ConnectionsEvent ce) {
        String dbSubType;
        Referenceable ref;
        if (Ide.isRunning() && !this.m_privateStore && (ref = ce.getReferenceable()) instanceof DatabaseProvider && ModelUtil.hasLength((String)(dbSubType = ((DatabaseProvider)ref).getProperty("subtype")))) {
            UsagesTracker tracker = UsagesTracker.getUsagesTracker();
            UsageData data = tracker.createUsageData();
            data.setEventId("CREATE_CONNECTION");
            data.setEventSource("DB");
            data.setProperty("db-type", dbSubType);
            tracker.report(data);
        }
    }

    private String getMessage(Throwable e) {
        Throwable t;
        String msg = e.getLocalizedMessage();
        if ((!ModelUtil.hasLength((String)msg) || msg.equals("null")) && (t = e.getCause()) != null && t != e) {
            msg = this.getMessage(t);
        }
        return msg;
    }

    @Override
    public final Collection<String> listConnections() {
        long startTime = System.currentTimeMillis();
        Collection<String> retval = this.listConnectionsImpl();
        this.logReturningConnections(retval, startTime);
        return retval;
    }

    private void logReturningConnections(Collection<String> conns, long startTime) {
        this.logTiming("Returned {0} connections.", startTime, conns.size());
    }

    private Collection<String> listConnectionsImpl() {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Context c = this.getWrapper().getDatabaseContext();
            if (c == null) {
                DatabaseConnections.getLogger().log(this.m_privateStore ? Level.FINE : Level.SEVERE, "DatabaseConnections has no JNDI context so cannot list connections.");
            } else {
                long startTime = System.currentTimeMillis();
                NamingEnumeration<NameClassPair> nenum = c.list("");
                while (nenum.hasMoreElements()) {
                    NameClassPair pair = (NameClassPair)nenum.nextElement();
                    if (!pair.getClassName().equals(DatabaseProvider.class.getName())) continue;
                    retval.add(pair.getName());
                }
                this.logTiming("Listing connections from CA", startTime, new Object[0]);
            }
        }
        catch (NamingException nme) {
            DatabaseConnections.getLogger().log(Level.SEVERE, ConnBundle.get("DB_CONN_LIST_ERR"), nme);
        }
        return retval;
    }

    public final Collection<String> listConnections(boolean oracleOnly) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        return this.listConnections(stringArray);
    }

    public Collection<String> listConnections(String[] subTypes) {
        Collection<String> retval;
        long startTime = System.currentTimeMillis();
        if (subTypes != null) {
            Arrays.sort(subTypes);
        }
        if ((retval = this.listConnectionsImpl()).size() > 0 && subTypes != null) {
            for (String name : new ArrayList<String>(retval)) {
                try {
                    Properties props = this.getProperties(name);
                    String subtype = props.getProperty("subtype");
                    if (subtype != null && Arrays.binarySearch(subTypes, subtype) >= 0) continue;
                    retval.remove(name);
                }
                catch (ConnectionException ce) {
                    DatabaseConnections.getLogger().log(Level.WARNING, ce.getMessage(), ce);
                    retval.remove(name);
                }
            }
        }
        this.logReturningConnections(retval, startTime);
        return retval;
    }

    @Override
    public final Collection<String> listConnections(Properties filter) {
        long startTime = System.currentTimeMillis();
        Collection<String> allConns = this.listConnectionsImpl();
        if (filter == null || filter.size() == 0) {
            return allConns;
        }
        ArrayList<String> retval = new ArrayList<String>();
        for (String name : allConns) {
            boolean add = false;
            try {
                Properties connProps = this.getProperties(name);
                add = true;
                for (Object key : filter.keySet()) {
                    String filterVal = filter.getProperty((String)key);
                    String connVal = connProps.getProperty((String)key);
                    if (!ModelUtil.areDifferent((Object)connVal, (Object)filterVal)) continue;
                    add = false;
                    break;
                }
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
            if (!add) continue;
            retval.add(name);
        }
        this.logReturningConnections(retval, startTime);
        return retval;
    }

    public Collection<String> listOpenConnections() {
        Collection<String> retval = this.m_connCreator == null ? Collections.emptyList() : this.m_connCreator.listDatabases();
        return retval;
    }

    public final Connection getConnection(String connName) throws ConnectionException {
        try {
            Database db = this.getDatabase(connName);
            if (db == null) {
                throw new ConnectionException(ConnBundle.format("DB_CONN_MISSING", connName));
            }
            return db.getConnection();
        }
        catch (DBException dbe) {
            Throwable t = dbe.getCause() == null ? dbe : dbe.getCause();
            throw new ConnectionException(ConnBundle.format("DB_CONN_CONN_ERR", connName, this.getMessage(t)), t);
        }
    }

    public final Connection getUniqueConnection(String connName) throws ConnectionException {
        DatabaseProvider ref = this.getReferenceable(connName);
        if (ref instanceof DatabaseProvider) {
            try {
                Connection conn = ref.getConnection();
                Collection<Connection> extraConns = this.m_extraConns.get(connName);
                if (extraConns == null) {
                    extraConns = new ArrayList<Connection>();
                    this.m_extraConns.put(connName, extraConns);
                }
                extraConns.add(conn);
                return conn;
            }
            catch (SQLException sqe) {
                throw new ConnectionException(ConnBundle.format("DB_CONN_CONN_ERR", connName, this.getMessage(sqe)), sqe);
            }
        }
        throw new ConnectionException(ConnBundle.format("DB_CONN_MISSING", connName));
    }

    public final Connection getConnection(Properties props) throws ConnectionException {
        Connection retval = null;
        DatabaseProvider pro = this.newDatabaseProvider(null, props);
        try {
            retval = pro.getConnection();
            ConnectionsEvent event = new ConnectionsEvent(null, (Referenceable)pro);
            this.fireConnectionConnected(event, DatabaseConnectionsListener.ConnectionType.UNIQUE);
        }
        catch (SQLException sqe) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_CONN2_ERR", this.getMessage(sqe)), sqe);
        }
        return retval;
    }

    private void fireConnectionConnected(ConnectionsEvent event, DatabaseConnectionsListener.ConnectionType type) {
        for (DatabaseConnectionsListener l : this.getListeners()) {
            try {
                l.connectionConnected(event, type);
            }
            catch (Exception e) {
                DatabaseConnections.getLogger().log(Level.SEVERE, l.getClass().getName(), e);
            }
        }
    }

    public final Database getDatabase(String connName) throws DBException {
        return this.getDatabase(connName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Database getDatabase(String connName, boolean create) throws DBException {
        String encoded;
        try {
            if (this.getReferenceable(connName) == null) {
                return null;
            }
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        Database db = null;
        boolean foundStore = false;
        if (this.m_connCreator != null) {
            foundStore = true;
            if (create) {
                DatabaseFactory.ConnectionCreator connectionCreator = this.m_connCreator;
                synchronized (connectionCreator) {
                    db = this.m_connCreator.findDatabase(connName);
                    if (db == null && create) {
                        db = DatabaseFactory.createDatabase((String)connName, (DatabaseFactory.ConnectionCreator)this.m_connCreator);
                    }
                }
            } else {
                db = this.m_connCreator.findDatabase(connName);
            }
        }
        if (!foundStore && (db = (Database)DBObjectProviderFactory.findProvider((String)"db", (Object)(encoded = DatabaseFactory.encodeIdentifier((String)this.m_storeName, (String)connName)))) == null && create) {
            db = (Database)DBObjectProviderFactory.findOrCreateProvider((String)"db", (Object)encoded);
        }
        return db;
    }

    public DatabaseProvider getReferenceable(String connName) throws ConnectionException {
        Context c;
        DatabaseProvider retval = null;
        if (connName != null && (c = this.getWrapper().getDatabaseContext()) != null) {
            try {
                long time = System.currentTimeMillis();
                Object obj = c.lookup(connName);
                if (obj instanceof DatabaseProvider) {
                    this.logTiming("... lookup of Referenceable from CA", time, new Object[0]);
                    retval = (DatabaseProvider)obj;
                }
            }
            catch (NameNotFoundException time) {
            }
            catch (NamingException nme) {
                throw new ConnectionException(ConnBundle.format("DB_CONN_REF_ERR", connName, this.getMessage(nme)), nme);
            }
        }
        return retval;
    }

    @Override
    public final Properties getProperties(String connName) throws ConnectionException {
        Properties retval = null;
        DatabaseProvider connPro = this.getReferenceable(connName);
        if (connPro != null) {
            retval = connPro.getProperties();
        }
        return retval;
    }

    private DatabaseProvider newDatabaseProvider(String connName, Properties props) {
        DatabaseProvider retval = new DatabaseProvider(connName, props);
        DatabaseContextManager.ContextWrapper wrapper = this.getWrapper();
        if (wrapper instanceof DefaultContextWrapper) {
            retval.setReferenceWorker(((DefaultContextWrapper)wrapper).getReferenceWorker());
        }
        return retval;
    }

    @Override
    public void addConnection(String connName, Properties props) throws ConnectionException {
        long time = System.currentTimeMillis();
        DatabaseProvider connPro = this.newDatabaseProvider(connName, props);
        Context ctx = this.getWrapper().getDatabaseContext();
        try {
            PerformanceLogger logger = PerformanceLogger.get();
            String KEY = "DatabaseConnections.addConnection";
            logger.startTiming("DatabaseConnections.addConnection");
            ctx.bind(connName, (Object)connPro);
            logger.stopTiming("DatabaseConnections.addConnection", "bind of new connection to AdfJndiContext", 500);
            if (this.m_namingListBridge == null) {
                this.fireConnectionAdded(new ConnectionsEvent(connName, (Referenceable)connPro));
            }
        }
        catch (NameAlreadyBoundException nabe) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_EXISTS", connName));
        }
        catch (NamingException nme) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_CREATE_ERR", connName, this.getMessage(nme)), nme);
        }
        this.logTiming("Total time for addConnection", time, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeConnection(String connName) throws ConnectionException {
        long time = System.currentTimeMillis();
        DatabaseProvider removing = this.getReferenceable(connName);
        if (removing == null) {
            return false;
        }
        Context ctx = this.getWrapper().getDatabaseContext();
        try {
            if (!this.disconnect(connName, false)) {
                return false;
            }
            try {
                if (this.m_namingListBridge != null) {
                    this.m_namingListBridge.m_listening = false;
                }
                long bindtime = System.currentTimeMillis();
                ctx.unbind(connName);
                this.logTiming("... unbind from CA", bindtime, new Object[0]);
                this.closeDatabase(connName, true, removing, true);
            }
            finally {
                if (this.m_namingListBridge != null) {
                    this.m_namingListBridge.m_listening = true;
                }
            }
            this.logTiming("Total time for removeConnection", time, new Object[0]);
            return true;
        }
        catch (NameNotFoundException nnfe) {
            return false;
        }
        catch (NamingException nme) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_REMOVE_ERR", connName, this.getMessage(nme)), nme);
        }
    }

    private void closeDatabase(String connName, boolean uncacheDatabase, DatabaseProvider ref, boolean fireRemoved) {
        Database db;
        if (this.m_connCreator != null && (db = this.m_connCreator.findDatabase(connName)) != null) {
            db.close();
            if (uncacheDatabase) {
                this.m_connCreator.uncacheDatabase(connName);
            }
        }
        if (ref != null) {
            ref.disconnect();
        }
        if (fireRemoved) {
            this.fireConnectionRemoved(new ConnectionsEvent(connName, (Referenceable)ref));
        }
    }

    @Override
    public boolean updateConnection(String connName, String newName, Properties newProps) throws ConnectionException {
        return this.updateConnection(connName, newName, newProps, false);
    }

    public boolean updateConnection(String connName, String newName, Properties newProps, boolean skipDisconnect) throws ConnectionException {
        boolean rename;
        boolean propsChanged;
        DatabaseProvider connPro;
        long time = System.currentTimeMillis();
        DatabaseProvider oldConnPro = this.getReferenceable(connName);
        if (oldConnPro == null) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_MISSING", connName));
        }
        if (newProps == null) {
            connPro = oldConnPro;
            propsChanged = false;
        } else {
            connPro = this.newDatabaseProvider(newName == null ? connName : newName, newProps);
            propsChanged = !connPro.equals((Object)oldConnPro);
        }
        boolean bl = rename = !connName.equals(newName);
        if (propsChanged || rename) {
            Context ctx = this.getWrapper().getDatabaseContext();
            boolean removed = false;
            try {
                if (propsChanged) {
                    if (!skipDisconnect && !this.disconnect(connName, false)) {
                        boolean bl2 = false;
                        return bl2;
                    }
                } else {
                    this.renameDatabase(connName, newName);
                }
                if (newName != null && newName.length() > 0 && rename) {
                    DatabaseProvider existing = this.getReferenceable(newName);
                    if (existing != null) {
                        throw new ConnectionException(ConnBundle.format("DB_CONN_EXISTS", newName));
                    }
                    if (this.m_namingListBridge != null) {
                        this.m_namingListBridge.m_listening = false;
                    }
                    long bindtime = System.currentTimeMillis();
                    ctx.unbind(connName);
                    removed = true;
                    ctx.bind(newName, (Object)connPro);
                    this.logTiming("... rebind (bind/unbind) to CA", bindtime, new Object[0]);
                    String name = newName;
                    this.fireConnectionUpdated(new ConnectionsEvent(connName, name, (Referenceable)connPro));
                } else {
                    long bindtime = System.currentTimeMillis();
                    ctx.rebind(connName, (Object)connPro);
                    String name = connName;
                    this.logTiming("... rebind to CA", bindtime, new Object[0]);
                }
            }
            catch (NamingException nme) {
                if (removed) {
                    try {
                        ctx.bind(connName, (Object)oldConnPro);
                    }
                    catch (NamingException e) {
                        DatabaseConnections.getLogger().log(Level.WARNING, "couldn't rollback remove of old connection", e);
                    }
                }
                throw new ConnectionException(ConnBundle.format("DB_CONN_UPDATE_ERR", connName, this.getMessage(nme)), nme);
            }
            finally {
                if (this.m_namingListBridge != null) {
                    this.m_namingListBridge.m_listening = true;
                }
            }
            if (!skipDisconnect && propsChanged) {
                this.closeDatabase(connName, true, oldConnPro, false);
            }
        }
        this.logTiming("Total time for updateConnection", time, new Object[0]);
        return true;
    }

    private void renameDatabase(String oldName, String newName) {
        if (this.m_connCreator != null) {
            this.m_connCreator.renameDatabase(oldName, newName);
        }
    }

    @Override
    public final void testConnection(Properties props) throws ConnectionException {
        this.testConnection(props, null);
    }

    public final void testConnection(Properties props, DatabaseConnectionTester tester) throws ConnectionException {
        DatabaseProvider connPro = this.newDatabaseProvider(null, props);
        Connection conn = null;
        try {
            conn = connPro.getConnection();
            if (tester != null) {
                tester.testConnection(conn);
            }
        }
        catch (Throwable e) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_TEST_ERR", this.getMessage(e)), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public final void disconnect(String connName) throws ConnectionException {
        this.disconnect(connName, false);
    }

    public final boolean disconnect(String connName, boolean force) throws ConnectionException {
        DatabaseProvider ref = this.getReferenceable(connName);
        return this.doDisconnect(connName, ref, force);
    }

    private boolean doDisconnect(String connName, DatabaseProvider ref, boolean force) throws ConnectionException {
        ConnectionsEvent ce = new ConnectionsEvent(connName, (Referenceable)ref);
        for (DisconnectListener disconnectListener : this.getListeners()) {
            try {
                if (disconnectListener.canDisconnect(ce)) continue;
                if (force) {
                    DatabaseConnections.getLogger().log(Level.FINE, ConnBundle.format("DB_CONN_DISCONNECT_NOT_BLOCKED", connName, disconnectListener.getClass().getName()));
                    continue;
                }
                DatabaseConnections.getLogger().log(Level.FINE, ConnBundle.format("DB_CONN_DISCONNECT_BLOCKED", connName, disconnectListener.getClass().getName()));
                return false;
            }
            catch (Exception exception) {
                DatabaseConnections.getLogger().log(Level.SEVERE, ConnBundle.format("DB_CONN_DISCONNECT_LIST_ERR", disconnectListener.getClass().getSimpleName()));
            }
        }
        this.closeDatabase(connName, false, ref, false);
        Collection<Connection> extraConns = this.m_extraConns.get(connName);
        if (extraConns != null) {
            Iterator<Connection> iterator = extraConns.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                try {
                    iterator.remove();
                    DatabaseConnections.getLogger().log(Level.FINE, ConnBundle.format("DB_CONN_DISCONNECT_ADDITIONAL", connName));
                    connection.close();
                }
                catch (SQLException e) {
                    DatabaseConnections.getLogger().log(Level.FINE, ConnBundle.format("DB_CONN_DISCONNECT_ERR", connName), e);
                }
            }
        }
        for (DisconnectListener disconnectListener : this.getDisconnectListeners()) {
            try {
                disconnectListener.connectionDisconnected(ce);
            }
            catch (Exception e) {
                DatabaseConnections.getLogger().log(Level.WARNING, ConnBundle.format("DB_CONN_DISCONNECT_LIST_ERR", disconnectListener.getClass().getSimpleName()));
            }
        }
        return true;
    }

    @Override
    public void saveConnections() throws ConnectionException {
        try {
            this.getWrapper().saveDatabaseContext();
        }
        catch (NamingException nme) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_SAVE_ERR", this.getMessage(nme)), nme);
        }
    }

    public String getStoreName() {
        return this.m_storeName;
    }

    public boolean isCentralStore() {
        return "IdeConnections".equals(this.m_storeName);
    }

    private void logTiming(String msg, long start, Object ... params) {
        long millis = System.currentTimeMillis() - start;
        Logger logger = DatabaseConnections.getLogger();
        Level level = DBLog.getTimingLogLevel();
        if (millis > 50L && logger.isLoggable(level)) {
            if (params != null) {
                msg = MessageFormat.format(msg, params);
            }
            logger.log(level, "Timing: " + millis + "ms " + msg);
        }
    }

    private static Logger getLogger() {
        if (s_logger == null) {
            s_logger = DBLog.getLogger(DatabaseConnections.class);
        }
        return s_logger;
    }

    public static DatabaseConnections getInstance() {
        if (s_instance == null && (Product.isJDeveloper() || Product.isRaptor() || StoreContext.getContext().isCentralStoreAvailable())) {
            DatabaseFactory.ConnectionCreator cc = CAConnectionCreatorFactory.findCreator("IdeConnections");
            if (cc == null) {
                cc = new CAConnectionCreator();
            }
            s_instance = new DatabaseConnections("IdeConnections", null, cc);
        }
        return s_instance;
    }

    @Deprecated
    public static DatabaseConnections getPrivateInstance(URL url) {
        return DatabaseConnections.getLegacyPrivateInstance(url);
    }

    public static DatabaseConnections getLegacyPrivateInstance(URL url) {
        return DatabaseConnections.getPrivateInstanceImpl(url, DefaultContextWrapper.createLegacyWrapper(url));
    }

    public static DatabaseConnections getPrivateInstance(URL url, String key) {
        return DatabaseConnections.getPrivateInstanceImpl(url, new DefaultContextWrapper(url, key));
    }

    private static DatabaseConnections getPrivateInstanceImpl(URL url, DefaultContextWrapper wrapper) {
        String name = URLFileSystem.getPath((URL)url);
        DatabaseFactory.ConnectionCreator cc = CAConnectionCreatorFactory.findCreator(name);
        if (cc == null) {
            cc = new CAConnectionCreator(name, wrapper);
        }
        DatabaseConnections dc = new DatabaseConnections(name, wrapper, cc);
        dc.m_privateStore = true;
        return dc;
    }

    @Deprecated
    public static void useStandaloneConnectionStore() {
    }

    public static abstract class DatabaseConnectionTester {
        public abstract void testConnection(Connection var1) throws ConnectionException;
    }

    private class ProviderListenerBridge
    extends DBObjectProviderListener {
        private ProviderListenerBridge() {
        }

        public void providerOpened(DBObjectProvider provider) {
            this.fireEvent(provider, DatabaseConnectionsListener.ConnectionType.CONNECT);
        }

        public void providerReloaded(DBObjectProvider provider) {
            this.fireEvent(provider, DatabaseConnectionsListener.ConnectionType.RECONNECT);
        }

        private void fireEvent(DBObjectProvider provider, DatabaseConnectionsListener.ConnectionType type) {
            String storeName;
            if (provider instanceof Database && ModelUtil.areEqual((Object)(storeName = ((Database)provider).getConnectionStore()), (Object)DatabaseConnections.this.m_storeName)) {
                DatabaseConnections.this.fireConnectionConnected(new ConnectionsEvent((Database)provider), type);
            }
        }
    }

    private class NamingListenerBridge
    implements ObjectChangeListener,
    NamespaceChangeListener {
        private boolean m_listening = true;
        private EventContext m_context;

        private NamingListenerBridge() {
        }

        void listenToContext(EventContext context) throws NamingException {
            if (context != null && this.m_context != context) {
                this.removeFromContext();
                context.addNamingListener("", 0, (NamingListener)this);
                this.m_context = context;
            }
        }

        void removeFromContext() {
            if (this.m_context != null) {
                try {
                    this.m_context.removeNamingListener(this);
                    this.m_context = null;
                }
                catch (NamingException ne) {
                    DatabaseConnections.getLogger().warning("Couldn't remove listener from context: " + ne.getMessage());
                }
            }
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
        }

        @Override
        public void objectChanged(NamingEvent evt) {
            Binding binding;
            if (this.m_listening && (binding = evt.getNewBinding()).getObject() instanceof DatabaseProvider) {
                DatabaseConnections.this.fireConnectionUpdated(new ConnectionsEvent(evt.getOldBinding(), evt.getNewBinding()));
            }
        }

        @Override
        public void objectAdded(NamingEvent evt) {
            Binding binding;
            if (this.m_listening && (binding = evt.getNewBinding()).getObject() instanceof DatabaseProvider) {
                DatabaseConnections.this.fireConnectionAdded(new ConnectionsEvent(binding));
            }
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            Binding binding;
            Object ref;
            if (this.m_listening && (ref = (binding = evt.getOldBinding()).getObject()) instanceof DatabaseProvider) {
                String connName = binding.getName();
                try {
                    if (!DatabaseConnections.this.doDisconnect(connName, (DatabaseProvider)ref, false)) {
                        Context c = DatabaseConnections.this.getWrapper().getDatabaseContext();
                        try {
                            c.bind(connName, ref);
                        }
                        catch (NamingException ne) {
                            DatabaseConnections.getLogger().log(Level.WARNING, "Error encountered replacing connection (disconnect has been vetoed)", ne);
                        }
                    } else if (ref != null) {
                        DatabaseConnections.this.closeDatabase(connName, true, (DatabaseProvider)ref, true);
                    }
                }
                catch (ConnectionException ce) {
                    DatabaseConnections.getLogger().log(Level.WARNING, "Error encountered removing connection", ce);
                }
            }
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            Binding binding = evt.getNewBinding();
            if (binding.getObject() instanceof DatabaseProvider) {
                DatabaseConnections.this.fireConnectionUpdated(new ConnectionsEvent(evt.getOldBinding(), evt.getNewBinding()));
            }
        }
    }
}

