/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.hover;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.ide.hover.Hoverable;

public final class MultiHoverProvider
implements Hoverable {
    private List<HoverProvider> providers = new ArrayList<HoverProvider>();
    private JComponent component;

    public MultiHoverProvider(JComponent component) {
        this.component = component;
    }

    public void registerProvider(HoverProvider provider) {
        this.providers.add(provider);
    }

    public void unregisterProvider(HoverProvider provider) {
        this.providers.remove(provider);
    }

    @Override
    public Hover hover(Point p, List<HoverFlavor> flavors) {
        for (int i = 0; i < flavors.size(); ++i) {
            List<HoverFlavor> flavor = flavors.subList(i, i + 1);
            for (HoverProvider provider : this.providers) {
                Hover hover = provider.hover(this.component, new Point(p), flavor);
                if (hover == null) continue;
                return hover;
            }
        }
        return null;
    }
}

