/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.List;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class WindowFunction
extends Function {
    private static final String OVER = "OVER";
    private static final String PARTITION_BY = "PARTITION BY";
    private static final String BETWEEN = "BETWEEN";
    private static final String AND = " AND ";
    private static final String UNBOUNDED = "UNBOUNDED";
    private static final String CURRENT_ROW = "CURRENT ROW";
    private static final String WITHIN_GROUP = "WITHIN GROUP";
    private static final String FROM_FIRST = "FROM FIRST";
    private static final String FROM_LAST = "FROM LAST";
    private static final String RESPECT_NULLS = "RESPECT NULLS";
    private static final String IGNORE_NULLS = "IGNORE NULLS";
    private static final String LISTAGG = "LISTAGG";

    public WindowFunction() {
        this((String)null);
    }

    public WindowFunction(String func) {
        super(func, (SQLFragment[])null, false);
        this.setSeparator(", ");
    }

    public void setFromPolicy(FromPolicy fromPolicy) {
        this.setProperty("fromPolicy", (Object)fromPolicy);
    }

    public FromPolicy getFromPolicy() {
        return (FromPolicy)((Object)this.getProperty("fromPolicy"));
    }

    public void setNullPolicy(NullPolicy nullPolicy) {
        this.setProperty("nullPolicy", (Object)nullPolicy);
    }

    public NullPolicy getNullPolicy() {
        return (NullPolicy)((Object)this.getProperty("nullPolicy"));
    }

    public void setPartitionBy(SQLFragment[] frags) {
        this.getChildSupport("partitionBy").setChildArray(frags);
    }

    public SQLFragment[] getPartitionBy() {
        return this.getChildSupport("partitionBy").getChildArray(SQLFragment.class);
    }

    public void setOrderBy(OrderByObject[] frags) {
        this.getChildSupport("orderBy").setChildArray(frags);
    }

    public OrderByObject[] getOrderBy() {
        return this.getChildSupport("orderBy").getChildArray(OrderByObject.class);
    }

    public void setClauseType(ClauseType clauseType) {
        this.setProperty("clauseType", (Object)clauseType);
    }

    public ClauseType getClauseType() {
        return (ClauseType)((Object)this.getProperty("clauseType"));
    }

    public void setBounds(SQLFragment[] bounds) {
        this.getChildSupport("bounds").setChildArray(bounds);
    }

    public SQLFragment[] getBounds() {
        return this.getChildSupport("bounds").getChildArray(SQLFragment.class);
    }

    @Override
    public String getSQLText() {
        String funcSQL = super.getSQLText();
        FromPolicy fromPolicy = this.getFromPolicy();
        NullPolicy nullPolicy = this.getNullPolicy();
        List partitionBys = this.getChildSupport("partitionBy").getChildList(false);
        List orderBys = this.getChildSupport("orderBy").getChildList(false);
        List bounds = this.getChildSupport("bounds").getChildList(false);
        boolean partBy = partitionBys != null && partitionBys.size() > 0;
        boolean orderBy = orderBys != null && orderBys.size() > 0;
        boolean between = bounds != null && bounds.size() == 2;
        StringBuilder buff = new StringBuilder(funcSQL);
        if (fromPolicy != null) {
            if (fromPolicy == FromPolicy.FIRST) {
                buff.append(" ").append(FROM_FIRST);
            } else if (fromPolicy == FromPolicy.LAST) {
                buff.append(" ").append(FROM_LAST);
            }
        }
        if (nullPolicy != null) {
            if (nullPolicy == NullPolicy.RESPECT) {
                buff.append(" ").append(RESPECT_NULLS);
            } else if (nullPolicy == NullPolicy.IGNORE) {
                buff.append(" ").append(IGNORE_NULLS);
            }
        }
        if (partBy || orderBy) {
            if (LISTAGG.equals(this.getFunction())) {
                StringBuilder buff2 = new StringBuilder();
                buff2.append(WITHIN_GROUP).append(" ");
                buff2.append(this.surroundWithBrackets(this.buildOrderBy(orderBys, orderBy), true));
                if (partBy) {
                    buff2.append(" ").append(OVER).append(" ");
                    buff2.append(this.surroundWithBrackets(this.buildPartitionByText(partitionBys, partBy), true));
                }
                buff.append(" ").append(buff2.toString());
            } else {
                StringBuilder buff2 = new StringBuilder();
                buff2.append(this.buildPartitionByText(partitionBys, partBy));
                buff2.append(this.buildOrderBy(orderBys, orderBy));
                ClauseType clauseType = this.getClauseType();
                if (clauseType != null) {
                    buff2.append(" ").append(clauseType.toString()).append(" ");
                    if (between) {
                        buff2.append(BETWEEN).append(" ");
                    }
                    buff2.append(this.argsToString(bounds, false, AND, 0));
                }
                buff.append(" ").append(OVER);
                buff.append(this.surroundWithBrackets(buff2.toString()));
            }
            return buff.toString();
        }
        return funcSQL;
    }

    private String buildOrderBy(Collection orderBys, boolean orderBy) {
        StringBuilder buf = new StringBuilder();
        if (orderBy) {
            buf.append(" ").append("ORDER BY").append(" ");
            buf.append(this.argsToString(orderBys, true, ", ", 0));
        }
        return buf.toString();
    }

    private String buildPartitionByText(Collection partitionBys, boolean partBy) {
        StringBuilder buf = new StringBuilder();
        if (partBy) {
            buf.append(" ").append(PARTITION_BY).append(" ");
            buf.append(this.argsToString(partitionBys, true, ", ", 0));
        }
        return buf.toString();
    }

    public static class WindowFunctionBound
    extends AbstractSQLFragment {
        public void setBoundExpr(SQLFragment[] boundExpr) {
            this.getChildSupport("boundExpr").setChildArray(boundExpr);
        }

        public SQLFragment[] getBoundExpr() {
            return this.getChildSupport("boundExpr").getChildArray(SQLFragment.class);
        }

        public void setBoundType(BoundType boundType) {
            this.setProperty("boundType", (Object)boundType);
        }

        public BoundType getBoundType() {
            return (BoundType)((Object)this.getProperty("boundType"));
        }

        @Override
        public String getSQLText() {
            List bound = this.getChildSupport("boundExpr").getChildList(false);
            BoundType boundType = this.getBoundType();
            StringBuilder buff = new StringBuilder();
            if (bound != null && bound.size() > 0) {
                boolean needparen = false;
                for (SQLFragment b : bound) {
                    needparen = !(b instanceof SimpleSQLFragment);
                }
                String bstring = this.argsToString(bound, true, ", ", 0);
                if (needparen) {
                    bstring = this.surroundWithBrackets(bstring);
                }
                buff.append(bstring);
                if (boundType != null) {
                    buff.append(" ").append(boundType.toString());
                }
            } else if (boundType != null) {
                if (boundType == BoundType.CURRENT_ROW) {
                    buff.append(WindowFunction.CURRENT_ROW);
                } else {
                    buff.append(WindowFunction.UNBOUNDED).append(" ");
                    buff.append(boundType.toString());
                }
            }
            String result = buff.toString();
            return result;
        }
    }

    public static enum NullPolicy {
        RESPECT,
        IGNORE;

    }

    public static enum FromPolicy {
        FIRST,
        LAST;

    }

    public static enum BoundType {
        PRECEDING,
        FOLLOWING,
        CURRENT_ROW;

    }

    public static enum ClauseType {
        ROWS,
        RANGE;

    }
}

