/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.parser.plsql.symtab.SqlColdef;
import oracle.javatools.parser.plsql.symtab.SqlOpndef;
import oracle.javatools.parser.plsql.symtab.SqlOptdef;
import oracle.javatools.parser.plsql.symtab.SqlQbcdef;
import oracle.javatools.parser.plsql.symtab.SqlSeldef;
import oracle.javatools.parser.plsql.symtab.SqlStrdef;
import oracle.javatools.parser.plsql.syntax.SqlDriver;
import oracle.javatools.util.ModelUtil;

public class ParserUtils {
    private static Collection<String> s_literals = Arrays.asList("BINARY_FLOAT_NAN", "BINARY_FLOAT_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_DOUBLE_INFINITY");

    private ParserUtils() {
    }

    public static String getHexToRawString(SQLFragment frag) {
        String result = null;
        if (frag instanceof Function && "HEXTORAW".equalsIgnoreCase(((Function)frag).getFunction())) {
            result = ParserUtils.getString(((Function)frag).getArguments()[0]);
        }
        return result;
    }

    @Deprecated
    public static String getHexToRawString(PlsqlNode node) {
        String result = null;
        if (node instanceof SqlOptdef && ((SqlOptdef)node).getOperatorType() == 102) {
            result = ParserUtils.getString((PlsqlNode)((SqlOptdef)node).getOperands()[0]);
        }
        return result;
    }

    public static String getString(SQLFragment frag) {
        String result = null;
        if (ParserUtils.isConstant(frag) && frag.getSQLText().charAt(0) == '\'') {
            result = frag.getSQLText();
        }
        return result;
    }

    @Deprecated
    public static String getString(PlsqlNode node) {
        String result = null;
        if (ParserUtils.isConstant(node) && ((SqlStrdef)node).getStringText().charAt(0) == '\'') {
            result = ((SqlStrdef)node).getStringText();
        }
        return result;
    }

    public static boolean isAllowedExpression(SQLFragment frag, Collection<String> validOperators) {
        boolean retval;
        if (frag instanceof FunctionUsage) {
            retval = true;
        } else {
            String fnName = null;
            if (frag instanceof Function) {
                fnName = ((Function)frag).getFunction();
            } else if (frag instanceof ArithmeticOperation) {
                fnName = ((ArithmeticOperation)frag).getOperatorText();
            } else if (frag instanceof SimpleSQLFragment) {
                fnName = frag.getSQLText();
            }
            retval = validOperators.contains(fnName);
        }
        return retval;
    }

    @Deprecated
    public static boolean isAllowedExpression(PlsqlNode node, Collection validOperators) {
        return node instanceof SqlExpression && validOperators.contains(new Integer(((SqlExpression)node).getOperatorType()));
    }

    @Deprecated
    public static boolean isAllowedStringType(PlsqlNode node, Collection validStringTypes) {
        return node instanceof SqlStrdef && validStringTypes.contains(new Integer(((SqlStrdef)node).getStringType()));
    }

    public static boolean isConstant(SQLFragment frag) {
        boolean retval = false;
        if (frag != null && frag instanceof SimpleSQLFragment && ModelUtil.hasLength((String)frag.getSQLText())) {
            String quote = "'";
            String text = frag.getSQLText().trim().toUpperCase();
            if (text.length() > 1 && (text.startsWith("'") || text.startsWith("N'") || text.startsWith("Q'") || text.startsWith("NQ'")) && text.endsWith("'")) {
                retval = true;
            } else if (text.length() > 0 && text.substring(0, 1).matches("[-+.0-9]")) {
                retval = true;
            } else if (s_literals.contains(text)) {
                retval = true;
            }
        }
        return retval;
    }

    @Deprecated
    public static boolean isConstant(PlsqlNode node) {
        return node instanceof SqlStrdef && ((SqlStrdef)node).getStringType() == 0;
    }

    @Deprecated
    public static boolean isNull(PlsqlNode node) {
        return node instanceof SqlOpndef && ((SqlOpndef)node).getOperandType() == 3 && ((SqlOpndef)node).getStringType() == 8;
    }

    @Deprecated
    public static boolean isDbObjectName(PlsqlNode node) {
        return node instanceof SqlOpndef && (((SqlOpndef)node).getOperandType() == 1 || ((SqlOpndef)node).getOperandType() == 7);
    }

    public static String getConstant(SQLFragment frag) {
        return ParserUtils.isConstant(frag) ? frag.getSQLText() : null;
    }

    @Deprecated
    public static String getConstant(PlsqlNode node) {
        return ParserUtils.isConstant(node) ? ((SqlStrdef)node).getStringText() : null;
    }

    public static Collection<String[]> getColumnNames(String expression, SQLFragmentExpressionBuilder.ExpressionType type, DBObjectProvider prov, Relation rel) throws SQLQueryException {
        SQLFragment frag = SQLFragmentExpressionBuilder.getExpressionOrFail(prov, rel, type, expression);
        return ParserUtils.getColumnNames(frag);
    }

    public static Collection<String[]> getColumnNames(SQLFragment sqlFragment) {
        HashSet<String[]> columnNames = new HashSet<String[]>();
        DBObject[] operands = sqlFragment.getOwnedObjects();
        if (sqlFragment instanceof SQLQuery) {
            SQLQuery sqlqbc = (SQLQuery)sqlFragment;
            operands = sqlqbc.getSelectObjects();
        }
        if (operands != null) {
            for (int i = 0; i < operands.length; ++i) {
                if (null == operands[i] || !(operands[i] instanceof SQLFragment)) continue;
                columnNames.addAll(ParserUtils.getColumnNames((SQLFragment)operands[i]));
            }
        }
        if (sqlFragment instanceof ColumnUsage) {
            String colName;
            String alias;
            DBObject user;
            ColumnUsage coldef = (ColumnUsage)sqlFragment;
            ArrayList<String> nameComponents = new ArrayList<String>();
            DBObject parent = coldef.getParent();
            DBObject dBObject = user = parent == null ? null : parent.getParent();
            if (user instanceof AliasFragment && ModelUtil.hasLength((String)(alias = ((AliasFragment)user).getUsableAlias()))) {
                nameComponents.add(alias);
            }
            if (parent instanceof AliasFragment && ModelUtil.hasLength((String)(alias = ((AliasFragment)parent).getUsableAlias()))) {
                nameComponents.add(alias);
            }
            if (ModelUtil.hasLength((String)(colName = coldef.getColumnName()))) {
                nameComponents.add(colName);
            } else {
                nameComponents.addAll(Arrays.asList(coldef.getAttributes()));
            }
            columnNames.add(nameComponents.toArray(new String[nameComponents.size()]));
        } else if (sqlFragment instanceof SelectObject) {
            SelectObject sqlsel = (SelectObject)sqlFragment;
            columnNames.addAll(ParserUtils.getColumnNames(sqlsel.getExpression()));
        }
        return columnNames;
    }

    @Deprecated
    public static Collection<String[]> getColumnNames(String expression, ExpressionType type) throws SQLQueryException {
        PlsqlRoot root = ParserUtils.parseQueryString(expression, ParserUtils.getSqlDriverType(type));
        ParserUtils.checkErrors(root, expression);
        PlsqlNode[] units = root.getUnits();
        if (units.length != 1 || !(units[0] instanceof SqlExpression)) {
            DBLog.getLogger().warning("SQL parser failure. Returned " + units.length + " PlsqlNode. Expecting 1 SqlExpression");
            return new HashSet<String[]>();
        }
        return ParserUtils.getColumnNames((SqlExpression)units[0]);
    }

    @Deprecated
    public static Collection<String[]> getColumnNames(SqlExpression sqlExpression) {
        HashSet<String[]> columnNames = new HashSet<String[]>();
        SqlExpression[] operands = sqlExpression.getOperands();
        if (sqlExpression instanceof SqlQbcdef) {
            SqlQbcdef sqlqbc = (SqlQbcdef)sqlExpression;
            operands = sqlqbc.qbcsel;
        }
        if (operands != null) {
            for (int i = 0; i < operands.length; ++i) {
                if (null == operands[i]) continue;
                columnNames.addAll(ParserUtils.getColumnNames(operands[i]));
            }
        }
        if (sqlExpression instanceof SqlColdef) {
            SqlColdef coldef = (SqlColdef)sqlExpression;
            ArrayList<String> nameComponents = new ArrayList<String>();
            if (ModelUtil.hasLength((String)coldef.getColumnUserName())) {
                nameComponents.add(coldef.getColumnUserName());
            }
            if (ModelUtil.hasLength((String)coldef.getColumnTableName())) {
                nameComponents.add(coldef.getColumnTableName());
            }
            if (ModelUtil.hasLength((String)coldef.getColumnBaseName())) {
                nameComponents.add(coldef.getColumnBaseName());
            } else {
                nameComponents.addAll(Arrays.asList(coldef.getColumnAndAttributes()));
            }
            columnNames.add(nameComponents.toArray(new String[nameComponents.size()]));
        } else if (sqlExpression instanceof SqlSeldef) {
            SqlSeldef sqlsel = (SqlSeldef)sqlExpression;
            columnNames.addAll(ParserUtils.getColumnNames((SqlExpression)sqlsel.getSelopn()));
        }
        return columnNames;
    }

    @Deprecated
    public static void checkErrors(PlsqlRoot root, String sql) throws SQLQueryException {
        PlsqlError[] errors = root.getErrors();
        SQLParseException.ParseError[] perrors = new SQLParseException.ParseError[errors.length];
        for (int i = 0; i < errors.length; ++i) {
            perrors[i] = new SQLParseException.ParseError(errors[i].getStartOffset(), errors[i].getErrorMessage());
        }
        if (errors != null && errors.length > 0) {
            throw new SQLParseException(perrors, sql);
        }
    }

    @Deprecated
    public static PlsqlRoot parseQueryString(String expression, int type) throws SQLQueryException {
        try {
            ReadTextBuffer textBuffer = TextBufferFactory.createReadTextBuffer((String)expression);
            PlsqlParser.ParsingOptions options = new PlsqlParser.ParsingOptions();
            options.inputType = 16;
            SqlDriver sql = new SqlDriver();
            sql.setTextBuffer(textBuffer);
            return sql.qcpidrv(type);
        }
        catch (Exception e) {
            throw new SQLQueryException(APIBundle.format("SQL_UNKNOWN_ERR", e.getMessage()));
        }
    }

    @Deprecated
    private static final int getSqlDriverType(ExpressionType type) {
        switch (type) {
            case BOOLEAN: {
                return 1;
            }
            case ARITHMETIC: {
                return 2;
            }
            case SELECT_LIST: {
                return 3;
            }
        }
        return 0;
    }

    public static enum ExpressionType {
        BOOLEAN,
        ARITHMETIC,
        SELECT_LIST,
        SQL_STATEMENT;

    }
}

