/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Arrays;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.ObjectTypeBundle;
import oracle.javatools.db.resource.PropertyBundle;

public class DisplayNames {
    private static final Collection<String> PROPERTY_SUFFIXES = Arrays.asList("Fragment", "Source", "ID");

    public static String getTypeDisplayName(String objectType) {
        try {
            return ObjectTypeBundle.get(DisplayNames.getTypeKey(objectType));
        }
        catch (Exception e) {
            return objectType;
        }
    }

    public static String getTypePluralName(String objectType) {
        try {
            return ObjectTypeBundle.get(DisplayNames.getTypeKey(objectType) + "_plural");
        }
        catch (Exception e) {
            return objectType;
        }
    }

    private static String getTypeKey(String type) {
        return type.replaceAll(" ", "_");
    }

    public static String getPropertyDisplayName(String propName) {
        String nls = DisplayNames.getPropertyDisplayName(propName, PropertyBundle.getBundle());
        return nls == null ? propName : nls;
    }

    public static String getPropertyDisplayName(String propName, ResourceBundle bundle) {
        String lastProp = Property.getLastProperty(propName);
        try {
            return bundle.getString(lastProp);
        }
        catch (MissingResourceException mre) {
            for (String suffix : PROPERTY_SUFFIXES) {
                if (!lastProp.endsWith(suffix)) continue;
                try {
                    String stripped = lastProp.substring(0, lastProp.length() - suffix.length());
                    return PropertyBundle.get(stripped);
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            return null;
        }
    }
}

