/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.util.Collection;
import java.util.TreeSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.bigdata.BigDataJsonArray;
import oracle.javatools.db.ora.bigdata.BigDataJsonObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class BigDataJsonEntry
extends AbstractSQLFragment {
    public static final String TYPE = "BigDataJsonEntry";
    public static final String ACTION = "action";
    public static final String BYTES = "bytes";
    public static final String COL = "col";
    public static final String FIELD = "field";
    public static final String MASK = "mask";
    public static final String VALUE = "value";
    public static final String ERROR = "error";
    public static final String TRUNCATE = "truncate";
    public static final String SETNULL = "setnull";
    public static final String REJECT = "reject";
    public static final String REPLACE = "replace";

    public BigDataJsonEntry() {
    }

    public BigDataJsonEntry(String name, SQLFragment valueFragment) {
        this.setName(name);
        this.setValueFragment(valueFragment);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public SQLFragment getValueFragment() {
        return (SQLFragment)this.getProperty("valueFragment");
    }

    public void setValueFragment(SQLFragment value) {
        this.setProperty("valueFragment", value);
    }

    @Override
    public String getSQLText() {
        StringBuilder buff = new StringBuilder();
        buff.append("\"").append(this.getName()).append("\": ");
        this.appendValue(buff);
        return buff.toString();
    }

    public String getValueSQLText() {
        StringBuilder buff = new StringBuilder();
        this.appendValue(buff);
        return buff.toString();
    }

    private void appendValue(StringBuilder buff) {
        SQLFragment value = this.getValueFragment();
        if (value instanceof SQLFragment && this.isNonStringEntry()) {
            buff.append(value.getSQLText());
        } else {
            BigDataJsonEntry.appendBigDataSQLText(buff, value);
        }
    }

    private boolean isNonStringEntry() {
        return BYTES.equals(this.getName());
    }

    static void appendBigDataSQLText(StringBuilder buff, SQLFragment frag) {
        boolean quote;
        String text = frag == null ? null : frag.getSQLText();
        boolean bl = quote = !ModelUtil.hasLength((String)text) || !(frag instanceof BigDataJsonArray) && !(frag instanceof BigDataJsonObject);
        if (quote) {
            buff.append("\"");
        }
        if (text != null) {
            buff.append(text);
        }
        if (quote) {
            buff.append("\"");
        }
    }

    public static Tuple<String, String> getJsonEntryNames(String paramName) {
        Tuple retval = null;
        if ("com.oracle.bigdata.colmap".equals(paramName)) {
            retval = new Tuple((Object)COL, (Object)FIELD);
        } else if ("com.oracle.bigdata.datemask".equals(paramName)) {
            retval = new Tuple((Object)MASK, (Object)COL);
        } else if ("com.oracle.bigdata.maxlen".equals(paramName)) {
            retval = new Tuple((Object)BYTES, (Object)COL);
        } else if ("com.oracle.bigdata.overflow".equals(paramName)) {
            retval = new Tuple((Object)ACTION, (Object)COL);
        } else if ("com.oracle.bigdata.erroropt".equals(paramName)) {
            retval = new Tuple((Object)ACTION, (Object)COL);
        }
        return retval;
    }

    public static boolean isJsonEntryOptional(String paramName, String entryName) {
        return COL.equals(entryName) && !"com.oracle.bigdata.colmap".equals(paramName);
    }

    public static Collection<String> getAllowedValueStrings(String entryName, String paramName, Relation table) {
        TreeSet<String> retval = null;
        if (COL.equals(entryName)) {
            retval = new TreeSet<String>();
            if (table != null) {
                for (Column c : table.getColumns()) {
                    retval.add(c.getName());
                }
            }
        } else if (ACTION.equals(entryName)) {
            retval = new TreeSet();
            if ("com.oracle.bigdata.erroropt".equals(paramName)) {
                retval.add(REJECT);
                retval.add(REPLACE);
                retval.add(SETNULL);
            } else {
                retval.add(ERROR);
                retval.add(TRUNCATE);
            }
        }
        return retval;
    }

    public static String getDefaultValueString(String entryName, String paramName) {
        String retval = BYTES.equals(entryName) ? String.valueOf(4000) : ("com.oracle.bigdata.overflow".equals(paramName) && ACTION.equals(entryName) ? ERROR : ("com.oracle.bigdata.erroropt".equals(paramName) && ACTION.equals(entryName) ? REJECT : null));
        return retval;
    }

    public static boolean hasExtendedEntry(String entryName, String paramName) {
        return ACTION.equals(entryName) && "com.oracle.bigdata.erroropt".equals(paramName);
    }

    public static String getExtendedEntryName(String entryName, String entryValue, String paramName) {
        String retval = ACTION.equals(entryName) && REPLACE.equals(entryValue) && "com.oracle.bigdata.erroropt".equals(paramName) ? VALUE : null;
        return retval;
    }
}

