/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyInfo;

public final class DelegateDDLGenerator
implements DDLGenerator {
    private final DDLGenerator m_base;
    private final DatabaseDescriptor m_desc;
    private final Class<? extends Database> m_databaseClass;
    private final DBObjectProvider m_pro;
    private Map<String, DDLGenerator> m_extras;

    public DelegateDDLGenerator(DDLGenerator base, DatabaseDescriptor desc, Class<? extends Database> databaseClass, DBObjectProvider pro) {
        if (base == null || desc == null || databaseClass == null) {
            throw new IllegalArgumentException("must provide a base generator, database descriptor and class");
        }
        this.m_base = base;
        this.m_desc = desc;
        this.m_databaseClass = databaseClass;
        this.m_pro = pro;
    }

    public DDLGenerator getBaseGenerator() {
        return this.m_base;
    }

    private DDLGenerator getDelegate(Difference diff) {
        return this.getDelegate((DBObject)diff.getOriginalObject(), (DBObject)diff.getUpdatedObject());
    }

    private DDLGenerator getDelegate(DBObject original, DBObject update) {
        String type = null;
        if (original != null) {
            type = original.getType();
        } else if (update != null) {
            type = update.getType();
        }
        return this.getDelegate(type);
    }

    private DDLGenerator getDelegate(String type) {
        DDLGenerator extra;
        if (this.m_extras == null && DBObjectRegistry.isActive()) {
            DBObjectRegistry reg = DBObjectRegistry.getInstance();
            this.m_extras = reg.getDDLGenerators(this.m_desc.getDatabaseType(), this.m_desc.getDatabaseVersion(), this.m_databaseClass, this.m_pro);
        }
        DDLGenerator retval = this.m_base;
        if (type != null && (extra = this.m_extras.get(type)) != null) {
            retval = extra;
        }
        return retval;
    }

    @Override
    public boolean canCreateProperty(SystemObject object, String prop) {
        return this.getDelegate(null, object).canCreateProperty(object, prop);
    }

    public DDL getCreateDDL(DDLOptions options, DBObject ... objects) {
        DDL retval = null;
        if (objects != null) {
            for (DBObject obj : objects) {
                DDL next = this.getDelegate(obj, null).getCreateDDL(options, obj);
                if (next == null) continue;
                if (retval == null) {
                    retval = next;
                    continue;
                }
                retval.append(next);
            }
        }
        return retval;
    }

    public DDL getDeleteDDL(DDLOptions options, DBObject ... objects) {
        DDL retval = null;
        if (objects != null) {
            for (DBObject obj : objects) {
                DDL next = this.getDelegate(obj, null).getDeleteDDL(options, obj);
                if (next == null) continue;
                if (retval == null) {
                    retval = next;
                    continue;
                }
                retval.append(next);
            }
        }
        return retval;
    }

    public DDL getUndeleteDDL(DDLOptions options, DBObject ... objects) {
        DDL retval = null;
        if (objects != null) {
            for (DBObject obj : objects) {
                DDL next = this.getDelegate(obj, null).getUndeleteDDL(options, obj);
                if (next == null) continue;
                if (retval == null) {
                    retval = next;
                    continue;
                }
                retval.append(next);
            }
        }
        return retval;
    }

    public DDL getUpdateDDL(DDLOptions options, Difference diff) {
        DDL ddl = new DDL();
        if ((diff.isMap() || diff.isLeaf()) && SystemObject.class.isAssignableFrom(diff.getDifferenceClass())) {
            this.processDifference(options, diff, ddl);
        } else if (diff.isList()) {
            for (Difference difference : diff.getChildren()) {
                this.processDifference(options, difference, ddl);
            }
        } else {
            DBLog.getLogger(this).warning("unexpected Difference type for DDL");
        }
        return ddl;
    }

    private void processDifference(DDLOptions options, Difference diff, DDL ddl) {
        DDL next = this.getDelegate(diff).getUpdateDDL(options, diff);
        if (next != null) {
            ddl.append(next);
        }
    }

    @Override
    public boolean supportsAction(String type, PropertyAction.Type action) {
        return this.getDelegate(type).supportsAction(type, action);
    }

    @Override
    public boolean supportsProperty(String type, String prop) {
        return this.getDelegate(type).supportsProperty(type, prop);
    }

    @Override
    public PropertyInfo findPropertyInfo(Class<? extends DBObject> objClass, String prop) {
        return this.getDelegate(Metadata.getType(objClass)).findPropertyInfo(objClass, prop);
    }

    @Override
    public boolean supportsProperty(Class<? extends DBObject> objClz, String prop) {
        return this.getDelegate(Metadata.getType(objClz)).supportsProperty(objClz, prop);
    }

    @Override
    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        return this.getDelegate(originalObject, updatedObject).getAllowedPropertyValues(originalObject, updatedObject, property);
    }

    @Override
    public Collection<String> getRestrictingProperties(Class<? extends SystemObject> objClz, String property) {
        String type = Metadata.getType(objClz);
        return this.getDelegate(type).getRestrictingProperties(objClz, property);
    }

    @Override
    public Collection<String> getAllowedReferenceParentTypes(DBObject obj, String property) {
        return this.getDelegate(null, obj).getAllowedReferenceParentTypes(obj, property);
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(DBObject object, String property) {
        return this.getDelegate(null, object).getAllowedReferenceTypes(object, property);
    }

    @Override
    public boolean canAlterProperty(SystemObject original, SystemObject update, String prop) {
        return this.getDelegate(original, update).canAlterProperty(original, update, prop);
    }

    @Override
    public PropertyAction canChangeProperty(SystemObject original, SystemObject update, String prop) {
        return this.getDelegate(original, update).canChangeProperty(original, update, prop);
    }

    @Override
    public PropertyAction canUpdateObject(Difference rs) {
        return this.getDelegate(rs).canUpdateObject(rs);
    }

    @Override
    public PropertyAction canUpdateObject(SystemObject orig, SystemObject update) {
        return this.getDelegate(orig, update).canUpdateObject(orig, update);
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(String objectType, String property) {
        return this.getDelegate(objectType).getAllowedReferenceTypes(objectType, property);
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(PropertyInfo propInfo) {
        return propInfo == null ? null : propInfo.getAllowedReferenceTypes();
    }

    @Override
    public PropertyAction supportsPropertyChange(Class<? extends SystemObject> objClz, String prop) {
        PropertyAction retval = null;
        String type = Metadata.getType(objClz);
        DDLGenerator delegate = this.getDelegate(type);
        if (delegate != null) {
            retval = delegate.supportsPropertyChange(objClz, prop);
        }
        return retval;
    }

    @Override
    public Object getImplicitDefaultValue(DBObject obj, String property) {
        Object retval = null;
        DDLGenerator delegate = this.getDelegate(null, obj);
        if (delegate != null) {
            retval = delegate.getImplicitDefaultValue(obj, property);
        }
        return retval;
    }

    @Override
    public Nullable.NullBehaviour getNullBehaviour(DBObject originalObject, DBObject updatedObject, String property) {
        Nullable.NullBehaviour retval = null;
        DDLGenerator delegate = this.getDelegate(null, updatedObject);
        if (delegate != null) {
            retval = delegate.getNullBehaviour(originalObject, updatedObject, property);
        }
        return retval;
    }
}

