/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CancelledSQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.resource.APIBundle;

public class StatementWrapper {
    private static ExecutionProxy s_proxy;
    private static final List<ExecutionRunnable> s_running;
    private static final Iterator<String> s_tsKeyGen;
    private Database m_db;
    private DBObject m_contextObj;
    private boolean m_reconnectFirst;
    private boolean m_executing;
    private boolean m_cancelled;
    private Connection m_conn;
    private String m_name;
    private String m_identifier;
    private Statement m_stmt;
    private String[] m_statement;
    private boolean m_ignoreErrors;
    private boolean m_noThreads;
    private long m_nanos;
    private final StringBuffer m_queryLog = new StringBuffer();
    private static Collection<Listener> s_listeners;

    public StatementWrapper(String connName, Connection connection, String ... statements) {
        this.m_name = connName;
        this.m_conn = connection;
        this.setStatement(statements);
    }

    public StatementWrapper(Database db, String ... statements) {
        this(db, db.isConnectionClosed(null) == null, statements);
    }

    protected StatementWrapper(Database db, boolean reconnectFirst, String ... statements) {
        this.m_db = db;
        this.m_reconnectFirst = reconnectFirst;
        this.setStatement(statements);
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    public void setContextObject(DBObject obj) {
        this.m_contextObj = obj;
    }

    public void setStatement(String ... statements) {
        this.m_statement = statements;
    }

    protected final String[] getStatementStrings() {
        return this.m_statement;
    }

    public String getStatementTextForLog() {
        StringBuilder buff = new StringBuilder();
        if (this.m_statement != null) {
            for (String s : this.m_statement) {
                if (buff.length() > 0) {
                    buff.append('\n');
                }
                buff.append(s);
            }
        }
        return buff.toString();
    }

    protected final Statement getStatement() throws SQLException {
        if (this.m_stmt == null) {
            Integer timeout;
            if (!this.m_executing) {
                throw new IllegalStateException("not executing, statement cannot be retrieved");
            }
            this.m_stmt = this.createStatment();
            GlobalSettings settings = GlobalSettings.getInstance();
            if (settings != null && (timeout = settings.getStatementTimeout()) != null) {
                try {
                    this.m_stmt.setQueryTimeout(timeout);
                }
                catch (SQLException sqe) {
                    boolean log = true;
                    if (this.m_db == null) {
                        log = !AbstractDatabase.isSQLStateNotImplemented(sqe);
                    } else if (this.m_db instanceof AbstractDatabase) {
                        boolean bl = log = !((AbstractDatabase)this.m_db).isUnsupportedOperation(sqe);
                    }
                    if (log) {
                        this.getLogger().warning(APIBundle.format("STATEMENT_TIMEOUT_ERR", sqe.getMessage()));
                    }
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.SEVERE, APIBundle.format("STATEMENT_TIMEOUT_ERR", t.getMessage()), t);
                }
            }
        }
        return this.m_stmt;
    }

    protected Statement createStatment() throws SQLException {
        return this.getConnection().createStatement();
    }

    public void setBypassExecutionProxy(boolean doNotThread) {
        this.m_noThreads = doNotThread;
    }

    protected final void setExecuting(boolean executing) {
        this.m_executing = executing;
    }

    protected final boolean isCancelled() {
        return this.m_cancelled;
    }

    public boolean execute() throws DBException {
        return this.doExecute(new ExecutionRunnable<Boolean>(){

            @Override
            public Boolean runImpl() throws DBException {
                boolean retval = false;
                if (StatementWrapper.this.m_statement != null) {
                    StatementWrapper.this.setExecuting(true);
                    try {
                        if (StatementWrapper.this.m_db != null) {
                            ConnectionWrapper wrap = new ConnectionWrapper(StatementWrapper.this.m_db, StatementWrapper.this.getStatementTextForLog());
                            retval = wrap.call(new ConnectionWrapper.SQLCallable<Boolean>(wrap){

                                @Override
                                public Boolean call() throws SQLException {
                                    return StatementWrapper.this.executeStatements();
                                }
                            });
                        } else {
                            try {
                                retval = StatementWrapper.this.executeStatements();
                            }
                            catch (SQLException sqe) {
                                StatementWrapper.this.throwDBException(sqe);
                            }
                        }
                    }
                    finally {
                        StatementWrapper.this.close();
                        StatementWrapper.this.setExecuting(false);
                    }
                }
                return retval;
            }
        });
    }

    private boolean executeStatements() throws SQLException {
        boolean retval = true;
        for (String s : this.m_statement) {
            if (s == null) continue;
            try {
                retval = this.executeImpl(s) || retval;
            }
            catch (SQLException sqe) {
                if (this.m_ignoreErrors) continue;
                throw sqe;
            }
        }
        return retval;
    }

    protected boolean executeImpl(String stmt) throws SQLException {
        this.sqlTrace(this.getConnectionName(), stmt, new Object[0]);
        return this.getStatement().execute(stmt);
    }

    protected final <T> T doExecute(ExecutionRunnable<T> r) throws DBException {
        if (Thread.currentThread().isInterrupted()) {
            StatementWrapper.throwCancelledException();
        }
        Object retval = null;
        try {
            this.queryStarted();
            ExecutionProxy ep = StatementWrapper.getExecutionProxy();
            if (ep == null || this.m_noThreads) {
                r.run();
                retval = r.getResult();
            } else {
                retval = ep.doExecute(r);
            }
        }
        catch (DBException dbe) {
            if (this.m_cancelled && !(dbe instanceof CancelledException)) {
                StatementWrapper.throwCancelledException();
            }
            throw dbe;
        }
        finally {
            this.queryFinished();
        }
        return (T)retval;
    }

    public void close() {
        if (this.m_stmt != null) {
            try {
                this.m_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final String getIdentifier() {
        return this.m_identifier;
    }

    public final void setIdentifier(String i) {
        this.m_identifier = i;
    }

    protected final Database getDatabase() {
        return this.m_db;
    }

    protected final void setDatabase(Database db) {
        this.m_db = db;
    }

    protected final String getConnectionName() {
        if (this.m_db == null) {
            return this.m_name;
        }
        return this.m_db.getConnectionName();
    }

    protected final Connection getConnection() {
        Connection retval;
        if (this.m_db == null) {
            retval = this.m_conn;
        } else {
            try {
                retval = this.m_db.getConnection(this.m_reconnectFirst);
            }
            catch (DBException dbe) {
                retval = this.m_db.getConnection();
            }
        }
        return retval;
    }

    protected boolean isIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignore) {
        this.m_ignoreErrors = ignore;
    }

    protected final void throwDBException(DBObject obj, String text, SQLException sqe) throws DBException {
        throw this.createDBSQLException(obj, text, sqe);
    }

    protected DBSQLException createDBSQLException(DBObject obj, String text, SQLException sqe) {
        return StatementWrapper.createDBSQLException(this.m_db, obj, text, sqe);
    }

    public final void throwDBException(SQLException sqe) throws DBException {
        this.throwDBException(this.m_contextObj, sqe);
    }

    public final void throwDBException(DBObject obj, SQLException sqe) throws DBException {
        if (this.hasCancelled(sqe)) {
            StatementWrapper.throwCancelledException();
        }
        this.throwDBException(obj, this.getStatementTextForLog(), sqe);
    }

    protected boolean hasCancelled(SQLException sqe) {
        return sqe instanceof CancelledSQLException;
    }

    protected final synchronized void sqlTrace(String dbName, String query, Object ... params) {
        StringBuilder paramList = null;
        if (params != null) {
            paramList = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                int index = query.indexOf(63);
                if (index < 0) continue;
                String param = params[i] == null ? "<null>" : "'" + params[i] + "'";
                query = query.substring(0, index) + param + query.substring(index + 1);
                paramList.append(param).append(", ");
            }
        }
        this.m_queryLog.append('\n');
        this.m_queryLog.append(query.trim());
        if (paramList != null && paramList.length() > 0) {
            this.m_queryLog.append('\n');
            this.m_queryLog.append(APIBundle.get("STATEMENT_EXECUTE_BINDS"));
            this.m_queryLog.append(' ');
            this.m_queryLog.append((CharSequence)paramList);
        }
    }

    protected final void queryStarted() {
        this.m_nanos = System.nanoTime();
        if (s_listeners != null) {
            for (Listener list : s_listeners) {
                try {
                    list.queryStarted(this);
                }
                catch (Exception e) {
                    DBLog.logStackTrace(e);
                }
            }
        }
    }

    protected final synchronized void queryFinished() {
        double millis = (double)(System.nanoTime() - this.m_nanos) / 1000000.0;
        this.m_nanos = 0L;
        if (s_listeners != null) {
            for (Listener list : s_listeners) {
                try {
                    list.queryFinished(this);
                }
                catch (Exception e) {
                    DBLog.logStackTrace(e);
                }
            }
        }
        if (this.m_queryLog != null) {
            this.m_queryLog.append('\n');
            this.m_queryLog.append(APIBundle.format("STATEMENT_EXECUTE_TIMING", Double.toString(millis)));
            DBLog.getSQLLog().log(Level.FINE, this.getConnectionName() + ": " + this.m_queryLog.toString());
        }
    }

    public void cancel() {
        this.m_cancelled = true;
        Statement stmt = this.m_stmt;
        if (stmt != null) {
            try {
                stmt.cancel();
            }
            catch (SQLFeatureNotSupportedException sfnse) {
                this.getLogger().warning(APIBundle.get("STATEMENT_CANNOT_CANCEL"));
            }
            catch (SQLException sqe) {
                this.getLogger().warning(APIBundle.get("STATEMENT_CANCEL_ERR") + sqe.getMessage());
            }
        }
    }

    protected static final DBSQLException createDBSQLException(Database db, DBObject obj, String text, SQLException sqe) {
        if (db instanceof AbstractDatabase) {
            String msg = ((AbstractDatabase)db).getDBExceptionMessage(sqe);
            return new DBSQLException(obj, text, msg, sqe);
        }
        return new DBSQLException(obj, text, sqe);
    }

    public static final void addListener(Listener l) {
        if (l != null) {
            if (s_listeners == null) {
                s_listeners = new HashSet<Listener>();
            }
            s_listeners.add(l);
        }
    }

    public static final boolean removeListener(Listener l) {
        return s_listeners != null && s_listeners.remove(l);
    }

    public static void setExecutionProxy(ExecutionProxy ep) {
        if (s_proxy != null) {
            DBLog.getLogger().info("changing execution proxy for db queries from " + s_proxy.getClass().getName() + " to " + (ep == null ? "null" : ep.getClass().getName()));
        }
        s_proxy = ep;
    }

    public static ExecutionProxy getExecutionProxy() {
        return s_proxy;
    }

    public static void throwCancelledException() throws CancelledException {
        throw StatementWrapper.createCancelledException();
    }

    private static CancelledException createCancelledException() {
        return new CancelledException(APIBundle.get("CANCELLED_STMT_EX"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelExecution(Thread thread) {
        List<ExecutionRunnable> list = s_running;
        synchronized (list) {
            for (ExecutionRunnable r : s_running) {
                if (thread != r.m_runningThread) continue;
                r.cancel();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExecutionProxyThread(Thread parent, Thread running) {
        boolean retval = false;
        List<ExecutionRunnable> list = s_running;
        synchronized (list) {
            for (ExecutionRunnable r : s_running) {
                if (r.m_parentThread != parent || r.m_runningThread != running) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    static {
        s_running = Collections.synchronizedList(new ArrayList());
        s_tsKeyGen = DBUtil.getTimestampKeyGenerator(StatementWrapper.class.getName());
    }

    public abstract class ExecutionRunnable<T>
    implements Runnable {
        private T m_result;
        private DBException m_dbe;
        private Thread m_parentThread;
        private Thread m_runningThread;

        @Override
        public synchronized void run() {
            String key = (String)s_tsKeyGen.next();
            try {
                DBUtil.suspendTimestampChecking(StatementWrapper.this.m_db, key);
                this.m_result = null;
                this.m_dbe = null;
                this.m_runningThread = Thread.currentThread();
                s_running.add(this);
                if (StatementWrapper.this.m_cancelled || this.m_runningThread.isInterrupted()) {
                    this.m_dbe = StatementWrapper.createCancelledException();
                } else {
                    this.m_result = this.runImpl();
                }
            }
            catch (DBException dbe) {
                this.m_dbe = dbe;
            }
            catch (Throwable t) {
                this.m_dbe = new DBException(t);
            }
            finally {
                this.m_runningThread = null;
                s_running.remove(this);
                DBUtil.resumeTimestampChecking(StatementWrapper.this.m_db, key);
            }
        }

        public abstract T runImpl() throws DBException;

        public T getResult() throws DBException {
            if (this.m_dbe != null) {
                throw this.m_dbe;
            }
            return this.m_result;
        }

        public String getName() {
            return StatementWrapper.this.m_db == null ? "" : StatementWrapper.this.m_db.getConnectionName();
        }

        public String getLogText() {
            return StatementWrapper.this.m_queryLog == null ? null : StatementWrapper.this.m_queryLog.toString();
        }

        public final void cancel() {
            StatementWrapper.this.cancel();
        }
    }

    public static abstract class ExecutionProxy {
        private <T> T doExecute(ExecutionRunnable<T> r) throws DBException {
            try {
                ((ExecutionRunnable)r).m_parentThread = Thread.currentThread();
                T t = this.execute(r);
                return t;
            }
            finally {
                ((ExecutionRunnable)r).m_parentThread = null;
            }
        }

        public abstract <T> T execute(ExecutionRunnable<T> var1) throws DBException;
    }

    public static interface Listener {
        public void queryStarted(StatementWrapper var1);

        public void queryFinished(StatementWrapper var1);
    }
}

