/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.execute;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.resource.APIBundle;

public class ConnectionWrapper {
    private final Database m_db;
    private final String m_desc;

    public ConnectionWrapper(Database db, String desc) {
        if (db == null) {
            throw new IllegalArgumentException("Database cannot be null.");
        }
        this.m_db = db;
        this.m_desc = desc;
    }

    public void run(SQLRunnable r) throws DBException {
        this.call(r);
    }

    public <T> T call(SQLCallable<T> c) throws DBException {
        return this.call(c, 0);
    }

    private <T> T call(SQLCallable<T> c, int attempt) throws DBException {
        Connection conn;
        SQLException sqe;
        DBException dbe;
        Object retval;
        block13: {
            retval = null;
            dbe = null;
            sqe = null;
            conn = c.getConnection();
            try {
                retval = ((SQLCallable)c).callImpl();
            }
            catch (SQLException e) {
                sqe = e;
            }
            catch (DBException e) {
                dbe = e;
                Throwable cause = e.getCause();
                if (!(cause instanceof SQLException)) break block13;
                sqe = (SQLException)cause;
            }
        }
        boolean throwIt = true;
        if (sqe != null && attempt < 5) {
            Boolean cclosed = this.m_db.isConnectionClosed(sqe);
            if (cclosed == null) {
                cclosed = !this.m_db.isConnectionAlive(conn);
            }
            if (Boolean.TRUE.equals(cclosed)) {
                String threadName = Thread.currentThread().getName() + ": ";
                DBLog.getLogger(this).info(threadName + APIBundle.format("CLOSED_EX", this.m_db.getName()));
                try {
                    Connection conn2 = this.m_db.getConnection(true);
                    if (conn2 == conn) {
                        DBLog.getLogger(this).info(threadName + APIBundle.format("RECONNECT_FAILED", this.m_db.getName()));
                    } else {
                        throwIt = false;
                        ((SQLCallable)c).m_connection = conn2;
                        retval = this.call(c, attempt++);
                    }
                }
                catch (DBException e) {
                    throwIt = true;
                }
            }
        }
        if (throwIt) {
            if (dbe != null) {
                throw dbe;
            }
            if (sqe != null) {
                throw StatementWrapper.createDBSQLException(this.m_db, null, this.m_desc, sqe);
            }
        }
        return (T)retval;
    }

    public abstract class SQLRunnable
    extends SQLCallable<Object> {
        @Override
        public final Object call() throws SQLException, DBException {
            this.run();
            return null;
        }

        public abstract void run() throws SQLException, DBException;
    }

    public abstract class SQLCallable<T> {
        private Connection m_connection;

        protected SQLCallable() {
            try {
                this.m_connection = ConnectionWrapper.this.m_db.getConnection(false);
            }
            catch (DBException dbe) {
                throw new RuntimeException(dbe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T callImpl() throws SQLException, DBException {
            Connection connection = this.m_connection;
            synchronized (connection) {
                return this.call();
            }
        }

        public abstract T call() throws SQLException, DBException;

        protected final Connection getConnection() {
            return this.m_connection;
        }
    }
}

