/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.BuildableDBObjectDiffer;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Holder;

public class DifferenceApplier {
    private List<DBObjectChange> m_events;
    private boolean m_applyToB;
    private DBObjectProvider m_pro;

    public DifferenceApplier(DBObjectProvider pro) {
        this(pro, false);
    }

    public DifferenceApplier(DBObjectProvider pro, boolean applyToB) {
        this.m_pro = pro;
        this.m_applyToB = applyToB;
    }

    private Object getOriginalObject(Difference rs) {
        return this.m_applyToB ? rs.getUpdatedObject() : rs.getOriginalObject();
    }

    private Object getUpdatedObject(Difference rs) {
        return this.m_applyToB ? rs.getOriginalObject() : rs.getUpdatedObject();
    }

    private Integer getIndexOfUpdatedObject(Difference rs) {
        return this.m_applyToB ? rs.getIndexOfOriginalObject() : rs.getIndexOfUpdatedObject();
    }

    public final void apply(SystemObject original, SystemObject updated) {
        this.apply(this.m_pro.getDiffEngine().difference(original, updated));
    }

    public final void apply(Difference rs) {
        this.m_events = new ArrayList<DBObjectChange>();
        if (!rs.isSame()) {
            if (rs.isList()) {
                Collection<? extends Difference> change = rs.getChildren();
                for (Difference difference : change) {
                    if (!difference.isModified() || !difference.isMap() || difference.isSame()) continue;
                    this.applyImpl(difference);
                }
            } else if (rs.isMap()) {
                this.applyImpl(rs);
            }
        }
    }

    private void applyImpl(final Difference objDiff) {
        Object obj = this.getOriginalObject(objDiff);
        if (obj instanceof DBObject) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DifferenceApplier.this.applyProperties(objDiff, null);
                }
            };
            DBUtil.invokeCompoundChange((DBObject)obj, r, true);
        } else {
            this.applyProperties(objDiff, null);
        }
    }

    private final void applyProperties(Difference rs, Difference parent) {
        Object original = this.getOriginalObject(rs);
        if (original != null) {
            TreeMap<PropertyInfo, Difference> process = new TreeMap<PropertyInfo, Difference>();
            Map<String, PropertyInfo> infos = PropertyIterator.getPropertyInfos(original);
            Collection<? extends Difference> changed = rs.getChildren();
            for (Difference difference : changed) {
                String propertyName = difference.getPropertyName();
                if (difference.isSame() || BuildableDBObjectDiffer.isLazyDifference(difference)) continue;
                Class<?> objClass = rs.getDifferenceClass();
                if (Map.class.isAssignableFrom(objClass)) {
                    Holder<?> newPropValue = this.getAppliedPropertyValue(difference, rs, parent);
                    if (newPropValue == null) continue;
                    ((Map)original).put(propertyName, newPropValue.get());
                    continue;
                }
                PropertyInfo info = infos.get(propertyName);
                if (info == null) {
                    throw new IllegalStateException("don't have a property info for property " + propertyName + " on object " + objClass);
                }
                process.put(info, difference);
            }
            for (PropertyInfo propertyInfo : process.keySet()) {
                Difference change = (Difference)process.get(propertyInfo);
                Object[] value = null;
                boolean setProp = false;
                if (change.isList()) {
                    List<?> list = this.applyList(change, rs);
                    setProp = true;
                    if (list != null && list.size() > 0) {
                        value = Array.newInstance(change.getDifferenceClass().getComponentType(), list.size());
                        value = list.toArray((Object[])value);
                    } else {
                        value = null;
                    }
                } else if ("schema".equals(propertyInfo.getPropertyName()) && SchemaObject.class.isAssignableFrom(rs.getDifferenceClass())) {
                    value = this.getUpdatedObject(change);
                    setProp = true;
                } else {
                    Holder<?> newPropValue = this.getAppliedPropertyValue(change, rs, parent);
                    if (newPropValue != null) {
                        value = newPropValue.get();
                        setProp = true;
                    }
                }
                if (!setProp) continue;
                try {
                    propertyInfo.setPropertyValue(original, value);
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Error applying property value", e);
                }
            }
            if (parent == null) {
                this.m_events.add(new ResultSetChange(rs, this.m_pro));
            }
        }
    }

    private Holder<?> getAppliedPropertyValue(Difference change, Difference rs, Difference parent) {
        boolean setProp = true;
        Object newPropValue = this.getUpdatedObject(change);
        if (change.isSame()) {
            setProp = false;
        } else if (!change.isList() && newPropValue != null) {
            Object originalPropValue = this.getOriginalObject(change);
            if (originalPropValue == null || originalPropValue.getClass() != newPropValue.getClass()) {
                Object parentObj;
                Object object = parentObj = parent == null ? null : this.getOriginalObject(parent);
                if (newPropValue instanceof ChildDBObject && this.m_pro != null && parentObj instanceof DBObject) {
                    ChildDBObject newChildObject = (ChildDBObject)newPropValue;
                    newPropValue = this.m_pro.getObjectFactory().newObject(newChildObject.getClass(), (DBObject)parentObj, false);
                    ((ChildDBObject)newPropValue).setID(null);
                    newChildObject.copyTo((DBObject)((ChildDBObject)newPropValue), new TemporaryObjectID.CopyBackPolicy());
                } else if (newPropValue instanceof Copyable) {
                    newPropValue = ((Copyable)newPropValue).copyTo(null);
                }
            } else if (change.isMap() && (newPropValue instanceof DBObject || "properties".equals(change.getPropertyName()) && this.getUpdatedObject(rs) instanceof DBObject)) {
                setProp = false;
                this.applyProperties(change, rs);
            }
        }
        return setProp ? new Holder(newPropValue) : null;
    }

    private final List<?> applyList(Difference rs, Difference parent) {
        ArrayList<Object> value = null;
        ArrayList<? extends Difference> changes = new ArrayList<Difference>(rs.getChildren());
        if (changes != null) {
            Collections.sort(changes, new Comparator<Difference>(){

                @Override
                public int compare(Difference o1, Difference o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -100;
                    }
                    if (o2 == null) {
                        return 100;
                    }
                    return DifferenceApplier.this.getIndexOfUpdatedObject(o1).compareTo(DifferenceApplier.this.getIndexOfUpdatedObject(o2));
                }
            });
            value = new ArrayList<Object>(changes.size());
            for (Difference difference : changes) {
                Holder<?> newChild = this.getAppliedPropertyValue(difference, rs, parent);
                if (newChild == null) {
                    value.add(this.getOriginalObject(difference));
                    continue;
                }
                Object newChildValue = newChild.get();
                if (newChildValue == null) continue;
                value.add(newChildValue);
            }
        }
        return value;
    }

    public SystemObject getCopyOfOrigWithDiffApplied(Difference diff) {
        SystemObject retval = null;
        SystemObject orig = (SystemObject)diff.getOriginalObject();
        SystemObject upd = (SystemObject)diff.getUpdatedObject();
        if (orig != null) {
            Map<DBObjectID, DBObjectID> origToUpdIDMap = DBUtil.getTemporaryIDMap(upd);
            SameTempIDPolicy policy = new SameTempIDPolicy(origToUpdIDMap);
            orig.copyTo(null, policy);
            Difference diffToApply = (Difference)diff.copyTo(null);
            this.switchOriginalWithCopy(diffToApply, policy.m_ourTemps);
            this.apply(diffToApply);
            retval = (SystemObject)diffToApply.getOriginalObject();
            DBUtil.replaceAllIDs(retval, policy.m_ourTemps);
        }
        if (retval == null) {
            retval = upd;
        }
        return retval;
    }

    private void switchOriginalWithCopy(Difference diff, Map<DBObjectID, TemporaryObjectID> idMap) {
        TemporaryObjectID temporaryObjectID;
        DBObjectID origID;
        Object orig = diff.getOriginalObject();
        if (orig instanceof DBObject && (origID = ((DBObject)orig).getID()) != null && (temporaryObjectID = idMap.get(origID)) != null) {
            try {
                DBObject tempCopy = temporaryObjectID.resolveID();
                if (tempCopy != null) {
                    diff.setObject(diff.getOriginalContributor(), tempCopy);
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        for (Difference difference : diff.getChildren()) {
            this.switchOriginalWithCopy(difference, idMap);
        }
    }

    @Deprecated
    public DBObjectChange[] fireEvents() {
        return this.m_events == null ? new DBObjectChange[]{} : this.m_events.toArray(new DBObjectChange[this.m_events.size()]);
    }

    public Iterable<DBObjectChange> getEvents() {
        return this.m_events;
    }

    private DBObjectChange fireLazyChangeEventImpl(SystemObject obj, SystemObject copyOfOriginal) {
        ResultSetChange change = new ResultSetChange(obj, copyOfOriginal, this.m_pro);
        obj.fireObjectUpdated(change);
        return change;
    }

    public static DBObjectChange fireLazyChangeEvent(SystemObject obj, SystemObject copyOfOriginal, DBObjectProvider pro) {
        DifferenceApplier app = new DifferenceApplier(pro);
        return app.fireLazyChangeEventImpl(obj, copyOfOriginal);
    }

    private static class SameTempIDPolicy
    extends IDPolicy.SameIDPolicy {
        private final Map<DBObjectID, TemporaryObjectID> m_ourTemps = new DBObjectIDMap<TemporaryObjectID>(true);
        private final Map<DBObjectID, DBObjectID> m_origToUpdIDMap;

        public SameTempIDPolicy(Map<DBObjectID, DBObjectID> origToUpdIDMap) {
            this.m_origToUpdIDMap = origToUpdIDMap;
        }

        @Override
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            TemporaryObjectID tempID = (TemporaryObjectID)TemporaryObjectID.createID(copy, original);
            DBObjectID origID = super.getNewID(original, copy);
            if (origID != null) {
                this.m_ourTemps.put(origID, tempID);
                DBObjectID fromUpd = this.m_origToUpdIDMap.get(origID);
                if (fromUpd != null) {
                    this.m_ourTemps.put(fromUpd, tempID);
                }
            }
            return origID;
        }
    }

    private final class ResultSetChange
    extends DBObjectChange {
        private DiffEngine m_diffEngine;
        private Difference m_diff;
        private DBObject m_lazyDiffObj;
        private final Collection<String> m_loaded;
        private final List<DBObject> m_objectsAdded;
        private final List<DBObject> m_objectsRemoved;
        private final Map<DBObject, DBObjectChange> m_objectsChanged;
        private Collection<String> m_allChangedProps;
        private boolean m_fullyLoaded;
        private final PropertyChangeMap m_propsChanged;

        private ResultSetChange(Difference rs, DBObjectProvider pro) {
            super((DBObject)DifferenceApplier.this.getOriginalObject(rs), pro);
            this.m_loaded = new CopyOnWriteArraySet<String>();
            this.m_objectsAdded = new ArrayList<DBObject>();
            this.m_objectsRemoved = new ArrayList<DBObject>();
            this.m_objectsChanged = new IdentityHashMap<DBObject, DBObjectChange>();
            this.m_propsChanged = new PropertyChangeMap();
            this.m_diff = rs;
        }

        private ResultSetChange(DBObject toRebuild, DBObject copyOfOriginal, DBObjectProvider pro) {
            super(toRebuild, pro);
            this.m_loaded = new CopyOnWriteArraySet<String>();
            this.m_objectsAdded = new ArrayList<DBObject>();
            this.m_objectsRemoved = new ArrayList<DBObject>();
            this.m_objectsChanged = new IdentityHashMap<DBObject, DBObjectChange>();
            this.m_propsChanged = new PropertyChangeMap();
            this.m_lazyDiffObj = copyOfOriginal;
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableList(this.m_objectsAdded);
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableMap(this.m_objectsChanged);
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableList(this.m_objectsRemoved);
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            return this.m_propsChanged;
        }

        @Override
        public Collection<String> getAllChangedProperties() {
            if (this.m_allChangedProps == null) {
                this.m_allChangedProps = new ArrayList<String>();
                for (Difference difference : this.getDifference().getChildren()) {
                    if (difference.isSame()) continue;
                    this.m_allChangedProps.add(difference.getPropertyName());
                }
            }
            return this.m_allChangedProps;
        }

        private Difference getDifference() {
            if (this.m_diff == null) {
                this.m_diff = this.getDiffEngine().difference(this.m_lazyDiffObj, this.getDBObject());
            }
            return this.m_diff;
        }

        private DiffEngine getDiffEngine() {
            if (this.m_diffEngine == null) {
                this.m_diffEngine = GenericDiffEngine.getDiffEngine(true);
            }
            return this.m_diffEngine;
        }

        private void ensureChildrenLoaded() {
            if (!this.m_fullyLoaded) {
                for (Difference difference : this.getDifference().getChildren()) {
                    this.loadDifferenceImpl(difference);
                }
            }
        }

        private void loadDifferenceImpl(Difference diff) {
            String propName = diff.getPropertyName();
            if (!this.m_loaded.contains(propName) && !diff.isSame()) {
                boolean propChange = true;
                if (diff.isList()) {
                    Class<?> propClass = diff.getDifferenceClass();
                    if (propClass.isArray() && DBObject.class.isAssignableFrom(propClass.getComponentType())) {
                        for (Difference difference : diff.getChildren()) {
                            if (!difference.isSame()) {
                                DBObject updated = (DBObject)DifferenceApplier.this.getUpdatedObject(difference);
                                DBObject original = (DBObject)DifferenceApplier.this.getOriginalObject(difference);
                                if (updated == null && original != null) {
                                    this.m_objectsRemoved.add(original);
                                } else if (updated != null && original == null) {
                                    String prop;
                                    DBObject added = updated;
                                    DBObject originalParent = this.getDBObject();
                                    if (updated.getParent() != originalParent && (prop = DBUtil.getParentProperty(updated)) != null) {
                                        Object val = originalParent.getProperty(prop);
                                        if (val instanceof DBObject) {
                                            added = (DBObject)val;
                                        } else if (val instanceof Object[]) {
                                            for (Object kid : (Object[])val) {
                                                if (!(kid instanceof DBObject) || !DBUtil.areNamesAndTypesEqual(updated, (DBObject)kid)) continue;
                                                added = (DBObject)kid;
                                                break;
                                            }
                                        }
                                    }
                                    this.m_objectsAdded.add(added);
                                } else {
                                    this.m_objectsChanged.put(original, new ResultSetChange(difference, this.getProvider()));
                                }
                            }
                            int indexA = difference.getIndexOfOriginalObject();
                            int indexB = difference.getIndexOfUpdatedObject();
                            if (indexA < 0 || indexB < 0 || indexA == indexB) continue;
                            this.m_objectsChanged.put((DBObject)DifferenceApplier.this.getOriginalObject(difference), new ResultSetChange(difference, this.getProvider()));
                        }
                    }
                } else if (diff.isMap()) {
                    if ("properties".equals(propName)) {
                        propChange = false;
                        for (Difference difference : diff.getChildren()) {
                            this.loadDifferenceImpl(difference);
                        }
                    } else {
                        DBObjectComparator<DBObject> dBObjectComparator;
                        Object updated = DifferenceApplier.this.getUpdatedObject(diff);
                        Object object = DifferenceApplier.this.getOriginalObject(diff);
                        if (updated instanceof DBObject && object instanceof DBObject && (dBObjectComparator = new DBObjectComparator<DBObject>()).compare((DBObject)updated, (DBObject)object) == 0) {
                            this.m_objectsChanged.put((DBObject)object, new ResultSetChange(diff, this.getProvider()));
                        }
                    }
                }
                if (propChange) {
                    PropertyChangeEvent pce = new PropertyChangeEvent(this.getDBObject(), propName, DifferenceApplier.this.getOriginalObject(diff), DifferenceApplier.this.getUpdatedObject(diff));
                    this.m_propsChanged.m_delegate.put(propName, pce);
                }
            }
            this.m_loaded.add(propName);
        }

        @Override
        public boolean hasNameChanged() {
            if (this.m_diff == null) {
                DBObject obj = this.getDBObject();
                return !DBUtil.areNamesAndTypesEqual(this.m_lazyDiffObj, obj);
            }
            return super.hasNameChanged();
        }

        private class PropertyChangeMap
        extends AbstractMap<String, PropertyChangeEvent> {
            private Map<String, PropertyChangeEvent> m_delegate = new ConcurrentHashMap<String, PropertyChangeEvent>();

            private PropertyChangeMap() {
            }

            @Override
            public Set<Map.Entry<String, PropertyChangeEvent>> entrySet() {
                ResultSetChange.this.ensureChildrenLoaded();
                return this.m_delegate.entrySet();
            }

            @Override
            public PropertyChangeEvent get(Object key) {
                PropertyChangeEvent retval = this.m_delegate.get(key);
                if (key instanceof String && retval == null && !ResultSetChange.this.m_loaded.contains(key) && !ResultSetChange.this.m_fullyLoaded) {
                    Difference propDiff;
                    String propName = (String)key;
                    if (ResultSetChange.this.m_diff == null && ResultSetChange.this.m_lazyDiffObj != null && !"properties".equals(propName)) {
                        Object oldVal = ResultSetChange.this.m_lazyDiffObj.getProperty(propName);
                        Object newVal = ResultSetChange.this.getDBObject().getProperty(propName);
                        if (oldVal == null && newVal == null) {
                            ResultSet rs = new ResultSet(null, null, null, propName, "MAP");
                            rs.setSame(true);
                            propDiff = rs;
                        } else {
                            ResultSet rs = ResultSetChange.this.getDiffEngine().diff(oldVal, newVal).getResult();
                            rs.setName(propName);
                            propDiff = rs;
                        }
                    } else {
                        propDiff = ResultSetChange.this.m_diff.getChildDifference(propName);
                    }
                    if (propDiff != null) {
                        ResultSetChange.this.loadDifferenceImpl(propDiff);
                        retval = this.m_delegate.get(key);
                    }
                }
                return retval;
            }

            @Override
            public Set<String> keySet() {
                Set<String> retval;
                if (ResultSetChange.this.m_fullyLoaded) {
                    retval = super.keySet();
                } else {
                    retval = new HashSet();
                    this.addChangedProperties(ResultSetChange.this.getDifference(), retval);
                }
                return retval;
            }

            private void addChangedProperties(Difference diff, Collection<String> propNames) {
                for (Difference difference : diff.getChildren()) {
                    if (difference.isSame()) continue;
                    String propName = difference.getPropertyName();
                    if ("properties".equals(propName)) {
                        this.addChangedProperties(difference, propNames);
                        continue;
                    }
                    propNames.add(propName);
                }
            }

            @Override
            public boolean containsKey(Object key) {
                return this.keySet().contains(key);
            }
        }
    }
}

