/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GeneratorCache {
    private Map<Class, Subcache> m_cache = new HashMap<Class, Subcache>();

    GeneratorCache() {
    }

    synchronized <T> void registerGenerator(Class<T> clz, String type, T g) {
        Subcache sc = this.m_cache.get(clz);
        if (sc == null) {
            sc = new Subcache();
            this.m_cache.put(clz, sc);
        }
        sc.registerGenerator(type, g);
    }

    synchronized <T> boolean unregisterGenerator(Class<T> clz, String type, T g) {
        Subcache sc = this.m_cache.get(clz);
        if (sc != null) {
            return sc.unregisterGenerator(type, g);
        }
        return false;
    }

    <T> List<T> getGenerators(Class<T> clz, String type) {
        Subcache sc = this.m_cache.get(clz);
        if (sc != null) {
            return sc.getGenerators(type);
        }
        return Collections.emptyList();
    }

    boolean containsType(Class clz, String type) {
        Subcache sc = this.m_cache.get(clz);
        if (sc != null) {
            return sc.containsType(type);
        }
        return false;
    }

    private class Subcache<G> {
        private Map<String, List<G>> m_subcache = new HashMap<String, List<G>>();

        private Subcache() {
        }

        private void registerGenerator(String type, G g) {
            List<G> list = this.m_subcache.get(type);
            if (list == null) {
                list = new ArrayList<G>();
                this.m_subcache.put(type, list);
            }
            list.add(0, g);
        }

        private boolean unregisterGenerator(String type, G g) {
            List<G> list = this.m_subcache.get(type);
            if (list != null) {
                return list.remove(g);
            }
            return false;
        }

        private List<G> getGenerators(String type) {
            List<G> retval = this.m_subcache.get(type);
            if (retval != null) {
                return retval;
            }
            return Collections.emptyList();
        }

        private boolean containsType(String type) {
            return this.m_subcache.containsKey(type);
        }
    }
}

