/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.util.ModelUtil;

public class SchemaObjectManager
extends CascadeManager {
    private static final DBObjectID[] EMPTY_ID = new DBObjectID[0];
    private boolean m_registeredAll;
    private final Map<DBObjectID, Collection<DBObjectID>> m_deps;
    private final Map<DBObjectID, Collection<DBObjectID>> m_soDeps;
    private final Map<String, Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>>> m_danglers = new HashMap<String, Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>>>();

    public SchemaObjectManager(DBObjectProvider provider) {
        super(provider);
        this.m_deps = this.createIDMap();
        this.m_soDeps = this.createIDMap();
    }

    protected final boolean haveRegisteredAll() {
        return this.m_registeredAll;
    }

    protected void clearAllCaches() {
        this.m_registeredAll = false;
        this.m_deps.clear();
        this.m_soDeps.clear();
        this.m_danglers.clear();
    }

    protected boolean supportsUnresolvedReferences() {
        return false;
    }

    protected boolean couldFixUnresolvedReferences(DBObject obj) {
        return false;
    }

    protected boolean resolvesUnresolvedReference(DBObjectID id, DBObjectID unresolved) {
        return false;
    }

    public void registerObject(SystemObject obj) {
        this.registerObject(obj, false);
    }

    public void registerObject(SystemObject obj, boolean loadOnly) {
        if (this.shouldRegister(obj, loadOnly)) {
            this.registerObject(obj, obj);
        }
    }

    protected boolean shouldRegister(SystemObject obj, boolean loadOnly) {
        boolean register = this.m_registeredAll;
        if (!register) {
            register = obj instanceof View || obj instanceof Synonym || obj instanceof Table || obj instanceof Trigger || obj instanceof MaterializedViewLog;
        }
        return register;
    }

    protected final boolean needsInitialization(SystemObject obj) {
        return DBUtil.needsBuilding(obj);
    }

    public void unregisterObject(SystemObject obj) {
        if (this.m_registeredAll) {
            DBObjectID id = obj.getID();
            if (id != null && this.supportsUnresolvedReferences()) {
                for (Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> sos : this.m_danglers.values()) {
                    if (!sos.containsKey(id)) continue;
                    sos.remove(id);
                }
            }
            this.unregisterImpl(obj);
        }
    }

    @Deprecated
    public DBObjectID[] getSchemaObjectReferers(SystemObject obj, boolean deep) {
        return EMPTY_ID;
    }

    @Override
    public Collection<DBObjectID> listTopLevelReferers(SystemObject obj, CascadeManager.LookupCriteria criteria) throws CancelledException {
        boolean deep = criteria.isRecurse();
        this.checkInit();
        DBObjectID id = obj.getID();
        Collection<DBObjectID> refs = this.getSchemaObjectReferersImpl(id, deep ? this.createIDSet() : null);
        if (obj instanceof Schema) {
            refs = this.includeSchemaObjects((Schema)obj, refs);
        }
        if (criteria.getTypes() != null) {
            Iterator<DBObjectID> iter = refs.iterator();
            while (iter.hasNext()) {
                if (criteria.isRequiredType(iter.next().getType())) continue;
                iter.remove();
            }
        }
        return refs == null ? Collections.emptyList() : refs;
    }

    protected final Collection<DBObjectID> includeSchemaObjects(Schema schema, Collection<DBObjectID> refs) {
        try {
            DBObjectProvider pro = this.getProvider();
            DBObjectCriteria<SystemObject> crit = DBObjectCriteria.createCriteria(DBUtil.filterSchemaObjectTypes(pro.listObjectTypes()), schema, null);
            crit.setUserOnly(true);
            Collection<SystemObject> objs = pro.listObjects(crit);
            for (SystemObject schemaObj : objs) {
                DBObjectID schemaObjID;
                if (refs == null) {
                    refs = this.createIDSet();
                }
                if ((schemaObjID = schemaObj.getID()) == null) continue;
                refs.add(schemaObjID);
            }
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Error listing objects in schema {0}: {1}", new Object[]{schema.getName(), dbe.getMessage()});
        }
        return refs;
    }

    @Deprecated
    public DBObjectID[] getReferers(DBObject obj) {
        return EMPTY_ID;
    }

    @Override
    public Collection<DBObjectID> listReferers(DBObject obj) throws CancelledException {
        Collection<DBObjectID> retval;
        Collection<DBObjectID> refs;
        DBObjectID topID;
        this.checkInit();
        SystemObject top = DBUtil.findParentOfType(obj, SystemObject.class);
        if (top != null && (topID = top.getID()) != null && (refs = this.getSchemaObjectReferersImpl(top.getID(), null)) != null) {
            for (DBObjectID ref : refs) {
                try {
                    DBObject refObj = ref.resolveID();
                    this.ensureDerivedReferencePropertiesBuilt(refObj);
                }
                catch (DBException dbe) {
                    this.getLogger().warning(dbe.getMessage());
                }
            }
        }
        return (retval = this.listReferers(obj, null)) == null ? Collections.emptyList() : retval;
    }

    private void ensureDerivedReferencePropertiesBuilt(DBObject obj) throws DBException {
        if (obj != null) {
            PropertyIterator propIter = new PropertyIterator(obj.getClass(), this.getProvider().getClass());
            Iterator<PropertyInfo> iter = propIter.getPropertyIterator(false, false, true);
            while (iter.hasNext()) {
                PropertyInfo info = iter.next();
                if (!info.isDerived() || info.getReferencedClass() == null) continue;
                DBUtil.ensureObjectBuilt(obj, info.getPropertyName());
            }
            for (DBObject kid : DBUtil.getExistingOwnedObjects(obj)) {
                this.ensureDerivedReferencePropertiesBuilt(kid);
            }
        }
    }

    private Collection<DBObjectID> listReferers(DBObject obj, Collection<DBObjectID> referers) {
        Collection<DBObjectID> refs;
        DBObjectID id = obj.getID();
        if (id != null && (refs = this.m_deps.get(id)) != null) {
            if (referers == null) {
                referers = this.createIDSet();
            }
            referers.addAll(refs);
        }
        for (DBObject kid : this.getOwnedObjects(obj)) {
            referers = this.listReferers(kid, referers);
        }
        return referers;
    }

    private DBObject[] getOwnedObjects(DBObject obj) {
        DBObject[] retval;
        if (obj instanceof AbstractBuildableObject && this.getProvider() instanceof Database && DBUtil.needsBuilding(obj)) {
            Collection<DBObject> owned = ((AbstractDBObject)obj).getPropertySupport().getOwnedObjects(null);
            retval = owned.toArray(new DBObject[owned.size()]);
        } else {
            retval = obj.getOwnedObjects();
        }
        return retval;
    }

    public boolean hasUnresolvedReference(SystemObject obj, String refType) throws CancelledException {
        DBObjectID id;
        this.checkInit();
        Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> danglersForType = this.m_danglers.get(refType);
        if (danglersForType != null && (id = obj.getID()) != null) {
            return danglersForType.containsKey(id);
        }
        return false;
    }

    @Override
    public Collection<Difference> resolveUnresolvedReferences(SystemObject obj) throws CancelledException {
        ArrayList<Difference> retval = null;
        if (this.supportsUnresolvedReferences() && this.couldFixUnresolvedReferences(obj)) {
            this.checkInit();
            ArrayList<SystemObject> originals = new ArrayList<SystemObject>();
            ArrayList<SystemObject> updates = new ArrayList<SystemObject>();
            Map<String, Collection<DBObject>> typeMap = this.createDanglersTypeMap(obj, null);
            for (String refType : typeMap.keySet()) {
                Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> danglersForType = this.m_danglers.get(refType);
                if (danglersForType == null) continue;
                for (Map.Entry<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> soToChildren : danglersForType.entrySet()) {
                    DBObjectID key = soToChildren.getKey();
                    Map<DBObjectID, Collection<DBObjectID>> kiddies = soToChildren.getValue();
                    for (Map.Entry<DBObjectID, Collection<DBObjectID>> childEntry : kiddies.entrySet()) {
                        DBObjectID refererId = childEntry.getKey();
                        try {
                            DBObject referer = refererId.resolveID();
                            if (referer == null) {
                                DBLog.log("SchemaObjectManager contains unresolvable ID " + refererId, new Object[0]);
                                continue;
                            }
                            Map replacements = null;
                            Collection<DBObjectID> refs = childEntry.getValue();
                            if (refs != null) {
                                for (DBObjectID unresolved : refs) {
                                    Collection<DBObject> objs = typeMap.get(refType);
                                    for (DBObject couldResolve : objs) {
                                        DBObjectID id;
                                        if (referer instanceof FKConstraint && unresolved instanceof ReferenceID) {
                                            Relation rel = ((FKConstraint)referer).getRelation();
                                            ReferenceID refTabID = (ReferenceID)unresolved.getParent();
                                            if (rel.getName().equals(refTabID.getName()) && rel.getSchema().getName().equals(refTabID.getSchemaName())) continue;
                                        }
                                        if (!this.resolvesUnresolvedReference(id = couldResolve.getID(), unresolved)) continue;
                                        if (replacements == null) {
                                            replacements = this.createIDMap();
                                        }
                                        replacements.put(unresolved, id);
                                        this.registerDependency((SystemObject)key.resolveID(), referer, id);
                                    }
                                }
                            }
                            if (replacements == null || replacements.size() <= 0) continue;
                            this.replaceReferences(originals, updates, referer, replacements);
                        }
                        catch (DBException dBException) {}
                    }
                }
            }
            if (originals.size() > 0) {
                retval = new ArrayList<Difference>();
                DiffEngine de = this.getProvider().getDiffEngine();
                for (int i = 0; i < originals.size(); ++i) {
                    Difference diff = de.difference(originals.get(i), updates.get(i));
                    retval.add(diff);
                }
            }
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    private Map<String, Collection<DBObject>> createDanglersTypeMap(DBObject obj, Map<String, Collection<DBObject>> map) {
        HashMap<String, Collection<DBObject>> hashMap = map = map != null ? map : new HashMap<String, Collection<DBObject>>();
        if (this.m_danglers.containsKey(obj.getType())) {
            this.mapKeyToCollection(obj.getType(), obj, map);
        }
        for (DBObject kid : this.getOwnedObjects(obj)) {
            this.createDanglersTypeMap(kid, map);
        }
        return map;
    }

    private void replaceReferences(List<SystemObject> originals, List<SystemObject> updates, DBObject referer, Map<DBObjectID, DBObjectID> replacements) {
        SystemObject soUpdateMe = null;
        SystemObject so = null;
        ArrayList<DBObject> trail = new ArrayList<DBObject>();
        if (referer instanceof SystemObject) {
            so = (SystemObject)referer;
        } else {
            DBObject parent = referer;
            while (!(parent instanceof SystemObject)) {
                trail.add(0, parent);
                parent = parent.getParent();
            }
            so = (SystemObject)parent;
        }
        int index = this.indexOf(originals, so);
        if (index == -1) {
            soUpdateMe = (SystemObject)so.copyTo(null, true);
            originals.add(so);
            updates.add(soUpdateMe);
        } else {
            soUpdateMe = updates.get(index);
        }
        DBObject updateReferer = this.findMatchingChild(soUpdateMe, trail);
        updateReferer.replaceReferenceIDs(replacements);
    }

    private int indexOf(List<SystemObject> objs, SystemObject s) {
        int retval = -1;
        Comparator<DBObject> c = DBUtil.getNameComparator();
        for (int i = 0; i < objs.size(); ++i) {
            if (c.compare(objs.get(i), s) != 0) continue;
            retval = i;
            break;
        }
        return retval;
    }

    private DBObject findMatchingChild(SystemObject copy, List<DBObject> trailToChild) {
        DBObject result = copy;
        for (DBObject child : trailToChild) {
            String childType = child.getType();
            String childName = child.getName();
            if (ModelUtil.hasLength((String)childName)) {
                result = result.findOwnedObject(childType, childName);
                continue;
            }
            result = result.getOwnedObjects(childType)[0];
        }
        return result;
    }

    private void unregisterImpl(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id != null) {
            Collection<DBObjectID> refs = this.getProvider().getObjectFactory().getReferenceIDs(obj);
            for (DBObjectID ref : refs) {
                Collection<DBObjectID> referers;
                if (!this.m_deps.containsKey(ref) || (referers = this.m_deps.get(ref)) == null) continue;
                referers.remove(id);
                if (referers.size() >= 1) continue;
                this.m_deps.remove(ref);
            }
            for (DBObject kid : this.getOwnedObjects(obj)) {
                this.unregisterImpl(kid);
            }
            if (obj instanceof SystemObject) {
                Iterator<Map.Entry<DBObjectID, Collection<DBObjectID>>> iter = this.m_soDeps.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<DBObjectID, Collection<DBObjectID>> e = iter.next();
                    Collection<DBObjectID> referers = e.getValue();
                    if (referers == null) continue;
                    referers.remove(id);
                    if (referers.size() >= 1) continue;
                    iter.remove();
                }
            }
        }
    }

    private void unregisterChildren(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id != null) {
            if (this.m_deps.containsKey(id)) {
                Collection<DBObjectID> object = this.m_deps.remove(id);
            }
            for (DBObject kid : this.getOwnedObjects(obj)) {
                this.unregisterChildren(kid);
            }
        }
    }

    private Collection<DBObjectID> getSchemaObjectReferersImpl(DBObjectID id, Collection<DBObjectID> refs) {
        Collection<DBObjectID> newRefs;
        if (id != null && (newRefs = this.m_soDeps.get(id)) != null && newRefs.size() > 0) {
            if (refs == null) {
                refs = this.createIDSet();
                refs.addAll(newRefs);
            } else {
                for (DBObjectID deepID : newRefs) {
                    if (deepID == null || refs.contains(deepID)) continue;
                    refs.add(deepID);
                    this.getSchemaObjectReferersImpl(deepID, refs);
                }
            }
        }
        return refs;
    }

    private void registerObject(SystemObject key, DBObject obj) {
        Collection<DBObjectID> refs = this.getProvider().getObjectFactory().getReferenceIDs(obj);
        for (DBObjectID ref : refs) {
            if (ref instanceof TemporaryObjectID) {
                this.getLogger().warning("WARNING: attempt to cache temporary ID with the dependency manager");
                continue;
            }
            if (this.supportsUnresolvedReferences() && this.isUnresolvedReference(ref)) {
                this.registerUnresolvedReference(key, obj, ref);
                continue;
            }
            this.registerDependency(key, obj, ref);
        }
        for (DBObject kid : this.getOwnedObjects(obj)) {
            this.registerObject(key, kid);
        }
    }

    private void registerSchemaObjectDependency(SystemObject referer, DBObjectID referedTo) {
        DBObjectID id = referer.getID();
        this.addMapping(id, referedTo, this.m_soDeps);
    }

    private void registerDependency(SystemObject key, DBObject referer, DBObjectID referedTo) {
        DBObjectID id = referer.getID();
        if (!(referedTo instanceof DataTypeID)) {
            this.addMapping(id, referedTo, this.m_deps);
            DBObjectID referedToParent = DBUtil.getUppermostParent(referedTo);
            if (referedToParent != null && key != null) {
                this.registerSchemaObjectDependency(key, referedToParent);
            }
        }
    }

    private void addMapping(DBObjectID id, DBObjectID refID, Map<DBObjectID, Collection<DBObjectID>> deps) {
        if (refID != null && id != null && !refID.equals(id)) {
            this.mapKeyToCollection(refID, id, deps);
        }
    }

    private <K, T> void mapKeyToCollection(K key, T itemForCollection, Map<K, Collection<T>> map) {
        Collection<T> c = map.get(key);
        if (c == null) {
            c = itemForCollection instanceof DBObjectID ? this.createIDSet() : new HashSet<T>();
            map.put(key, c);
        }
        c.add(itemForCollection);
    }

    private void registerUnresolvedReference(SystemObject key, DBObject referer, DBObjectID ref) {
        Collection<DBObjectID> referers;
        Map<DBObjectID, Collection<DBObjectID>> childObjectRefs;
        DBObjectID soID = key.getID();
        DBObjectID id = referer.getID();
        String refType = ref.getType();
        Map<DBObjectID, Map<DBObjectID, Collection<DBObjectID>>> danglersForType = this.m_danglers.get(refType);
        if (danglersForType == null) {
            danglersForType = this.createIDMap();
            this.m_danglers.put(refType, danglersForType);
        }
        if ((childObjectRefs = danglersForType.get(soID)) == null) {
            childObjectRefs = this.createIDMap();
            danglersForType.put(soID, childObjectRefs);
        }
        if ((referers = childObjectRefs.get(id)) == null) {
            referers = this.createIDSet();
            childObjectRefs.put(id, referers);
        }
        if (!referers.contains(ref)) {
            referers.add(ref);
        }
    }

    protected void checkInit() throws CancelledException {
    }

    protected final synchronized void registerAllObjects() throws CancelledException {
        try {
            this.clearAllCaches();
            this.m_registeredAll = true;
            String[] types = this.listObjectTypes();
            Schema[] schemas = this.listSchemas();
            for (int i = 0; i < schemas.length; ++i) {
                this.setRegisterProgress(0, 1, i, schemas.length, schemas[i].getName());
                SchemaObject[] objects = this.getProvider().listObjects(types, schemas[i]);
                for (int j = 0; j < objects.length; ++j) {
                    this.setRegisterProgress(j, objects.length, i, schemas.length, schemas[i].getName());
                    this.registerObject(objects[j]);
                }
            }
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (DBException dbe) {
            DBLog.getLogger(this).severe(dbe.getMessage());
            this.m_registeredAll = false;
        }
    }

    protected String[] listObjectTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        String[] t = this.getProvider().listObjectTypes();
        for (int i = 0; i < t.length; ++i) {
            retval.add(t[i]);
        }
        retval.remove("SEQUENCE");
        retval.remove("PACKAGE");
        retval.remove("FUNCTION");
        retval.remove("PROCEDURE");
        return retval.toArray(new String[retval.size()]);
    }

    protected Schema[] listSchemas() throws DBException {
        return this.getProvider().listSchemas();
    }

    protected void setRegisterProgress(int objN, int objT, int schemaN, int schemaT, String schemaName) throws CancelledException {
        CancelledException.checkInterrupt();
    }

    @Deprecated
    public static final SystemObject[] getDependencies(SystemObject obj, DBObjectProvider pro, boolean recurse) {
        return new SystemObject[0];
    }
}

