/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.RelationValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class ViewValidator
extends RelationValidator<View> {
    public ViewValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("forceOnCreate");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"SQLQuery", "queryString"}, path=true, level=ValidationLevel.FULL)
    public void validateView(View original, View view) throws ValidationException {
        ViewValidator.validateQuery((SQLQueryOwner)view, this.getProvider());
    }

    @DBObjectValidator.PropertyValidator(value={"restriction"}, level=ValidationLevel.FULL)
    public void validateQueryRestriction(View original, View view) throws ValidationException {
        OrderByObject[] orderBy;
        View.Restriction restriction = view.getRestriction();
        if (restriction != null && view.isDeclarative() && (orderBy = view.getSQLQuery().getOrderByObjects()) != null && orderBy.length > 0) {
            throw new ValidationException((DBObject)view, APIBundle.format((String)"VIEW_ORDER_BY_RESTRICTION", (Object[])new Object[]{restriction}));
        }
    }

    @Override
    public CascadeAction cascadeDelete(DBObject removed, View obj) {
        CascadeAction retval = CascadeAction.NONE;
        retval = this.checkSchemaDelete(removed, (SchemaObject)obj) ? CascadeAction.DELETE : ViewValidator.cascadeDelete(removed, (SQLQueryOwner)obj, this.getProvider());
        return retval;
    }

    public CascadeAction cascadeUpdate(Difference objDiff, View obj) throws DBException {
        CascadeAction retval = super.cascadeUpdate(objDiff, (DBObject)obj);
        if (retval == CascadeAction.UPDATE) {
            ViewValidator.resetDeclarativeQueryString((SQLQueryOwner)obj);
        }
        return retval;
    }

    public static CascadeAction cascadeDelete(DBObject removed, SQLQueryOwner obj, DBObjectProvider pro) {
        SQLQueryBuilder builder;
        Collection refs;
        CascadeAction retval = CascadeAction.NONE;
        SQLQuery query = obj.getSQLQuery();
        if (query != null && query.isDeclarative() && (refs = DBUtil.findUsagesIn((DBObject)removed, (DBObject)query)) != null && !refs.isEmpty() && (builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)pro)) != null) {
            retval = CascadeAction.UPDATE;
            DBObjectID origViewID = DBUtil.getOriginalID((DBObject)obj);
            if (origViewID == null) {
                builder.ensureQueryNonDeclarative(obj);
            } else {
                try {
                    SQLQueryOwner origView = (SQLQueryOwner)origViewID.resolveID();
                    if (origView != null) {
                        builder.ensureQueryNonDeclarative(origView);
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger(ViewValidator.class).warning("Couldn't resolve dependent view's ID: " + dbe.getMessage());
                }
            }
        }
        return retval;
    }

    public static void resetDeclarativeQueryString(SQLQueryOwner obj) {
        SQLQuery query = obj.getSQLQuery();
        if (query.isDeclarative()) {
            query.setQueryString(null);
        }
    }

    public static void buildAndResetQueryString(SQLQueryOwner obj, DBObjectProvider pro) {
        SQLQuery query = obj.getSQLQuery();
        if (query != null) {
            if (!query.isDeclarative()) {
                DBObject orig = null;
                DBObjectID id = obj.getID();
                if (id instanceof TemporaryObjectID) {
                    orig = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)id));
                }
                Schema schema = orig == null ? DBUtil.getSchema((DBObject)obj) : DBUtil.getSchema((DBObject)orig);
                SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)pro, (Schema)schema);
                try {
                    builder.buildQuery(query.getQueryString());
                    SQLQuery newQuery = builder.getSQLQuery();
                    obj.setSQLQuery(newQuery);
                }
                catch (SQLQueryException dbe) {
                    DBLog.getLogger(ViewValidator.class).fine("Couldn't build query for " + obj.getName());
                }
            }
            ViewValidator.resetDeclarativeQueryString(obj);
        }
    }

    public static void validateQuery(SQLQueryOwner view, DBObjectProvider pro) throws ValidationException {
        block3: {
            SQLQuery query = view.getSQLQuery();
            if (query == null) {
                throw new ValidationException((DBObject)view, APIBundle.get((String)"VIEW_ERROR_MISSING_QUERY"));
            }
            SQLQueryBuilder builder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)query, (DBObjectProvider)pro);
            try {
                builder.buildQuery(query);
            }
            catch (SQLQueryException sqe) {
                if (!query.isDeclarative() && (!builder.matchesProvider() || !(sqe instanceof SQLParseException))) break block3;
                throw new ValidationException((DBObject)view, sqe.getMessage());
            }
        }
    }
}

