/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;

public class SynonymValidator
extends SchemaObjectValidator<Synonym> {
    public SynonymValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("public");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"reference"})
    public void validateReference(Synonym original, Synonym synonym) throws ValidationException {
        DBObjectID ref = synonym.getReference();
        if (ref == null) {
            throw new ValidationException((DBObject)synonym, APIBundle.format((String)"SYNONYM_ERROR_BAD_REF", (Object[])new Object[]{synonym.getName(), "" + null}));
        }
        if (ref.equals(synonym.getID(), false)) {
            throw new ValidationException((DBObject)synonym, APIBundle.get((String)"SYNONYM_ERROR_LOOP"));
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }
}

