/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.util.ModelUtil;

public class AdaptiveServerEnterpriseTableBuilder
extends JdbcTableBuilder<Table> {
    public AdaptiveServerEnterpriseTableBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string);
    }

    @Override
    protected void buildUKs(final Table rel) throws DBException {
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select ind.name constraint_name,\n       tab.name table_name,\n       index_col(object_name(tab.id), ind.indid, 1, usr.uid) col1,\n       index_col(object_name(tab.id), ind.indid, 2, usr.uid) col2,\n       index_col(object_name(tab.id), ind.indid, 3, usr.uid) col3,\n       index_col(object_name(tab.id), ind.indid, 4, usr.uid) col4,\n       index_col(object_name(tab.id), ind.indid, 5, usr.uid) col5,\n       index_col(object_name(tab.id), ind.indid, 6, usr.uid) col6,\n       index_col(object_name(tab.id), ind.indid, 7, usr.uid) col7,\n       index_col(object_name(tab.id), ind.indid, 8, usr.uid) col8,\n       index_col(object_name(tab.id), ind.indid, 9, usr.uid) col9,\n       index_col(object_name(tab.id), ind.indid, 10, usr.uid) col10,\n       index_col(object_name(tab.id), ind.indid, 11, usr.uid) col11,\n       index_col(object_name(tab.id), ind.indid, 12, usr.uid) col12,\n       index_col(object_name(tab.id), ind.indid, 13, usr.uid) col13,\n       index_col(object_name(tab.id), ind.indid, 14, usr.uid) col14,\n       index_col(object_name(tab.id), ind.indid, 15, usr.uid) col15,\n       index_col(object_name(tab.id), ind.indid, 16, usr.uid) col16\nfrom sysindexes ind,\n     sysobjects tab,\n     sysusers usr\nwhere (ind.status & 2050) = 2\n  and ind.id = tab.id\n  and usr.uid = tab.uid\n  and usr.name = ?\n  and tab.name = ?", new Object[]{rel.getSchema(), rel.getName()});
        wrap.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        UniqueConstraint con = (UniqueConstraint)AdaptiveServerEnterpriseTableBuilder.this.getProvider().getObjectFactory().newObject(UniqueConstraint.class, (DBObject)rel);
                        String name = rs.getString("constraint_name");
                        con.setName(name);
                        con.setID((DBObjectID)new NameBasedID("CONSTRAINT", name, rel.getID()));
                        rel.addConstraint((Constraint)con);
                        for (int i = 1; i <= 16; ++i) {
                            String alias = "col" + i;
                            String colName = rs.getString(alias);
                            if (!ModelUtil.hasLength((String)colName)) continue;
                            Column col = rel.getColumn(colName);
                            con.addColumn(col);
                        }
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)rel, sqe);
                }
            }
        });
    }

    @Override
    protected void buildCCs(final Table rel) throws DBException {
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select obj.name,\n       com.text\nfrom syscomments com,\n     sysconstraints con,\n     sysobjects obj,\n     sysobjects tab,\n     sysusers usr\nwhere con.status = 128\n  and con.constrid = com.id\n  and com.id = obj.id\n  and con.tableid = tab.id\n  and usr.uid = tab.uid\n  and usr.name = ?\n  and tab.name = ?", new Object[]{rel.getSchema(), rel.getName()});
        wrap.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        CheckConstraint con = (CheckConstraint)AdaptiveServerEnterpriseTableBuilder.this.getProvider().getObjectFactory().newObject(CheckConstraint.class, (DBObject)rel);
                        String ccName = rs.getString(1);
                        con.setName(ccName);
                        String ccCondition = rs.getString(2);
                        int start = ccCondition.indexOf(40) + 1;
                        int end = ccCondition.lastIndexOf(41);
                        con.setCheckCondition(ccCondition.substring(start, end));
                        con.setID((DBObjectID)new NameBasedID("CONSTRAINT", ccName, rel.getID()));
                        rel.addConstraint((Constraint)con);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)rel, sqe);
                }
            }
        });
    }

    @Override
    protected void buildFKs(final Table table) throws DBException {
        QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select null '1 PKTABLE_CAT',\n       pk_schema.name '2 PKTABLE_SCHEM',\n       pk_table.name '3 PKTABLE_NAME',\n       pk_col.name '4 PKCOLUMN_NAME',\n       null '5 FKTABLE_CAT',\n       fk_schema.name '6 FKSCHEM',\n       fk_table.name '7 FKTABLE_NAME',\n       fk_col.name '8 FKCOLUMN_NAME',\n       1 '9 KEY_SEQ',\n       null '10 UPDATE_RULE',\n       null '11 DELETE_RULE',\n       fk.name '12 FK_NAME',\n       null '13 PK_NAME',\n       null '14 DEFERRABILIITY'\nfrom sysreferences ref,\n     sysusers pk_schema,\n     sysobjects pk_table,\n     syscolumns pk_col,\n     sysusers fk_schema,\n     sysobjects fk_table,\n     syscolumns fk_col,\n     sysobjects fk\nwhere fk_schema.name = ? and\n      fk_table.name = ? and\n      fk.id = ref.constrid and\n      fk_table.id = ref.tableid and\n      pk_table.id = ref.reftabid and\n      pk_schema.uid = pk_table.uid and\n      fk_schema.uid = fk_table.uid and\n      fk_col.id = fk_table.id and\n      pk_col.id = pk_table.id and\n      ( ( fk_col.colid = ref.fokey1 and pk_col.colid = ref.refkey1 ) or\n        ( fk_col.colid = ref.fokey2 and pk_col.colid = ref.refkey2 ) or\n        ( fk_col.colid = ref.fokey3 and pk_col.colid = ref.refkey3 ) or\n        ( fk_col.colid = ref.fokey4 and pk_col.colid = ref.refkey4 ) or\n        ( fk_col.colid = ref.fokey5 and pk_col.colid = ref.refkey5 ) or\n        ( fk_col.colid = ref.fokey6 and pk_col.colid = ref.refkey6 ) or\n        ( fk_col.colid = ref.fokey7 and pk_col.colid = ref.refkey7 ) or\n        ( fk_col.colid = ref.fokey8 and pk_col.colid = ref.refkey8 ) or\n        ( fk_col.colid = ref.fokey9 and pk_col.colid = ref.refkey9 ) or\n        ( fk_col.colid = ref.fokey10 and pk_col.colid = ref.refkey10 ) or\n        ( fk_col.colid = ref.fokey11 and pk_col.colid = ref.refkey11 ) or\n        ( fk_col.colid = ref.fokey12 and pk_col.colid = ref.refkey12 ) or\n        ( fk_col.colid = ref.fokey13 and pk_col.colid = ref.refkey13 ) or\n        ( fk_col.colid = ref.fokey14 and pk_col.colid = ref.refkey14 ) or\n        ( fk_col.colid = ref.fokey15 and pk_col.colid = ref.refkey15 ) or\n        ( fk_col.colid = ref.fokey16 and pk_col.colid = ref.refkey16 ) ) ", new Object[]{table.getSchema().getName(), table.getName()});
        QueryWrapper.QueryRunnable run = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                AdaptiveServerEnterpriseTableBuilder.this.buildFKsFromMetadata(rs, (Relation)table, table.getName());
            }
        };
        try {
            wrap.executeQuery(run);
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Couldn't get FK information from dictionary for {0}: {1}", new String[]{table.getName(), dbe.getMessage()});
        }
    }

    @Override
    protected String makePKName(String pkSchemaName, String pkTableName) {
        String retval = null;
        String schemaDotName = pkSchemaName + "." + pkTableName;
        QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), " SELECT name  FROM sysindexes  WHERE (status & 2048) = 2048  AND id = object_id( ? ) ", new Object[]{schemaDotName});
        try {
            retval = wrap.executeSingleCellQuery();
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Couldn't get PK name from dictionary for {0}: {1}", new String[]{schemaDotName, dbe.getMessage()});
        }
        if (!ModelUtil.hasLength((String)retval)) {
            retval = super.makePKName(pkSchemaName, pkTableName);
        }
        return retval;
    }
}

