/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.sqlite.SQLiteBuilderHelper;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

public class SQLiteTableBuilder
extends JdbcTableBuilder<Table> {
    private static final String COMMENT_HEADER = "/*COMMENT=\n";
    private final SQLiteBuilderHelper m_helper;
    private final TokenPattern m_pkUkSearch = new TokenPattern(", CONSTRAINT <name ?> <type {PRIMARY KEY | UNIQUE}>");
    private final TokenPattern m_fkSearch = new TokenPattern(", CONSTRAINT <name ?> FOREIGN KEY (...) REFERENCES <refTable ?.> [<refCols (...)>]");
    private final TokenPattern m_fkDelSearch = new TokenPattern("ON DELETE <action {SET NULL|SET DEFAULT|CASCADE|RESTRICT|NO ACTION}>");
    private final TokenPattern m_fkDefSearch = new TokenPattern("<not [NOT]> DEFERRABLE [INITIALLY <initially {IMMEDIATE|DEFERRED}>]");
    private final TokenPattern m_ccSearch = new TokenPattern(", CONSTRAINT <name ?> CHECK <cond (...)>");
    private final TokenPattern m_colDefSearch = new TokenPattern("<name ?> {^DEFAULT}... {DEFAULT <defVal {(...)|?}>}");

    public SQLiteTableBuilder(JdbcDatabase db, String catalog) {
        super(db, catalog);
        this.m_helper = new SQLiteBuilderHelper((Database)db);
    }

    @Override
    protected Map<String, Object> createDataTypeAttributes(Table rel, Column column, DataType dataType, Long size, Long scale, String jdbcTypeName) {
        return null;
    }

    @Override
    protected void buildPK(Table rel) throws DBException {
        this.buildPKUKs(rel, true);
    }

    @Override
    protected void buildUKs(Table rel) throws DBException {
        this.buildPKUKs(rel, false);
    }

    private void buildPKUKs(Table rel, boolean buildPk) {
        Map<String, List<String>> map = this.getPKUKColumns(rel.getName(), buildPk, !buildPk);
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            String name = e.getKey();
            List<String> cols = e.getValue();
            if (cols.size() <= 0) continue;
            PKConstraint uk = buildPk ? new PKConstraint(name, (Relation)rel) : new UniqueConstraint(name, (Relation)rel);
            this.setID((ChildDBObject)uk);
            for (String col : cols) {
                uk.addColumn(rel.getColumn(col));
            }
            rel.addConstraint((Constraint)uk);
        }
    }

    @Override
    protected void buildFKs(Table rel) throws DBException {
        TokenPattern.PatternResult fkSearch;
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", rel.getName());
        String schemaName = rel.getSchema().getName();
        while ((fkSearch = this.m_fkSearch.getResult((Token)tk, false)) != null) {
            tk = fkSearch.getStartToken();
            List<String> cols = this.getFKColumnList((Token)tk);
            Token refColTk = fkSearch.getNamedMatchStartToken("refCols");
            List<Object> refCols = refColTk == null ? new ArrayList() : this.getFKColumnList(refColTk);
            if (cols.size() > 0) {
                TokenPattern.PatternResult fkDefSearch;
                FKConstraint fk = new FKConstraint(fkSearch.getNamedMatch("name"), (Relation)rel);
                this.setID((ChildDBObject)fk);
                for (String col : cols) {
                    fk.addColumn(rel.getColumn(col));
                }
                fk.setReferenceID(this.getRefConstraintID(fkSearch.getNamedMatch("refTable"), schemaName, cols, refCols));
                TokenPattern.PatternResult fkDelSearch = this.m_fkDelSearch.getResult((Token)tk, false);
                if (fkDelSearch != null) {
                    Token actionToken = fkDelSearch.getNamedMatchStartToken("action");
                    FKConstraint.ReferentialAction action = FKConstraint.ReferentialAction.RESTRICT;
                    if (actionToken.matches("RESTRICT")) {
                        action = FKConstraint.ReferentialAction.RESTRICT;
                    } else if (actionToken.matches("CASCADE")) {
                        action = FKConstraint.ReferentialAction.CASCADE;
                    } else if (actionToken.matches("NO") && actionToken.getNextCodeToken().matches("ACTION")) {
                        action = FKConstraint.ReferentialAction.NO_ACTION;
                    } else if (actionToken.matches("SET") && actionToken.getNextCodeToken().matches("NULL")) {
                        action = FKConstraint.ReferentialAction.SET_NULL;
                    } else if (actionToken.matches("SET") && actionToken.getNextCodeToken().matches("DEFAULT")) {
                        action = FKConstraint.ReferentialAction.SET_DEFAULT;
                    }
                    fk.setOnDeleteAction(action);
                }
                if ((fkDefSearch = this.m_fkDefSearch.getResult((Token)tk, false)) != null) {
                    Token notToken = fkDefSearch.getNamedMatchStartToken("not");
                    Token initiallyToken = fkDefSearch.getNamedMatchStartToken("initially");
                    Constraint.DeferrableState defState = null;
                    if (notToken == null) {
                        defState = initiallyToken != null && initiallyToken.matches("IMMEDIATE") ? Constraint.DeferrableState.DEFER_INIT_IMMEDIATE : Constraint.DeferrableState.DEFER_INIT_DEFERRED;
                    }
                    fk.setDeferrableState(defState);
                }
                rel.addConstraint((Constraint)fk);
            }
            tk = fkSearch.getEndToken();
        }
    }

    @Override
    protected void buildCCs(Table rel) throws DBException {
        TokenPattern.PatternResult ccSearch;
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", rel.getName());
        while ((ccSearch = this.m_ccSearch.getResult((Token)tk, false)) != null) {
            tk = ccSearch.getStartToken();
            Token condStart = ccSearch.getNamedMatchStartToken("cond");
            Token condEnd = ccSearch.getNamedMatchEndToken("cond");
            CheckConstraint cc = (CheckConstraint)this.newObject(CheckConstraint.class, ccSearch.getNamedMatch("name"));
            cc.setRelation((Relation)rel);
            this.setID((ChildDBObject)cc);
            String cond = condStart.getNextCodeToken().getSource(true, condEnd.getPrevToken());
            cc.setCheckCondition(cond);
            rel.addConstraint((Constraint)cc);
            tk = ccSearch.getEndToken();
        }
    }

    private Map<String, List<String>> getPKUKColumns(String tablename, boolean pk, boolean uk) {
        TokenPattern.PatternResult pkUkSearch;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", tablename);
        while ((pkUkSearch = this.m_pkUkSearch.getResult((Token)tk, false)) != null) {
            tk = pkUkSearch.getNamedMatchStartToken("type");
            if (pk && tk.matches("PRIMARY") || uk && tk.matches("UNIQUE")) {
                List<String> cols = this.getFKColumnList((Token)tk);
                map.put(pkUkSearch.getNamedMatch("name"), cols);
            }
            tk = pkUkSearch.getEndToken();
        }
        return map;
    }

    private List<String> getFKColumnList(Token tk) {
        Token tk2 = tk;
        ArrayList<String> ret = new ArrayList<String>();
        while (tk2.isCode() && !tk2.matches("(")) {
            tk2 = tk2.getNextCodeToken();
        }
        while (tk2.matches("(") || tk2.matches(",")) {
            tk2 = tk2.getNextCodeToken();
            ret.add(tk2.getSource());
            tk2 = tk2.getNextCodeToken();
        }
        return ret;
    }

    private List<String> getColumnList(Token tk) {
        Token tk2 = tk;
        ArrayList<String> ret = new ArrayList<String>();
        while (tk2.isCode() && !tk2.matches("(")) {
            tk2 = tk2.getNextCodeToken();
        }
        while (tk2.matches("(") || tk2.matches(",")) {
            Token start = tk2 = tk2.getNextCodeToken();
            int paren = 0;
            while (paren >= 0 && (paren != 0 || !tk2.matches(",") && !tk2.matches(")"))) {
                if (tk2.matches("(")) {
                    ++paren;
                } else if (tk2.matches(")")) {
                    --paren;
                }
                tk2 = tk2.getNextCodeToken();
            }
            ret.add(start.getSource(false, tk2.getPrevCodeToken()));
        }
        return ret;
    }

    private DBObjectID getRefConstraintID(String tableName, String schemaName, List<String> fkCols, List<String> refCols) throws DBException {
        int numFKCols = fkCols.size();
        int numRefCols = refCols.size();
        NameBasedID parID = new NameBasedID("TABLE", schemaName, tableName);
        parID.setProvider((DBObjectProvider)this.getDatabase());
        Map<String, List<String>> map = numRefCols == 0 ? this.getPKUKColumns(tableName, true, false) : (numRefCols == numFKCols ? this.getPKUKColumns(tableName, true, true) : new HashMap<String, List<String>>());
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            String name = e.getKey();
            List<String> colList = e.getValue();
            if (colList.size() != fkCols.size()) continue;
            if (numRefCols == 0) {
                NameBasedID id = new NameBasedID("CONSTRAINT", name, (DBObjectID)parID);
                id.setProvider((DBObjectProvider)this.getDatabase());
                return id;
            }
            boolean found = true;
            for (String refCol : refCols) {
                if (colList.contains(refCol)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            NameBasedID id = new NameBasedID("CONSTRAINT", name, (DBObjectID)parID);
            id.setProvider((DBObjectProvider)this.getDatabase());
            return id;
        }
        return null;
    }

    @Override
    protected void loadAndBuildIndexes(Table table) throws DBException {
        super.loadAndBuildIndexes(table);
        ArrayList<String> toDel = new ArrayList<String>();
        for (Index i : table.getIndexes()) {
            String name = i.getName();
            if (name == null || !name.startsWith("sqlite_autoindex_")) continue;
            toDel.add(name);
        }
        for (String name : toDel) {
            table.removeIndex(table.getIndex(name));
        }
    }

    private void setID(ChildDBObject obj) {
        obj.setID((DBObjectID)new NameBasedID(obj.getType(), obj.getName(), obj.getParent().getID()));
    }

    @Override
    protected void addExtraColumnAttributes(Table rel) {
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", rel.getName());
        List<String> colList = this.getColumnList((Token)tk);
        for (String colDef : colList) {
            TokenPattern.PatternResult colDefSearch = this.m_colDefSearch.getResult(colDef);
            if (colDefSearch == null) continue;
            Column col = (Column)DBUtil.findChildByName((DBObject)rel, (String)"columns", (String)colDefSearch.getNamedMatch("name"), (DBObjectProvider)this.getProvider());
            String defaultValue = colDefSearch.getNamedMatch("defVal");
            col.setDefault((Object)defaultValue);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"Comment"})
    public void fillInComment(Table rel) throws DBException {
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", rel.getName());
        while (!tk.isCode() || !tk.matches("(")) {
            tk = tk.getNextCodeToken();
        }
        if (tk.matches("(")) {
            String comment;
            tk = tk.getNextToken();
            while (tk.getType() == Token.Type.WHITESPACE) {
                tk = tk.getNextToken();
            }
            if (tk.getType() == Token.Type.MULTI_LINE_COMMENT && (comment = tk.getSource()).startsWith(COMMENT_HEADER)) {
                String tableComment = comment.substring(COMMENT_HEADER.length(), comment.length() - 3);
                rel.setProperty("Comment", (Object)tableComment);
            }
        }
    }
}

