/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlSpecAndBodyBuilder;
import oracle.javatools.util.Tuple;

public class TypeBuilder
extends PlSqlSpecAndBodyBuilder<Type> {
    private static final String action = "action";
    private static final String ADD = "ADD";
    private static final String ATTRIBUTE = "ATTRIBUTE";
    private static final String authid = "authid";
    private static final String ccontext = "ccontext";
    private static final String clibname = "clibname";
    private static final String cname = "cname";
    private static final String CURRENT_USER = "CURRENT_USER";
    private static final String CustomDatum = "CustomDatum";
    private static final String datatype = "datatype";
    private static final String DROP = "DROP";
    private static final String extname = "extname";
    private static final String extvarname = "extvarname";
    private static final String final_ = "final";
    private static final String FINAL = "FINAL";
    private static final String INSTANTIABLE = "INSTANTIABLE";
    private static final String inst = "inst";
    private static final String isAsUnder = "isAsUnder";
    private static final String javaname = "javaname";
    private static final String limit = "limit";
    private static final String methodType = "methodType";
    private static final String name = "name";
    private static final String notFinal = "notFinal";
    private static final String notInst = "notInst";
    private static final String NOT = "NOT";
    private static final String oid = "oid";
    private static final String OPAQUE = "OPAQUE";
    private static final String OraData = "OraData";
    private static final String over = "over";
    private static final String PRAGMA = "PRAGMA";
    private static final String SQLData = "SQLData";
    private static final String start = "start";
    private static final String typ = "type";
    private static final String under = "under";
    private static final String UNDER = "UNDER";
    private static final String using = "using";
    private static final String what = "what";
    private PlSqlTokenPattern m_selfSearch;

    public TypeBuilder(AbstractDBObjectProvider pro) {
        super(pro, "TYPE");
    }

    @Override
    protected void addChildren(Object parentParseNode, Type parentFrag, PlSqlParser parser) throws CancelledException {
    }

    @Override
    protected void buildObjectProperties(Type type, PlSqlParser parser) throws CancelledException {
        PlSqlToken tk = parser.getTypeToken();
        PlSqlSearch search = new PlSqlSearch("[create [or replace]] TYPE ?. [OID ?] [AUTHID ?] <isAsUnder {IS|AS|UNDER}> <type [{OPAQUE|OBJECT|TABLE OF|VARRAY|VARYING ARRAY}]>");
        String typeCode = null;
        String collType = null;
        if (search.matches(tk)) {
            if (search.getNamedMatchStartToken(isAsUnder).matches(UNDER)) {
                typeCode = "OBJECT";
            } else {
                tk = search.getNamedMatchStartToken(typ);
                if (tk != null) {
                    if (tk.matches("OBJECT") || tk.matches(OPAQUE)) {
                        typeCode = "OBJECT";
                    } else {
                        typeCode = "COLLECTION";
                        collType = tk.matches("TABLE") ? "TABLE" : "VARYING ARRAY";
                    }
                }
            }
        }
        type.setTypeCode(typeCode);
        type.setCollectionType(collType);
        StringBuffer sb = new StringBuffer("{<ref [REF]> ");
        if (type.getSchema() != null) {
            sb.append("[").append(type.getSchema().getName()).append(" .]");
        }
        sb.append(type.getName()).append("|SELF AS RESULT}");
        this.m_selfSearch = new PlSqlTokenPattern(sb.toString());
        if ("OBJECT".equals(typeCode)) {
            this.deriveObjectProperties(type, parser);
        } else {
            this.deriveCollectionProperties(type, parser);
        }
        for (Tuple toks : parser.getAlterStatements()) {
            for (Tuple<PlSqlToken, PlSqlToken> clause : this.getAlterClauses((Tuple<PlSqlToken, PlSqlToken>)toks)) {
                this.processAlterClause(type, clause, parser);
            }
        }
        this.m_selfSearch = null;
    }

    @Override
    protected PlSqlTokenPattern getSelfSearch() {
        return this.m_selfSearch;
    }

    private List<Tuple<PlSqlToken, PlSqlToken>> getAlterClauses(Tuple<PlSqlToken, PlSqlToken> toks) {
        PlSqlSearch search = new PlSqlSearch("alter type ?. <start ?>");
        ArrayList<Tuple<PlSqlToken, PlSqlToken>> ret = new ArrayList<Tuple<PlSqlToken, PlSqlToken>>();
        int endOfStatement = ((PlSqlToken)toks.getSecond()).getEnd();
        if (search.matches((PlSqlToken)toks.getFirst(), (PlSqlToken)toks.getSecond())) {
            PlSqlToken tk1;
            PlSqlToken tk2 = tk1 = search.getNamedMatchStartToken(start);
            int parens = 0;
            while (!tk2.isEndMarker() && tk2.getStart() < endOfStatement) {
                if (tk2.matches("(")) {
                    ++parens;
                } else if (tk2.matches(")")) {
                    --parens;
                } else if (parens == 0 && tk2.matches(",")) {
                    ret.add((Tuple<PlSqlToken, PlSqlToken>)new Tuple((Object)tk1, (Object)tk2.getPrevCodeToken()));
                    tk1 = (PlSqlToken)tk2.getNextCodeToken();
                }
                tk2 = (PlSqlToken)tk2.getNextCodeToken();
            }
            if (tk2.isEndMarker()) {
                tk2 = (PlSqlToken)tk2.getPrevCodeToken();
            }
            ret.add((Tuple<PlSqlToken, PlSqlToken>)new Tuple((Object)tk1, (Object)tk2));
        }
        return ret;
    }

    private void deriveObjectProperties(Type type, PlSqlParser parser) throws CancelledException {
        boolean isFinal = true;
        boolean isInstantiable = true;
        PlSqlSearch search = new PlSqlSearch("TYPE ?. [FORCE] [OID <oid ?>] [AUTHID <authid ?>] {{IS|AS}OBJECT|UNDER <under ?.>|{IS|AS}OPAQUE VARYING (*) USING LIBRARY ?} [EXTERNAL NAME <extname ?> LANGUAGE JAVA USING <using ?>]");
        if (search.matches(parser.getTypeToken())) {
            PlSqlToken childTk;
            int offset;
            type.setOID(search.getNamedMatch(oid));
            boolean authidCurrentUser = CURRENT_USER.equalsIgnoreCase(search.getNamedMatch(authid));
            type.setAuthidCurrentUser(authidCurrentUser);
            if (search.getNamedMatch(under) != null) {
                PlSqlToken start = search.getNamedMatchStartToken(under);
                PlSqlToken end = search.getNamedMatchEndToken(under);
                PlSqlReference ref = this.findDataTypeReference(start, end, "underTypeReference", parser);
                type.setUnderTypeReference(ref);
            }
            type.setSqljExternalName(this.getNameSearchStripQuotes(search, extname));
            if (type.getSqljExternalName() != null) {
                Type.SQLJUsingType sqljUsing = null;
                String usingStr = search.getNamedMatch(using);
                if (SQLData.equalsIgnoreCase(usingStr)) {
                    sqljUsing = Type.SQLJUsingType.SQLData;
                } else if (OraData.equalsIgnoreCase(usingStr)) {
                    sqljUsing = Type.SQLJUsingType.OraData;
                }
                if (CustomDatum.equalsIgnoreCase(usingStr)) {
                    sqljUsing = Type.SQLJUsingType.CustomDatum;
                }
                type.setSqljUsing(sqljUsing);
            }
            PlSqlToken tk = parser.getTokenAtOffset(parser.getEndOffsetOfObject());
            while (!tk.isCode() || tk.matches(";") || tk.matches("/")) {
                tk = (PlSqlToken)tk.getPrevCodeToken();
            }
            if (tk.matches(INSTANTIABLE) && (tk = (PlSqlToken)tk.getPrevCodeToken()).matches(NOT)) {
                isInstantiable = false;
                tk = (PlSqlToken)tk.getPrevCodeToken();
            }
            if (tk.matches(FINAL) && (tk = (PlSqlToken)tk.getPrevCodeToken()).matches(NOT)) {
                isFinal = false;
            }
            type.setFinal(isFinal);
            type.setInstantiable(isInstantiable);
            for (Object childNode : parser.getPropertyNodes((DBObjectPlSqlFragment)type, "attributes")) {
                offset = parser.getStartOffset(childNode);
                childTk = parser.getTokenAtOffset(offset);
                PlSqlAttribute attr = this.getAttribute(type, childTk, null, parser);
                if (attr == null) continue;
                type.addAttribute(attr);
            }
            for (Object childNode : parser.getPropertyNodes((DBObjectPlSqlFragment)type, "methods")) {
                offset = parser.getStartOffset(childNode);
                childTk = parser.getTokenAtOffset(offset);
                PlSqlMethod meth = this.getMethod(type, childTk, parser);
                if (meth == null) continue;
                type.addMethod(meth);
            }
        }
    }

    private void deriveCollectionProperties(Type type, PlSqlParser parser) throws CancelledException {
        PlSqlSearch search = new PlSqlSearch("TYPE ?. [FORCE] [OID <oid ?>] {IS|AS} { {VARRAY | VARYING ARRAY} ( <limit ?> ) |   TABLE } OF <datatype ?%> [NOT NULL]");
        if (search.matches(this.getParser(type).getTypeToken())) {
            type.setOID(search.getNamedMatch(oid));
            type.setLimit(this.getIntegerNamedMatch(search, limit));
            PlSqlToken start = search.getNamedMatchStartToken(datatype);
            PlSqlToken end = search.getNamedMatchEndToken(datatype);
            PlSqlReference ref = this.findDataTypeReference(start, end, "ofTypeUsageReference", parser);
            type.setOfTypeUsageReference(ref);
        }
    }

    private void processAlterClause(Type type, Tuple<PlSqlToken, PlSqlToken> toks, PlSqlParser parser) throws CancelledException {
        PlSqlSearch search;
        PlSqlToken endToken;
        PlSqlSearch dependantHandlingSearch = new PlSqlSearch("{INVALIDATE|CASCADE}");
        PlSqlToken tk = (PlSqlToken)toks.getFirst();
        if (dependantHandlingSearch.isWithin(tk, endToken = (PlSqlToken)toks.getSecond())) {
            endToken = (PlSqlToken)dependantHandlingSearch.getStartToken().getPrevCodeToken();
        }
        if ((search = new PlSqlSearch("<action {ADD|DROP|MODIFY}> <what ?>")).matches(tk)) {
            PlSqlToken actionTk = search.getNamedMatchStartToken(action);
            PlSqlToken whatTk = search.getNamedMatchStartToken(what);
            PlSqlToken startTk = (PlSqlToken)whatTk.getNextCodeToken();
            if (whatTk.matches(ATTRIBUTE)) {
                boolean more = true;
                while (more) {
                    if (startTk.matches("(") || startTk.matches(",")) {
                        startTk = (PlSqlToken)startTk.getNextCodeToken();
                    }
                    PlSqlSearch attrSearch = actionTk.matches(DROP) ? new PlSqlSearch("<name ?>") : new PlSqlSearch("<name ?> <datatype ?%> [EXTERNAL NAME <extname ?>]");
                    more = false;
                    if (!attrSearch.matches(startTk)) continue;
                    PlSqlToken end = attrSearch.getEndToken();
                    this.processAlterAttributeClause(type, search.getNamedMatch(action), startTk, end, parser);
                    startTk = (PlSqlToken)end.getNextCodeToken();
                    more = startTk.matches(",") && startTk.getStart() < endToken.getStart();
                }
            } else if (actionTk.matches(ADD)) {
                PlSqlMethod meth = this.getMethod(type, whatTk, parser);
                if (meth != null) {
                    type.addMethod(meth);
                }
            } else if (actionTk.matches(DROP)) {
                this.processDropMethodClause(type, whatTk, parser);
            } else {
                PlSqlSearch search2 = new PlSqlSearch("MODIFY {LIMIT <limit ?>|ELEMENT TYPE <datatype ?%>}");
                if (search2.matches(tk, endToken)) {
                    String datatypeStr = search2.getNamedMatch(datatype);
                    if (datatypeStr != null) {
                        PlSqlToken start = search2.getNamedMatchStartToken(datatype);
                        PlSqlToken end = search2.getNamedMatchEndToken(datatype);
                        PlSqlReference ref = this.findDataTypeReference(start, end, "ofTypeUsageReference", parser);
                        type.setOfTypeUsageReference(ref);
                    } else {
                        type.setLimit(this.getIntegerNamedMatch(search2, limit));
                    }
                }
            }
        } else {
            PlSqlSearch search3 = new PlSqlSearch(" { <notInst NOT INSTANTIABLE>|   <inst INSTANTIABLE>|   <notFinal NOT FINAL>|   <final FINAL>}...");
            if (search3.matches(tk, endToken)) {
                if (search3.getNamedMatch(notInst) != null) {
                    type.setInstantiable(false);
                } else if (search3.getNamedMatch(inst) != null) {
                    type.setInstantiable(true);
                }
                if (search3.getNamedMatch(notFinal) != null) {
                    type.setFinal(false);
                } else if (search3.getNamedMatch(final_) != null) {
                    type.setFinal(true);
                }
            }
        }
    }

    private PlSqlAttribute getAttribute(Type type, PlSqlToken startToken, PlSqlToken endToken, PlSqlParser parser) throws CancelledException {
        PlSqlSearch attributeSearch = new PlSqlSearch("<name ?> <datatype ?%> [EXTERNAL NAME <extname ?>]");
        PlSqlAttribute attr = null;
        if (attributeSearch.matches(startToken, endToken)) {
            PlSqlToken nameTk = attributeSearch.getNamedMatchStartToken(name);
            String name = this.getProvider().getInternalName(nameTk.getSource());
            attr = this.createFragment(PlSqlAttribute.class);
            attr.setParent((DBObject)type);
            this.setCommon(parser, (DBObjectPlSqlFragment)attr, attributeSearch.getStartToken().getStart(), attributeSearch.getEndToken().getEnd(), name, nameTk);
            PlSqlToken startTk = attributeSearch.getNamedMatchStartToken(datatype);
            PlSqlToken endTk = attributeSearch.getNamedMatchEndToken(datatype);
            PlSqlReference ref = this.findDataTypeReference(startTk, endTk, "dataTypeReference", parser);
            attr.setDataTypeReference(ref);
            attr.setSqljExternalName(this.getNameSearchStripQuotes(attributeSearch, extname));
        }
        return attr;
    }

    private PlSqlMethod getMethod(Type type, PlSqlToken tk, PlSqlParser parser) throws CancelledException {
        PlSqlSearch methodSearch = new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]");
        PlSqlMethod method = null;
        if (methodSearch.matches(tk)) {
            method = this.createFragment(PlSqlMethod.class);
            method.setParent((DBObject)type);
            method.setStartOffset(Integer.valueOf(methodSearch.getStartToken().getStart()));
            method.setEndOffset(Integer.valueOf(methodSearch.getEndToken().getEnd()));
            PlSqlToken pnameTk = methodSearch.getNamedMatchStartToken("pname");
            PlSqlToken fnameTk = methodSearch.getNamedMatchStartToken("fname");
            PlSqlToken sigStartTk = pnameTk != null ? pnameTk : fnameTk;
            String signature = this.getSubProgramName(sigStartTk, (PlSqlSubProgram)method);
            method.setName(signature);
            method.setFinal(methodSearch.getNamedMatch(final_) != null);
            method.setOverriding(methodSearch.getNamedMatch(over) != null);
            method.setInstantiable(methodSearch.getNamedMatch(notInst) == null);
            String methodTypeStr = methodSearch.getNamedMatch(methodType);
            methodTypeStr = methodTypeStr.replace(" ", "_");
            try {
                method.setMethodType(PlSqlMethod.MethodType.valueOf((String)methodTypeStr));
            }
            catch (Exception e) {
                method.setMethodType(PlSqlMethod.MethodType.MEMBER);
            }
            String javaName = this.getNameSearchStripQuotes(methodSearch, javaname);
            String cLibName = this.getNameSearchStripQuotes(methodSearch, clibname);
            if (javaName != null) {
                method.setCallSpecLanguage(PlSqlMethod.CallSpecLanguage.JAVA);
                method.setCallSpecName(javaName);
            } else if (cLibName != null) {
                method.setCallSpecLanguage(PlSqlMethod.CallSpecLanguage.C);
                method.setCallSpecName(this.getNameSearchStripQuotes(methodSearch, cname));
                method.setCallSpecLibName(cLibName);
                method.setCallSpecWithContext(methodSearch.getNamedMatch(ccontext) != null);
            }
            String extnameStr = this.getNameSearchStripQuotes(methodSearch, extname);
            String extvarnameStr = this.getNameSearchStripQuotes(methodSearch, extvarname);
            if (extnameStr != null) {
                method.setSqljSigName(extnameStr);
            } else if (extvarnameStr != null) {
                method.setSqljSigVarName(extvarnameStr);
            }
        }
        return method;
    }

    private void processAlterAttributeClause(Type type, String action, PlSqlToken startTk, PlSqlToken endToken, PlSqlParser parser) throws CancelledException {
        if (DROP.equalsIgnoreCase(action)) {
            PlSqlAttribute oldAttr = type.getAttribute(startTk.getSource(true));
            if (oldAttr != null) {
                type.removeAttribute(oldAttr);
            }
        } else {
            PlSqlAttribute attr = this.getAttribute(type, startTk, endToken, parser);
            if (attr != null) {
                if (ADD.equalsIgnoreCase(action)) {
                    type.addAttribute(attr);
                } else {
                    PlSqlAttribute oldAttr = type.getAttribute(attr.getName());
                    attr.copyTo((Object)oldAttr);
                }
            }
        }
    }

    private void processDropMethodClause(Type type, PlSqlToken tk, PlSqlParser parser) throws CancelledException {
        PlSqlMethod method = this.getMethod(type, tk, parser);
        if (method != null) {
            String sig = method.getSignature();
            PlSqlMethod delMethod = null;
            for (PlSqlMethod m : type.getMethods()) {
                if (!sig.equals(m.getSignature())) continue;
                delMethod = m;
                break;
            }
            if (delMethod != null) {
                type.removeMethod(delMethod);
            }
        }
    }

    private Integer getIntegerNamedMatch(PlSqlSearch search, String name) {
        Integer retval = null;
        String strVal = search.getNamedMatch(name);
        if (strVal != null) {
            try {
                retval = Integer.valueOf(strVal);
            }
            catch (NumberFormatException e) {
                retval = null;
            }
        }
        return retval;
    }

    private String getNameSearchStripQuotes(PlSqlSearch search, String name) {
        String retval = search.getNamedMatch(name);
        if (retval != null && (retval.startsWith("'") && retval.endsWith("'") || retval.startsWith("\"") && retval.endsWith("\""))) {
            retval = retval.substring(1, retval.length() - 1);
        }
        return retval;
    }
}

