/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public final class PlSqlReferenceResolver {
    public static List<DBObjectID> findReferences(List<String> nameList, DBObjectProvider pro, DBObject context) {
        DBObject first;
        DBObject par;
        while (!(context instanceof PlSqlStatement) && (par = context.getParent()) != null) {
            context = par;
        }
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(nameList);
        String paramName = null;
        if (names.size() > 2 && ((String)names.get(names.size() - 2)).startsWith("(") && ((String)names.get(names.size() - 2)).contains((CharSequence)names.get(names.size() - 1))) {
            paramName = (String)names.get(names.size() - 1);
            names.remove(names.size() - 1);
        }
        if ((first = PlSqlReferenceResolver.findFirstNameInScope(context, names)) != null) {
            PlSqlParameter param;
            DBObject refObject = names.size() == 0 ? first : PlSqlReferenceResolver.findNamesInContext(first, names);
            if (refObject instanceof PlSqlSubProgram && paramName != null && (param = ((PlSqlSubProgram)refObject).getParameter(paramName)) != null) {
                refObject = param;
            }
            if (refObject != null) {
                DataTypeUsage dataTypeUsage;
                Object newParentID;
                PlSqlDatum var;
                PlSqlReference ref;
                retval.add(refObject.getID());
                if (names.size() > 0 && refObject instanceof PlSqlDatum && (ref = (var = (PlSqlDatum)refObject).getDataTypeReference()) != null && (newParentID = ref.getReferenceType() == PlSqlReference.ReferenceType.PCT_ROWTYPE ? var.getDataTypeReference().getReferenceID() : ((dataTypeUsage = ref.getDataTypeUsage()) != null ? dataTypeUsage.getDataTypeID() : null)) != null) {
                    try {
                        DBObject parent = newParentID.resolveID();
                        if (parent != null && (refObject = PlSqlReferenceResolver.findNamesInContext(parent, names)) != null) {
                            retval.add(refObject.getID());
                        }
                    }
                    catch (DBException parent) {
                        // empty catch block
                    }
                }
            }
        }
        if (retval.size() > 0) {
            ArrayList<DBObjectID> extras = new ArrayList<DBObjectID>();
            for (DBObjectID id : retval) {
                try {
                    DBObject refObject;
                    DBObject top;
                    PlSqlSchemaObject other;
                    String idType = id.getType();
                    if (!Metadata.getInstance().isTypeOf(DBObjectPlSqlFragment.class, idType)) continue;
                    DBObjectID topID = DBUtil.getUppermostParent((DBObjectID)id);
                    String topType = topID.getType();
                    if (!Metadata.getInstance().isTypeOf(PlSqlSchemaObjectSpec.class, topType) && !Metadata.getInstance().isTypeOf(PlSqlSchemaObjectBody.class, topType) || (other = PlSqlUtil.getCompanionObject((PlSqlSchemaObject)(top = topID.resolveID()), pro)) == null) continue;
                    ArrayList<String> nameInOther = new ArrayList<String>();
                    DBObject ref = id.resolveID();
                    if (ref == null) continue;
                    while (ref.getParent() != null) {
                        String n = ref.getName();
                        if (n != null) {
                            nameInOther.add(0, n);
                            ref = ref.getParent();
                            continue;
                        }
                        nameInOther.clear();
                        break;
                    }
                    if ((refObject = PlSqlReferenceResolver.findNamesInContext((DBObject)other, nameInOther)) == null) continue;
                    extras.add(refObject.getID());
                }
                catch (DBException dBException) {}
            }
            retval.addAll(extras);
        } else {
            DBObjectID id = PlSqlReferenceResolver.createUnspecifiedTypeID(nameList, pro, context);
            retval.add(id);
        }
        return retval;
    }

    private static DBObject findFirstNameInScope(DBObject context, List<String> names) {
        if (context == null || names == null || names.size() == 0 || context instanceof Schema) {
            return null;
        }
        String name = names.get(0);
        for (DBObject child : DBUtil.getExistingOwnedObjects((DBObject)context)) {
            if (!PlSqlReferenceResolver.isNameEqual(child, name)) continue;
            names.remove(0);
            return child;
        }
        DBObject sigObject = PlSqlReferenceResolver.findSignatureInContext(context, names);
        if (sigObject != null) {
            names.clear();
            return sigObject;
        }
        Object parent = context instanceof PlSqlSchemaObjectBody ? PlSqlReferenceResolver.getSpec((PlSqlSchemaObjectBody)context) : context.getParent();
        return PlSqlReferenceResolver.findFirstNameInScope(parent, names);
    }

    private static DBObject findNamesInContext(DBObject context, List<String> names) {
        if (names.size() != 0) {
            DBObject sigObject = PlSqlReferenceResolver.findSignatureInContext(context, names);
            if (sigObject != null) {
                names.clear();
                return sigObject;
            }
            for (DBObject kid : DBUtil.getExistingOwnedObjects((DBObject)context)) {
                if (!PlSqlReferenceResolver.isNameEqual(kid, names.get(0))) continue;
                names.remove(0);
                return PlSqlReferenceResolver.findNamesInContext(kid, names);
            }
        }
        return context;
    }

    private static boolean isNameEqual(DBObject obj, String name) {
        DBObject orig = TemporaryObjectID.findOriginalObject((DBObject)obj);
        String objName = orig == null ? obj.getName() : orig.getName();
        return ModelUtil.areEqual((Object)name, (Object)objName);
    }

    private static DBObject findSignatureInContext(DBObject context, List<String> names) {
        if (names.size() > 0 && !names.get(0).startsWith("(") && context instanceof PlSqlBlock) {
            PlSqlVariable var;
            if (names.size() == 2 && names.get(1).equals("(?)") && (var = ((PlSqlBlock)context).getVariable(names.get(0))) != null) {
                return var;
            }
            PlSqlSubProgram prog = PlSqlUtil.findPlSqlSubProgram(names, (PlSqlBlock)context);
            if (prog != null) {
                return prog;
            }
        }
        return null;
    }

    private static PlSqlSchemaObjectSpec getSpec(PlSqlSchemaObjectBody body) {
        PlSqlSchemaObjectSpec retval = null;
        DBObjectID specID = body.getSpecID();
        try {
            retval = (PlSqlSchemaObjectSpec)(specID != null ? specID.resolveID() : null);
        }
        catch (DBException e) {
            retval = null;
        }
        return retval;
    }

    private static DBObjectID createUnspecifiedTypeID(List<String> names, DBObjectProvider pro, DBObject context) {
        ReferenceID retval = null;
        int size = names.size();
        DBObject top = DBUtil.getUppermostParent((DBObject)context);
        String schemaName = top instanceof SchemaObject && ((SchemaObject)top).getSchema() != null ? ((SchemaObject)top).getSchema().getName() : null;
        for (int i = 0; i < size; ++i) {
            String name = names.get(i);
            if (i < size - 1 && names.get(i + 1).startsWith("(")) {
                name = name + names.get(++i);
            }
            ReferenceID id = new ReferenceID("UNSPECIFIED_TYPE", schemaName, name);
            id.setParent(retval);
            id.setProvider(pro);
            schemaName = null;
            retval = id;
        }
        return retval;
    }
}

