/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleInMemoryColumnProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class InMemoryColumnPropertiesValidator
extends AbstractChildDBObjectValidator<OracleInMemoryColumnProperties> {
    public InMemoryColumnPropertiesValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("inMemory");
        retval.add("inMemoryCompression");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"columnIDs"})
    public void validateColumnIDs(ValidationContext<OracleInMemoryColumnProperties> context) throws ValidationException {
        if (context.getLevel() == ValidationLevel.FULL) {
            OracleInMemoryColumnProperties[] allCols;
            OracleInMemoryColumnProperties imcp = (OracleInMemoryColumnProperties)context.getUpdatedObject();
            DBObjectID[] cols = imcp.getColumnIDs();
            if (cols == null || cols.length == 0) {
                throw new ValidationException((DBObject)imcp, "columnIDs", APIBundle.get((String)"IM_PROPERTY_COLUMNIDS"));
            }
            DBObject par = imcp.getParent();
            for (OracleInMemoryColumnProperties other : allCols = (OracleInMemoryColumnProperties[])((Table)par).getProperty("OracleInMemoryColumnProperties")) {
                DBObjectID[] otherCols;
                if (other == imcp || (otherCols = other.getColumnIDs()) == null) continue;
                for (DBObjectID otherID : otherCols) {
                    for (DBObjectID localID : cols) {
                        if (localID == null || !localID.equals(otherID, true)) continue;
                        throw new ValidationException((DBObject)imcp, "columnIDs", APIBundle.format((String)"IM_PROPERTY_COLUMNIDS_DUP", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)localID)}));
                    }
                }
            }
        }
    }
}

